/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.CtbDict;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class CtbPreDetector
extends RareExtractor {
    private String t1;
    private static final long serialVersionUID = 43L;

    CtbPreDetector(String t2, int n2) {
        super(n2);
        this.t1 = t2;
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String s = TestSentence.toNice(pH.getWord(h, this.position));
        if (!s.equals("") && CtbDict.getTagPre(this.t1, s.substring(0, 1)).equals("1")) {
            return "1:" + this.t1;
        }
        return "0:" + this.t1;
    }

    @Override
    public String toString() {
        return super.toString() + " tag=" + this.t1;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

