/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TrainOptions;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;
import java.util.Collections;

class PostSplitter
implements TreeTransformer {
    private final ClassicCounter<String> nonTerms = new ClassicCounter();
    private final TreebankLangParserParams tlpParams;
    private final HeadFinder hf;
    private final TrainOptions trainOptions;

    @Override
    public Tree transformTree(Tree t) {
        TreeFactory tf = t.treeFactory();
        return this.transformTreeHelper(t, t, tf);
    }

    public Tree transformTreeHelper(Tree t, Tree root, TreeFactory tf) {
        Tree[] kids;
        String grandParentStr;
        String parentStr;
        Tree parent;
        if (root == null || t.equals(root)) {
            parent = null;
            parentStr = "";
        } else {
            parent = t.parent(root);
            parentStr = parent.label().value();
        }
        if (parent == null || parent.equals(root)) {
            grandParentStr = "";
        } else {
            Tree grandParent = parent.parent(root);
            grandParentStr = grandParent.label().value();
        }
        String cat = t.label().value();
        String baseParentStr = this.tlpParams.treebankLanguagePack().basicCategory(parentStr);
        String baseGrandParentStr = this.tlpParams.treebankLanguagePack().basicCategory(grandParentStr);
        if (t.isLeaf()) {
            return tf.newLeaf(new Word(t.label().value()));
        }
        String word = t.headTerminal(this.hf).value();
        if (t.isPreTerminal()) {
            this.nonTerms.incrementCount(t.label().value());
        } else {
            String cat2;
            this.nonTerms.incrementCount(t.label().value());
            if (this.trainOptions.postPA && !this.trainOptions.smoothing && baseParentStr.length() > 0) {
                cat2 = this.trainOptions.postSplitWithBaseCategory ? cat + '^' + baseParentStr : cat + '^' + parentStr;
                if (!this.trainOptions.selectivePostSplit || this.trainOptions.postSplitters.contains(cat2)) {
                    cat = cat2;
                }
            }
            if (this.trainOptions.postGPA && !this.trainOptions.smoothing && grandParentStr.length() > 0) {
                cat2 = this.trainOptions.postSplitWithBaseCategory ? cat + '~' + baseGrandParentStr : cat + '~' + grandParentStr;
                if (this.trainOptions.selectivePostSplit) {
                    if (cat.contains("^") && this.trainOptions.postSplitters.contains(cat2)) {
                        cat = cat2;
                    }
                } else {
                    cat = cat2;
                }
            }
        }
        Tree result = tf.newTreeNode(new CategoryWordTag(cat, word, cat), Collections.<Tree>emptyList());
        ArrayList<Tree> newKids = new ArrayList<Tree>();
        for (Tree kid : kids = t.children()) {
            newKids.add(this.transformTreeHelper(kid, root, tf));
        }
        result.setChildren(newKids);
        return result;
    }

    public void dumpStats() {
        System.out.println("%% Counts of nonterminals:");
        ArrayList<String> biggestCounts = new ArrayList<String>(this.nonTerms.keySet());
        Collections.sort(biggestCounts, Counters.toComparatorDescending(this.nonTerms));
        for (String str : biggestCounts) {
            System.out.println(str + ": " + this.nonTerms.getCount(str));
        }
    }

    public PostSplitter(TreebankLangParserParams tlpParams, Options op) {
        this.tlpParams = tlpParams;
        this.hf = tlpParams.headFinder();
        this.trainOptions = op.trainOptions;
    }
}

