/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.FilePermission;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import sun.util.logging.PlatformLogger;

final class ProxyClassesDumper {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] BAD_CHARS = new char[]{'\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String[] REPLACEMENT = new String[]{"%5C", "%3A", "%2A", "%3F", "%22", "%3C", "%3E", "%7C"};
    private final Path dumpDir;

    public static ProxyClassesDumper getInstance(String string) {
        if (null == string) {
            return null;
        }
        try {
            string = string.trim();
            final Path path = Paths.get(string.isEmpty() ? "." : string, new String[0]);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ProxyClassesDumper.validateDumpDir(path);
                    return null;
                }
            }, null, new FilePermission("<<ALL FILES>>", "read, write"));
            return new ProxyClassesDumper(path);
        }
        catch (InvalidPathException invalidPathException) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning("Path " + string + " is not valid - dumping disabled", invalidPathException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning(illegalArgumentException.getMessage() + " - dumping disabled");
        }
        return null;
    }

    private ProxyClassesDumper(Path path) {
        this.dumpDir = Objects.requireNonNull(path);
    }

    private static void validateDumpDir(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Directory " + path + " does not exist");
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + path + " is not a directory");
        }
        if (!Files.isWritable(path)) {
            throw new IllegalArgumentException("Directory " + path + " is not writable");
        }
    }

    public static String encodeForFilename(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c <= '\u001f') {
                stringBuilder.append('%');
                stringBuilder.append(HEX[c >> 4 & 0xF]);
                stringBuilder.append(HEX[c & 0xF]);
                continue;
            }
            for (n2 = 0; n2 < BAD_CHARS.length; ++n2) {
                if (c != BAD_CHARS[n2]) continue;
                stringBuilder.append(REPLACEMENT[n2]);
                break;
            }
            if (n2 < BAD_CHARS.length) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void dumpClass(String string, byte[] byArray) {
        Path path;
        try {
            path = this.dumpDir.resolve(ProxyClassesDumper.encodeForFilename(string) + ".class");
        }
        catch (InvalidPathException invalidPathException) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning("Invalid path for class " + string);
            return;
        }
        try {
            Path path2 = path.getParent();
            Files.createDirectories(path2, new FileAttribute[0]);
            Files.write(path, byArray, new OpenOption[0]);
        }
        catch (Exception exception) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning("Exception writing to path at " + path.toString());
        }
    }
}

