/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrityHmac.class);
    private final Mac macAlgorithm;
    private HMACOutputLength hmacOutputLength;

    abstract int getDigestLength();

    public IntegrityHmac() throws XMLSignatureException {
        this(null);
    }

    public IntegrityHmac(Provider provider) throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        LOG.debug("Created IntegrityHmacSHA1 using {}", string);
        try {
            this.macAlgorithm = provider == null ? Mac.getInstance(string) : Mac.getInstance(string, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("empty", new Object[]{"Incorrect method call"});
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            if (this.hmacOutputLength != null && this.hmacOutputLength.length < this.getDigestLength()) {
                LOG.debug("HMACOutputLength must not be less than {}", this.getDigestLength());
                Object[] objectArray = new Object[]{String.valueOf(this.getDigestLength())};
                throw new XMLSignatureException("algorithms.HMACOutputLengthMin", objectArray);
            }
            byte[] byArray2 = this.macAlgorithm.doFinal();
            return MessageDigestAlgorithm.isEqual(byArray2, byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException(illegalStateException);
        }
    }

    @Override
    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.macAlgorithm.init(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            if (this.hmacOutputLength != null && this.hmacOutputLength.length < this.getDigestLength()) {
                LOG.debug("HMACOutputLength must not be less than {}", this.getDigestLength());
                Object[] objectArray = new Object[]{String.valueOf(this.getDigestLength())};
                throw new XMLSignatureException("algorithms.HMACOutputLengthMin", objectArray);
            }
            return this.macAlgorithm.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException(illegalStateException);
        }
    }

    @Override
    protected void engineInitSign(Key key) throws XMLSignatureException {
        this.engineInitSign(key, (AlgorithmParameterSpec)null);
    }

    @Override
    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(key instanceof SecretKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = SecretKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            if (algorithmParameterSpec == null) {
                this.macAlgorithm.init(key);
            } else {
                this.macAlgorithm.init(key, algorithmParameterSpec);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            throw new XMLSignatureException(generalSecurityException);
        }
    }

    @Override
    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    @Override
    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.macAlgorithm.update(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException(illegalStateException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.macAlgorithm.update(by);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException(illegalStateException);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.macAlgorithm.update(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLSignatureException(illegalStateException);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.macAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.macAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        this.hmacOutputLength = new HMACOutputLength(n);
    }

    @Override
    protected void engineGetContextFromElement(Element element) throws XMLSignatureException {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("element null");
        }
        Element element2 = XMLUtils.selectDsNode(element.getFirstChild(), "HMACOutputLength", 0);
        if (element2 != null && (string = XMLUtils.getFullTextChildrenFromNode(element2)) != null && !"".equals(string)) {
            this.hmacOutputLength = new HMACOutputLength(Integer.parseInt(string));
        }
    }

    @Override
    protected void engineAddContextToElement(Element element) throws XMLSignatureException {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this.hmacOutputLength != null) {
            Document document = element.getOwnerDocument();
            Element element2 = XMLUtils.createElementInSignatureSpace(document, "HMACOutputLength");
            Text text = document.createTextNode("" + this.hmacOutputLength.length);
            element2.appendChild(text);
            XMLUtils.addReturnToElement(element);
            element.appendChild(element2);
            XMLUtils.addReturnToElement(element);
        }
    }

    private static class HMACOutputLength {
        private static final int MIN_LENGTH = 128;
        private static final int MAX_LENGTH = 2048;
        private final int length;

        public HMACOutputLength(int n) throws XMLSignatureException {
            this.length = n;
            if (n < 128) {
                LOG.debug("HMACOutputLength must not be less than {}", 128);
                Object[] objectArray = new Object[]{String.valueOf(128)};
                throw new XMLSignatureException("algorithms.HMACOutputLengthMin", objectArray);
            }
            if (n > 2048) {
                LOG.debug("HMACOutputLength must not be more than {}", 2048);
                Object[] objectArray = new Object[]{String.valueOf(2048)};
                throw new XMLSignatureException("algorithms.HMACOutputLengthMax", objectArray);
            }
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        public IntegrityHmacMD5() throws XMLSignatureException {
        }

        public IntegrityHmacMD5(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }

        @Override
        int getDigestLength() {
            return 128;
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        public IntegrityHmacRIPEMD160() throws XMLSignatureException {
        }

        public IntegrityHmacRIPEMD160(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }

        @Override
        int getDigestLength() {
            return 160;
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        public IntegrityHmacSHA512() throws XMLSignatureException {
        }

        public IntegrityHmacSHA512(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }

        @Override
        int getDigestLength() {
            return 512;
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        public IntegrityHmacSHA384() throws XMLSignatureException {
        }

        public IntegrityHmacSHA384(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }

        @Override
        int getDigestLength() {
            return 384;
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        public IntegrityHmacSHA256() throws XMLSignatureException {
        }

        public IntegrityHmacSHA256(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }

        @Override
        int getDigestLength() {
            return 256;
        }
    }

    public static class IntegrityHmacSHA224
    extends IntegrityHmac {
        public IntegrityHmacSHA224() throws XMLSignatureException {
        }

        public IntegrityHmacSHA224(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha224";
        }

        @Override
        int getDigestLength() {
            return 224;
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        public IntegrityHmacSHA1() throws XMLSignatureException {
        }

        public IntegrityHmacSHA1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }

        @Override
        int getDigestLength() {
            return 160;
        }
    }
}

