/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SourceFile
extends Attribute {
    private int sourcefile_index;

    public SourceFile(SourceFile c) {
        this(c.getNameIndex(), c.getLength(), c.getSourceFileIndex(), c.getConstantPool());
    }

    SourceFile(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, input.readUnsignedShort(), constant_pool);
    }

    public SourceFile(int name_index, int length, int sourcefile_index, ConstantPool constant_pool) {
        super((byte)0, name_index, length, constant_pool);
        this.sourcefile_index = sourcefile_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitSourceFile(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.sourcefile_index);
    }

    public int getSourceFileIndex() {
        return this.sourcefile_index;
    }

    public void setSourceFileIndex(int sourcefile_index) {
        this.sourcefile_index = sourcefile_index;
    }

    public String getSourceFileName() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.sourcefile_index, (byte)1);
        return c.getBytes();
    }

    @Override
    public String toString() {
        return "SourceFile: " + this.getSourceFileName();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        return (Attribute)this.clone();
    }
}

