/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Utilities;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import sun.util.logging.PlatformLogger;

public final class SSLLogger {
    private static final SSLConsoleLogger logger;
    private static final String property;
    public static final boolean isOn;
    private static final String FORMAT_MATCH1;
    private static final String FORMAT_MATCH2 = "java.lang.Thread";

    private static void help() {
        System.err.println();
        System.err.println("help           print the help messages");
        System.err.println("expand         expand debugging information");
        System.err.println();
        System.err.println("all            turn on all debugging");
        System.err.println("ssl            turn on ssl debugging");
        System.err.println();
        System.err.println("The following can be used with ssl:");
        System.err.println("\trecord       enable per-record tracing");
        System.err.println("\thandshake    print each handshake message");
        System.err.println("\tkeygen       print key generation data");
        System.err.println("\tsession      print session activity");
        System.err.println("\tdefaultctx   print default SSL initialization");
        System.err.println("\tsslctx       print SSLContext tracing");
        System.err.println("\tsessioncache print session cache tracing");
        System.err.println("\tkeymanager   print key manager tracing");
        System.err.println("\ttrustmanager print trust manager tracing");
        System.err.println("\tpluggability print pluggability tracing");
        System.err.println();
        System.err.println("\thandshake debugging can be widened with:");
        System.err.println("\tdata         hex dump of each handshake message");
        System.err.println("\tverbose      verbose handshake message printing");
        System.err.println();
        System.err.println("\trecord debugging can be widened with:");
        System.err.println("\tplaintext    hex dump of record plaintext");
        System.err.println("\tpacket       print raw SSL/TLS packets");
        System.err.println();
        System.exit(0);
    }

    public static boolean isOn(String string) {
        String[] stringArray;
        if (property == null) {
            return false;
        }
        if (property.isEmpty()) {
            return true;
        }
        for (String string2 : stringArray = string.split(",")) {
            if (SSLLogger.hasOption(string2 = string2.trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasOption(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        if (property.contains("all")) {
            return true;
        }
        int n = property.indexOf("ssl");
        if (!(n == -1 || property.indexOf("sslctx", n) == -1 || string.equals("data") || string.equals("packet") || string.equals("plaintext"))) {
            return true;
        }
        return property.contains(string);
    }

    public static void severe(String string, Object ... objectArray) {
        SSLLogger.log(PlatformLogger.Level.SEVERE, string, objectArray);
    }

    public static void warning(String string, Object ... objectArray) {
        SSLLogger.log(PlatformLogger.Level.WARNING, string, objectArray);
    }

    public static void info(String string, Object ... objectArray) {
        SSLLogger.log(PlatformLogger.Level.INFO, string, objectArray);
    }

    public static void fine(String string, Object ... objectArray) {
        SSLLogger.log(PlatformLogger.Level.FINE, string, objectArray);
    }

    public static void finer(String string, Object ... objectArray) {
        SSLLogger.log(PlatformLogger.Level.FINER, string, objectArray);
    }

    public static void finest(String string, Object ... objectArray) {
        SSLLogger.log(PlatformLogger.Level.ALL, string, objectArray);
    }

    private static void log(PlatformLogger.Level level, String string, Object ... objectArray) {
        if (logger != null && logger.isLoggable(level)) {
            if (objectArray == null || objectArray.length == 0) {
                logger.log(level, string, new Object[0]);
            } else {
                try {
                    String string2 = SSLSimpleFormatter.formatParameters(objectArray);
                    logger.log(level, string, string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static String toString(Object ... objectArray) {
        try {
            return SSLSimpleFormatter.formatParameters(objectArray);
        }
        catch (Exception exception) {
            return "unexpected exception thrown: " + exception.getMessage();
        }
    }

    static {
        FORMAT_MATCH1 = SSLLogger.class.getName();
        String string = GetPropertyAction.privilegedGetProperty("javax.net.debug");
        if (string != null) {
            if (string.isEmpty()) {
                property = "";
                logger = new SSLConsoleLogger("javax.net.ssl", string);
            } else {
                property = string.toLowerCase(Locale.ENGLISH);
                if (property.equals("help")) {
                    SSLLogger.help();
                }
                logger = new SSLConsoleLogger("javax.net.ssl", string);
            }
            isOn = true;
        } else {
            property = null;
            logger = null;
            isOn = false;
        }
    }

    private static class SSLSimpleFormatter {
        private static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS z", Locale.ENGLISH);
            }
        };
        private static final MessageFormat basicCertFormat = new MessageFormat("\"version\"            : \"v{0}\",\n\"serial number\"      : \"{1}\",\n\"signature algorithm\": \"{2}\",\n\"issuer\"             : \"{3}\",\n\"not before\"         : \"{4}\",\n\"not  after\"         : \"{5}\",\n\"subject\"            : \"{6}\",\n\"subject public key\" : \"{7}\"\n", Locale.ENGLISH);
        private static final MessageFormat extendedCertFormart = new MessageFormat("\"version\"            : \"v{0}\",\n\"serial number\"      : \"{1}\",\n\"signature algorithm\": \"{2}\",\n\"issuer\"             : \"{3}\",\n\"not before\"         : \"{4}\",\n\"not  after\"         : \"{5}\",\n\"subject\"            : \"{6}\",\n\"subject public key\" : \"{7}\",\n\"extensions\"         : [\n{8}\n]\n", Locale.ENGLISH);
        private static final MessageFormat messageFormatNoParas = new MessageFormat("'{'\n  \"logger\"      : \"{0}\",\n  \"level\"       : \"{1}\",\n  \"thread id\"   : \"{2}\",\n  \"thread name\" : \"{3}\",\n  \"time\"        : \"{4}\",\n  \"caller\"      : \"{5}\",\n  \"message\"     : \"{6}\"\n'}'\n", Locale.ENGLISH);
        private static final MessageFormat messageCompactFormatNoParas = new MessageFormat("{0}|{1}|{2}|{3}|{4}|{5}|{6}\n", Locale.ENGLISH);
        private static final MessageFormat messageFormatWithParas = new MessageFormat("'{'\n  \"logger\"      : \"{0}\",\n  \"level\"       : \"{1}\",\n  \"thread id\"   : \"{2}\",\n  \"thread name\" : \"{3}\",\n  \"time\"        : \"{4}\",\n  \"caller\"      : \"{5}\",\n  \"message\"     : \"{6}\",\n  \"specifics\"   : [\n{7}\n  ]\n'}'\n", Locale.ENGLISH);
        private static final MessageFormat messageCompactFormatWithParas = new MessageFormat("{0}|{1}|{2}|{3}|{4}|{5}|{6} (\n{7}\n)\n", Locale.ENGLISH);
        private static final MessageFormat keyObjectFormat = new MessageFormat("\"{0}\" : '{'\n{1}'}'\n", Locale.ENGLISH);

        private SSLSimpleFormatter() {
        }

        private static String format(SSLConsoleLogger sSLConsoleLogger, PlatformLogger.Level level, String string, Object ... objectArray) {
            if (objectArray == null || objectArray.length == 0) {
                Object[] objectArray2 = new Object[]{sSLConsoleLogger.loggerName, level.name(), Utilities.toHexString(Thread.currentThread().getId()), Thread.currentThread().getName(), dateFormat.get().format(new Date(System.currentTimeMillis())), SSLSimpleFormatter.formatCaller(), string};
                if (sSLConsoleLogger.useCompactFormat) {
                    return messageCompactFormatNoParas.format(objectArray2);
                }
                return messageFormatNoParas.format(objectArray2);
            }
            Object[] objectArray3 = new Object[]{sSLConsoleLogger.loggerName, level.name(), Utilities.toHexString(Thread.currentThread().getId()), Thread.currentThread().getName(), dateFormat.get().format(new Date(System.currentTimeMillis())), SSLSimpleFormatter.formatCaller(), string, sSLConsoleLogger.useCompactFormat ? SSLSimpleFormatter.formatParameters(objectArray) : Utilities.indent(SSLSimpleFormatter.formatParameters(objectArray))};
            if (sSLConsoleLogger.useCompactFormat) {
                return messageCompactFormatWithParas.format(objectArray3);
            }
            return messageFormatWithParas.format(objectArray3);
        }

        private static String formatCaller() {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (stackTraceElement.getClassName().startsWith(FORMAT_MATCH1) || stackTraceElement.getClassName().startsWith(SSLLogger.FORMAT_MATCH2)) continue;
                return stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber();
            }
            return new String("unknown caller");
        }

        private static String formatParameters(Object ... objectArray) {
            StringBuilder stringBuilder = new StringBuilder(512);
            boolean bl = true;
            for (Object object : objectArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",\n");
                }
                if (object instanceof Throwable) {
                    stringBuilder.append(SSLSimpleFormatter.formatThrowable((Throwable)object));
                    continue;
                }
                if (object instanceof Certificate) {
                    stringBuilder.append(SSLSimpleFormatter.formatCertificate((Certificate)object));
                    continue;
                }
                if (object instanceof ByteArrayInputStream) {
                    stringBuilder.append(SSLSimpleFormatter.formatByteArrayInputStream((ByteArrayInputStream)object));
                    continue;
                }
                if (object instanceof ByteBuffer) {
                    stringBuilder.append(SSLSimpleFormatter.formatByteBuffer((ByteBuffer)object));
                    continue;
                }
                if (object instanceof byte[]) {
                    stringBuilder.append(SSLSimpleFormatter.formatByteArrayInputStream(new ByteArrayInputStream((byte[])object)));
                    continue;
                }
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    stringBuilder.append(SSLSimpleFormatter.formatMapEntry(entry));
                    continue;
                }
                stringBuilder.append(SSLSimpleFormatter.formatObject(object));
            }
            return stringBuilder.toString();
        }

        private static String formatThrowable(Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder(512);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (Object[] objectArray = new PrintStream(byteArrayOutputStream);){
                throwable.printStackTrace((PrintStream)objectArray);
                stringBuilder.append(Utilities.indent(byteArrayOutputStream.toString()));
            }
            objectArray = new Object[]{"throwable", stringBuilder.toString()};
            return keyObjectFormat.format(objectArray);
        }

        private static String formatCertificate(Certificate certificate) {
            Object[] objectArray;
            if (!(certificate instanceof X509Certificate)) {
                return Utilities.indent(certificate.toString());
            }
            StringBuilder stringBuilder = new StringBuilder(512);
            try {
                objectArray = X509CertImpl.toImpl((X509Certificate)certificate);
                X509CertInfo x509CertInfo = (X509CertInfo)objectArray.get("x509.info");
                CertificateExtensions certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
                if (certificateExtensions == null) {
                    Object[] objectArray2 = new Object[]{objectArray.getVersion(), Utilities.toHexString(objectArray.getSerialNumber().toByteArray()), objectArray.getSigAlgName(), objectArray.getIssuerX500Principal().toString(), dateFormat.get().format(objectArray.getNotBefore()), dateFormat.get().format(objectArray.getNotAfter()), objectArray.getSubjectX500Principal().toString(), objectArray.getPublicKey().getAlgorithm()};
                    stringBuilder.append(Utilities.indent(basicCertFormat.format(objectArray2)));
                } else {
                    StringBuilder stringBuilder2 = new StringBuilder(512);
                    boolean bl = true;
                    for (Extension extension : certificateExtensions.getAllExtensions()) {
                        if (bl) {
                            bl = false;
                        } else {
                            stringBuilder2.append(",\n");
                        }
                        stringBuilder2.append("{\n" + Utilities.indent(extension.toString()) + "\n}");
                    }
                    Object[] objectArray3 = new Object[]{objectArray.getVersion(), Utilities.toHexString(objectArray.getSerialNumber().toByteArray()), objectArray.getSigAlgName(), objectArray.getIssuerX500Principal().toString(), dateFormat.get().format(objectArray.getNotBefore()), dateFormat.get().format(objectArray.getNotAfter()), objectArray.getSubjectX500Principal().toString(), objectArray.getPublicKey().getAlgorithm(), Utilities.indent(stringBuilder2.toString())};
                    stringBuilder.append(Utilities.indent(extendedCertFormart.format(objectArray3)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            objectArray = new Object[]{"certificate", stringBuilder.toString()};
            return Utilities.indent(keyObjectFormat.format(objectArray));
        }

        private static String formatByteArrayInputStream(ByteArrayInputStream byteArrayInputStream) {
            StringBuilder stringBuilder = new StringBuilder(512);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                hexDumpEncoder.encodeBuffer((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream);
                stringBuilder.append(Utilities.indent(byteArrayOutputStream.toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringBuilder.toString();
        }

        private static String formatByteBuffer(ByteBuffer byteBuffer) {
            StringBuilder stringBuilder = new StringBuilder(512);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                hexDumpEncoder.encodeBuffer(byteBuffer.duplicate(), (OutputStream)byteArrayOutputStream);
                stringBuilder.append(Utilities.indent(byteArrayOutputStream.toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringBuilder.toString();
        }

        private static String formatMapEntry(Map.Entry<String, ?> entry) {
            String string;
            String string2 = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof String) {
                string = "\"" + string2 + "\": \"" + (String)obj + "\"";
            } else if (obj instanceof String[]) {
                StringBuilder stringBuilder = new StringBuilder(512);
                String[] stringArray = (String[])obj;
                stringBuilder.append("\"" + string2 + "\": [\n");
                for (String string3 : stringArray) {
                    stringBuilder.append("      \"" + string3 + "\"");
                    if (string3 != stringArray[stringArray.length - 1]) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("      ]");
                string = stringBuilder.toString();
            } else {
                string = obj instanceof byte[] ? "\"" + string2 + "\": \"" + Utilities.toHexString((byte[])obj) + "\"" : (obj instanceof Byte ? "\"" + string2 + "\": \"" + Utilities.toHexString((Byte)obj) + "\"" : "\"" + string2 + "\": \"" + obj.toString() + "\"");
            }
            return Utilities.indent(string);
        }

        private static String formatObject(Object object) {
            return object.toString();
        }
    }

    private static class SSLConsoleLogger {
        private final String loggerName;
        private final boolean useCompactFormat;

        SSLConsoleLogger(String string, String string2) {
            this.loggerName = string;
            string2 = string2.toLowerCase(Locale.ENGLISH);
            this.useCompactFormat = !string2.contains("expand");
        }

        public String getName() {
            return this.loggerName;
        }

        public boolean isLoggable(PlatformLogger.Level level) {
            return level != PlatformLogger.Level.OFF;
        }

        public void log(PlatformLogger.Level level, String string, Object ... objectArray) {
            if (this.isLoggable(level)) {
                try {
                    String string2 = SSLSimpleFormatter.format(this, level, string, objectArray);
                    System.err.write(string2.getBytes("UTF-8"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void log(PlatformLogger.Level level, String string, Throwable throwable) {
            if (this.isLoggable(level)) {
                try {
                    String string2 = SSLSimpleFormatter.format(this, level, string, new Object[]{throwable});
                    System.err.write(string2.getBytes("UTF-8"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

