/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MaxSizeConcurrentHashSet<E>
implements Set<E>,
Serializable {
    private final ConcurrentMap<E, Boolean> m;
    private transient Set<E> s;
    private int maxSize;
    private static final long serialVersionUID = 1L;

    public MaxSizeConcurrentHashSet() {
        this(-1);
    }

    public MaxSizeConcurrentHashSet(int maxSize) {
        this.m = new ConcurrentHashMap<E, Boolean>();
        this.maxSize = maxSize;
        this.init();
    }

    public MaxSizeConcurrentHashSet(Set<? extends E> s) {
        this.m = new ConcurrentHashMap<E, Boolean>(Math.max(s.size(), 16));
        this.init();
        this.addAll(s);
        this.maxSize = -1;
    }

    private void init() {
        this.s = this.m.keySet();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E e) {
        if (this.maxSize >= 0 && this.size() >= this.maxSize) {
            return false;
        }
        return this.m.put(e, Boolean.TRUE) == null;
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o) != null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.s.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.s.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.s.toArray(a);
    }

    public String toString() {
        return this.s.toString();
    }

    @Override
    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.s.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.s.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.s.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.s.retainAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = false;
        for (E item : c) {
            if (this.m.put(item, Boolean.TRUE) != null) continue;
            added = true;
        }
        return added;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.s.forEach(action);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.s.removeIf(filter);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.s.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.s.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.s.parallelStream();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
    }
}

