/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.AbstractCounter;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.stats.TwoDimensionalCounterInterface;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.Sets;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.PrettyLogger;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public class Counters {
    private static final double LOG_E_2 = Math.log(2.0);
    static final Random RAND = new Random();

    private Counters() {
    }

    public static <E> double logSum(Counter<E> c) {
        return ArrayMath.logSum(ArrayMath.unbox(c.values()));
    }

    public static <E> void logNormalizeInPlace(Counter<E> c) {
        double logsum = Counters.logSum(c);
        for (Map.Entry<E, Double> e : c.entrySet()) {
            e.setValue(e.getValue() - logsum);
        }
    }

    public static <E> double max(Counter<E> c) {
        return Counters.max(c, Double.NEGATIVE_INFINITY);
    }

    public static <E> double max(Counter<E> c, double valueIfEmpty) {
        if (c.size() == 0) {
            return valueIfEmpty;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (double v : c.values()) {
            max = Math.max(max, v);
        }
        return max;
    }

    public static <E> Counter<E> asCounter(Collection<E> c) {
        ClassicCounter<E> count = new ClassicCounter<E>();
        for (E elem : c) {
            count.incrementCount(elem);
        }
        return count;
    }

    public static <E> double min(Counter<E> c) {
        double min = Double.POSITIVE_INFINITY;
        for (double v : c.values()) {
            min = Math.min(min, v);
        }
        return min;
    }

    public static <E> E argmax(Counter<E> c) {
        return Counters.argmax(c, (x, y) -> 0, null);
    }

    public static <E> E argmin(Counter<E> c) {
        double min = Double.POSITIVE_INFINITY;
        E argmin = null;
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            if (argmin != null && !(count < min)) continue;
            min = count;
            argmin = key;
        }
        return argmin;
    }

    public static <E> E argmax(Counter<E> c, Comparator<E> tieBreaker) {
        return Counters.argmax(c, tieBreaker, null);
    }

    public static <E> E argmax(Counter<E> c, Comparator<E> tieBreaker, E defaultIfEmpty) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        if (c.size() == 0) {
            return defaultIfEmpty;
        }
        double max = Double.NEGATIVE_INFINITY;
        Object argmax = null;
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            if (argmax != null && !(count > max) && (count != max || tieBreaker.compare(key, argmax) >= 0)) continue;
            max = count;
            argmax = key;
        }
        return (E)argmax;
    }

    public static <E> E argmin(Counter<E> c, Comparator<E> tieBreaker) {
        double min = Double.POSITIVE_INFINITY;
        Object argmin = null;
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            if (argmin != null && !(count < min) && (count != min || tieBreaker.compare(key, argmin) >= 0)) continue;
            min = count;
            argmin = key;
        }
        return (E)argmin;
    }

    public static <E> double mean(Counter<E> c) {
        return c.totalCount() / (double)c.size();
    }

    public static <E> double standardDeviation(Counter<E> c) {
        double std = 0.0;
        double mean = c.totalCount() / (double)c.size();
        for (Map.Entry<E, Double> en : c.entrySet()) {
            std += (en.getValue() - mean) * (en.getValue() - mean);
        }
        return Math.sqrt(std / (double)c.size());
    }

    public static <E> void addInPlace(Counter<E> target, Counter<E> arg, double scale) {
        for (E key : arg.keySet()) {
            target.incrementCount(key, scale * arg.getCount(key));
        }
    }

    public static <E> void addInPlace(Counter<E> target, Counter<E> arg) {
        for (Map.Entry<E, Double> entry : arg.entrySet()) {
            double count = entry.getValue();
            if (count == 0.0) continue;
            target.incrementCount(entry.getKey(), count);
        }
    }

    public static <E> void addInPlace(double[] target, Counter<E> arg, Index<E> idx) {
        for (Map.Entry<E, Double> entry : arg.entrySet()) {
            int n = idx.indexOf(entry.getKey());
            target[n] = target[n] + entry.getValue();
        }
    }

    public static <T1, T2> TwoDimensionalCounter<T1, T2> add(TwoDimensionalCounter<T1, T2> arg1, TwoDimensionalCounter<T1, T2> arg2) {
        TwoDimensionalCounter add = new TwoDimensionalCounter();
        Counters.addInPlace(add, arg1);
        Counters.addInPlace(add, arg2);
        return add;
    }

    public static <T1, T2> void addInPlace(TwoDimensionalCounter<T1, T2> target, TwoDimensionalCounter<T1, T2> arg, double scale) {
        for (T1 outer : arg.firstKeySet()) {
            for (T2 inner : arg.secondKeySet()) {
                target.incrementCount(outer, inner, scale * arg.getCount(outer, inner));
            }
        }
    }

    public static <T1, T2> void addInPlace(TwoDimensionalCounter<T1, T2> target, TwoDimensionalCounter<T1, T2> arg) {
        for (T1 outer : arg.firstKeySet()) {
            for (T2 inner : arg.secondKeySet()) {
                target.incrementCount(outer, inner, arg.getCount(outer, inner));
            }
        }
    }

    public static <E> void addInPlace(Counter<E> target, Collection<E> arg, double value) {
        for (E key : arg) {
            target.incrementCount(key, value);
        }
    }

    public static <T1, T2> void addInPlace(TwoDimensionalCounter<T1, T2> target, double value) {
        for (T1 outer : target.firstKeySet()) {
            Counters.addInPlace(target.getCounter((Object)outer), value);
        }
    }

    public static <E> void addInPlace(Counter<E> target, Collection<E> arg) {
        for (E key : arg) {
            target.incrementCount(key, 1.0);
        }
    }

    public static <E> void addInPlace(Counter<E> target, double value) {
        for (E key : target.keySet()) {
            target.incrementCount(key, value);
        }
    }

    public static <E> void subtractInPlace(Counter<E> target, Counter<E> arg) {
        for (E key : arg.keySet()) {
            target.decrementCount(key, arg.getCount(key));
        }
    }

    public static <E> void subtractInPlace(double[] target, Counter<E> arg, Index<E> idx) {
        for (Map.Entry<E, Double> entry : arg.entrySet()) {
            int n = idx.indexOf(entry.getKey());
            target[n] = target[n] - entry.getValue();
        }
    }

    public static <E> void divideInPlace(Counter<E> target, Counter<E> denominator) {
        for (E key : target.keySet()) {
            target.setCount(key, target.getCount(key) / denominator.getCount(key));
        }
    }

    public static <E> void dotProductInPlace(Counter<E> target, Counter<E> term) {
        for (E key : target.keySet()) {
            target.setCount(key, target.getCount(key) * term.getCount(key));
        }
    }

    public static <E> Counter<E> divideInPlace(Counter<E> target, double divisor) {
        for (Map.Entry<E, Double> entry : target.entrySet()) {
            target.setCount(entry.getKey(), entry.getValue() / divisor);
        }
        return target;
    }

    public static <E> Counter<E> multiplyInPlace(Counter<E> target, double multiplier) {
        for (Map.Entry<E, Double> entry : target.entrySet()) {
            target.setCount(entry.getKey(), entry.getValue() * multiplier);
        }
        return target;
    }

    public static <E> Counter<E> multiplyInPlace(Counter<E> target, Counter<E> mult) {
        for (Map.Entry<E, Double> entry : target.entrySet()) {
            target.setCount(entry.getKey(), entry.getValue() * mult.getCount(entry.getKey()));
        }
        Counters.retainNonZeros(target);
        return target;
    }

    public static <E> void normalize(Counter<E> target) {
        Counters.divideInPlace(target, target.totalCount());
    }

    public static <E, C extends Counter<E>> C asNormalizedCounter(C c) {
        return Counters.scale(c, 1.0 / c.totalCount());
    }

    public static <E, F> void normalize(TwoDimensionalCounter<E, F> target) {
        Counters.divideInPlace(target, target.totalCount());
    }

    public static <E> void logInPlace(Counter<E> target) {
        for (E key : target.keySet()) {
            target.setCount(key, Math.log(target.getCount(key)));
        }
    }

    public static <E> List<E> deleteOutofRange(Counter<E> c, int top, int bottom) {
        ArrayList<E> purgedItems = new ArrayList<E>();
        int numToPurge = top + bottom;
        if (numToPurge <= 0) {
            return purgedItems;
        }
        List<E> l = Counters.toSortedList(c);
        for (int i = 0; i < top; ++i) {
            E item = l.get(i);
            purgedItems.add(item);
            c.remove(item);
        }
        int size = c.size();
        for (int i = c.size() - 1; i >= size - bottom; --i) {
            E item = l.get(i);
            purgedItems.add(item);
            c.remove(item);
        }
        return purgedItems;
    }

    public static <E> void retainTop(Counter<E> c, int num) {
        int numToPurge = c.size() - num;
        if (numToPurge <= 0) {
            return;
        }
        List<E> l = Counters.toSortedList(c, true);
        for (int i = 0; i < numToPurge; ++i) {
            c.remove(l.get(i));
        }
    }

    public static <E extends Comparable<E>> void retainTopKeyComparable(Counter<E> c, int num) {
        int numToPurge = c.size() - num;
        if (numToPurge <= 0) {
            return;
        }
        List<E> l = Counters.toSortedListKeyComparable(c);
        Collections.reverse(l);
        for (int i = 0; i < numToPurge; ++i) {
            c.remove(l.get(i));
        }
    }

    public static <E> List<E> retainBottom(Counter<E> c, int num) {
        int numToPurge = c.size() - num;
        if (numToPurge <= 0) {
            return Generics.newArrayList();
        }
        ArrayList<E> removed = new ArrayList<E>();
        List<E> l = Counters.toSortedList(c);
        for (int i = 0; i < numToPurge; ++i) {
            E rem = l.get(i);
            removed.add(rem);
            c.remove(rem);
        }
        return removed;
    }

    public static <E> Set<E> retainNonZeros(Counter<E> counter) {
        Set<E> removed = Generics.newHashSet();
        for (E key : counter.keySet()) {
            if (counter.getCount(key) != 0.0) continue;
            removed.add(key);
        }
        for (E key : removed) {
            counter.remove(key);
        }
        return removed;
    }

    public static <E> Set<E> retainAbove(Counter<E> counter, double countThreshold) {
        Set<E> removed = Generics.newHashSet();
        for (E key : counter.keySet()) {
            if (!(counter.getCount(key) < countThreshold)) continue;
            removed.add(key);
        }
        for (E key : removed) {
            counter.remove(key);
        }
        return removed;
    }

    public static <E1, E2> Set<Pair<E1, E2>> retainAbove(TwoDimensionalCounter<E1, E2> counter, double countThreshold) {
        HashSet<Pair<E1, E2>> removed = new HashSet<Pair<E1, E2>>();
        for (Map.Entry<E1, ClassicCounter<E2>> entry : counter.entrySet()) {
            for (Map.Entry<E2, Double> en2 : entry.getValue().entrySet()) {
                if (!(counter.getCount(entry.getKey(), en2.getKey()) < countThreshold)) continue;
                removed.add(new Pair<E1, E2>(entry.getKey(), en2.getKey()));
            }
        }
        for (Pair pair : removed) {
            counter.remove(pair.first(), pair.second());
        }
        return removed;
    }

    public static <E> Counter<E> retainBelow(Counter<E> counter, double countMaxThreshold) {
        ClassicCounter removed = new ClassicCounter();
        for (Object k : counter.keySet()) {
            double count = counter.getCount(k);
            if (!(counter.getCount(k) > countMaxThreshold)) continue;
            removed.setCount(k, count);
        }
        for (Map.Entry entry : removed.entrySet()) {
            counter.remove(entry.getKey());
        }
        return removed;
    }

    public static Set<String> retainMatchingKeys(Counter<String> counter, List<Pattern> matchPatterns) {
        Set<String> removed = Generics.newHashSet();
        for (String key : counter.keySet()) {
            boolean matched = false;
            for (Pattern pattern : matchPatterns) {
                if (!pattern.matcher(key).matches()) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            removed.add(key);
        }
        for (String key : removed) {
            counter.remove(key);
        }
        return removed;
    }

    public static <E> Set<E> retainKeys(Counter<E> counter, Collection<E> matchKeys) {
        Set<E> removed = Generics.newHashSet();
        for (E key : counter.keySet()) {
            boolean matched = matchKeys.contains(key);
            if (matched) continue;
            removed.add(key);
        }
        for (E key : removed) {
            counter.remove(key);
        }
        return removed;
    }

    public static <E> void removeKeys(Counter<E> counter, Collection<E> removeKeysCollection) {
        for (E key : removeKeysCollection) {
            counter.remove(key);
        }
    }

    public static <E, F> void removeKeys(TwoDimensionalCounter<E, F> counter, Collection<E> removeKeysCollection) {
        for (E key : removeKeysCollection) {
            counter.remove(key);
        }
    }

    public static <E> Set<E> keysAbove(Counter<E> c, double countThreshold) {
        Set<E> keys = Generics.newHashSet();
        for (E key : c.keySet()) {
            if (!(c.getCount(key) >= countThreshold)) continue;
            keys.add(key);
        }
        return keys;
    }

    public static <E> Set<E> keysBelow(Counter<E> c, double countThreshold) {
        Set<E> keys = Generics.newHashSet();
        for (E key : c.keySet()) {
            if (!(c.getCount(key) <= countThreshold)) continue;
            keys.add(key);
        }
        return keys;
    }

    public static <E> Set<E> keysAt(Counter<E> c, double count) {
        Set<E> keys = Generics.newHashSet();
        for (E key : c.keySet()) {
            if (c.getCount(key) != count) continue;
            keys.add(key);
        }
        return keys;
    }

    public static <T1, T2> Counter<T2> transform(Counter<T1> c, Function<T1, T2> f) {
        ClassicCounter<T2> c2 = new ClassicCounter<T2>();
        for (T1 key : c.keySet()) {
            c2.setCount(f.apply(key), c.getCount(key));
        }
        return c2;
    }

    public static <T1, T2> Counter<T2> transformWithValuesAdd(Counter<T1> c, Function<T1, T2> f) {
        ClassicCounter<T2> c2 = new ClassicCounter<T2>();
        for (T1 key : c.keySet()) {
            c2.incrementCount(f.apply(key), c.getCount(key));
        }
        return c2;
    }

    public static <E> Comparator<E> toComparator(Counter<E> counter) {
        return (o1, o2) -> Double.compare(counter.getCount(o1), counter.getCount(o2));
    }

    public static <E extends Comparable<E>> Comparator<E> toComparatorWithKeys(Counter<E> counter) {
        return (o1, o2) -> {
            int res = Double.compare(counter.getCount(o1), counter.getCount(o2));
            if (res == 0) {
                return o1.compareTo(o2);
            }
            return res;
        };
    }

    public static <E> Comparator<E> toComparatorDescending(Counter<E> counter) {
        return (o1, o2) -> Double.compare(counter.getCount(o2), counter.getCount(o1));
    }

    public static <E> Comparator<E> toComparator(Counter<E> counter, boolean ascending, boolean useMagnitude) {
        return (o1, o2) -> {
            if (ascending) {
                if (useMagnitude) {
                    return Double.compare(Math.abs(counter.getCount(o1)), Math.abs(counter.getCount(o2)));
                }
                return Double.compare(counter.getCount(o1), counter.getCount(o2));
            }
            if (useMagnitude) {
                return Double.compare(Math.abs(counter.getCount(o2)), Math.abs(counter.getCount(o1)));
            }
            return Double.compare(counter.getCount(o2), counter.getCount(o1));
        };
    }

    public static <E> List<E> toSortedList(Counter<E> c) {
        return Counters.toSortedList(c, false);
    }

    public static <E> List<E> toSortedList(Counter<E> c, boolean ascending) {
        ArrayList<E> l = new ArrayList<E>(c.keySet());
        Comparator<E> comp = ascending ? Counters.toComparator(c) : Counters.toComparatorDescending(c);
        Collections.sort(l, comp);
        return l;
    }

    public static <E extends Comparable<E>> List<E> toSortedListKeyComparable(Counter<E> c) {
        ArrayList<E> l = new ArrayList<E>(c.keySet());
        Comparator<E> comp = Counters.toComparatorWithKeys(c);
        Collections.sort(l, comp);
        Collections.reverse(l);
        return l;
    }

    public static <E> IntCounter<E> toRankCounter(Counter<E> c) {
        IntCounter<E> rankCounter = new IntCounter<E>();
        List<E> sortedList = Counters.toSortedList(c);
        for (int i = 0; i < sortedList.size(); ++i) {
            rankCounter.setCount(sortedList.get(i), i);
        }
        return rankCounter;
    }

    public static <E> Counter<E> toTiedRankCounter(Counter<E> c) {
        ClassicCounter<E> rankCounter = new ClassicCounter<E>();
        List<Pair<E, Double>> sortedList = Counters.toSortedListWithCounts(c);
        int i = 0;
        Iterator<Pair<E, Double>> it = sortedList.iterator();
        while (it.hasNext()) {
            Pair<E, Double> jEn;
            Pair<E, Double> iEn = it.next();
            double icount = iEn.second();
            E iKey = iEn.first();
            ArrayList<Integer> l = new ArrayList<Integer>();
            ArrayList<E> keys = new ArrayList<E>();
            l.add(i + 1);
            keys.add(iKey);
            for (int j = i + 1; j < sortedList.size() && icount == (jEn = sortedList.get(j)).second(); ++j) {
                l.add(j + 1);
                keys.add(jEn.first());
            }
            if (l.size() > 1) {
                double sum = 0.0;
                for (Integer d : l) {
                    sum += (double)d.intValue();
                }
                double avgRank = sum / (double)l.size();
                for (int k = 0; k < l.size(); ++k) {
                    rankCounter.setCount(keys.get(k), avgRank);
                    if (k != l.size() - 1 && it.hasNext()) {
                        it.next();
                    }
                    ++i;
                }
                continue;
            }
            rankCounter.setCount(iKey, i + 1);
            ++i;
        }
        return rankCounter;
    }

    public static <E> List<Pair<E, Double>> toDescendingMagnitudeSortedListWithCounts(Counter<E> c) {
        ArrayList<E> keys = new ArrayList<E>(c.keySet());
        Collections.sort(keys, Counters.toComparator(c, false, true));
        ArrayList l = new ArrayList(keys.size());
        for (Object key : keys) {
            l.add(new Pair(key, c.getCount(key)));
        }
        return l;
    }

    public static <E> List<Pair<E, Double>> toSortedListWithCounts(Counter<E> c) {
        ArrayList<Pair<Pair<E, Double>, Double>> l = new ArrayList<Pair<Pair<E, Double>, Double>>(c.size());
        for (E e : c.keySet()) {
            l.add(new Pair<E, Double>(e, c.getCount(e)));
        }
        Collections.sort(l, (a, b) -> Double.compare((Double)b.second, (Double)a.second));
        return l;
    }

    public static <E> List<Pair<E, Double>> toSortedListWithCounts(Counter<E> c, Comparator<Pair<E, Double>> comparator) {
        ArrayList<Pair<Pair<E, Double>, Double>> l = new ArrayList<Pair<Pair<E, Double>, Double>>(c.size());
        for (E e : c.keySet()) {
            l.add(new Pair<E, Double>(e, c.getCount(e)));
        }
        Collections.sort(l, comparator);
        return l;
    }

    public static <E> PriorityQueue<E> toPriorityQueue(Counter<E> c) {
        BinaryHeapPriorityQueue<E> queue = new BinaryHeapPriorityQueue<E>();
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            queue.add(key, count);
        }
        return queue;
    }

    public static <E, C extends Counter<E>> C union(C c1, C c2) {
        Counter<E> result = c1.getFactory().create();
        Counters.addInPlace(result, c1);
        Counters.addInPlace(result, c2);
        return (C)result;
    }

    public static <E> Counter<E> intersection(Counter<E> c1, Counter<E> c2) {
        Counter<E> result = c1.getFactory().create();
        for (E key : Sets.union(c1.keySet(), c2.keySet())) {
            double count2;
            double count1 = c1.getCount(key);
            double d = count1 < (count2 = c2.getCount(key)) ? count1 : count2;
            double minCount = d;
            if (!(minCount > 0.0)) continue;
            result.setCount(key, minCount);
        }
        return result;
    }

    public static <E> double jaccardCoefficient(Counter<E> c1, Counter<E> c2) {
        double minCount = 0.0;
        double maxCount = 0.0;
        for (E key : Sets.union(c1.keySet(), c2.keySet())) {
            double count2;
            double count1 = c1.getCount(key);
            minCount += count1 < (count2 = c2.getCount(key)) ? count1 : count2;
            maxCount += count1 > count2 ? count1 : count2;
        }
        return minCount / maxCount;
    }

    public static <E> Counter<E> product(Counter<E> c1, Counter<E> c2) {
        Counter<E> result = c1.getFactory().create();
        for (E key : Sets.intersection(c1.keySet(), c2.keySet())) {
            result.setCount(key, c1.getCount(key) * c2.getCount(key));
        }
        return result;
    }

    public static <E> double dotProduct(Counter<E> c1, Counter<E> c2) {
        double dotProd = 0.0;
        if (c1.size() > c2.size()) {
            Counter<E> tmpCnt = c1;
            c1 = c2;
            c2 = tmpCnt;
        }
        for (E key : c1.keySet()) {
            double count1 = c1.getCount(key);
            if (Double.isNaN(count1) || Double.isInfinite(count1)) {
                throw new RuntimeException("Counters.dotProduct infinite or NaN value for key: " + key + '\t' + c1.getCount(key) + '\t' + c2.getCount(key));
            }
            if (count1 == 0.0) continue;
            double count2 = c2.getCount(key);
            if (Double.isNaN(count2) || Double.isInfinite(count2)) {
                throw new RuntimeException("Counters.dotProduct infinite or NaN value for key: " + key + '\t' + c1.getCount(key) + '\t' + c2.getCount(key));
            }
            if (count2 == 0.0) continue;
            dotProd += count1 * count2;
        }
        return dotProd;
    }

    public static <E> double dotProduct(Counter<E> c, double[] a, Index<E> idx) {
        double dotProd = 0.0;
        for (Map.Entry<E, Double> entry : c.entrySet()) {
            int keyIdx = idx.indexOf(entry.getKey());
            if (keyIdx < 0) continue;
            dotProd += entry.getValue() * a[keyIdx];
        }
        return dotProd;
    }

    public static <E> double sumEntries(Counter<E> c1, Collection<E> entries) {
        double dotProd = 0.0;
        for (E entry : entries) {
            dotProd += c1.getCount(entry);
        }
        return dotProd;
    }

    public static <E> Counter<E> add(Counter<E> c1, Collection<E> c2) {
        Counter<E> result = c1.getFactory().create();
        Counters.addInPlace(result, c1);
        for (E key : c2) {
            result.incrementCount(key, 1.0);
        }
        return result;
    }

    public static <E> Counter<E> add(Counter<E> c1, Counter<E> c2) {
        Counter<E> result = c1.getFactory().create();
        for (E key : Sets.union(c1.keySet(), c2.keySet())) {
            result.setCount(key, c1.getCount(key) + c2.getCount(key));
        }
        Counters.retainNonZeros(result);
        return result;
    }

    public static <E> Counter<E> add(Counter<E> c1, double value) {
        Counter<E> result = c1.getFactory().create();
        for (E key : c1.keySet()) {
            result.setCount(key, c1.getCount(key) + value);
        }
        return result;
    }

    public static <E> double optimizedDotProduct(Counter<E> c1, Counter<E> c2) {
        int size2;
        double dotProd = 0.0;
        int size1 = c1.size();
        if (size1 < (size2 = c2.size())) {
            for (E key : c1.keySet()) {
                double count2;
                double count1 = c1.getCount(key);
                if (count1 == 0.0 || (count2 = c2.getCount(key)) == 0.0) continue;
                dotProd += count1 * count2;
            }
        } else {
            for (E key : c2.keySet()) {
                double count1;
                double count2 = c2.getCount(key);
                if (count2 == 0.0 || (count1 = c1.getCount(key)) == 0.0) continue;
                dotProd += count1 * count2;
            }
        }
        return dotProd;
    }

    public static <E> Counter<E> absoluteDifference(Counter<E> c1, Counter<E> c2) {
        Counter<E> result = c1.getFactory().create();
        for (E key : Sets.union(c1.keySet(), c2.keySet())) {
            double newCount = Math.abs(c1.getCount(key) - c2.getCount(key));
            if (!(newCount > 0.0)) continue;
            result.setCount(key, newCount);
        }
        return result;
    }

    public static <E> Counter<E> division(Counter<E> c1, Counter<E> c2) {
        Counter<E> result = c1.getFactory().create();
        for (E key : Sets.union(c1.keySet(), c2.keySet())) {
            result.setCount(key, c1.getCount(key) / c2.getCount(key));
        }
        return result;
    }

    public static <E> Counter<E> divisionNonNaN(Counter<E> c1, Counter<E> c2) {
        Counter<E> result = c1.getFactory().create();
        for (E key : Sets.union(c1.keySet(), c2.keySet())) {
            if (c2.getCount(key) == 0.0) continue;
            result.setCount(key, c1.getCount(key) / c2.getCount(key));
        }
        return result;
    }

    public static <E> double entropy(Counter<E> c) {
        double entropy = 0.0;
        double total = c.totalCount();
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            if (count == 0.0) continue;
            entropy -= (count /= total) * (Math.log(count) / LOG_E_2);
        }
        return entropy;
    }

    public static <E> double crossEntropy(Counter<E> from, Counter<E> to) {
        double tot2 = to.totalCount();
        double result = 0.0;
        for (E key : from.keySet()) {
            double count1 = from.getCount(key);
            if (count1 == 0.0) continue;
            double count2 = to.getCount(key);
            double logFract = Math.log(count2 / tot2);
            if (logFract == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            result += count1 * (logFract / LOG_E_2);
        }
        return result;
    }

    public static <E> double klDivergence(Counter<E> from, Counter<E> to) {
        double result = 0.0;
        double tot = from.totalCount();
        double tot2 = to.totalCount();
        for (E key : from.keySet()) {
            double num = from.getCount(key);
            if (num == 0.0) continue;
            double num2 = to.getCount(key);
            double logFract = Math.log((num /= tot) / (num2 /= tot2));
            if (logFract == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            result += num * (logFract / LOG_E_2);
        }
        return result;
    }

    public static <E> double jensenShannonDivergence(Counter<E> c1, Counter<E> c2) {
        Counter<E> d1 = Counters.asNormalizedCounter(c1);
        Counter<E> d2 = Counters.asNormalizedCounter(c2);
        Counter<E> average = Counters.average(d1, d2);
        double kl1 = Counters.klDivergence(d1, average);
        double kl2 = Counters.klDivergence(d2, average);
        return (kl1 + kl2) / 2.0;
    }

    public static <E> double skewDivergence(Counter<E> c1, Counter<E> c2, double skew) {
        Counter<E> d1 = Counters.asNormalizedCounter(c1);
        Counter<E> d2 = Counters.asNormalizedCounter(c2);
        Counter<E> average = Counters.linearCombination(d2, skew, d1, 1.0 - skew);
        return Counters.klDivergence(d1, average);
    }

    public static <E, C extends Counter<E>> double L2Norm(C c) {
        return Math.sqrt(Counters.sumSquares(c));
    }

    public static <E, C extends Counter<E>> double sumSquares(C c) {
        double lenSq = 0.0;
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            lenSq += count * count;
        }
        return lenSq;
    }

    public static <E, C extends Counter<E>> double L1Norm(C c) {
        double sumAbs = 0.0;
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            if (count == 0.0) continue;
            sumAbs += Math.abs(count);
        }
        return sumAbs;
    }

    public static <E, C extends Counter<E>> C L2Normalize(C c) {
        return Counters.scale(c, 1.0 / Counters.L2Norm(c));
    }

    public static <E> Counter<E> L2NormalizeInPlace(Counter<E> c) {
        return Counters.multiplyInPlace(c, 1.0 / Counters.L2Norm(c));
    }

    public static <E, C extends Counter<E>> double saferL2Norm(C c) {
        double maxVal = 0.0;
        for (E key : c.keySet()) {
            double value = Math.abs(c.getCount(key));
            if (!(value > maxVal)) continue;
            maxVal = value;
        }
        double sqrSum = 0.0;
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            sqrSum += Math.pow(count / maxVal, 2.0);
        }
        return maxVal * Math.sqrt(sqrSum);
    }

    public static <E, C extends Counter<E>> C saferL2Normalize(C c) {
        return Counters.scale(c, 1.0 / Counters.saferL2Norm(c));
    }

    public static <E> double cosine(Counter<E> c1, Counter<E> c2) {
        double dotProd = 0.0;
        double lsq1 = 0.0;
        double lsq2 = 0.0;
        for (E key : c1.keySet()) {
            double count1 = c1.getCount(key);
            if (count1 == 0.0) continue;
            lsq1 += count1 * count1;
            double count2 = c2.getCount(key);
            if (count2 == 0.0) continue;
            dotProd += count1 * count2;
        }
        for (E key : c2.keySet()) {
            double count2 = c2.getCount(key);
            if (count2 == 0.0) continue;
            lsq2 += count2 * count2;
        }
        if (lsq1 != 0.0 && lsq2 != 0.0) {
            double denom = Math.sqrt(lsq1) * Math.sqrt(lsq2);
            return dotProd / denom;
        }
        return 0.0;
    }

    public static <E> Counter<E> average(Counter<E> c1, Counter<E> c2) {
        Counter<E> average = c1.getFactory().create();
        Set<E> allKeys = Generics.newHashSet(c1.keySet());
        allKeys.addAll(c2.keySet());
        for (E key : allKeys) {
            average.setCount(key, (c1.getCount(key) + c2.getCount(key)) * 0.5);
        }
        return average;
    }

    public static <E> Counter<E> linearCombination(Counter<E> c1, double w1, Counter<E> c2, double w2) {
        Counter<E> result = c1.getFactory().create();
        for (E o : c1.keySet()) {
            result.incrementCount(o, c1.getCount(o) * w1);
        }
        for (E o : c2.keySet()) {
            result.incrementCount(o, c2.getCount(o) * w2);
        }
        return result;
    }

    public static <T1, T2> double pointwiseMutualInformation(Counter<T1> var1Distribution, Counter<T2> var2Distribution, Counter<Pair<T1, T2>> jointDistribution, Pair<T1, T2> values) {
        double var1Prob = var1Distribution.getCount(values.first);
        double var2Prob = var2Distribution.getCount(values.second);
        double jointProb = jointDistribution.getCount(values);
        double pmi = Math.log(jointProb) - Math.log(var1Prob) - Math.log(var2Prob);
        return pmi / LOG_E_2;
    }

    public static <E> int hIndex(Counter<E> citationCounts) {
        ClassicCounter<Integer> countCounts = new ClassicCounter<Integer>();
        for (double value : citationCounts.values()) {
            int i = 0;
            while ((double)i <= value) {
                countCounts.incrementCount(i);
                ++i;
            }
        }
        List citationCountValues = CollectionUtils.sorted(countCounts.keySet());
        Collections.reverse(citationCountValues);
        Iterator iterator = citationCountValues.iterator();
        while (iterator.hasNext()) {
            int citationCount = (Integer)iterator.next();
            double occurrences = countCounts.getCount(citationCount);
            if (!(occurrences >= (double)citationCount)) continue;
            return citationCount;
        }
        return 0;
    }

    public static <E, C extends Counter<E>> C perturbCounts(C c, Random random, double p) {
        Counter<E> result = c.getFactory().create();
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            double noise = -Math.log(1.0 - random.nextDouble());
            double perturbedCount = count + noise * p;
            result.setCount(key, perturbedCount);
        }
        return (C)result;
    }

    public static <E> void printCounterComparison(Counter<E> a, Counter<E> b) {
        Counters.printCounterComparison(a, b, System.err);
    }

    public static <E> void printCounterComparison(Counter<E> a, Counter<E> b, PrintStream out2) {
        Counters.printCounterComparison(a, b, new PrintWriter(out2, true));
    }

    public static <E> void printCounterComparison(Counter<E> a, Counter<E> b, PrintWriter out2) {
        if (a.equals(b)) {
            out2.println("Counters are equal.");
            return;
        }
        for (E key : a.keySet()) {
            double bCount;
            double aCount = a.getCount(key);
            if (!(Math.abs(aCount - (bCount = b.getCount(key))) > 1.0E-5)) continue;
            out2.println("Counters differ on key " + key + '\t' + a.getCount(key) + " vs. " + b.getCount(key));
        }
        Set<E> rest = Generics.newHashSet(b.keySet());
        rest.removeAll(a.keySet());
        for (E key : rest) {
            double bCount;
            double aCount = a.getCount(key);
            if (!(Math.abs(aCount - (bCount = b.getCount(key))) > 1.0E-5)) continue;
            out2.println("Counters differ on key " + key + '\t' + a.getCount(key) + " vs. " + b.getCount(key));
        }
    }

    public static <E> Counter<Double> getCountCounts(Counter<E> c) {
        ClassicCounter<Double> result = new ClassicCounter<Double>();
        for (double v : c.values()) {
            result.incrementCount(v);
        }
        return result;
    }

    public static <E, C extends Counter<E>> C scale(C c, double s) {
        Counter<E> scaled = c.getFactory().create();
        for (E key : c.keySet()) {
            scaled.setCount(key, c.getCount(key) * s);
        }
        return (C)scaled;
    }

    public static <E, C extends Counter<E>> C tfLogScale(C c, double base) {
        Counter<E> scaled = c.getFactory().create();
        for (E key : c.keySet()) {
            double cnt = c.getCount(key);
            double scaledCnt = 0.0;
            if (cnt > 0.0) {
                scaledCnt = 1.0 + SloppyMath.log(cnt, base);
            }
            scaled.setCount(key, scaledCnt);
        }
        return (C)scaled;
    }

    public static <E extends Comparable<E>> void printCounterSortedByKeys(Counter<E> c) {
        ArrayList<E> keyList = new ArrayList<E>(c.keySet());
        Collections.sort(keyList);
        for (Comparable o : keyList) {
            System.out.println(o + ":" + c.getCount(o));
        }
    }

    public static <E> ClassicCounter<E> loadCounter(String filename, Class<E> c) throws RuntimeException {
        ClassicCounter counter = new ClassicCounter();
        Counters.loadIntoCounter(filename, c, counter);
        return counter;
    }

    public static <E> IntCounter<E> loadIntCounter(String filename, Class<E> c) throws Exception {
        IntCounter counter = new IntCounter();
        Counters.loadIntoCounter(filename, c, counter);
        return counter;
    }

    private static <E> void loadIntoCounter(String filename, Class<E> c, Counter<E> counter) throws RuntimeException {
        try {
            String line;
            Constructor<E> m = c.getConstructor(String.class);
            BufferedReader in = IOUtils.getBufferedFileReader(filename);
            while ((line = in.readLine()) != null) {
                String[] tokens = line.trim().split("\\s+");
                if (tokens.length != 2) {
                    throw new RuntimeException();
                }
                double value = Double.parseDouble(tokens[1]);
                counter.setCount(m.newInstance(tokens[0]), value);
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <E> void saveCounter(Counter<E> c, OutputStream stream) {
        PrintStream out2 = new PrintStream(stream);
        for (E key : c.keySet()) {
            out2.println(key + " " + c.getCount(key));
        }
    }

    public static <E> void saveCounter(Counter<E> c, String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        Counters.saveCounter(c, fos);
        fos.close();
    }

    public static <T1, T2> TwoDimensionalCounter<T1, T2> load2DCounter(String filename, Class<T1> t1, Class<T2> t2) throws RuntimeException {
        try {
            TwoDimensionalCounter tdc = new TwoDimensionalCounter();
            Counters.loadInto2DCounter(filename, t1, t2, tdc);
            return tdc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T1, T2> void loadInto2DCounter(String filename, Class<T1> t1, Class<T2> t2, TwoDimensionalCounter<T1, T2> tdc) throws RuntimeException {
        try {
            String line;
            Constructor<T1> m1 = t1.getConstructor(String.class);
            Constructor<T2> m2 = t2.getConstructor(String.class);
            BufferedReader in = IOUtils.getBufferedFileReader(filename);
            while ((line = in.readLine()) != null) {
                String[] tuple = line.trim().split("\t");
                String outer = tuple[0];
                String inner = tuple[1];
                String valStr = tuple[2];
                tdc.setCount(m1.newInstance(outer.trim()), m2.newInstance(inner.trim()), Double.parseDouble(valStr.trim()));
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T1, T2> void loadIncInto2DCounter(String filename, Class<T1> t1, Class<T2> t2, TwoDimensionalCounterInterface<T1, T2> tdc) throws RuntimeException {
        try {
            String line;
            Constructor<T1> m1 = t1.getConstructor(String.class);
            Constructor<T2> m2 = t2.getConstructor(String.class);
            BufferedReader in = IOUtils.getBufferedFileReader(filename);
            while ((line = in.readLine()) != null) {
                String[] tuple = line.trim().split("\t");
                String outer = tuple[0];
                String inner = tuple[1];
                String valStr = tuple[2];
                tdc.incrementCount(m1.newInstance(outer.trim()), m2.newInstance(inner.trim()), Double.parseDouble(valStr.trim()));
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T1, T2> void save2DCounter(TwoDimensionalCounter<T1, T2> tdc, String filename) throws IOException {
        PrintWriter out2 = new PrintWriter(new FileWriter(filename));
        for (T1 outer : tdc.firstKeySet()) {
            for (T2 inner : tdc.secondKeySet()) {
                out2.println(outer + "\t" + inner + '\t' + tdc.getCount(outer, inner));
            }
        }
        out2.close();
    }

    public static <T1, T2> void save2DCounterSorted(TwoDimensionalCounterInterface<T1, T2> tdc, String filename) throws IOException {
        PrintWriter out2 = new PrintWriter(new FileWriter(filename));
        for (T1 outer : tdc.firstKeySet()) {
            Counter<T2> c = tdc.getCounter(outer);
            List<T2> keys = Counters.toSortedList(c);
            for (T2 inner : keys) {
                out2.println(outer + "\t" + inner + '\t' + c.getCount(inner));
            }
        }
        out2.close();
    }

    public static <T> void serializeCounter(Counter<T> c, String filename) throws IOException {
        ObjectOutputStream out2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        out2.writeObject(c);
        out2.close();
    }

    public static <T> ClassicCounter<T> deserializeCounter(String filename) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename)));
        ClassicCounter c = (ClassicCounter)ErasureUtils.uncheckedCast(in.readObject());
        in.close();
        return c;
    }

    public static <T> String toSortedString(Counter<T> counter, int k, String itemFormat, String joiner, String wrapperFormat) {
        PriorityQueue<T> queue = Counters.toPriorityQueue(counter);
        ArrayList<String> strings = new ArrayList<String>();
        for (int rank = 0; rank < k && !queue.isEmpty(); ++rank) {
            T key = queue.removeFirst();
            double value = counter.getCount(key);
            strings.add(String.format(itemFormat, key, value));
        }
        return String.format(wrapperFormat, StringUtils.join(strings, joiner));
    }

    public static <T> String toSortedString(Counter<T> counter, int k, String itemFormat, String joiner) {
        return Counters.toSortedString(counter, k, itemFormat, joiner, "%s");
    }

    public static <T extends Comparable<T>> String toSortedByKeysString(Counter<T> counter, String itemFormat, String joiner, String wrapperFormat) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Comparable key : CollectionUtils.sorted(counter.keySet())) {
            strings.add(String.format(itemFormat, key, counter.getCount(key)));
        }
        return String.format(wrapperFormat, StringUtils.join(strings, joiner));
    }

    public static <E> String toString(Counter<E> counter, int maxKeysToPrint) {
        return Counters.toPriorityQueue(counter).toString(maxKeysToPrint);
    }

    public static <E> String toString(Counter<E> counter, NumberFormat nf) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        List<E> list = ErasureUtils.sortedIfPossible(counter.keySet());
        Iterator<E> iter = list.iterator();
        while (iter.hasNext()) {
            E key = iter.next();
            sb.append(key);
            sb.append('=');
            sb.append(nf.format(counter.getCount(key)));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public static <E> String toString(Counter<E> counter, NumberFormat nf, String preAppend, String postAppend, String keyValSeparator, String itemSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(preAppend);
        Iterator<E> iter = counter.keySet().iterator();
        while (iter.hasNext()) {
            E key = iter.next();
            double d = counter.getCount(key);
            sb.append(key);
            sb.append(keyValSeparator);
            sb.append(nf.format(d));
            if (!iter.hasNext()) continue;
            sb.append(itemSeparator);
        }
        sb.append(postAppend);
        return sb.toString();
    }

    public static <E> String toBiggestValuesFirstString(Counter<E> c) {
        return Counters.toPriorityQueue(c).toString();
    }

    public static <E> String toBiggestValuesFirstString(Counter<E> c, int k) {
        PriorityQueue<E> pq = Counters.toPriorityQueue(c);
        BinaryHeapPriorityQueue<E> largestK = new BinaryHeapPriorityQueue<E>();
        while (largestK.size() < k && !pq.isEmpty()) {
            double firstScore = pq.getPriority(pq.getFirst());
            E first = pq.removeFirst();
            largestK.changePriority(first, firstScore);
        }
        return ((Object)largestK).toString();
    }

    public static <T> String toBiggestValuesFirstString(Counter<Integer> c, int k, Index<T> index) {
        PriorityQueue<Integer> pq = Counters.toPriorityQueue(c);
        BinaryHeapPriorityQueue<T> largestK = new BinaryHeapPriorityQueue<T>();
        while (largestK.size() < k && !pq.isEmpty()) {
            double firstScore = pq.getPriority(pq.getFirst());
            int first = pq.removeFirst();
            largestK.changePriority(index.get(first), firstScore);
        }
        return ((Object)largestK).toString();
    }

    public static <E> String toVerticalString(Counter<E> c) {
        return Counters.toVerticalString(c, Integer.MAX_VALUE);
    }

    public static <E> String toVerticalString(Counter<E> c, int k) {
        return Counters.toVerticalString(c, k, "%g\t%s", false);
    }

    public static <E> String toVerticalString(Counter<E> c, String fmt) {
        return Counters.toVerticalString(c, Integer.MAX_VALUE, fmt, false);
    }

    public static <E> String toVerticalString(Counter<E> c, int k, String fmt) {
        return Counters.toVerticalString(c, k, fmt, false);
    }

    public static <E> String toVerticalString(Counter<E> c, int k, String fmt, boolean swap) {
        PriorityQueue<E> q = Counters.toPriorityQueue(c);
        List<E> sortedKeys = q.toSortedList();
        StringBuilder sb = new StringBuilder();
        Iterator<E> keyI = sortedKeys.iterator();
        for (int i = 0; keyI.hasNext() && i < k; ++i) {
            E key = keyI.next();
            double val = q.getPriority(key);
            if (swap) {
                sb.append(String.format(fmt, key, val));
            } else {
                sb.append(String.format(fmt, val, key));
            }
            if (!keyI.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static <E> E restrictedArgMax(Counter<E> c, Collection<E> restriction) {
        E maxKey = null;
        double max = Double.NEGATIVE_INFINITY;
        for (E key : restriction) {
            double count = c.getCount(key);
            if (!(count > max)) continue;
            max = count;
            maxKey = key;
        }
        return maxKey;
    }

    public static <T> Counter<T> toCounter(double[] counts, Index<T> index) {
        if (index.size() < counts.length) {
            throw new IllegalArgumentException("Index not large enough to name all the array elements!");
        }
        ClassicCounter<T> c = new ClassicCounter<T>();
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == 0.0) continue;
            c.setCount(index.get(i), counts[i]);
        }
        return c;
    }

    public static <E> Counter<E> toCounter(Map<Integer, ? extends Number> counts, Index<E> index) {
        ClassicCounter<E> counter = new ClassicCounter<E>();
        for (Map.Entry<Integer, ? extends Number> entry : counts.entrySet()) {
            counter.setCount(index.get(entry.getKey()), entry.getValue().doubleValue());
        }
        return counter;
    }

    public static <E> double[] asArray(Counter<E> counter, Index<E> index) {
        return Counters.asArray(counter, index, index.size());
    }

    public static <E> double[] asArray(Counter<E> counter, Index<E> index, int dimension) {
        if (index.size() == 0) {
            throw new IllegalArgumentException("Empty index");
        }
        Set<E> keys = counter.keySet();
        double[] array = new double[dimension];
        for (E key : keys) {
            int i = index.indexOf(key);
            if (i < 0) continue;
            array[i] = counter.getCount(key);
        }
        return array;
    }

    public static <E> double[] asArray(Counter<E> counter) {
        Set<E> keys = counter.keySet();
        double[] array = new double[counter.size()];
        int i = 0;
        for (E key : keys) {
            array[i] = counter.getCount(key);
            ++i;
        }
        return array;
    }

    public static <T1, T2> TwoDimensionalCounter<T1, T2> scale(TwoDimensionalCounter<T1, T2> c, double d) {
        TwoDimensionalCounter<T1, T2> result = new TwoDimensionalCounter<T1, T2>(c.getOuterMapFactory(), c.getInnerMapFactory());
        for (T1 key : c.firstKeySet()) {
            Counter ctr = c.getCounter((Object)key);
            result.setCounter(key, Counters.scale(ctr, d));
        }
        return result;
    }

    public static <T> T sample(Counter<T> c, Random rand) {
        if (rand == null) {
            rand = RAND;
        }
        double r = rand.nextDouble() * c.totalCount();
        double total = 0.0;
        for (T t : c.keySet()) {
            if (!((total += c.getCount(t)) >= r)) continue;
            return t;
        }
        return c.keySet().iterator().next();
    }

    public static <T> T sample(Counter<T> c) {
        return Counters.sample(c, null);
    }

    public static <E> Counter<E> powNormalized(Counter<E> c, double temp) {
        Counter<E> d = c.getFactory().create();
        double total = c.totalCount();
        for (E e : c.keySet()) {
            d.setCount(e, Math.pow(c.getCount(e) / total, temp));
        }
        return d;
    }

    public static <T> Counter<T> pow(Counter<T> c, double temp) {
        Counter<T> d = c.getFactory().create();
        for (T t : c.keySet()) {
            d.setCount(t, Math.pow(c.getCount(t), temp));
        }
        return d;
    }

    public static <T> void powInPlace(Counter<T> c, double temp) {
        for (T t : c.keySet()) {
            c.setCount(t, Math.pow(c.getCount(t), temp));
        }
    }

    public static <T> Counter<T> exp(Counter<T> c) {
        Counter<T> d = c.getFactory().create();
        for (T t : c.keySet()) {
            d.setCount(t, Math.exp(c.getCount(t)));
        }
        return d;
    }

    public static <T> void expInPlace(Counter<T> c) {
        for (T t : c.keySet()) {
            c.setCount(t, Math.exp(c.getCount(t)));
        }
    }

    public static <T> Counter<T> diff(Counter<T> goldFeatures, Counter<T> guessedFeatures) {
        Counter<T> result = goldFeatures.getFactory().create();
        for (T key : Sets.union(goldFeatures.keySet(), guessedFeatures.keySet())) {
            result.setCount(key, goldFeatures.getCount(key) - guessedFeatures.getCount(key));
        }
        Counters.retainNonZeros(result);
        return result;
    }

    public static <E> boolean equals(Counter<E> o1, Counter<E> o2) {
        return Counters.equals(o1, o2, 0.0);
    }

    public static <E> boolean equals(Counter<E> o1, Counter<E> o2, double tolerance) {
        if (o1 == o2) {
            return true;
        }
        if (Math.abs(o1.totalCount() - o2.totalCount()) > tolerance) {
            return false;
        }
        if (!o1.keySet().equals(o2.keySet())) {
            return false;
        }
        for (E key : o1.keySet()) {
            if (!(Math.abs(o1.getCount(key) - o2.getCount(key)) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static <T> Counter<T> unmodifiableCounter(final Counter<T> counter) {
        return new AbstractCounter<T>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(T key) {
                return counter.containsKey(key);
            }

            @Override
            public double getCount(Object key) {
                return counter.getCount(key);
            }

            @Override
            public Factory<Counter<T>> getFactory() {
                return counter.getFactory();
            }

            @Override
            public double remove(T key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setCount(T key, double value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double incrementCount(T key, double value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double incrementCount(T key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double logIncrementCount(T key, double value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return counter.size();
            }

            @Override
            public double totalCount() {
                return counter.totalCount();
            }

            @Override
            public Collection<Double> values() {
                return counter.values();
            }

            @Override
            public Set<T> keySet() {
                return Collections.unmodifiableSet(counter.keySet());
            }

            @Override
            public Set<Map.Entry<T, Double>> entrySet() {
                return Collections.unmodifiableSet(new AbstractSet<Map.Entry<T, Double>>(){

                    @Override
                    public Iterator<Map.Entry<T, Double>> iterator() {
                        return new Iterator<Map.Entry<T, Double>>(){
                            final Iterator<Map.Entry<T, Double>> inner;
                            {
                                this.inner = counter.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.inner.hasNext();
                            }

                            @Override
                            public Map.Entry<T, Double> next() {
                                return new Map.Entry<T, Double>(){
                                    final Map.Entry<T, Double> e;
                                    {
                                        this.e = inner.next();
                                    }

                                    @Override
                                    public T getKey() {
                                        return this.e.getKey();
                                    }

                                    @Override
                                    public Double getValue() {
                                        return (double)this.e.getValue();
                                    }

                                    @Override
                                    public Double setValue(Double value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return counter.size();
                    }
                });
            }

            @Override
            public void setDefaultReturnValue(double rv) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double defaultReturnValue() {
                return counter.defaultReturnValue();
            }

            @Override
            public void prettyLog(Redwood.RedwoodChannels channels, String description) {
                PrettyLogger.log(channels, description, Counters.asMap(this));
            }
        };
    }

    public static <E> Counter<E> asCounter(FixedPrioritiesPriorityQueue<E> p) {
        Object pq = p.clone();
        ClassicCounter counter = new ClassicCounter();
        while (((FixedPrioritiesPriorityQueue)pq).hasNext()) {
            double priority = ((FixedPrioritiesPriorityQueue)pq).getPriority();
            Object element = ((FixedPrioritiesPriorityQueue)pq).next();
            counter.incrementCount(element, priority);
        }
        return counter;
    }

    public static <E, N extends Number> Counter<E> fromMap(Map<E, N> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Map must have at least one element to infer numeric type; add an element first or use e.g. fromMap(map, Integer.class)");
        }
        return Counters.fromMap(map, ((Number)map.values().iterator().next()).getClass());
    }

    public static <E, N extends Number> Counter<E> fromMap(final Map<E, N> map, final Class<N> type) {
        double initialTotal = 0.0;
        for (Map.Entry<E, N> entry : map.entrySet()) {
            initialTotal += ((Number)entry.getValue()).doubleValue();
        }
        final double initialTotalFinal = initialTotal;
        return new AbstractCounter<E>(){
            double total;
            double defRV;
            {
                this.total = initialTotalFinal;
                this.defRV = 0.0;
            }

            @Override
            public void clear() {
                map.clear();
                this.total = 0.0;
            }

            @Override
            public boolean containsKey(E key) {
                return map.containsKey(key);
            }

            @Override
            public void setDefaultReturnValue(double rv) {
                this.defRV = rv;
            }

            @Override
            public double defaultReturnValue() {
                return this.defRV;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Counter)) {
                    return false;
                }
                return Counters.equals(this, (Counter)o);
            }

            public int hashCode() {
                return map.hashCode();
            }

            @Override
            public Set<Map.Entry<E, Double>> entrySet() {
                return new AbstractSet<Map.Entry<E, Double>>(){
                    Set<Map.Entry<E, N>> entries;
                    {
                        this.entries = map.entrySet();
                    }

                    @Override
                    public Iterator<Map.Entry<E, Double>> iterator() {
                        return new Iterator<Map.Entry<E, Double>>(){
                            Iterator<Map.Entry<E, N>> it;
                            Map.Entry<E, N> lastEntry;
                            {
                                this.it = entries.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Map.Entry<E, Double> next() {
                                final Map.Entry entry = this.it.next();
                                this.lastEntry = entry;
                                return new Map.Entry<E, Double>(){

                                    @Override
                                    public E getKey() {
                                        return entry.getKey();
                                    }

                                    @Override
                                    public Double getValue() {
                                        return ((Number)entry.getValue()).doubleValue();
                                    }

                                    @Override
                                    public Double setValue(Double value) {
                                        double rv;
                                        double lastValue = ((Number)entry.getValue()).doubleValue();
                                        if (type == Double.class) {
                                            rv = ((Map.Entry)ErasureUtils.uncheckedCast(entry)).setValue(value);
                                        } else if (type == Integer.class) {
                                            rv = ((Map.Entry)ErasureUtils.uncheckedCast(entry)).setValue(value.intValue()).intValue();
                                        } else if (type == Float.class) {
                                            rv = ((Map.Entry)ErasureUtils.uncheckedCast(entry)).setValue(Float.valueOf(value.floatValue())).floatValue();
                                        } else if (type == Long.class) {
                                            rv = ((Map.Entry)ErasureUtils.uncheckedCast(entry)).setValue(value.longValue()).longValue();
                                        } else if (type == Short.class) {
                                            rv = ((Map.Entry)ErasureUtils.uncheckedCast(entry)).setValue(value.shortValue()).shortValue();
                                        } else {
                                            throw new RuntimeException("Unrecognized numeric type in wrapped counter");
                                        }
                                        total += ((Number)entry.getValue()).doubleValue() - lastValue;
                                        return rv;
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                total -= ((Number)this.lastEntry.getValue()).doubleValue();
                                this.it.remove();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return map.size();
                    }
                };
            }

            @Override
            public double getCount(Object key) {
                Number value = (Number)map.get(key);
                return value != null ? value.doubleValue() : this.defRV;
            }

            @Override
            public Factory<Counter<E>> getFactory() {
                return new Factory<Counter<E>>(){
                    private static final long serialVersionUID = -4063129407369590522L;

                    @Override
                    public Counter<E> create() {
                        return Counters.fromMap(Generics.newHashMap(), type);
                    }
                };
            }

            @Override
            public Set<E> keySet() {
                return new AbstractSet<E>(){

                    @Override
                    public Iterator<E> iterator() {
                        return new Iterator<E>(){
                            Iterator<E> it;
                            {
                                this.it = map.keySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public E next() {
                                return this.it.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Cannot remove from key set");
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return map.size();
                    }
                };
            }

            @Override
            public double remove(E key) {
                Number removed = (Number)map.remove(key);
                if (removed != null) {
                    double rv = removed.doubleValue();
                    this.total -= rv;
                    return rv;
                }
                return this.defRV;
            }

            @Override
            public void setCount(E key, double value) {
                double newValue;
                Double lastValue;
                if (type == Double.class) {
                    lastValue = ((Map)ErasureUtils.uncheckedCast(map)).put(key, value);
                    newValue = value;
                } else if (type == Integer.class) {
                    Integer last = ((Map)ErasureUtils.uncheckedCast(map)).put(key, (int)value);
                    lastValue = last != null ? Double.valueOf(last.doubleValue()) : null;
                    newValue = (int)value;
                } else if (type == Float.class) {
                    Float last = ((Map)ErasureUtils.uncheckedCast(map)).put(key, Float.valueOf((float)value));
                    lastValue = last != null ? Double.valueOf(last.doubleValue()) : null;
                    newValue = (float)value;
                } else if (type == Long.class) {
                    Long last = ((Map)ErasureUtils.uncheckedCast(map)).put(key, (long)value);
                    lastValue = last != null ? Double.valueOf(last.doubleValue()) : null;
                    newValue = (long)value;
                } else if (type == Short.class) {
                    Short last = ((Map)ErasureUtils.uncheckedCast(map)).put(key, (short)value);
                    lastValue = last != null ? Double.valueOf(last.doubleValue()) : null;
                    newValue = (short)value;
                } else {
                    throw new RuntimeException("Unrecognized numeric type in wrapped counter");
                }
                this.total += newValue - (lastValue != null ? lastValue : 0.0);
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public double totalCount() {
                return this.total;
            }

            @Override
            public Collection<Double> values() {
                return new AbstractCollection<Double>(){

                    @Override
                    public Iterator<Double> iterator() {
                        return new Iterator<Double>(){
                            final Iterator<N> it;
                            {
                                this.it = map.values().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Double next() {
                                return ((Number)this.it.next()).doubleValue();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Cannot remove from values collection");
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return map.size();
                    }
                };
            }

            @Override
            public void prettyLog(Redwood.RedwoodChannels channels, String description) {
                PrettyLogger.log(channels, description, (Object)map);
            }
        };
    }

    public static <E> Map<E, Double> asMap(final Counter<E> counter) {
        return new AbstractMap<E, Double>(){

            @Override
            public int size() {
                return counter.size();
            }

            @Override
            public Set<Map.Entry<E, Double>> entrySet() {
                return counter.entrySet();
            }

            @Override
            public boolean containsKey(Object key) {
                return counter.containsKey(key);
            }

            @Override
            public Double get(Object key) {
                return counter.getCount(key);
            }

            @Override
            public Double put(E key, Double value) {
                double last = counter.getCount(key);
                counter.setCount(key, value);
                return last;
            }

            @Override
            public Double remove(Object key) {
                return counter.remove(key);
            }

            @Override
            public Set<E> keySet() {
                return counter.keySet();
            }
        };
    }

    public static <E> boolean isUniformDistribution(Counter<E> distribution, double tolerance) {
        double value = Double.NaN;
        double totalCount = 0.0;
        for (double val : distribution.values()) {
            if (Double.isNaN(value)) {
                value = val;
            }
            if (Math.abs(val - value) > tolerance) {
                return false;
            }
            totalCount += val;
        }
        return Math.abs(totalCount - 1.0) < tolerance;
    }

    public static <E> Counter<E> getCopy(Counter<E> originalCounter) {
        ClassicCounter<E> copyCounter = new ClassicCounter<E>();
        copyCounter.addAll(originalCounter);
        return copyCounter;
    }

    public static <E> void maxInPlace(Counter<E> target, Counter<E> other) {
        for (E e : CollectionUtils.union(other.keySet(), target.keySet())) {
            target.setCount(e, Math.max(target.getCount(e), other.getCount(e)));
        }
    }

    public static <E> void minInPlace(Counter<E> target, Counter<E> other) {
        for (E e : CollectionUtils.union(other.keySet(), target.keySet())) {
            target.setCount(e, Math.min(target.getCount(e), other.getCount(e)));
        }
    }

    public static <E> void retainTopMass(Counter<E> counter, double thresholdCount) {
        double value;
        PriorityQueue<E> queue = Counters.toPriorityQueue(counter);
        counter.clear();
        for (double mass = 0.0; mass < thresholdCount && !queue.isEmpty(); mass += value) {
            value = queue.getPriority();
            E key = queue.removeFirst();
            counter.setCount(key, value);
        }
    }

    public static <A, B> void divideInPlace(TwoDimensionalCounter<A, B> counter, double divisor) {
        for (Map.Entry<A, ClassicCounter<B>> c : counter.entrySet()) {
            Counters.divideInPlace((Counter)c.getValue(), divisor);
        }
        counter.recomputeTotal();
    }

    public static <E> double pearsonsCorrelationCoefficient(Counter<E> x, Counter<E> y) {
        double stddevX = Counters.standardDeviation(x);
        double stddevY = Counters.standardDeviation(y);
        double meanX = Counters.mean(x);
        double meanY = Counters.mean(y);
        Counter<E> t1 = Counters.add(x, -meanX);
        Counter<E> t2 = Counters.add(y, -meanY);
        Counters.divideInPlace(t1, stddevX);
        Counters.divideInPlace(t2, stddevY);
        return Counters.dotProduct(t1, t2) / (double)(x.size() - 1);
    }

    public static <E> double spearmanRankCorrelation(Counter<E> x, Counter<E> y) {
        Counter<E> xrank = Counters.toTiedRankCounter(x);
        Counter<E> yrank = Counters.toTiedRankCounter(y);
        return Counters.pearsonsCorrelationCoefficient(xrank, yrank);
    }

    public static <E> void ensureKeys(Counter<E> t, Collection<E> keys, double value) {
        for (E k : keys) {
            if (t.containsKey(k)) continue;
            t.setCount(k, value);
        }
    }

    public static <E> List<E> topKeys(Counter<E> t, int topNum) {
        ArrayList<E> list = new ArrayList<E>();
        PriorityQueue<E> q = Counters.toPriorityQueue(t);
        for (int num = 0; !q.isEmpty() && num < topNum; ++num) {
            list.add(q.removeFirst());
        }
        return list;
    }

    public static <E> List<Pair<E, Double>> topKeysWithCounts(Counter<E> t, int topNum) {
        ArrayList<Pair<Pair<E, Double>, Double>> list = new ArrayList<Pair<Pair<E, Double>, Double>>();
        PriorityQueue<E> q = Counters.toPriorityQueue(t);
        for (int num = 0; !q.isEmpty() && num < topNum; ++num) {
            E k = q.removeFirst();
            list.add(new Pair<E, Double>(k, t.getCount(k)));
        }
        return list;
    }

    public static <E> Counter<E> getFCounter(Counter<E> precision, Counter<E> recall, double beta) {
        ClassicCounter<E> fscores = new ClassicCounter<E>();
        for (E k : precision.keySet()) {
            fscores.setCount(k, precision.getCount(k) * recall.getCount(k) * (1.0 + beta * beta) / (beta * beta * precision.getCount(k) + recall.getCount(k)));
        }
        return fscores;
    }

    public static <E> void transformValuesInPlace(Counter<E> counter, Function<Double, Double> func) {
        for (E key : counter.keySet()) {
            counter.setCount(key, func.apply(counter.getCount(key)));
        }
    }

    public static <E> Counter<E> getCounts(Counter<E> c, Collection<E> keys) {
        ClassicCounter<E> newcounter = new ClassicCounter<E>();
        for (E k : keys) {
            newcounter.setCount(k, c.getCount(k));
        }
        return newcounter;
    }

    public static <E> void retainKeys(Counter<E> counter, Function<E, Boolean> retainFunction) {
        HashSet<E> remove = new HashSet<E>();
        for (Map.Entry<E, Double> en : counter.entrySet()) {
            if (retainFunction.apply(en.getKey()).booleanValue()) continue;
            remove.add(en.getKey());
        }
        Counters.removeKeys(counter, remove);
    }

    public static <E, E2> Counter<E> flatten(Map<E2, Counter<E>> hier) {
        ClassicCounter<E> flat = new ClassicCounter<E>();
        for (Map.Entry<E2, Counter<E>> en : hier.entrySet()) {
            flat.addAll(en.getValue());
        }
        return flat;
    }

    public static <E> boolean isFinite(Counter<E> counts) {
        for (double value : counts.values()) {
            if (!Double.isInfinite(value) && !Double.isNaN(value)) continue;
            return false;
        }
        return true;
    }

    static class NaturalComparator<E>
    implements Comparator<E> {
        public String toString() {
            return "NaturalComparator";
        }

        @Override
        public int compare(E o1, E o2) {
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return 0;
        }
    }
}

