/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.scoref.CompressedFeatureVector;
import edu.stanford.nlp.scoref.Compressor;
import edu.stanford.nlp.scoref.Example;
import edu.stanford.nlp.scoref.MetaFeatureExtractor;
import edu.stanford.nlp.scoref.PairwiseModel;
import edu.stanford.nlp.scoref.SimpleLinearClassifier;
import edu.stanford.nlp.stats.Counter;
import java.util.Map;

public class MaxMarginMentionRanker
extends PairwiseModel {
    private final SimpleLinearClassifier.Loss[] losses = new SimpleLinearClassifier.Loss[ErrorType.values().length];
    private final SimpleLinearClassifier.Loss loss;
    public final double[] costs;
    public final boolean multiplicativeCost;

    public static Builder newBuilder(String name, MetaFeatureExtractor meta) {
        return new Builder(name, meta);
    }

    public MaxMarginMentionRanker(Builder builder) {
        super(builder);
        this.costs = builder.costs;
        this.multiplicativeCost = builder.multiplicativeCost;
        if (this.multiplicativeCost) {
            for (ErrorType et : ErrorType.values()) {
                this.losses[et.id] = SimpleLinearClassifier.maxMargin(builder.costs[et.id]);
            }
        }
        this.loss = SimpleLinearClassifier.maxMargin(1.0);
    }

    public void learn(Example correct, Example incorrect, Map<Integer, CompressedFeatureVector> mentionFeatures, Compressor<String> compressor, ErrorType errorType) {
        Counter<String> cFeatures = this.meta.getFeatures(correct, mentionFeatures, compressor);
        Counter<String> iFeatures = this.meta.getFeatures(incorrect, mentionFeatures, compressor);
        for (Map.Entry<String, Double> e : cFeatures.entrySet()) {
            iFeatures.decrementCount(e.getKey(), e.getValue());
        }
        if (this.multiplicativeCost) {
            this.classifier.learn(iFeatures, 1.0, this.costs[errorType.id], this.loss);
        } else {
            this.classifier.learn(iFeatures, 1.0, 1.0, this.losses[errorType.id]);
        }
    }

    public static class Builder
    extends PairwiseModel.Builder {
        private double[] costs = new double[]{1.2, 1.2, 0.5, 1.0};
        private boolean multiplicativeCost = true;

        public Builder(String name, MetaFeatureExtractor meta) {
            super(name, meta);
        }

        public Builder setCosts(double fnCost, double fnPronounCost, double faCost, double wlCost) {
            this.costs = new double[]{fnCost, fnPronounCost, faCost, wlCost};
            return this;
        }

        public Builder multiplicativeCost(boolean multiplicativeCost) {
            this.multiplicativeCost = multiplicativeCost;
            return this;
        }

        @Override
        public MaxMarginMentionRanker build() {
            return new MaxMarginMentionRanker(this);
        }
    }

    public static enum ErrorType {
        FN(0),
        FN_PRON(1),
        FL(2),
        WL(3);

        public final int id;

        private ErrorType(int id) {
            this.id = id;
        }
    }
}

