/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.scoref.Clusterer;
import edu.stanford.nlp.scoref.ClustererDataLoader;
import edu.stanford.nlp.scoref.Compressor;
import edu.stanford.nlp.scoref.DocumentExamples;
import edu.stanford.nlp.scoref.Example;
import edu.stanford.nlp.scoref.FeatureExtractor;
import edu.stanford.nlp.scoref.MetaFeatureExtractor;
import edu.stanford.nlp.scoref.PairwiseModel;
import edu.stanford.nlp.scoref.StatisticalCorefSystem;
import edu.stanford.nlp.scoref.StatisticalCorefUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class ClusteringCorefSystem
extends StatisticalCorefSystem {
    private final Clusterer clusterer;
    private final PairwiseModel classificationModel;
    private final PairwiseModel rankingModel;
    private final PairwiseModel anaphoricityModel;
    private final FeatureExtractor extractor;

    public ClusteringCorefSystem(Properties props, String clusteringPath, String classificationPath, String rankingPath, String anaphoricityPath, String wordCountsPath) {
        super(props);
        this.clusterer = new Clusterer(clusteringPath);
        this.classificationModel = PairwiseModel.newBuilder("classification", MetaFeatureExtractor.newBuilder().build()).modelPath(classificationPath).build();
        this.rankingModel = PairwiseModel.newBuilder("ranking", MetaFeatureExtractor.newBuilder().build()).modelPath(rankingPath).build();
        this.anaphoricityModel = PairwiseModel.newBuilder("anaphoricity", MetaFeatureExtractor.anaphoricityMFE()).modelPath(anaphoricityPath).build();
        this.extractor = new FeatureExtractor(props, this.dictionaries, null, wordCountsPath);
    }

    @Override
    public void runCoref(Document document) {
        Map<Pair<Integer, Integer>, Boolean> mentionPairs = StatisticalCorefUtils.getUnlabeledMentionPairs(document);
        if (mentionPairs.keySet().size() == 0) {
            return;
        }
        Compressor<String> compressor = new Compressor<String>();
        DocumentExamples examples = this.extractor.extract(0, document, mentionPairs, compressor);
        ClassicCounter<Pair<Integer, Integer>> classificationScores = new ClassicCounter<Pair<Integer, Integer>>();
        ClassicCounter<Pair<Integer, Integer>> rankingScores = new ClassicCounter<Pair<Integer, Integer>>();
        ClassicCounter<Integer> anaphoricityScores = new ClassicCounter<Integer>();
        for (Example example : examples.examples) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            Pair<Integer, Integer> mentionPair = new Pair<Integer, Integer>(example.mentionId1, example.mentionId2);
            classificationScores.incrementCount(mentionPair, this.classificationModel.predict(example, examples.mentionFeatures, compressor));
            rankingScores.incrementCount(mentionPair, this.rankingModel.predict(example, examples.mentionFeatures, compressor));
            if (anaphoricityScores.containsKey(example.mentionId2)) continue;
            anaphoricityScores.incrementCount(example.mentionId2, this.anaphoricityModel.predict(new Example(example, false), examples.mentionFeatures, compressor));
        }
        ClustererDataLoader.ClustererDoc doc = new ClustererDataLoader.ClustererDoc(0, classificationScores, rankingScores, anaphoricityScores, mentionPairs, null, document.predictedMentionsByID.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Mention)e.getValue()).mentionType.toString())));
        for (Pair<Integer, Integer> mentionPair : this.clusterer.getClusterMerges(doc)) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            StatisticalCorefUtils.mergeCoreferenceClusters(mentionPair, document);
        }
    }
}

