/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.scoref.Compressor;
import edu.stanford.nlp.scoref.DocumentExamples;
import edu.stanford.nlp.scoref.Example;
import edu.stanford.nlp.scoref.FeatureExtractor;
import edu.stanford.nlp.scoref.MetaFeatureExtractor;
import edu.stanford.nlp.scoref.PairwiseModel;
import edu.stanford.nlp.scoref.StatisticalCorefSystem;
import edu.stanford.nlp.scoref.StatisticalCorefUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BestFirstCorefSystem
extends StatisticalCorefSystem {
    private final Map<Pair<Boolean, Boolean>, Double> thresholds;
    private final FeatureExtractor extractor;
    private final PairwiseModel classifier;
    private final int maxMentionDistance;
    private final int maxMentionDistanceWithStringMatch;
    public static int i = 0;

    public BestFirstCorefSystem(Properties props, String wordCountsFile, String modelFile, int maxMentionDistance, int maxMentionDistanceWithStringMatch, double threshold) {
        this(props, wordCountsFile, modelFile, maxMentionDistance, maxMentionDistanceWithStringMatch, new double[]{threshold, threshold, threshold, threshold});
    }

    public BestFirstCorefSystem(Properties props, String wordCountsFile, String modelPath, int maxMentionDistance, int maxMentionDistanceWithStringMatch, double[] thresholds) {
        super(props);
        this.extractor = new FeatureExtractor(props, this.dictionaries, null, wordCountsFile);
        this.classifier = PairwiseModel.newBuilder("classifier", MetaFeatureExtractor.newBuilder().build()).modelPath(modelPath).build();
        this.maxMentionDistance = maxMentionDistance;
        this.maxMentionDistanceWithStringMatch = maxMentionDistanceWithStringMatch;
        this.thresholds = BestFirstCorefSystem.makeThresholds(thresholds);
    }

    private static Map<Pair<Boolean, Boolean>, Double> makeThresholds(double[] thresholds) {
        HashMap<Pair<Boolean, Boolean>, Double> thresholdsMap = new HashMap<Pair<Boolean, Boolean>, Double>();
        thresholdsMap.put(new Pair<Boolean, Boolean>(true, true), thresholds[0]);
        thresholdsMap.put(new Pair<Boolean, Boolean>(true, false), thresholds[1]);
        thresholdsMap.put(new Pair<Boolean, Boolean>(false, true), thresholds[2]);
        thresholdsMap.put(new Pair<Boolean, Boolean>(false, false), thresholds[3]);
        return thresholdsMap;
    }

    @Override
    public void runCoref(Document document) {
        Compressor<String> compressor = new Compressor<String>();
        List<Mention> sortedMentions = StatisticalCorefUtils.getSortedMentions(document);
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        for (int i = 0; i < sortedMentions.size(); ++i) {
            sortedMentions.get((int)i).mentionNum = i;
        }
        Map<Pair<Integer, Integer>, Boolean> pairs = StatisticalCorefUtils.getUnlabeledMentionPairs(document, this.maxMentionDistance);
        if (this.maxMentionDistance != Integer.MAX_VALUE) {
            HashMap wordToMentions = new HashMap();
            for (Mention mention : document.predictedMentionsByID.values()) {
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                for (String word : BestFirstCorefSystem.getContentWords(mention)) {
                    wordToMentions.putIfAbsent(word, new ArrayList());
                    ((List)wordToMentions.get(word)).add(mention);
                }
            }
            for (Mention mention : document.predictedMentionsByID.values()) {
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                for (String word : BestFirstCorefSystem.getContentWords(mention)) {
                    List ms = (List)wordToMentions.get(word);
                    if (ms == null) continue;
                    for (Mention m2 : ms) {
                        if (mention.mentionNum >= m2.mentionNum || mention.mentionNum < m2.mentionNum - this.maxMentionDistanceWithStringMatch) continue;
                        pairs.put(new Pair<Integer, Integer>(mention.mentionID, m2.mentionID), false);
                    }
                }
            }
        }
        DocumentExamples examples = this.extractor.extract(0, document, pairs, compressor);
        ClassicCounter<Pair<Integer, Integer>> pairwiseScores = new ClassicCounter<Pair<Integer, Integer>>();
        for (Example mentionPair : examples.examples) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            pairwiseScores.incrementCount(new Pair<Integer, Integer>(mentionPair.mentionId1, mentionPair.mentionId2), this.classifier.predict(mentionPair, examples.mentionFeatures, compressor));
        }
        ArrayList arrayList = new ArrayList(pairwiseScores.keySet());
        Collections.sort(arrayList, (p1, p2) -> {
            double diff = pairwiseScores.getCount(p2) - pairwiseScores.getCount(p1);
            return diff == 0.0 ? 0 : (int)Math.signum(diff);
        });
        HashSet seenAnaphors = new HashSet();
        for (Pair pair : arrayList) {
            if (seenAnaphors.contains(pair.second)) continue;
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            seenAnaphors.add(pair.second);
            Dictionaries.MentionType mt1 = document.predictedMentionsByID.get(pair.first).mentionType;
            Dictionaries.MentionType mt2 = document.predictedMentionsByID.get(pair.second).mentionType;
            double d = pairwiseScores.getCount(pair);
            Pair<Boolean, Boolean> pair2 = new Pair<Boolean, Boolean>(mt1 == Dictionaries.MentionType.PRONOMINAL, mt2 == Dictionaries.MentionType.PRONOMINAL);
            if (!(d > this.thresholds.get(pair2))) continue;
            StatisticalCorefUtils.mergeCoreferenceClusters(pair, document);
        }
    }

    private static List<String> getContentWords(Mention m) {
        ArrayList<String> words = new ArrayList<String>();
        for (int i = m.startIndex; i < m.endIndex; ++i) {
            CoreLabel cl = m.sentenceWords.get(i);
            String POS = (String)cl.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (!POS.equals("NN") && !POS.equals("NNS") && !POS.equals("NNP") && !POS.equals("NNPS")) continue;
            words.add(cl.word().toLowerCase());
        }
        return words;
    }
}

