/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.ScorePatterns;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CollectionUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ScorePatternsF1<E>
extends ScorePatterns<E> {
    Counter<CandidatePhrase> p0Set = null;
    E p0;

    public ScorePatternsF1(ConstantsAndVariables constVars, GetPatternsFromDataMultiClass.PatternScoring patternScoring, String label, Set<CandidatePhrase> allCandidatePhrases, TwoDimensionalCounter<E, CandidatePhrase> patternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> negPatternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> unLabeledPatternsandWords4Label, Properties props, Counter<CandidatePhrase> p0Set, E p0) {
        super(constVars, patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, props);
        this.p0 = p0;
        this.p0Set = p0Set;
    }

    @Override
    public void setUp(Properties props) {
    }

    @Override
    public Counter<E> score() {
        ClassicCounter specificity = new ClassicCounter();
        ClassicCounter sensitivity = new ClassicCounter();
        if (this.p0Set.keySet().size() == 0) {
            throw new RuntimeException("how come p0set size is empty for " + this.p0 + "?");
        }
        for (Map.Entry en : this.patternsandWords4Label.entrySet()) {
            int common = CollectionUtils.intersection(en.getValue().keySet(), this.p0Set.keySet()).size();
            if (common == 0) continue;
            if (en.getValue().keySet().size() == 0) {
                throw new RuntimeException("how come counter for " + en.getKey() + " is empty?");
            }
            specificity.setCount(en.getKey(), (double)common / (double)en.getValue().keySet().size());
            sensitivity.setCount(en.getKey(), (double)common / (double)this.p0Set.size());
        }
        Counters.retainNonZeros(specificity);
        Counters.retainNonZeros(sensitivity);
        Counter add = Counters.add(sensitivity, specificity);
        Counter product = Counters.product(sensitivity, specificity);
        Counters.retainNonZeros(product);
        Counters.retainKeys(product, add.keySet());
        Counter finalPat = Counters.scale(Counters.division(product, add), 2.0);
        return finalPat;
    }
}

