/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.dep.DataInstanceDep;
import edu.stanford.nlp.patterns.surface.DataInstanceSurface;
import edu.stanford.nlp.util.CoreMap;
import java.io.Serializable;
import java.util.List;

public abstract class DataInstance
implements Serializable {
    public abstract List<CoreLabel> getTokens();

    public static DataInstance getNewSurfaceInstance(List<CoreLabel> tokens) {
        return new DataInstanceSurface(tokens);
    }

    public static DataInstance getNewInstance(PatternFactory.PatternType type, CoreMap s) {
        if (type.equals((Object)PatternFactory.PatternType.SURFACE)) {
            return new DataInstanceSurface((List)s.get(CoreAnnotations.TokensAnnotation.class));
        }
        if (type.equals((Object)PatternFactory.PatternType.DEP)) {
            return new DataInstanceDep(s);
        }
        throw new UnsupportedOperationException();
    }
}

