/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.types;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.types.AssignableExpression;
import edu.stanford.nlp.ling.tokensregex.types.Expression;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.ling.tokensregex.types.ValueFunction;
import edu.stanford.nlp.ling.tokensregex.types.ValueFunctions;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class Expressions {
    public static final String TYPE_VAR = "VAR";
    public static final String TYPE_FUNCTION = "FUNCTION";
    public static final String TYPE_REGEX = "REGEX";
    public static final String TYPE_STRING_REGEX = "STRING_REGEX";
    public static final String TYPE_TOKEN_REGEX = "TOKEN_REGEX";
    public static final String TYPE_REGEXMATCHVAR = "REGEXMATCHVAR";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_NUMBER = "NUMBER";
    public static final String TYPE_COMPOSITE = "COMPOSITE";
    public static final String TYPE_LIST = "LIST";
    public static final String TYPE_SET = "SET";
    public static final String TYPE_ANNOTATION_KEY = "ANNOKEY";
    public static final String TYPE_CLASS = "CLASS";
    public static final String TYPE_TOKENS = "TOKENS";
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String VAR_SELF = "_";
    public static final Value<Boolean> TRUE = new PrimitiveValue<Boolean>("BOOLEAN", true, new String[0]);
    public static final Value<Boolean> FALSE = new PrimitiveValue<Boolean>("BOOLEAN", false, new String[0]);
    public static final Value NIL = new PrimitiveValue<Object>("NIL", null, new String[0]);
    private static final Pattern DIGITS_PATTERN = Pattern.compile("\\d+");
    protected static final String NEWLINE = System.getProperty("line.separator");

    private Expressions() {
    }

    public static Boolean convertValueToBoolean(Value v, boolean keepNull) {
        Object obj;
        Boolean res = null;
        if (v != null && (obj = v.get()) != null) {
            res = obj instanceof Boolean ? Boolean.valueOf((Boolean)obj) : (obj instanceof Integer ? Boolean.valueOf((Integer)obj != 0) : Boolean.valueOf(true));
            return res;
        }
        return keepNull ? res : false;
    }

    public static Value<Boolean> convertValueToBooleanValue(Value v, boolean keepNull) {
        if (v != null) {
            Object obj = v.get();
            if (obj instanceof Boolean) {
                return v;
            }
            return new PrimitiveValue<Boolean>(TYPE_BOOLEAN, Expressions.convertValueToBoolean(v, keepNull), new String[0]);
        }
        return keepNull ? null : FALSE;
    }

    public static <C> C asObject(Env env, Object v) {
        if (v instanceof Expression) {
            return (C)((Expression)v).evaluate(env, new Object[0]).get();
        }
        return (C)v;
    }

    public static Expression asExpression(Env env, Object v) {
        if (v instanceof Expression) {
            return (Expression)v;
        }
        return Expressions.createValue(null, v, new String[0]);
    }

    public static Value asValue(Env env, Object v) {
        if (v instanceof Value) {
            return (Value)v;
        }
        return Expressions.createValue(null, v, new String[0]);
    }

    public static <T> Value createValue(String typename, T value, String ... tags) {
        if (value instanceof Value) {
            return (Value)value;
        }
        if (typename == null && value != null) {
            typename = value.getClass().getName();
        }
        return new PrimitiveValue<T>(typename, value, tags);
    }

    private static final boolean isArgTypesCompatible(Class[] paramTypes, Class[] targetParamTypes) {
        boolean compatible = true;
        if (targetParamTypes.length == paramTypes.length) {
            for (int i = 0; i < targetParamTypes.length; ++i) {
                if (targetParamTypes[i].isPrimitive()) {
                    compatible = false;
                    if (paramTypes[i] != null) {
                        try {
                            Class type = (Class)paramTypes[i].getField("TYPE").get(null);
                            if (type.equals(targetParamTypes[i])) {
                                compatible = true;
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                    if (compatible) continue;
                    break;
                }
                if (paramTypes[i] == null || targetParamTypes[i].isAssignableFrom(paramTypes[i])) continue;
                compatible = false;
                break;
            }
        } else {
            compatible = false;
        }
        return compatible;
    }

    public static class CompositeValue
    extends SimpleCachedExpression<Map<String, Expression>>
    implements Value<Map<String, Expression>> {
        public CompositeValue(String ... tags) {
            super(Expressions.TYPE_COMPOSITE, new HashMap(), tags);
        }

        public CompositeValue(Map<String, Expression> m, boolean isEvaluated, String ... tags) {
            super(Expressions.TYPE_COMPOSITE, m, tags);
            if (isEvaluated) {
                this.evaluated = this;
                this.disableCaching = !this.checkValue();
            }
        }

        private boolean checkValue() {
            boolean ok = true;
            for (String key : ((Map)this.value).keySet()) {
                Expression expr = (Expression)((Map)this.value).get(key);
                if (expr == null || expr.hasValue()) continue;
                ok = false;
            }
            return ok;
        }

        public Set<String> getAttributes() {
            return ((Map)this.value).keySet();
        }

        public Expression getExpression(String attr) {
            return (Expression)((Map)this.value).get(attr);
        }

        public Value getValue(String attr) {
            Expression expr = (Expression)((Map)this.value).get(attr);
            if (expr == null) {
                return null;
            }
            if (expr instanceof Value) {
                return (Value)expr;
            }
            throw new UnsupportedOperationException("Expression was not evaluated....");
        }

        public <T> T get(String attr) {
            Expression expr = (Expression)((Map)this.value).get(attr);
            if (expr == null) {
                return null;
            }
            if (expr instanceof Value) {
                return ((Value)expr).get();
            }
            throw new UnsupportedOperationException("Expression was not evaluated....");
        }

        public void set(String attr, Object obj) {
            if (obj instanceof Expression) {
                ((Map)this.value).put(attr, (Expression)obj);
            } else {
                ((Map)this.value).put(attr, Expressions.createValue(null, obj, new String[0]));
            }
            this.evaluated = null;
        }

        private static Object toCompatibleObject(Field f, Object value) {
            if (value == null) {
                return value;
            }
            if (!f.getDeclaringClass().isAssignableFrom(value.getClass()) && Number.class.isAssignableFrom(value.getClass())) {
                Number number = (Number)value;
                if (f.getType().isAssignableFrom(Double.class)) {
                    return number.doubleValue();
                }
                if (f.getType().isAssignableFrom(Float.class)) {
                    return Float.valueOf(number.floatValue());
                }
                if (f.getType().isAssignableFrom(Long.class)) {
                    return number.longValue();
                }
                if (f.getType().isAssignableFrom(Integer.class)) {
                    return number.intValue();
                }
            }
            return value;
        }

        private static Value attemptTypeConversion(CompositeValue cv, Env env, Object ... args) {
            Expression typeFieldExpr = (Expression)((Map)cv.value).get("type");
            if (typeFieldExpr != null) {
                Value typeValue = typeFieldExpr.evaluate(env, args);
                if (typeFieldExpr instanceof VarExpression) {
                    VarExpression varExpr = (VarExpression)typeFieldExpr;
                    String typeName = (String)varExpr.get();
                    if (typeValue != null) {
                        if (Expressions.TYPE_CLASS.equals(typeValue.getType())) {
                            Class c = (Class)typeValue.get();
                            try {
                                Object obj = c.newInstance();
                                for (String s : ((Map)cv.value).keySet()) {
                                    if ("type".equals(s)) continue;
                                    Value v = ((Expression)((Map)cv.value).get(s)).evaluate(env, args);
                                    try {
                                        Field f = c.getField(s);
                                        Object objVal = CompositeValue.toCompatibleObject(f, v.get());
                                        f.set(obj, objVal);
                                    }
                                    catch (NoSuchFieldException ex) {
                                        throw new RuntimeException("Unknown field " + s + " for type " + typeName + ", trying to set to " + v, ex);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        throw new RuntimeException("Incompatible type " + s + " for type " + typeName + ", trying to set to " + v, ex);
                                    }
                                }
                                return new PrimitiveValue(typeName, obj, new String[0]);
                            }
                            catch (InstantiationException ex) {
                                throw new RuntimeException("Cannot instantiate " + c, ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw new RuntimeException("Cannot instantiate " + c, ex);
                            }
                        }
                        if (typeValue.get() != null) {
                            Class<?> c = typeValue.get().getClass();
                            try {
                                Method m = c.getMethod("create", CompositeValue.class);
                                CompositeValue evaluatedCv = cv.evaluateNoTypeConversion(env, args);
                                try {
                                    return new PrimitiveValue<Object>(typeName, m.invoke(typeValue.get(), evaluatedCv), new String[0]);
                                }
                                catch (InvocationTargetException ex) {
                                    throw new RuntimeException("Cannot instantiate " + c, ex);
                                }
                                catch (IllegalAccessException ex) {
                                    throw new RuntimeException("Cannot instantiate " + c, ex);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {}
                        }
                    }
                } else if (typeValue != null && typeValue.get() instanceof String) {
                    String typeName = (String)typeValue.get();
                    Expression valueField = (Expression)((Map)cv.value).get("value");
                    Value value = valueField.evaluate(env, args);
                    switch (typeName) {
                        case "ANNOKEY": {
                            String className = (String)value.get();
                            try {
                                return new PrimitiveValue(Expressions.TYPE_ANNOTATION_KEY, Class.forName(className), new String[0]);
                            }
                            catch (ClassNotFoundException ex) {
                                throw new RuntimeException("Unknown class " + className, ex);
                            }
                        }
                        case "CLASS": {
                            String className = (String)value.get();
                            try {
                                return new PrimitiveValue(Expressions.TYPE_CLASS, Class.forName(className), new String[0]);
                            }
                            catch (ClassNotFoundException ex) {
                                throw new RuntimeException("Unknown class " + className, ex);
                            }
                        }
                        case "STRING": {
                            return new PrimitiveValue<String>(Expressions.TYPE_STRING, (String)value.get(), new String[0]);
                        }
                        case "REGEX": {
                            return new RegexValue((String)value.get(), new String[0]);
                        }
                        case "NUMBER": {
                            if (value.get() instanceof Number) {
                                return new PrimitiveValue<Number>(Expressions.TYPE_NUMBER, (Number)value.get(), new String[0]);
                            }
                            if (value.get() instanceof String) {
                                String str = (String)value.get();
                                if (str.contains(".")) {
                                    return new PrimitiveValue<Double>(Expressions.TYPE_NUMBER, Double.valueOf(str), new String[0]);
                                }
                                return new PrimitiveValue<Long>(Expressions.TYPE_NUMBER, Long.valueOf(str), new String[0]);
                            }
                            throw new IllegalArgumentException("Invalid value " + value + " for type " + typeName);
                        }
                    }
                    return new PrimitiveValue(typeName, value.get(), new String[0]);
                }
            }
            return null;
        }

        public CompositeValue simplifyNoTypeConversion(Env env, Object ... args) {
            Map m = (Map)this.value;
            HashMap<String, Expression> res = new HashMap<String, Expression>(m.size());
            for (Map.Entry stringExpressionEntry : m.entrySet()) {
                res.put((String)stringExpressionEntry.getKey(), ((Expression)stringExpressionEntry.getValue()).simplify(env));
            }
            return new CompositeValue(res, true, new String[0]);
        }

        private CompositeValue evaluateNoTypeConversion(Env env, Object ... args) {
            Map m = (Map)this.value;
            HashMap<String, Expression> res = new HashMap<String, Expression>(m.size());
            for (Map.Entry stringExpressionEntry : m.entrySet()) {
                res.put((String)stringExpressionEntry.getKey(), ((Expression)stringExpressionEntry.getValue()).evaluate(env, args));
            }
            return new CompositeValue(res, true, new String[0]);
        }

        @Override
        public Value doEvaluation(Env env, Object ... args) {
            Value v = CompositeValue.attemptTypeConversion(this, env, args);
            if (v != null) {
                return v;
            }
            Map m = (Map)this.value;
            HashMap<String, Expression> res = new HashMap<String, Expression>(m.size());
            for (Map.Entry stringExpressionEntry : m.entrySet()) {
                res.put((String)stringExpressionEntry.getKey(), ((Expression)stringExpressionEntry.getValue()).evaluate(env, args));
            }
            this.disableCaching = !this.checkValue();
            return new CompositeValue(res, true, new String[0]);
        }
    }

    public static class PrimitiveValue<T>
    extends SimpleValue<T> {
        public PrimitiveValue(String typename, T value, String ... tags) {
            super(typename, value, tags);
        }
    }

    public static class MethodCallExpression
    extends TypedExpression {
        String function;
        Expression object;
        List<Expression> params;

        public MethodCallExpression(String function, Expression object, List<Expression> params, String ... tags) {
            super(Expressions.TYPE_FUNCTION, tags);
            this.function = function;
            this.object = object;
            this.params = params;
        }

        public String toString() {
            return this.object + "." + this.function + '(' + StringUtils.join(this.params, ", ") + ')';
        }

        @Override
        public Expression simplify(Env env) {
            boolean paramsAllHasValue = true;
            ArrayList<Expression> simplifiedParams = new ArrayList<Expression>(this.params.size());
            for (Expression param : this.params) {
                Expression simplified = param.simplify(env);
                simplifiedParams.add(simplified);
                if (simplified.hasValue()) continue;
                paramsAllHasValue = false;
            }
            Expression simplifiedObject = this.object.simplify(env);
            MethodCallExpression res = new MethodCallExpression(this.function, simplifiedObject, simplifiedParams, new String[0]);
            if (paramsAllHasValue && this.object.hasValue()) {
                return res.evaluate(env, new Object[0]);
            }
            return res;
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            Method method;
            Object[] objs;
            Object mainObj;
            block11: {
                Value evaledObj = this.object.evaluate(env, args);
                if (evaledObj == null || evaledObj.get() == null) {
                    return null;
                }
                mainObj = evaledObj.get();
                Class<?> c = mainObj.getClass();
                ArrayList<Value> evaled = new ArrayList<Value>();
                for (Expression param : this.params) {
                    evaled.add(param.evaluate(env, args));
                }
                Class[] paramTypes = new Class[this.params.size()];
                objs = new Object[this.params.size()];
                for (int i = 0; i < this.params.size(); ++i) {
                    Value v = (Value)evaled.get(i);
                    if (v != null) {
                        objs[i] = v.get();
                        if (objs[i] != null) {
                            paramTypes[i] = objs[i].getClass();
                            continue;
                        }
                        paramTypes[i] = null;
                        continue;
                    }
                    objs[i] = null;
                    paramTypes[i] = null;
                }
                method = null;
                try {
                    method = c.getMethod(this.function, paramTypes);
                }
                catch (NoSuchMethodException ex) {
                    Method[] methods;
                    for (Method m : methods = c.getMethods()) {
                        boolean compatible;
                        Class[] mParamTypes;
                        if (!m.getName().equals(this.function) || (mParamTypes = m.getParameterTypes()).length != paramTypes.length || !(compatible = Expressions.isArgTypesCompatible(paramTypes, mParamTypes))) continue;
                        method = m;
                        break;
                    }
                    if (method != null) break block11;
                    throw new RuntimeException("Cannot find method " + this.function + " on object of class " + c, ex);
                }
            }
            try {
                Object res = method.invoke(mainObj, objs);
                return new PrimitiveValue<Object>(this.function, res, new String[0]);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Cannot evaluate method " + this.function + " on object " + mainObj, ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Cannot evaluate method " + this.function + " on object " + mainObj, ex);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCallExpression)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MethodCallExpression that = (MethodCallExpression)o;
            if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
                return false;
            }
            if (this.object != null ? !this.object.equals(that.object) : that.object != null) {
                return false;
            }
            return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
            result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            return result;
        }
    }

    public static class FunctionCallExpression
    extends TypedExpression {
        final String function;
        final List<? extends Expression> params;

        public FunctionCallExpression(String function, List<? extends Expression> params, String ... tags) {
            super(Expressions.TYPE_FUNCTION, tags);
            this.function = function;
            this.params = params;
        }

        public String toString() {
            return this.function + '(' + StringUtils.join(this.params, ", ") + ')';
        }

        @Override
        public Expression simplify(Env env) {
            boolean paramsAllHasValue = true;
            ArrayList<Expression> simplifiedParams = new ArrayList<Expression>(this.params.size());
            for (Expression expression : this.params) {
                Expression simplified = expression.simplify(env);
                simplifiedParams.add(simplified);
                if (simplified.hasValue()) continue;
                paramsAllHasValue = false;
            }
            FunctionCallExpression res = new FunctionCallExpression(this.function, simplifiedParams, new String[0]);
            if (paramsAllHasValue) {
                return res.evaluate(env, new Object[0]);
            }
            return res;
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            Object funcValue = ValueFunctions.lookupFunctionObject(env, this.function);
            if (funcValue == null) {
                throw new RuntimeException("Unknown function " + this.function);
            }
            if (funcValue instanceof Value) {
                funcValue = ((Value)funcValue).evaluate(env, args).get();
            }
            if (funcValue instanceof ValueFunction) {
                ValueFunction f = (ValueFunction)funcValue;
                ArrayList<Value> evaled = new ArrayList<Value>();
                for (Expression expression : this.params) {
                    evaled.add(expression.evaluate(env, args));
                }
                return f.apply(env, evaled);
            }
            if (funcValue instanceof Collection) {
                ArrayList<Value> evaled = new ArrayList<Value>();
                for (Expression expression : this.params) {
                    evaled.add(expression.evaluate(env, args));
                }
                Collection fs = (Collection)funcValue;
                for (ValueFunction valueFunction : fs) {
                    if (!valueFunction.checkArgs(evaled)) continue;
                    return valueFunction.apply(env, evaled);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Cannot find function matching args: " + this.function + NEWLINE);
                stringBuilder.append("Args are: " + StringUtils.join(evaled, ",") + NEWLINE);
                if (fs.size() > 0) {
                    stringBuilder.append("Options are:\n" + StringUtils.join(fs, NEWLINE));
                } else {
                    stringBuilder.append("No options");
                }
                throw new RuntimeException(stringBuilder.toString());
            }
            if (funcValue instanceof Class) {
                Object obj;
                Class c = (Class)funcValue;
                ArrayList<Value> evaled = new ArrayList<Value>();
                for (Expression expression : this.params) {
                    evaled.add(expression.evaluate(env, args));
                }
                Class[] classArray = new Class[this.params.size()];
                Object[] objectArray = new Object[this.params.size()];
                boolean paramsNotNull = true;
                for (int i = 0; i < this.params.size(); ++i) {
                    Value v = (Value)evaled.get(i);
                    if (v != null) {
                        objectArray[i] = v.get();
                        if (objectArray[i] != null) {
                            classArray[i] = objectArray[i].getClass();
                            continue;
                        }
                        classArray[i] = null;
                        paramsNotNull = false;
                        continue;
                    }
                    objectArray[i] = null;
                    classArray[i] = null;
                    paramsNotNull = false;
                }
                if (paramsNotNull && (obj = MetaClass.create(c).createInstance(objectArray)) != null) {
                    return new PrimitiveValue(this.function, obj, new String[0]);
                }
                try {
                    Constructor<Object> constructor;
                    block22: {
                        constructor = null;
                        try {
                            constructor = c.getConstructor(classArray);
                        }
                        catch (NoSuchMethodException ex) {
                            Constructor<?>[] constructors;
                            for (Constructor<?> cons : constructors = c.getConstructors()) {
                                Class[] consParamTypes = cons.getParameterTypes();
                                boolean compatible = Expressions.isArgTypesCompatible(classArray, consParamTypes);
                                if (!compatible) continue;
                                constructor = cons;
                                break;
                            }
                            if (constructor != null) break block22;
                            throw new RuntimeException("Cannot instantiate " + c, ex);
                        }
                    }
                    Object obj2 = constructor.newInstance(objectArray);
                    return new PrimitiveValue(this.function, obj2, new String[0]);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException("Cannot instantiate " + c, ex);
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException("Cannot instantiate " + c, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Cannot instantiate " + c, ex);
                }
            }
            throw new UnsupportedOperationException("Unsupported function value " + funcValue);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FunctionCallExpression)) {
                return false;
            }
            FunctionCallExpression that = (FunctionCallExpression)o;
            if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
                return false;
            }
            return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
        }

        @Override
        public int hashCode() {
            int result = this.function != null ? this.function.hashCode() : 0;
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            return result;
        }
    }

    public static class ListExpression
    extends TypedExpression {
        List<Expression> exprs;

        public ListExpression(String typename, String ... tags) {
            super(typename, tags);
            this.exprs = new ArrayList<Expression>();
        }

        public ListExpression(String typename, List<Expression> exprs, String ... tags) {
            super(typename, tags);
            this.exprs = new ArrayList<Expression>(exprs);
        }

        public void addAll(List<Expression> exprs) {
            if (exprs != null) {
                this.exprs.addAll(exprs);
            }
        }

        public void add(Expression expr) {
            this.exprs.add(expr);
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            ArrayList<Value> values = new ArrayList<Value>(this.exprs.size());
            for (Expression s : this.exprs) {
                values.add(s.evaluate(env, args));
            }
            return new PrimitiveValue(this.typename, values, new String[0]);
        }
    }

    public static class ConditionalExpression
    extends WrappedExpression {
        public ConditionalExpression(Expression expr) {
            this.expr = expr;
        }

        public ConditionalExpression(String op, Expression expr1, Expression expr2) {
            switch (op) {
                case ">=": {
                    this.expr = new FunctionCallExpression("GE", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case "<=": {
                    this.expr = new FunctionCallExpression("LE", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case ">": {
                    this.expr = new FunctionCallExpression("GT", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case "<": {
                    this.expr = new FunctionCallExpression("LT", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case "==": {
                    this.expr = new FunctionCallExpression("EQ", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case "!=": {
                    this.expr = new FunctionCallExpression("NE", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case "=~": {
                    this.expr = new FunctionCallExpression("Match", Arrays.asList(expr1, expr2), new String[0]);
                    break;
                }
                case "!~": {
                    this.expr = new NotExpression(new FunctionCallExpression("Match", Arrays.asList(expr1, expr2), new String[0]));
                }
            }
        }

        @Override
        public String getType() {
            return Expressions.TYPE_BOOLEAN;
        }

        @Override
        public Expression simplify(Env env) {
            return this;
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            Value v = this.expr.evaluate(env, args);
            return Expressions.convertValueToBooleanValue(v, false);
        }
    }

    public static class CaseExpression
    extends WrappedExpression {
        public CaseExpression(List<Pair<Expression, Expression>> conds, Expression elseExpr) {
            if (conds.size() == 0) {
                throw new IllegalArgumentException("No conditions!");
            }
            this.expr = elseExpr;
            for (int i = conds.size() - 1; i >= 0; --i) {
                Pair<Expression, Expression> p = conds.get(i);
                this.expr = new IfExpression(p.first(), p.second(), this.expr);
            }
        }
    }

    public static class IfExpression
    extends TypedExpression {
        Expression condExpr;
        Expression trueExpr;
        Expression falseExpr;

        public IfExpression(Expression cond, Expression vt, Expression vf) {
            super("If", new String[0]);
            this.condExpr = cond;
            this.trueExpr = vt;
            this.falseExpr = vf;
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            Value condValue = this.condExpr.evaluate(env, args);
            Boolean cond = (Boolean)condValue.get();
            if (cond.booleanValue()) {
                return this.trueExpr.evaluate(env, args);
            }
            return this.falseExpr.evaluate(env, args);
        }
    }

    public static class NotExpression
    extends FunctionCallExpression {
        public NotExpression(Expression expr) {
            super("Not", Arrays.asList(expr), new String[0]);
        }
    }

    public static class AndExpression
    extends FunctionCallExpression {
        public AndExpression(List<Expression> children) {
            super("And", children, new String[0]);
        }
    }

    public static class OrExpression
    extends FunctionCallExpression {
        public OrExpression(List<Expression> children) {
            super("Or", children, new String[0]);
        }
    }

    public static class FieldExpression
    extends AssignableFunctionCallExpression {
        public FieldExpression(Expression expr, String field) {
            super("Select", Arrays.asList(expr, new PrimitiveValue<String>(Expressions.TYPE_STRING, field, new String[0])), new String[0]);
        }

        public FieldExpression(Expression expr, Expression field) {
            super("Select", Arrays.asList(expr, field), new String[0]);
        }
    }

    public static class IndexedExpression
    extends AssignableFunctionCallExpression {
        public IndexedExpression(Expression expr, int index) {
            super("ListSelect", Arrays.asList(expr, new PrimitiveValue<Integer>("Integer", index, new String[0])), new String[0]);
        }
    }

    public static class AssignableFunctionCallExpression
    extends FunctionCallExpression
    implements AssignableExpression {
        public AssignableFunctionCallExpression(String function, List<Expression> params, String ... tags) {
            super(function, params, tags);
        }

        @Override
        public Expression assign(Expression expr) {
            ArrayList<Expression> newParams = new ArrayList<Expression>(this.params);
            newParams.add(expr);
            FunctionCallExpression res = new FunctionCallExpression(this.function, newParams, new String[0]);
            res.setTags(this.tags);
            return res;
        }
    }

    public static class RegexMatchResultVarExpression
    extends SimpleExpression {
        public RegexMatchResultVarExpression(String groupname, String ... tags) {
            super(Expressions.TYPE_REGEXMATCHVAR, groupname, tags);
        }

        public RegexMatchResultVarExpression(Integer groupid, String ... tags) {
            super(Expressions.TYPE_REGEXMATCHVAR, groupid, tags);
        }

        public static RegexMatchResultVarExpression valueOf(String group) {
            if (DIGITS_PATTERN.matcher(group).matches()) {
                Integer n = Integer.valueOf(group);
                return new RegexMatchResultVarExpression(n, new String[0]);
            }
            return new RegexMatchResultVarExpression(group, new String[0]);
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            if (args != null && args.length > 0 && args[0] instanceof SequenceMatchResult) {
                SequenceMatchResult mr = (SequenceMatchResult)args[0];
                Object v = this.get();
                if (v instanceof String) {
                    return new PrimitiveValue("MATCHED_GROUP_INFO", mr.groupInfo((String)v), new String[0]);
                }
                if (v instanceof Integer) {
                    return new PrimitiveValue("MATCHED_GROUP_INFO", mr.groupInfo((Integer)v), new String[0]);
                }
                throw new UnsupportedOperationException("String match result must be referred to by group id");
            }
            return null;
        }
    }

    public static class RegexMatchVarExpression
    extends SimpleExpression
    implements AssignableExpression {
        public RegexMatchVarExpression(String groupname, String ... tags) {
            super(Expressions.TYPE_REGEXMATCHVAR, groupname, tags);
        }

        public RegexMatchVarExpression(Integer groupid, String ... tags) {
            super(Expressions.TYPE_REGEXMATCHVAR, groupid, tags);
        }

        public static RegexMatchVarExpression valueOf(String group) {
            if (DIGITS_PATTERN.matcher(group).matches()) {
                Integer n = Integer.valueOf(group);
                return new RegexMatchVarExpression(n, new String[0]);
            }
            return new RegexMatchVarExpression(group, new String[0]);
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            if (args != null && args.length > 0) {
                if (args[0] instanceof SequenceMatchResult) {
                    SequenceMatchResult mr = (SequenceMatchResult)args[0];
                    Object v = this.get();
                    if (v instanceof String) {
                        return new PrimitiveValue(Expressions.TYPE_TOKENS, mr.groupNodes((String)v), new String[0]);
                    }
                    if (v instanceof Integer) {
                        return new PrimitiveValue(Expressions.TYPE_TOKENS, mr.groupNodes((Integer)v), new String[0]);
                    }
                    throw new UnsupportedOperationException("String match result must be referred to by group id");
                }
                if (args[0] instanceof MatchResult) {
                    MatchResult mr = (MatchResult)args[0];
                    Object v = this.get();
                    if (v instanceof Integer) {
                        String str = mr.group((Integer)this.get());
                        return new PrimitiveValue<String>(Expressions.TYPE_STRING, str, new String[0]);
                    }
                    throw new UnsupportedOperationException("String match result must be referred to by group id");
                }
            }
            return null;
        }

        @Override
        public Expression assign(Expression expr) {
            return new VarAssignmentExpression(this.value.toString(), expr, false);
        }
    }

    public static class VarExpression
    extends SimpleExpression<String>
    implements AssignableExpression {
        public VarExpression(String varname, String ... tags) {
            super(Expressions.TYPE_VAR, varname, tags);
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            Value v;
            Expression exp = null;
            String varName = (String)this.value;
            if (args != null && args.length == 1 && args[0] instanceof CoreMap) {
                CoreMap cm = (CoreMap)args[0];
                if (Expressions.VAR_SELF.equals(varName)) {
                    return Expressions.createValue(varName, cm, new String[0]);
                }
                Class annotationKey = EnvLookup.lookupAnnotationKey(env, varName);
                if (annotationKey != null) {
                    return Expressions.createValue(varName, cm.get(annotationKey), new String[0]);
                }
            }
            if (Expressions.VAR_SELF.equals(varName)) {
                return Expressions.createValue(varName, env.peek(varName), new String[0]);
            }
            Object obj = env.get(varName);
            if (obj != null) {
                exp = Expressions.asExpression(env, obj);
            }
            Value value = v = exp != null ? exp.evaluate(env, args) : null;
            if (v == null) {
                System.err.println("Unknown variable: " + varName);
            }
            return v;
        }

        @Override
        public Expression assign(Expression expr) {
            return new VarAssignmentExpression((String)this.value, expr, true);
        }
    }

    public static class VarAssignmentExpression
    extends TypedExpression {
        final String varName;
        final Expression valueExpr;
        final boolean bindAsValue;

        public VarAssignmentExpression(String varName, Expression valueExpr, boolean bindAsValue) {
            super("VAR_ASSIGNMENT", new String[0]);
            this.varName = varName;
            this.valueExpr = valueExpr;
            this.bindAsValue = bindAsValue;
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            Value value = this.valueExpr.evaluate(env, args);
            if (args != null && args.length == 1 && args[0] instanceof CoreMap) {
                CoreMap cm = (CoreMap)args[0];
                Class annotationKey = EnvLookup.lookupAnnotationKey(env, this.varName);
                if (annotationKey != null) {
                    cm.set(annotationKey, value != null ? (Object)value.get() : null);
                    return value;
                }
            }
            if (this.bindAsValue) {
                env.bind(this.varName, value);
            } else {
                env.bind(this.varName, (Object)(value != null ? value.get() : null));
                if (Expressions.TYPE_REGEX == value.getType()) {
                    try {
                        Object vobj = value.get();
                        if (vobj instanceof String) {
                            env.bindStringRegex(this.varName, (String)vobj);
                        } else if (vobj instanceof Pattern) {
                            env.bindStringRegex(this.varName, ((Pattern)vobj).pattern());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VarAssignmentExpression)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarAssignmentExpression that = (VarAssignmentExpression)o;
            if (this.bindAsValue != that.bindAsValue) {
                return false;
            }
            if (this.valueExpr != null ? !this.valueExpr.equals(that.valueExpr) : that.valueExpr != null) {
                return false;
            }
            return !(this.varName != null ? !this.varName.equals(that.varName) : that.varName != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.varName != null ? this.varName.hashCode() : 0);
            result = 31 * result + (this.valueExpr != null ? this.valueExpr.hashCode() : 0);
            result = 31 * result + (this.bindAsValue ? 1 : 0);
            return result;
        }
    }

    public static class RegexValue
    extends SimpleValue<String> {
        public RegexValue(String regex, String ... tags) {
            super(Expressions.TYPE_REGEX, regex, tags);
        }
    }

    public static class SimpleValue<T>
    extends TypedExpression
    implements Value<T> {
        T value;

        protected SimpleValue(String typename, T value, String ... tags) {
            super(typename, tags);
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            return this;
        }

        public String toString() {
            return this.getType() + "(" + this.value + ")";
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleValue)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleValue that = (SimpleValue)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    public static class SimpleCachedExpression<T>
    extends SimpleExpression<T> {
        Value evaluated;
        boolean disableCaching = false;

        protected SimpleCachedExpression(String typename, T value, String ... tags) {
            super(typename, value, tags);
        }

        protected Value doEvaluation(Env env, Object ... args) {
            throw new UnsupportedOperationException("Cannot evaluate type: " + this.typename);
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            if (args != null) {
                return this.doEvaluation(env, args);
            }
            if (this.evaluated == null || this.disableCaching) {
                this.evaluated = this.doEvaluation(env, args);
            }
            return this.evaluated;
        }

        @Override
        public boolean hasValue() {
            return this.evaluated != null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleCachedExpression)) {
                return false;
            }
            SimpleCachedExpression that = (SimpleCachedExpression)o;
            if (this.disableCaching != that.disableCaching) {
                return false;
            }
            return !(this.evaluated != null ? !this.evaluated.equals(that.evaluated) : that.evaluated != null);
        }

        @Override
        public int hashCode() {
            int result = this.evaluated != null ? this.evaluated.hashCode() : 0;
            result = 31 * result + (this.disableCaching ? 1 : 0);
            return result;
        }
    }

    public static abstract class SimpleExpression<T>
    extends TypedExpression {
        T value;

        protected SimpleExpression(String typename, T value, String ... tags) {
            super(typename, tags);
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public String toString() {
            return this.getType() + "(" + this.value + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleExpression)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleExpression that = (SimpleExpression)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    public static abstract class TypedExpression
    implements Expression,
    Serializable {
        String typename;
        Tags tags;
        private static final long serialVersionUID = 2L;

        public TypedExpression(String typename, String ... tags) {
            this.typename = typename;
            if (tags != null) {
                this.tags = new Tags(tags);
            }
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public void setTags(Tags tags) {
            this.tags = tags;
        }

        @Override
        public String getType() {
            return this.typename;
        }

        @Override
        public Expression simplify(Env env) {
            return this;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypedExpression)) {
                return false;
            }
            TypedExpression that = (TypedExpression)o;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
                return false;
            }
            return !(this.typename != null ? !this.typename.equals(that.typename) : that.typename != null);
        }

        public int hashCode() {
            int result = this.typename != null ? this.typename.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }

    public static abstract class WrappedExpression
    implements Expression {
        protected Expression expr;

        @Override
        public Tags getTags() {
            return this.expr.getTags();
        }

        @Override
        public void setTags(Tags tags) {
            this.expr.setTags(tags);
        }

        @Override
        public String getType() {
            return this.expr.getType();
        }

        @Override
        public Expression simplify(Env env) {
            return this.expr.simplify(env);
        }

        @Override
        public boolean hasValue() {
            return this.expr.hasValue();
        }

        @Override
        public Value evaluate(Env env, Object ... args) {
            return this.expr.evaluate(env, args);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WrappedExpression)) {
                return false;
            }
            WrappedExpression that = (WrappedExpression)o;
            return !(this.expr != null ? !this.expr.equals(that.expr) : that.expr != null);
        }

        public int hashCode() {
            return this.expr != null ? this.expr.hashCode() : 0;
        }
    }
}

