/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.sieve;

import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.sieve.Sieve;
import java.util.List;
import java.util.Properties;

public class OracleSieve
extends Sieve {
    private static final long serialVersionUID = 3510248899162246138L;

    public OracleSieve(Properties props, String sievename) {
        super(props, sievename);
        this.classifierType = Sieve.ClassifierType.ORACLE;
    }

    @Override
    public void findCoreferentAntecedent(Mention m, int mIdx, Document document, Dictionaries dict, Properties props, StringBuilder sbLog) throws Exception {
        for (int distance = 0; distance <= m.sentNum; ++distance) {
            List<Mention> candidates = document.predictedMentions.get(m.sentNum - distance);
            for (Mention candidate : candidates) {
                if (!OracleSieve.matchedMentionType(candidate, this.aTypeStr) || !OracleSieve.matchedMentionType(m, this.mTypeStr) || candidate == m || distance == 0 && m.appearEarlierThan(candidate) || !Sieve.isReallyCoref(document, m.mentionID, candidate.mentionID)) continue;
                if (m.mentionType == Dictionaries.MentionType.LIST) {
                    System.err.println("LIST MATCHING MENTION : " + m.spanToString() + "\tANT: " + candidate.spanToString());
                }
                Sieve.merge(document, m.mentionID, candidate.mentionID);
                return;
            }
        }
    }
}

