/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.stream.Stream;
import jdk.internal.platform.cgroupv1.SubSystem;

public class Metrics
implements jdk.internal.platform.Metrics {
    private SubSystem.MemorySubSystem memory;
    private SubSystem cpu;
    private SubSystem cpuacct;
    private SubSystem cpuset;
    private SubSystem blkio;
    private boolean activeSubSystems = false;
    static long unlimited_minimum = 0x7FFFFFFFFF000000L;
    private static final Metrics INSTANCE = Metrics.initContainerSubSystems();
    private static final String PROVIDER_NAME = "cgroupv1";

    private Metrics() {
    }

    public static Metrics getInstance() {
        return INSTANCE;
    }

    private static Metrics initContainerSubSystems() {
        Throwable throwable;
        Stream<String> stream;
        if (!Metrics.isUseContainerSupport()) {
            return null;
        }
        Metrics metrics = new Metrics();
        try {
            stream = Metrics.readFilePrivileged(Paths.get("/proc/self/mountinfo", new String[0]));
            throwable = null;
            try {
                stream.filter(string -> string.contains(" - cgroup ")).map(string -> string.split(" ")).forEach(stringArray -> Metrics.createSubSystem(metrics, stringArray));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            stream = Metrics.readFilePrivileged(Paths.get("/proc/self/cgroup", new String[0]));
            throwable = null;
            try {
                stream.map(string -> string.split(":")).filter(stringArray -> ((String[])stringArray).length >= 3).forEach(stringArray -> Metrics.setSubSystemPath(metrics, stringArray));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (metrics.activeSubSystems()) {
            return metrics;
        }
        return null;
    }

    static Stream<String> readFilePrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<Stream> privilegedExceptionAction = () -> Files.lines(path);
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Metrics.unwrapIOExceptionAndRethrow(privilegedActionException);
            throw new InternalError(privilegedActionException.getCause());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    static void unwrapIOExceptionAndRethrow(PrivilegedActionException privilegedActionException) throws IOException {
        Throwable throwable = privilegedActionException.getCause();
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private static void createSubSystem(Metrics metrics, String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 5) {
            return;
        }
        Path path = Paths.get(stringArray[4], new String[0]);
        String[] stringArray3 = stringArray2 = path.getFileName().toString().split(",");
        int n = stringArray3.length;
        block14: for (int i = 0; i < n; ++i) {
            String string;
            switch (string = stringArray3[i]) {
                case "memory": {
                    metrics.setMemorySubSystem(new SubSystem.MemorySubSystem(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "cpuset": {
                    metrics.setCpuSetSubSystem(new SubSystem(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "cpuacct": {
                    metrics.setCpuAcctSubSystem(new SubSystem(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "cpu": {
                    metrics.setCpuSubSystem(new SubSystem(stringArray[3], stringArray[4]));
                    continue block14;
                }
                case "blkio": {
                    metrics.setBlkIOSubSystem(new SubSystem(stringArray[3], stringArray[4]));
                    continue block14;
                }
            }
        }
    }

    private static void setSubSystemPath(Metrics metrics, String[] stringArray) {
        SubSystem subSystem = null;
        SubSystem subSystem2 = null;
        String string = stringArray[1];
        String string2 = stringArray[2];
        if (string != null && string2 != null) {
            switch (string) {
                case "memory": {
                    subSystem = metrics.MemorySubSystem();
                    break;
                }
                case "cpuset": {
                    subSystem = metrics.CpuSetSubSystem();
                    break;
                }
                case "cpu,cpuacct": 
                case "cpuacct,cpu": {
                    subSystem = metrics.CpuSubSystem();
                    subSystem2 = metrics.CpuAcctSubSystem();
                    break;
                }
                case "cpuacct": {
                    subSystem = metrics.CpuAcctSubSystem();
                    break;
                }
                case "cpu": {
                    subSystem = metrics.CpuSubSystem();
                    break;
                }
                case "blkio": {
                    subSystem = metrics.BlkIOSubSystem();
                    break;
                }
            }
        }
        if (subSystem != null) {
            subSystem.setPath(string2);
            if (subSystem instanceof SubSystem.MemorySubSystem) {
                Object object = (SubSystem.MemorySubSystem)subSystem;
                boolean bl = Metrics.getHierarchical((SubSystem.MemorySubSystem)object);
                ((SubSystem.MemorySubSystem)object).setHierarchical(bl);
                boolean bl2 = Metrics.getSwapEnabled((SubSystem.MemorySubSystem)object);
                ((SubSystem.MemorySubSystem)object).setSwapEnabled(bl2);
            }
            metrics.setActiveSubSystems();
        }
        if (subSystem2 != null) {
            subSystem2.setPath(string2);
        }
    }

    private static boolean getSwapEnabled(SubSystem.MemorySubSystem memorySubSystem) {
        long l = SubSystem.getLongValue(memorySubSystem, "memory.memsw.limit_in_bytes");
        return l > 0L;
    }

    private static boolean getHierarchical(SubSystem.MemorySubSystem memorySubSystem) {
        long l = SubSystem.getLongValue(memorySubSystem, "memory.use_hierarchy");
        return l > 0L;
    }

    private void setActiveSubSystems() {
        this.activeSubSystems = true;
    }

    private boolean activeSubSystems() {
        return this.activeSubSystems;
    }

    private void setMemorySubSystem(SubSystem.MemorySubSystem memorySubSystem) {
        this.memory = memorySubSystem;
    }

    private void setCpuSubSystem(SubSystem subSystem) {
        this.cpu = subSystem;
    }

    private void setCpuAcctSubSystem(SubSystem subSystem) {
        this.cpuacct = subSystem;
    }

    private void setCpuSetSubSystem(SubSystem subSystem) {
        this.cpuset = subSystem;
    }

    private void setBlkIOSubSystem(SubSystem subSystem) {
        this.blkio = subSystem;
    }

    private SubSystem MemorySubSystem() {
        return this.memory;
    }

    private SubSystem CpuSubSystem() {
        return this.cpu;
    }

    private SubSystem CpuAcctSubSystem() {
        return this.cpuacct;
    }

    private SubSystem CpuSetSubSystem() {
        return this.cpuset;
    }

    private SubSystem BlkIOSubSystem() {
        return this.blkio;
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        return SubSystem.getLongValue(this.cpuacct, "cpuacct.usage");
    }

    @Override
    public long[] getPerCpuUsage() {
        String string = SubSystem.getStringValue(this.cpuacct, "cpuacct.usage_percpu");
        if (string == null) {
            return new long[0];
        }
        String[] stringArray = string.split(" ");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i]);
        }
        return lArray;
    }

    @Override
    public long getCpuUserUsage() {
        return SubSystem.getLongEntry(this.cpuacct, "cpuacct.stat", "user");
    }

    @Override
    public long getCpuSystemUsage() {
        return SubSystem.getLongEntry(this.cpuacct, "cpuacct.stat", "system");
    }

    @Override
    public long getCpuPeriod() {
        return SubSystem.getLongValue(this.cpu, "cpu.cfs_period_us");
    }

    @Override
    public long getCpuQuota() {
        return SubSystem.getLongValue(this.cpu, "cpu.cfs_quota_us");
    }

    @Override
    public long getCpuShares() {
        long l = SubSystem.getLongValue(this.cpu, "cpu.shares");
        if (l == 0L || l == 1024L) {
            return -1L;
        }
        return l;
    }

    @Override
    public long getCpuNumPeriods() {
        return SubSystem.getLongEntry(this.cpu, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return SubSystem.getLongEntry(this.cpu, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        return SubSystem.getLongEntry(this.cpu, "cpu.stat", "throttled_time");
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.cpus"));
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.effective_cpus"));
    }

    @Override
    public int[] getCpuSetMems() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.mems"));
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.effective_mems"));
    }

    @Override
    public double getCpuSetMemoryPressure() {
        return SubSystem.getDoubleValue(this.cpuset, "cpuset.memory_pressure");
    }

    @Override
    public boolean isCpuSetMemoryPressureEnabled() {
        long l = SubSystem.getLongValue(this.cpuset, "cpuset.memory_pressure_enabled");
        return l == 1L;
    }

    @Override
    public long getMemoryFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.failcnt");
    }

    @Override
    public long getMemoryLimit() {
        long l = SubSystem.getLongValue(this.memory, "memory.limit_in_bytes");
        if (l > unlimited_minimum && this.memory.isHierarchical()) {
            String string = "hierarchical_memory_limit";
            l = SubSystem.getLongValueMatchingLine(this.memory, "memory.stat", string, Metrics::convertHierachicalLimitLine);
        }
        return l > unlimited_minimum ? -1L : l;
    }

    public static long convertHierachicalLimitLine(String string) {
        String[] stringArray = string.split("\\s");
        if (stringArray.length == 2) {
            String string2 = stringArray[1];
            return SubSystem.convertStringToLong(string2);
        }
        return unlimited_minimum + 1L;
    }

    @Override
    public long getMemoryMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.max_usage_in_bytes");
    }

    @Override
    public long getMemoryUsage() {
        return SubSystem.getLongValue(this.memory, "memory.usage_in_bytes");
    }

    @Override
    public long getKernelMemoryFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.failcnt");
    }

    @Override
    public long getKernelMemoryLimit() {
        long l = SubSystem.getLongValue(this.memory, "memory.kmem.limit_in_bytes");
        return l > unlimited_minimum ? -1L : l;
    }

    @Override
    public long getKernelMemoryMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.max_usage_in_bytes");
    }

    @Override
    public long getKernelMemoryUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.usage_in_bytes");
    }

    @Override
    public long getTcpMemoryFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.tcp.failcnt");
    }

    @Override
    public long getTcpMemoryLimit() {
        long l = SubSystem.getLongValue(this.memory, "memory.kmem.tcp.limit_in_bytes");
        return l > unlimited_minimum ? -1L : l;
    }

    @Override
    public long getTcpMemoryMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.tcp.max_usage_in_bytes");
    }

    @Override
    public long getTcpMemoryUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.tcp.usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapFailCount() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryFailCount();
        }
        return SubSystem.getLongValue(this.memory, "memory.memsw.failcnt");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryLimit();
        }
        long l = SubSystem.getLongValue(this.memory, "memory.memsw.limit_in_bytes");
        if (l > unlimited_minimum && this.memory.isHierarchical()) {
            String string = "hierarchical_memsw_limit";
            l = SubSystem.getLongValueMatchingLine(this.memory, "memory.stat", string, Metrics::convertHierachicalLimitLine);
        }
        return l > unlimited_minimum ? -1L : l;
    }

    @Override
    public long getMemoryAndSwapMaxUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryMaxUsage();
        }
        return SubSystem.getLongValue(this.memory, "memory.memsw.max_usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryUsage();
        }
        return SubSystem.getLongValue(this.memory, "memory.memsw.usage_in_bytes");
    }

    @Override
    public boolean isMemoryOOMKillEnabled() {
        long l = SubSystem.getLongEntry(this.memory, "memory.oom_control", "oom_kill_disable");
        return l == 0L;
    }

    @Override
    public long getMemorySoftLimit() {
        long l = SubSystem.getLongValue(this.memory, "memory.soft_limit_in_bytes");
        return l > unlimited_minimum ? -1L : l;
    }

    @Override
    public long getBlkIOServiceCount() {
        return SubSystem.getLongEntry(this.blkio, "blkio.throttle.io_service_bytes", "Total");
    }

    @Override
    public long getBlkIOServiced() {
        return SubSystem.getLongEntry(this.blkio, "blkio.throttle.io_serviced", "Total");
    }

    private static native boolean isUseContainerSupport();
}

