/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverDirectHTTP;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverFragment;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverLocalFilesystem;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverXPointer;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceResolver.class);
    private static final List<ResourceResolverSpi> resolverList = new CopyOnWriteArrayList<ResourceResolverSpi>();
    private static final AtomicBoolean defaultResolversAdded = new AtomicBoolean();

    public static void register(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        Class<?> clazz = ClassLoaderUtils.loadClass(string, ResourceResolver.class);
        ResourceResolver.register((ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(clazz), false);
    }

    public static void registerAtStart(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        Class<?> clazz = ClassLoaderUtils.loadClass(string, ResourceResolver.class);
        ResourceResolver.register((ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(clazz), true);
    }

    public static void register(ResourceResolverSpi resourceResolverSpi, boolean bl) {
        JavaUtils.checkRegisterPermission();
        if (bl) {
            resolverList.add(0, resourceResolverSpi);
        } else {
            resolverList.add(resourceResolverSpi);
        }
        LOG.debug("Registered resolver: {}", resourceResolverSpi.toString());
    }

    public static void registerClassNames(List<String> list) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        ArrayList<ResourceResolverSpi> arrayList = new ArrayList<ResourceResolverSpi>(list.size());
        for (String string : list) {
            ResourceResolverSpi resourceResolverSpi = (ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(ClassLoaderUtils.loadClass(string, ResourceResolver.class));
            arrayList.add(resourceResolverSpi);
        }
        resolverList.addAll(arrayList);
    }

    public static void registerDefaultResolvers() {
        if (defaultResolversAdded.compareAndSet(false, true)) {
            ArrayList<ResourceResolverSpi> arrayList = new ArrayList<ResourceResolverSpi>();
            arrayList.add(new ResolverFragment());
            arrayList.add(new ResolverLocalFilesystem());
            arrayList.add(new ResolverXPointer());
            arrayList.add(new ResolverDirectHTTP());
            resolverList.addAll(arrayList);
        }
    }

    public static XMLSignatureInput resolve(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        for (ResourceResolverSpi resourceResolverSpi : resolverList) {
            LOG.debug("check resolvability by class {}", resourceResolverSpi.getClass().getName());
            if (!resourceResolverSpi.engineCanResolveURI(resourceResolverContext)) continue;
            if (resourceResolverContext.secureValidation && (resourceResolverSpi instanceof ResolverLocalFilesystem || resourceResolverSpi instanceof ResolverDirectHTTP)) {
                Object[] objectArray = new Object[]{resourceResolverSpi.getClass().getName()};
                throw new ResourceResolverException("signature.Reference.ForbiddenResolver", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
            }
            return resourceResolverSpi.engineResolveURI(resourceResolverContext);
        }
        Object[] objectArray = new Object[]{resourceResolverContext.uriToResolve != null ? resourceResolverContext.uriToResolve : "null", resourceResolverContext.baseUri};
        throw new ResourceResolverException("utils.resolver.noClass", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
    }

    public static XMLSignatureInput resolve(List<ResourceResolverSpi> list, ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        LOG.debug("I was asked to create a ResourceResolver and got {}", list == null ? 0 : list.size());
        if (list != null) {
            for (ResourceResolverSpi resourceResolverSpi : list) {
                String string = resourceResolverSpi.getClass().getName();
                LOG.debug("check resolvability by class {}", string);
                if (!resourceResolverSpi.engineCanResolveURI(resourceResolverContext)) continue;
                return resourceResolverSpi.engineResolveURI(resourceResolverContext);
            }
        }
        return ResourceResolver.resolve(resourceResolverContext);
    }
}

