/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayElementValue
extends ElementValue {
    private final ElementValue[] evalues;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i]);
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public ArrayElementValue(int type, ElementValue[] datums, ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor - type specified: " + type);
        }
        this.evalues = datums;
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.evalues.length);
        for (ElementValue evalue : this.evalues) {
            evalue.dump(dos);
        }
    }

    @Override
    public String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i].stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

