/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.ud.CoNLLUUtils;
import edu.stanford.nlp.util.IntPair;
import java.util.HashMap;

public class CoNLLUDocumentWriter {
    private static final String LRB_PATTERN = "(?i)-LRB-";
    private static final String RRB_PATTERN = "(?i)-RRB-";

    public String printSemanticGraph(SemanticGraph sg) {
        return this.printSemanticGraph(sg, true);
    }

    public String printSemanticGraph(SemanticGraph sg, boolean unescapeParenthesis) {
        StringBuilder sb = new StringBuilder();
        for (String comment : sg.getComments()) {
            sb.append(comment).append("\n");
        }
        for (IndexedWord token : sg.vertexListSorted()) {
            String relnName;
            IntPair tokenSpan;
            if (token.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) && (tokenSpan = (IntPair)token.get(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)).getSource() == token.index()) {
                String range = String.format("%d-%d", tokenSpan.getSource(), tokenSpan.getTarget());
                sb.append(String.format("%s\t%s\t_\t_\t_\t_\t_\t_\t_\t_%n", range, token.originalText()));
            }
            int govIdx = -1;
            GrammaticalRelation reln = null;
            HashMap<Integer, String> additionalDeps = new HashMap<Integer, String>();
            for (IndexedWord parent : sg.getParents(token)) {
                SemanticGraphEdge edge = sg.getEdge(parent, token);
                if (govIdx == -1 && !edge.isExtra()) {
                    govIdx = parent.index();
                    reln = edge.getRelation();
                    continue;
                }
                additionalDeps.put(parent.index(), edge.getRelation().toString());
            }
            String additionalDepsString = CoNLLUUtils.toExtraDepsString(additionalDeps);
            String word = token.word();
            String featuresString = CoNLLUUtils.toFeatureString((HashMap)token.get(CoreAnnotations.CoNLLUFeats.class));
            String pos = token.getString(CoreAnnotations.PartOfSpeechAnnotation.class, "_");
            String upos = token.getString(CoreAnnotations.CoarseTagAnnotation.class, "_");
            String misc = token.getString(CoreAnnotations.CoNLLUMisc.class, "_");
            String lemma = token.getString(CoreAnnotations.LemmaAnnotation.class, "_");
            String string = relnName = reln == null ? "_" : reln.toString();
            if (govIdx == -1 && sg.getRoots().contains(token)) {
                govIdx = 0;
                relnName = GrammaticalRelation.ROOT.toString();
            }
            if (unescapeParenthesis) {
                word = word.replaceAll(LRB_PATTERN, "(");
                word = word.replaceAll(RRB_PATTERN, ")");
                lemma = lemma.replaceAll(LRB_PATTERN, "(");
                lemma = lemma.replaceAll(RRB_PATTERN, ")");
            }
            sb.append(String.format("%d\t%s\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s%n", token.index(), word, lemma, upos, pos, featuresString, govIdx, relnName, additionalDepsString, misc));
        }
        sb.append("\n");
        return sb.toString();
    }
}

