/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.util.Generics;

public class DybroFrenchHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = 8798606577201646967L;

    public DybroFrenchHeadFinder() {
        this(new FrenchTreebankLanguagePack());
    }

    public DybroFrenchHeadFinder(TreebankLanguagePack tlp) {
        super(tlp, new String[0]);
        this.nonTerminalInfo = Generics.newHashMap();
        this.nonTerminalInfo.put(tlp.startSymbol(), new String[][]{{"right", "VN", "AP", "NP", "Srel", "VPpart", "AdP", "I", "Ssub", "VPinf", "PP"}, {"rightdis", "ADV", "ADVWH"}, {"right"}});
        this.nonTerminalInfo.put("SENT", new String[][]{{"right", "VN", "AP", "NP", "Srel", "VPpart", "AdP", "I", "Ssub", "VPinf", "PP"}, {"rightdis", "ADV", "ADVWH"}, {"right"}});
        this.nonTerminalInfo.put("AP", new String[][]{{"rightdis", "A", "ADJ", "ADJWH"}, {"right", "ET"}, {"rightdis", "V", "VIMP", "VINF", "VS", "VPP", "VPR"}, {"rightdis", "ADV", "ADVWH"}});
        this.nonTerminalInfo.put("AdP", new String[][]{{"rightdis", "ADV", "ADVWH"}, {"right"}});
        this.nonTerminalInfo.put("COORD", new String[][]{{"leftdis", "C", "CC", "CS"}, {"left"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"leftdis", "N", "NPP", "NC", "PRO", "PROWH", "PROREL"}, {"left", "NP"}, {"leftdis", "A", "ADJ", "ADJWH"}, {"left", "AP", "I", "VPpart"}, {"leftdis", "ADV", "ADVWH"}, {"left", "AdP", "ET"}, {"leftdis", "D", "DET", "DETWH"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"left", "P"}, {"left"}});
        this.nonTerminalInfo.put("VN", new String[][]{{"right", "V", "VPinf"}, {"right"}});
        this.nonTerminalInfo.put("VPinf", new String[][]{{"left", "VN"}, {"leftdis", "V", "VIMP", "VINF", "VS", "VPP", "VPR"}, {"left"}});
        this.nonTerminalInfo.put("VPpart", new String[][]{{"leftdis", "V", "VIMP", "VINF", "VS", "VPP", "VPR"}, {"left", "VN"}, {"left"}});
        this.nonTerminalInfo.put("Srel", new String[][]{{"right", "VN", "AP", "NP"}, {"right"}});
        this.nonTerminalInfo.put("Ssub", new String[][]{{"right", "VN", "AP", "NP", "PP", "VPinf", "Ssub", "VPpart"}, {"rightdis", "A", "ADJ", "ADJWH"}, {"rightdis", "ADV", "ADVWH"}, {"right"}});
        this.nonTerminalInfo.put("Sint", new String[][]{{"right", "VN", "AP", "NP", "PP", "VPinf", "Ssub", "VPpart"}, {"rightdis", "A", "ADJ", "ADJWH"}, {"rightdis", "ADV", "ADVWH"}, {"right"}});
        this.nonTerminalInfo.put("MWD", new String[][]{{"leftdis", "D", "DET", "DETWH"}, {"left"}});
        this.nonTerminalInfo.put("MWA", new String[][]{{"left", "P"}, {"leftdis", "N", "NPP", "NC"}, {"rightdis", "A", "ADJ", "ADJWH"}, {"right"}});
        this.nonTerminalInfo.put("MWC", new String[][]{{"leftdis", "C", "CC", "CS"}, {"left"}});
        this.nonTerminalInfo.put("MWN", new String[][]{{"rightdis", "N", "NPP", "NC"}, {"rightdis", "ET"}, {"right"}});
        this.nonTerminalInfo.put("MWV", new String[][]{{"leftdis", "V", "VIMP", "VINF", "VS", "VPP", "VPR"}, {"left"}});
        this.nonTerminalInfo.put("MWP", new String[][]{{"left", "P"}, {"leftdis", "ADV", "ADVWH"}, {"leftdis", "PRO", "PROWH", "PROREL"}, {"left"}});
        this.nonTerminalInfo.put("MWPRO", new String[][]{{"leftdis", "PRO", "PROWH", "PROREL"}, {"leftdis", "CL", "CLS", "CLR", "CLO"}, {"leftdis", "N", "NPP", "NC"}, {"leftdis", "A", "ADJ", "ADJWH"}, {"left"}});
        this.nonTerminalInfo.put("MWCL", new String[][]{{"leftdis", "CL", "CLS", "CLR", "CLO"}, {"right"}});
        this.nonTerminalInfo.put("MWADV", new String[][]{{"left", "P"}, {"leftdis", "ADV", "ADVWH"}, {"left"}});
        this.nonTerminalInfo.put("MWI", new String[][]{{"leftdis", "N", "NPP", "NC"}, {"leftdis", "ADV", "ADVWH"}, {"left", "P"}, {"left"}});
        this.nonTerminalInfo.put("MWET", new String[][]{{"left", "ET"}, {"leftdis", "N", "NPP", "NC"}, {"left"}});
        this.nonTerminalInfo.put("DUMMYP", new String[][]{{"left"}});
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        DybroFrenchHeadFinder chf = new DybroFrenchHeadFinder();
        ((Treebank)treebank).apply(pt -> {
            pt.percolateHeads(chf);
            pt.pennPrint();
            System.out.println();
        });
    }
}

