/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticalCorefUtils {
    public static List<Mention> getSortedMentions(Document document) {
        ArrayList<Mention> mentions = new ArrayList<Mention>(document.predictedMentionsByID.values());
        Collections.sort(mentions, (m1, m2) -> m1.appearEarlierThan((Mention)m2) ? -1 : 1);
        return mentions;
    }

    public static Map<Pair<Integer, Integer>, Boolean> getUnlabeledMentionPairs(Document document) {
        return StatisticalCorefUtils.getUnlabeledMentionPairs(document, Integer.MAX_VALUE);
    }

    public static Map<Pair<Integer, Integer>, Boolean> getUnlabeledMentionPairs(Document document, int maxMentionDistance) {
        HashMap<Pair<Integer, Integer>, Boolean> pairs = new HashMap<Pair<Integer, Integer>, Boolean>();
        List<Mention> mentions = StatisticalCorefUtils.getSortedMentions(document);
        for (int i = 0; i < mentions.size(); ++i) {
            for (int j = Math.max(0, i - maxMentionDistance); j < i; ++j) {
                pairs.put(new Pair<Integer, Integer>(mentions.get((int)j).mentionID, mentions.get((int)i).mentionID), false);
            }
        }
        return pairs;
    }

    public static void mergeCoreferenceClusters(Pair<Integer, Integer> mentionPair, Document document) {
        Mention m1 = document.predictedMentionsByID.get(mentionPair.first);
        Mention m2 = document.predictedMentionsByID.get(mentionPair.second);
        if (m1.corefClusterID == m2.corefClusterID) {
            return;
        }
        int removeId = m1.corefClusterID;
        CorefCluster c1 = document.corefClusters.get(m1.corefClusterID);
        CorefCluster c2 = document.corefClusters.get(m2.corefClusterID);
        CorefCluster.mergeClusters(c2, c1);
        document.corefClusters.remove(removeId);
    }

    public static void removeSingletonClusters(Document document) {
        for (CorefCluster c : new ArrayList<CorefCluster>(document.corefClusters.values())) {
            if (c.getCorefMentions().size() != 1) continue;
            document.corefClusters.remove(c.clusterID);
        }
    }

    public static String fieldValues(Object o) {
        Field[] fields;
        String s = "";
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                s = s + field.getName() + " = " + field.get(o) + "\n";
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting field value for " + field.getName(), e);
            }
        }
        return s;
    }
}

