/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.AbstractListProcessor;
import edu.stanford.nlp.process.StripTagsProcessor;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class PTBEscapingProcessor<IN extends HasWord, L, F>
extends AbstractListProcessor<IN, HasWord, L, F>
implements Function<List<IN>, List<HasWord>> {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final char[] SUBST_CHARS = new char[]{'(', ')', '[', ']', '{', '}'};
    private static final String[] REPLACE_SUBSTS = new String[]{"-LRB-", "-RRB-", "-LSB-", "-RSB-", "-LCB-", "-RCB-"};
    private final char[] substChars;
    private final String[] replaceSubsts;
    private final char[] escapeChars;
    private final String[] replaceEscapes;
    private final boolean fixQuotes;

    public PTBEscapingProcessor() {
        this(true);
    }

    public PTBEscapingProcessor(boolean fixQuotes) {
        this(EMPTY_CHAR_ARRAY, StringUtils.EMPTY_STRING_ARRAY, SUBST_CHARS, REPLACE_SUBSTS, fixQuotes);
    }

    public PTBEscapingProcessor(char[] escapeChars, String[] replaceEscapes, char[] substChars, String[] replaceSubsts, boolean fixQuotes) {
        this.escapeChars = escapeChars;
        this.replaceEscapes = replaceEscapes;
        this.substChars = substChars;
        this.replaceSubsts = replaceSubsts;
        this.fixQuotes = fixQuotes;
    }

    @Override
    public List<HasWord> apply(List<IN> hasWordsList) {
        return this.process(hasWordsList);
    }

    public static String unprocess(String s) {
        for (int i = 0; i < REPLACE_SUBSTS.length; ++i) {
            s = s.replaceAll(REPLACE_SUBSTS[i], String.valueOf(SUBST_CHARS[i]));
        }
        return s;
    }

    @Override
    public List<HasWord> process(List<? extends IN> input) {
        ArrayList<HasWord> output = new ArrayList<HasWord>();
        for (HasWord h : input) {
            String s = h.word();
            h.setWord(this.escapeString(s));
            output.add(h);
        }
        if (this.fixQuotes) {
            return PTBEscapingProcessor.fixQuotes(output);
        }
        return output;
    }

    private static List<HasWord> fixQuotes(List<HasWord> input) {
        int inputSize = input.size();
        LinkedList<HasWord> result = new LinkedList<HasWord>();
        if (inputSize == 0) {
            return result;
        }
        if (input.get(inputSize - 1).word().equals("\"")) {
            boolean begin = false;
            for (int i = inputSize - 1; i >= 0; --i) {
                HasWord hw = input.get(i);
                String tok = hw.word();
                if (tok.equals("\"")) {
                    if (begin) {
                        hw.setWord("``");
                        begin = false;
                    } else {
                        hw.setWord("''");
                        begin = true;
                    }
                }
                result.addFirst(hw);
            }
        } else {
            boolean begin = true;
            for (HasWord hw : input) {
                String tok = hw.word();
                if (tok.equals("\"")) {
                    if (begin) {
                        hw.setWord("``");
                        begin = false;
                    } else {
                        hw.setWord("''");
                        begin = true;
                    }
                }
                result.addLast(hw);
            }
        }
        return result;
    }

    public String escapeString(String s) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int k;
            char curChar = s.charAt(i);
            boolean found = false;
            for (k = 0; k < this.substChars.length; ++k) {
                if (curChar != this.substChars[k]) continue;
                buff.append(this.replaceSubsts[k]);
                found = true;
                break;
            }
            if (found) continue;
            if (curChar == '\\') {
                buff.append(curChar);
                if (this.maybeAppendOneMore(i + 1, s, buff)) {
                    ++i;
                }
                found = true;
            }
            if (found) continue;
            for (k = 0; k < this.escapeChars.length; ++k) {
                if (curChar != this.escapeChars[k]) continue;
                buff.append(this.replaceEscapes[k]);
                found = true;
                break;
            }
            if (found) continue;
            buff.append(curChar);
        }
        return buff.toString();
    }

    private boolean maybeAppendOneMore(int pos, String s, StringBuilder buff) {
        if (pos >= s.length()) {
            return false;
        }
        char candidate = s.charAt(pos);
        boolean found = false;
        for (char ch : this.substChars) {
            if (candidate != ch) continue;
            found = true;
            break;
        }
        if (found) {
            return false;
        }
        buff.append(candidate);
        return true;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java edu.stanford.nlp.process.PTBEscapingProcessor fileOrUrl");
            return;
        }
        String filename = args[0];
        try {
            Document d;
            if (filename.startsWith("http://")) {
                BasicDocument dpre = new BasicDocument(WhitespaceTokenizer.factory()).init(new URL(filename));
                StripTagsProcessor notags = new StripTagsProcessor();
                d = notags.processDocument(dpre);
            } else {
                d = new BasicDocument(WhitespaceTokenizer.factory()).init(new File(filename));
            }
            PTBEscapingProcessor proc = new PTBEscapingProcessor();
            Document newD = proc.processDocument(d);
            for (HasWord word : newD) {
                System.out.println(word);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

