/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.CoNLLOutputter;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.pipeline.XMLOutputter;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class StanfordCoreNLPClient
extends AnnotationPipeline {
    private final String path = "";
    private final Properties properties;
    private final String propsAsJSON;
    private final BackendScheduler scheduler;
    private final ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer(true);

    private StanfordCoreNLPClient(Properties properties, List<Backend> backends) {
        this.properties = properties;
        Properties serverProperties = new Properties();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            serverProperties.setProperty(key, properties.getProperty(key));
        }
        Collections.shuffle(backends, new Random(System.currentTimeMillis()));
        this.scheduler = new BackendScheduler(backends);
        serverProperties.setProperty("inputFormat", "serialized");
        serverProperties.setProperty("outputFormat", "serialized");
        serverProperties.setProperty("inputSerializer", ProtobufAnnotationSerializer.class.getName());
        serverProperties.setProperty("outputSerializer", ProtobufAnnotationSerializer.class.getName());
        ArrayList<String> jsonProperties = new ArrayList<String>();
        keys = serverProperties.propertyNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            jsonProperties.add("\"" + JSONOutputter.cleanJSON(key.toString()) + "\": \"" + JSONOutputter.cleanJSON(serverProperties.getProperty(key.toString())) + "\"");
        }
        this.propsAsJSON = "{ " + StringUtils.join(jsonProperties, ", ") + " }";
        this.scheduler.start();
    }

    public StanfordCoreNLPClient(Properties properties, String host, int port) {
        this(properties, Collections.singletonList(new Backend(host, port)));
    }

    public StanfordCoreNLPClient(Properties properties, final String host, final int port, final int threads) {
        this(properties, (List<Backend>)new ArrayList<Backend>(){
            {
                for (int i = 0; i < threads; ++i) {
                    this.add(new Backend(host, port));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotate(Annotation annotation) {
        ReentrantLock lock = new ReentrantLock();
        Condition annotationDone = lock.newCondition();
        this.annotate(Collections.singleton(annotation), 1, annInput -> {
            try {
                lock.lock();
                annotationDone.signal();
            }
            finally {
                lock.unlock();
            }
        });
        try {
            lock.lock();
            annotationDone.await();
        }
        catch (InterruptedException e) {
            System.err.println("Interrupt while waiting for annotation to return");
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void annotate(Iterable<Annotation> annotations, int numThreads, Consumer<Annotation> callback) {
        for (Annotation annotation : annotations) {
            this.annotate(annotation, callback);
        }
    }

    public void annotate(final Annotation annotation, Consumer<Annotation> callback) {
        this.scheduler.schedule((backend, isFinishedCallback) -> new Thread((Backend)backend, (Consumer)isFinishedCallback, callback){
            final /* synthetic */ Backend val$backend;
            final /* synthetic */ Consumer val$isFinishedCallback;
            final /* synthetic */ Consumer val$cap$1;
            {
                this.val$backend = backend;
                this.val$isFinishedCallback = consumer;
                this.val$cap$1 = consumer2;
            }

            @Override
            public void run() {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    StanfordCoreNLPClient.this.serializer.write(annotation, os);
                    os.close();
                    byte[] message = os.toByteArray();
                    String queryParams = String.format("properties=%s", URLEncoder.encode(StanfordCoreNLPClient.this.propsAsJSON, "utf-8"));
                    URL serverURL = new URL(this.val$backend.protocol, this.val$backend.host, this.val$backend.port, "" + "?" + queryParams);
                    URLConnection connection = serverURL.openConnection();
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Content-Type", "application/x-protobuf");
                    connection.setRequestProperty("Content-Length", Integer.toString(message.length));
                    connection.setRequestProperty("Accept-Charset", "utf-8");
                    connection.setRequestProperty("User-Agent", StanfordCoreNLPClient.class.getName());
                    switch (this.val$backend.protocol) {
                        case "http": {
                            ((HttpURLConnection)connection).setRequestMethod("POST");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Haven't implemented protocol: " + this.val$backend.protocol);
                        }
                    }
                    connection.getOutputStream().write(message);
                    os.close();
                    Annotation response = (Annotation)((StanfordCoreNLPClient)StanfordCoreNLPClient.this).serializer.read((InputStream)connection.getInputStream()).first;
                    this.val$isFinishedCallback.accept(this.val$backend);
                    for (Class<?> key : response.keySet()) {
                        annotation.set(key, response.get(key));
                    }
                    this.val$cap$1.accept(annotation);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not connect to server: " + this.val$backend.host + ":" + this.val$backend.port, e);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }.start());
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    private static void shell(StanfordCoreNLPClient pipeline) throws IOException {
        System.err.println("Entering interactive shell. Type q RETURN or EOF to quit.");
        StanfordCoreNLP.OutputFormat outputFormat = StanfordCoreNLP.OutputFormat.valueOf(pipeline.properties.getProperty("outputFormat", "text").toUpperCase());
        IOUtils.console("NLP> ", line -> {
            if (line.length() > 0) {
                Annotation anno = pipeline.process((String)line);
                try {
                    switch (outputFormat) {
                        case XML: {
                            new XMLOutputter().print(anno, System.out);
                            break;
                        }
                        case JSON: {
                            new JSONOutputter().print(anno, System.out);
                            System.out.println();
                            break;
                        }
                        case CONLL: {
                            new CoNLLOutputter().print(anno, System.out);
                            System.out.println();
                            break;
                        }
                        case TEXT: {
                            new TextOutputter().print(anno, System.out);
                            break;
                        }
                        case SERIALIZED: {
                            Redwood.Util.warn("You probably cannot read the serialized output, so printing in text instead");
                            new TextOutputter().print(anno, System.out);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Cannot output in format " + (Object)((Object)outputFormat) + " from the interactive shell");
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }

    public void run() throws IOException {
        StanfordRedwoodConfiguration.minimalSetup();
        StanfordCoreNLP.OutputFormat outputFormat = StanfordCoreNLP.OutputFormat.valueOf(this.properties.getProperty("outputFormat", "text").toUpperCase());
        if (this.properties.containsKey("file") || this.properties.containsKey("textFile")) {
            String fileName = this.properties.getProperty("file");
            if (fileName == null) {
                fileName = this.properties.getProperty("textFile");
            }
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true);
            StanfordCoreNLP.processFiles(null, files, 1, this.properties, this::annotate, StanfordCoreNLP.createOutputter(this.properties, new AnnotationOutputter.Options()), outputFormat);
        } else if (this.properties.containsKey("filelist")) {
            String fileName = this.properties.getProperty("filelist");
            Collection<File> inputfiles = StanfordCoreNLP.readFileList(fileName);
            ArrayList<File> files = new ArrayList<File>(inputfiles.size());
            for (File file : inputfiles) {
                if (file.isDirectory()) {
                    files.addAll(new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true));
                    continue;
                }
                files.add(file);
            }
            StanfordCoreNLP.processFiles(null, files, 1, this.properties, this::annotate, StanfordCoreNLP.createOutputter(this.properties, new AnnotationOutputter.Options()), outputFormat);
        } else {
            StanfordCoreNLPClient.shell(this);
        }
    }

    public void shutdown() throws InterruptedException {
        this.scheduler.queueLock.lock();
        try {
            while (!this.scheduler.queue.isEmpty()) {
                this.scheduler.queueEmpty.await();
            }
            this.scheduler.doRun = false;
            this.scheduler.enqueued.signalAll();
        }
        finally {
            this.scheduler.queueLock.unlock();
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Properties props = StringUtils.argsToProperties(args);
        boolean hasH = props.containsKey("h");
        boolean hasHelp = props.containsKey("help");
        if (hasH || hasHelp) {
            String helpValue = hasH ? props.getProperty("h") : props.getProperty("help");
            StanfordCoreNLP.printHelp(System.err, helpValue);
            return;
        }
        ArrayList<Backend> backends = new ArrayList<Backend>();
        for (String spec : props.getProperty("backends", "corenlp.run").split(",")) {
            if (spec.contains(":")) {
                String host = spec.substring(0, spec.indexOf(":"));
                int port = Integer.parseInt(spec.substring(spec.indexOf(":") + 1));
                backends.add(new Backend(host, port));
                continue;
            }
            backends.add(new Backend(spec, 80));
        }
        StanfordCoreNLPClient client = new StanfordCoreNLPClient(props, backends);
        client.run();
        try {
            client.shutdown();
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
    }

    private static class BackendScheduler
    extends Thread {
        public final List<Backend> backends;
        private final Queue<Backend> freeAnnotators;
        private final Lock freeAnnotatorsLock = new ReentrantLock();
        private final Condition newlyFree = this.freeAnnotatorsLock.newCondition();
        private final Queue<BiConsumer<Backend, Consumer<Backend>>> queue;
        private final Lock queueLock = new ReentrantLock();
        private final Condition enqueued = this.queueLock.newCondition();
        public final Condition queueEmpty = this.queueLock.newCondition();
        private boolean doRun = true;

        public BackendScheduler(List<Backend> backends) {
            this.setDaemon(true);
            this.backends = backends;
            this.freeAnnotators = new LinkedList<Backend>(backends);
            this.queue = new LinkedList<BiConsumer<Backend, Consumer<Backend>>>();
        }

        @Override
        public void run() {
            try {
                while (this.doRun) {
                    this.queueLock.lock();
                    while (this.queue.isEmpty()) {
                        this.enqueued.await();
                        if (this.doRun) continue;
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        this.queueEmpty.signalAll();
                    }
                    BiConsumer<Backend, Consumer<Backend>> request = this.queue.poll();
                    this.queueLock.unlock();
                    this.freeAnnotatorsLock.lock();
                    while (this.freeAnnotators.isEmpty()) {
                        this.newlyFree.await();
                    }
                    Backend annotator = this.freeAnnotators.poll();
                    this.freeAnnotatorsLock.unlock();
                    request.accept(annotator, freedAnnotator -> {
                        this.freeAnnotatorsLock.lock();
                        try {
                            this.freeAnnotators.add((Backend)freedAnnotator);
                            this.newlyFree.signal();
                        }
                        finally {
                            this.freeAnnotatorsLock.unlock();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void schedule(BiConsumer<Backend, Consumer<Backend>> annotate) {
            this.queueLock.lock();
            try {
                this.queue.add(annotate);
                this.enqueued.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }
    }

    private static class Backend {
        public final String protocol = "http";
        public final String host;
        public final int port;

        public Backend(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Backend)) {
                return false;
            }
            Backend backend = (Backend)o;
            return this.port == backend.port && "http".equals(backend.protocol) && this.host.equals(backend.host);
        }

        public int hashCode() {
            throw new IllegalStateException("Hashing backends is dangerous!");
        }
    }
}

