/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentWriter;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class CoNLLUOutputter
extends AnnotationOutputter {
    private static final CoNLLUDocumentWriter conllUWriter = new CoNLLUDocumentWriter();

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        PrintWriter writer = new PrintWriter(target);
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            SemanticGraph sg = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            if (sg == null) continue;
            writer.print(conllUWriter.printSemanticGraph(sg));
        }
        writer.flush();
    }

    public static void conllUPrint(Annotation annotation, OutputStream os) throws IOException {
        new CoNLLUOutputter().print(annotation, os);
    }

    public static void conllUPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new CoNLLUOutputter().print(annotation, os, pipeline);
    }

    public static void conllUPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new CoNLLUOutputter().print(annotation, os, options);
    }
}

