/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CreatePatterns<E> {
    ConstantsAndVariables constVars;

    public CreatePatterns(Properties props, ConstantsAndVariables constVars) throws IOException {
        this.constVars = constVars;
        Execution.fillOptions(ConstantsAndVariables.class, props);
        constVars.setUp(props);
        this.setUp(props);
    }

    void setUp(Properties props) {
        Execution.fillOptions((Object)this, props);
    }

    public void getAllPatterns(Map<String, DataInstance> sents, Properties props, ConstantsAndVariables.PatternForEachTokenWay storePatsForEachTokenWay) {
        Date startDate = new Date();
        ArrayList<String> keyset = new ArrayList<String>(sents.keySet());
        int num = this.constVars.numThreads == 1 ? keyset.size() : keyset.size() / this.constVars.numThreads;
        ExecutorService executor = Executors.newFixedThreadPool(this.constVars.numThreads);
        Redwood.log(ConstantsAndVariables.extremedebug, "Computing all patterns. keyset size is " + keyset.size() + ". Assigning " + num + " values to each thread");
        ArrayList<Future<Boolean>> list = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < this.constVars.numThreads; ++i) {
            int n = i * num;
            int to = -1;
            to = i == this.constVars.numThreads - 1 ? keyset.size() : Math.min(keyset.size(), (i + 1) * num);
            List<String> ids = keyset.subList(n, to);
            CreatePatternsThread task = new CreatePatternsThread(sents, ids, props, storePatsForEachTokenWay);
            Future<Boolean> submit = executor.submit(task);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                future.get();
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
        Date endDate = new Date();
        String string = GetPatternsFromDataMultiClass.elapsedTime(startDate, endDate);
        Redwood.log(new Object[]{Redwood.DBG, "Done computing all patterns [" + string + "]"});
    }

    public class CreatePatternsThread
    implements Callable<Boolean> {
        Map<String, DataInstance> sents;
        List<String> sentIds;
        PatternsForEachToken<E> patsForEach;

        public CreatePatternsThread(Map<String, DataInstance> sents, List<String> sentIds, Properties props, ConstantsAndVariables.PatternForEachTokenWay storePatsForEachToken) {
            this.sents = sents;
            this.sentIds = sentIds;
            this.patsForEach = PatternsForEachToken.getPatternsInstance(props, storePatsForEachToken);
        }

        @Override
        public Boolean call() throws Exception {
            HashMap tempPatternsForTokens = new HashMap();
            int numSentencesInOneCommit = 0;
            for (String id : this.sentIds) {
                DataInstance sent = this.sents.get(id);
                if (!CreatePatterns.this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                    tempPatternsForTokens.put(id, new HashMap());
                }
                CreatePatterns createPatterns = CreatePatterns.this;
                Map p = PatternFactory.getPatternsAroundTokens(CreatePatterns.this.constVars.patternType, sent, createPatterns.constVars.getStopWords());
                if (!CreatePatterns.this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                    tempPatternsForTokens.put(id, p);
                    if (++numSentencesInOneCommit % 1000 != 0) continue;
                    this.patsForEach.addPatterns(tempPatternsForTokens);
                    tempPatternsForTokens.clear();
                    numSentencesInOneCommit = 0;
                    continue;
                }
                this.patsForEach.addPatterns(id, p);
            }
            if (!CreatePatterns.this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                this.patsForEach.addPatterns(tempPatternsForTokens);
            }
            return true;
        }
    }
}

