/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Quadruple;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CRFLogConditionalObjectiveFunctionWithDropout
extends CRFLogConditionalObjectiveFunction {
    private final double delta;
    private final double dropoutScale;
    private double[][] dropoutPriorGradTotal;
    private final boolean dropoutApprox;
    private double[][] weightSquare;
    private final int[][][][] totalData;
    private int unsupDropoutStartIndex;
    private final double unsupDropoutScale;
    private List<List<Set<Integer>>> dataFeatureHash;
    private List<Map<Integer, List<Integer>>> condensedMap;
    private int[][] dataFeatureHashByDoc;
    private int edgeLabelIndexSize;
    private int nodeLabelIndexSize;
    private int[][] edgeLabels;
    private Map<Integer, List<Integer>> currPrevLabelsMap;
    private Map<Integer, List<Integer>> currNextLabelsMap;
    private ThreadsafeProcessor<Pair<Integer, Boolean>, Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>>> dropoutPriorThreadProcessor = new ThreadsafeProcessor<Pair<Integer, Boolean>, Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>>>(){

        @Override
        public Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>> process(Pair<Integer, Boolean> docIndexUnsup) {
            return CRFLogConditionalObjectiveFunctionWithDropout.this.expectedCountsAndValueForADoc(docIndexUnsup.first(), false, docIndexUnsup.second());
        }

        @Override
        public ThreadsafeProcessor<Pair<Integer, Boolean>, Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>>> newInstance() {
            return this;
        }
    };

    CRFLogConditionalObjectiveFunctionWithDropout(int[][][][] data, int[][] labels, int window, Index<String> classIndex, List<Index<CRFLabel>> labelIndices, int[] map, String priorType, String backgroundSymbol, double sigma, double[][][][] featureVal, double delta, double dropoutScale, int multiThreadGrad, boolean dropoutApprox, double unsupDropoutScale, int[][][][] unsupDropoutData) {
        super(data, labels, window, classIndex, labelIndices, map, priorType, backgroundSymbol, sigma, featureVal, multiThreadGrad);
        this.delta = delta;
        this.dropoutScale = dropoutScale;
        this.dropoutApprox = dropoutApprox;
        this.dropoutPriorGradTotal = this.empty2D();
        this.unsupDropoutStartIndex = data.length;
        this.unsupDropoutScale = unsupDropoutScale;
        if (unsupDropoutData != null) {
            int i;
            this.totalData = new int[data.length + unsupDropoutData.length][][][];
            for (i = 0; i < data.length; ++i) {
                this.totalData[i] = data[i];
            }
            for (i = 0; i < unsupDropoutData.length; ++i) {
                this.totalData[i + this.unsupDropoutStartIndex] = unsupDropoutData[i];
            }
        } else {
            this.totalData = data;
        }
        this.initEdgeLabels();
        this.initializeDataFeatureHash();
    }

    private void initEdgeLabels() {
        if (this.labelIndices.size() < 2) {
            return;
        }
        Index edgeLabelIndex = (Index)this.labelIndices.get(1);
        this.edgeLabelIndexSize = edgeLabelIndex.size();
        Index nodeLabelIndex = (Index)this.labelIndices.get(0);
        this.nodeLabelIndexSize = nodeLabelIndex.size();
        this.currPrevLabelsMap = new HashMap<Integer, List<Integer>>();
        this.currNextLabelsMap = new HashMap<Integer, List<Integer>>();
        this.edgeLabels = new int[this.edgeLabelIndexSize][];
        for (int k = 0; k < this.edgeLabelIndexSize; ++k) {
            int[] labelPair = ((CRFLabel)edgeLabelIndex.get(k)).getLabel();
            this.edgeLabels[k] = labelPair;
            int curr = labelPair[1];
            int prev = labelPair[0];
            if (!this.currPrevLabelsMap.containsKey(curr)) {
                this.currPrevLabelsMap.put(curr, new ArrayList(this.numClasses));
            }
            this.currPrevLabelsMap.get(curr).add(prev);
            if (!this.currNextLabelsMap.containsKey(prev)) {
                this.currNextLabelsMap.put(prev, new ArrayList(this.numClasses));
            }
            this.currNextLabelsMap.get(prev).add(curr);
        }
    }

    private Map<Integer, double[]> sparseE(Set<Integer> activeFeatures) {
        HashMap<Integer, double[]> aMap = new HashMap<Integer, double[]>(activeFeatures.size());
        for (int f : activeFeatures) {
            aMap.put(f, new double[this.map[f] == 0 ? this.nodeLabelIndexSize : this.edgeLabelIndexSize]);
        }
        return aMap;
    }

    private Map<Integer, double[]> sparseE(int[] activeFeatures) {
        HashMap<Integer, double[]> aMap = new HashMap<Integer, double[]>(activeFeatures.length);
        for (int f : activeFeatures) {
            aMap.put(f, new double[this.map[f] == 0 ? this.nodeLabelIndexSize : this.edgeLabelIndexSize]);
        }
        return aMap;
    }

    private Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>> expectedCountsAndValueForADoc(int docIndex, boolean skipExpectedCountCalc, boolean skipValCalc) {
        int[] activeFeatures = this.dataFeatureHashByDoc[docIndex];
        List<Set<Integer>> docDataHash = this.dataFeatureHash.get(docIndex);
        Map<Integer, List<Integer>> condensedFeaturesMap = this.condensedMap.get(docIndex);
        double prob = 0.0;
        int[][][] docData = this.totalData[docIndex];
        int[] docLabels = null;
        if (docIndex < this.labels.length) {
            docLabels = this.labels[docIndex];
        }
        Timing timer = new Timing();
        double[][][] featureVal3DArr = null;
        if (this.featureVal != null) {
            featureVal3DArr = this.featureVal[docIndex];
        }
        CRFCliqueTree<String> cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(docData, this.labelIndices, this.numClasses, this.classIndex, this.backgroundSymbol, this.cliquePotentialFunc, featureVal3DArr);
        if (!skipValCalc) {
            int[] given = new int[this.window - 1];
            Arrays.fill(given, this.classIndex.indexOf(this.backgroundSymbol));
            if (docLabels.length > docData.length) {
                System.arraycopy(docLabels, 0, given, 0, given.length);
                int[] newDocLabels = new int[docData.length];
                System.arraycopy(docLabels, docLabels.length - newDocLabels.length, newDocLabels, 0, newDocLabels.length);
                docLabels = newDocLabels;
            }
            double startPosLogProb = cliqueTree.logProbStartPos();
            if (VERBOSE) {
                System.err.printf("P_-1(Background) = % 5.3f\n", startPosLogProb);
            }
            prob += startPosLogProb;
            for (int i = 0; i < docData.length; ++i) {
                int label = docLabels[i];
                double p = cliqueTree.condLogProbGivenPrevious(i, label, given);
                if (VERBOSE) {
                    System.err.println("P(" + label + "|" + ArrayMath.toString(given) + ")=" + Math.exp(p));
                }
                prob += p;
                System.arraycopy(given, 1, given, 0, given.length - 1);
                given[given.length - 1] = label;
            }
        }
        Map<Integer, double[]> EForADoc = this.sparseE(activeFeatures);
        ArrayList<Map<Integer, double[]>> EForADocPos = null;
        if (this.dropoutApprox) {
            EForADocPos = new ArrayList<Map<Integer, double[]>>(docData.length);
        }
        if (!skipExpectedCountCalc) {
            double fVal = 1.0;
            for (int i = 0; i < docData.length; ++i) {
                Object labelIndex;
                Set<Integer> docDataHashI = docDataHash.get(i);
                Map<Integer, double[]> EForADocPosAtI = null;
                if (this.dropoutApprox) {
                    EForADocPosAtI = this.sparseE(docDataHashI);
                }
                for (int fIndex : docDataHashI) {
                    int j = this.map[fIndex];
                    labelIndex = (Index)this.labelIndices.get(j);
                    for (int k = 0; k < labelIndex.size(); ++k) {
                        int[] label = ((CRFLabel)labelIndex.get(k)).getLabel();
                        double p = cliqueTree.prob(i, label);
                        if (this.dropoutApprox) {
                            this.increScore(EForADocPosAtI, fIndex, k, fVal * p);
                        }
                        this.increScore(EForADoc, fIndex, k, fVal * p);
                    }
                }
                if (!this.dropoutApprox) continue;
                for (int fIndex : docDataHashI) {
                    if (!condensedFeaturesMap.containsKey(fIndex)) continue;
                    List<Integer> aList = condensedFeaturesMap.get(fIndex);
                    labelIndex = aList.iterator();
                    while (labelIndex.hasNext()) {
                        int toCopyInto = (Integer)labelIndex.next();
                        double[] arr = EForADocPosAtI.get(fIndex);
                        double[] targetArr = new double[arr.length];
                        for (int q = 0; q < arr.length; ++q) {
                            targetArr[q] = arr[q];
                        }
                        EForADocPosAtI.put(toCopyInto, targetArr);
                    }
                }
                EForADocPos.add(EForADocPosAtI);
            }
            for (Map.Entry<Integer, List<Integer>> entry : condensedFeaturesMap.entrySet()) {
                int key = entry.getKey();
                List<Integer> aList = entry.getValue();
                for (int toCopyInto : aList) {
                    double[] arr = EForADoc.get(key);
                    double[] targetArr = new double[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        targetArr[i] = arr[i];
                    }
                    EForADoc.put(toCopyInto, targetArr);
                }
            }
        }
        Map<Integer, double[]> dropoutPriorGrad = null;
        if (this.prior == 4) {
            dropoutPriorGrad = this.sparseE(activeFeatures);
            prob -= this.getDropoutPrior(cliqueTree, docData, EForADoc, docDataHash, activeFeatures, dropoutPriorGrad, condensedFeaturesMap, EForADocPos);
        }
        return new Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>>(docIndex, prob, EForADoc, dropoutPriorGrad);
    }

    private void increScore(Map<Integer, double[]> aMap, int fIndex, int k, double val) {
        double[] dArray = aMap.get(fIndex);
        int n = k;
        dArray[n] = dArray[n] + val;
    }

    private void increScoreAllowNull(Map<Integer, double[]> aMap, int fIndex, int k, double val) {
        if (!aMap.containsKey(fIndex)) {
            aMap.put(fIndex, new double[this.map[fIndex] == 0 ? this.nodeLabelIndexSize : this.edgeLabelIndexSize]);
        }
        double[] dArray = aMap.get(fIndex);
        int n = k;
        dArray[n] = dArray[n] + val;
    }

    private void initializeDataFeatureHash() {
        int macroActiveFeatureTotalCount = 0;
        int macroCondensedTotalCount = 0;
        int macroDocPosCount = 0;
        System.err.println("initializing data feature hash, sup-data size: " + this.data.length + ", unsup data size: " + (this.totalData.length - this.data.length));
        this.dataFeatureHash = new ArrayList<List<Set<Integer>>>(this.totalData.length);
        this.condensedMap = new ArrayList<Map<Integer, List<Integer>>>(this.totalData.length);
        this.dataFeatureHashByDoc = new int[this.totalData.length][];
        for (int m = 0; m < this.totalData.length; ++m) {
            Object dataI;
            HashMap<Integer, Integer> occurPos = new HashMap<Integer, Integer>();
            int[][][] aDoc = this.totalData[m];
            ArrayList aList = new ArrayList(aDoc.length);
            HashSet setOfFeatures = new HashSet();
            for (int i = 0; i < aDoc.length; ++i) {
                HashSet<Integer> aSet = new HashSet<Integer>();
                dataI = aDoc[i];
                for (int j = 0; j < ((int[][])dataI).length; ++j) {
                    int[] dataJ;
                    for (int item : dataJ = dataI[j]) {
                        if (j == 0) {
                            if (occurPos.containsKey(item)) {
                                occurPos.put(item, -1);
                            } else {
                                occurPos.put(item, i);
                            }
                        }
                        aSet.add(item);
                    }
                }
                aList.add(aSet);
                setOfFeatures.addAll(aSet);
            }
            macroDocPosCount += aDoc.length;
            macroActiveFeatureTotalCount += setOfFeatures.size();
            HashMap condensedFeaturesMap = new HashMap();
            int[] representFeatures = new int[aDoc.length];
            Arrays.fill(representFeatures, -1);
            dataI = occurPos.entrySet().iterator();
            while (dataI.hasNext()) {
                Map.Entry entry = (Map.Entry)dataI.next();
                int key = (Integer)entry.getKey();
                int pos = (Integer)entry.getValue();
                if (pos == -1) continue;
                if (representFeatures[pos] == -1) {
                    representFeatures[pos] = key;
                    condensedFeaturesMap.put(key, new ArrayList());
                    continue;
                }
                int rep = representFeatures[pos];
                ((List)condensedFeaturesMap.get(rep)).add(key);
                ((Set)aList.get(pos)).remove(key);
                setOfFeatures.remove(key);
            }
            boolean condensedCount = false;
            Iterator it = condensedFeaturesMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (((List)entry.getValue()).size() != 0) continue;
                it.remove();
            }
            macroCondensedTotalCount += setOfFeatures.size();
            this.condensedMap.add(condensedFeaturesMap);
            this.dataFeatureHash.add(aList);
            int[] arrOfIndex = new int[setOfFeatures.size()];
            int pos2 = 0;
            for (Integer ind : setOfFeatures) {
                arrOfIndex[pos2++] = ind;
            }
            this.dataFeatureHashByDoc[m] = arrOfIndex;
        }
        System.err.println("Avg. active features per position: " + (double)macroActiveFeatureTotalCount / ((double)macroDocPosCount + 0.0));
        System.err.println("Avg. condensed features per position: " + (double)macroCondensedTotalCount / ((double)macroDocPosCount + 0.0));
        System.err.println("initializing data feature hash done!");
    }

    /*
     * WARNING - void declaration
     */
    private double getDropoutPrior(CRFCliqueTree cliqueTree, int[][][] docData, Map<Integer, double[]> EForADoc, List<Set<Integer>> docDataHash, int[] activeFeatures, Map<Integer, double[]> dropoutPriorGrad, Map<Integer, List<Integer>> condensedFeaturesMap, List<Map<Integer, double[]>> EForADocPos) {
        int i;
        Map<Integer, double[]> dropoutPriorGradFirstHalf = this.sparseE(activeFeatures);
        Timing timer = new Timing();
        double priorValue = 0.0;
        long elapsedMs = 0L;
        Pair<double[][][], double[][][]> condProbs = this.getCondProbs(cliqueTree, docData);
        double[][][] prevGivenCurr = condProbs.first();
        double[][][] nextGivenCurr = condProbs.second();
        Object FAlpha = null;
        Object FBeta = null;
        if (!this.dropoutApprox) {
            FAlpha = new double[docData.length][][][];
            FBeta = new double[docData.length][][][];
        }
        for (int i2 = 0; i2 < docData.length; ++i2) {
            if (this.dropoutApprox) continue;
            FAlpha[i2] = new double[activeFeatures.length][][];
            FBeta[i2] = new double[activeFeatures.length][][];
        }
        if (!this.dropoutApprox) {
            void var29_30;
            double bb;
            double aa;
            int fIndex = 0;
            double cc = 0.0;
            boolean prevFeaturePresent = false;
            for (i = 1; i < docData.length; ++i) {
                Set<Integer> set = docDataHash.get(i - 1);
                for (int fIndexPos = 0; fIndexPos < activeFeatures.length; ++fIndexPos) {
                    fIndex = activeFeatures[fIndexPos];
                    prevFeaturePresent = set.contains(fIndex);
                    int j = this.map[fIndex];
                    Index labelIndex = (Index)this.labelIndices.get(j);
                    int labelIndexSize = labelIndex.size();
                    if (FAlpha[i - 1][fIndexPos] == null) {
                        FAlpha[i - 1][fIndexPos] = new double[this.numClasses][labelIndexSize];
                        for (int q = 0; q < this.numClasses; ++q) {
                            FAlpha[i - 1][fIndexPos][q] = new double[labelIndexSize];
                        }
                    }
                    for (Map.Entry<Integer, List<Integer>> entry : this.currPrevLabelsMap.entrySet()) {
                        int y = entry.getKey();
                        double[] sum = new double[labelIndexSize];
                        for (int yPrime : entry.getValue()) {
                            int kk = 0;
                            while (kk < labelIndexSize) {
                                int[] prevLabel = ((CRFLabel)labelIndex.get(kk)).getLabel();
                                aa = prevGivenCurr[i - 1][y][yPrime];
                                bb = prevFeaturePresent && (j == 0 && prevLabel[0] == y || j == 1 && prevLabel[1] == y && prevLabel[0] == yPrime) ? 1 : 0;
                                cc = 0.0;
                                if (FAlpha[i - 1][fIndexPos][yPrime] != null) {
                                    cc = FAlpha[i - 1][fIndexPos][yPrime][kk];
                                }
                                int n = kk++;
                                sum[n] = sum[n] + aa * (bb + cc);
                            }
                        }
                        if (FAlpha[i][fIndexPos] == null) {
                            FAlpha[i][fIndexPos] = new double[this.numClasses][];
                        }
                        FAlpha[i][fIndexPos][y] = sum;
                    }
                }
            }
            int docDataLen = docData.length;
            int n = docDataLen - 2;
            while (var29_30 >= 0) {
                Set<Integer> docDataHashIPlusOne = docDataHash.get((int)(var29_30 + true));
                for (int fIndexPos = 0; fIndexPos < activeFeatures.length; ++fIndexPos) {
                    fIndex = activeFeatures[fIndexPos];
                    boolean nextFeaturePresent = docDataHashIPlusOne.contains(fIndex);
                    int j = this.map[fIndex];
                    Index labelIndex = (Index)this.labelIndices.get(j);
                    int labelIndexSize = labelIndex.size();
                    if (FBeta[var29_30 + true][fIndexPos] == null) {
                        FBeta[var29_30 + true][fIndexPos] = new double[this.numClasses][labelIndexSize];
                        for (int q = 0; q < this.numClasses; ++q) {
                            FBeta[var29_30 + true][fIndexPos][q] = new double[labelIndexSize];
                        }
                    }
                    for (Map.Entry<Integer, List<Integer>> entry : this.currNextLabelsMap.entrySet()) {
                        int y = entry.getKey();
                        double[] sum = new double[labelIndexSize];
                        for (int yPrime : entry.getValue()) {
                            int kk = 0;
                            while (kk < labelIndexSize) {
                                int[] nextLabel = ((CRFLabel)labelIndex.get(kk)).getLabel();
                                aa = nextGivenCurr[var29_30][y][yPrime];
                                bb = nextFeaturePresent && (j == 0 && nextLabel[0] == yPrime || j == 1 && nextLabel[0] == y && nextLabel[1] == yPrime) ? 1 : 0;
                                cc = 0.0;
                                if (FBeta[var29_30 + true][fIndexPos][yPrime] != null) {
                                    cc = FBeta[var29_30 + true][fIndexPos][yPrime][kk];
                                }
                                int n2 = kk++;
                                sum[n2] = sum[n2] + aa * (bb + cc);
                            }
                        }
                        if (FBeta[var29_30][fIndexPos] == null) {
                            FBeta[var29_30][fIndexPos] = new double[this.numClasses][];
                        }
                        FBeta[var29_30][fIndexPos][y] = sum;
                    }
                }
                --var29_30;
            }
        }
        double deltaDivByOneMinusDelta = this.delta / (1.0 - this.delta);
        Timing innerTimer = new Timing();
        long eTiming = 0L;
        long dropoutTiming = 0L;
        boolean containsFeature = false;
        for (i = 1; i < docData.length; ++i) {
            Set<Integer> set = docDataHash.get(i);
            Map<Integer, double[]> EForADocPosAtI = null;
            if (this.dropoutApprox) {
                EForADocPosAtI = EForADocPos.get(i);
            }
            for (int k = 0; k < this.edgeLabelIndexSize; ++k) {
                int fIndex;
                int[] label = this.edgeLabels[k];
                int y = label[0];
                int yP = label[1];
                double PtYYp = cliqueTree.prob(i, label);
                double PtYYpTimesOneMinusPtYYp = PtYYp * (1.0 - PtYYp);
                double oneMinus2PtYYp = 1.0 - 2.0 * PtYYp;
                double USum = 0.0;
                for (int jjj = 0; jjj < this.labelIndices.size(); ++jjj) {
                    for (int n = 0; n < docData[i][jjj].length; ++n) {
                        double theta;
                        fIndex = docData[i][jjj][n];
                        int valIndex = jjj == 1 ? k : yP;
                        try {
                            theta = this.weights[fIndex][valIndex];
                        }
                        catch (Exception ex) {
                            System.err.printf("weights[%d][%d], map[%d]=%d, labelIndices.get(map[%d]).size() = %d, weights.length=%d\n", fIndex, valIndex, fIndex, this.map[fIndex], fIndex, ((Index)this.labelIndices.get(this.map[fIndex])).size(), this.weights.length);
                            throw new RuntimeException(ex);
                        }
                        USum += this.weightSquare[fIndex][valIndex];
                        double VarUp = deltaDivByOneMinusDelta * theta;
                        this.increScoreAllowNull(dropoutPriorGradFirstHalf, fIndex, valIndex, VarUp * PtYYpTimesOneMinusPtYYp);
                    }
                }
                double VarU = 0.5 * deltaDivByOneMinusDelta * USum;
                priorValue += VarU * PtYYpTimesOneMinusPtYYp;
                double VarUTimesOneMinus2PtYYp = VarU * oneMinus2PtYYp;
                for (int fIndexPos = 0; fIndexPos < activeFeatures.length; ++fIndexPos) {
                    fIndex = activeFeatures[fIndexPos];
                    containsFeature = set.contains(fIndex);
                    int jj = this.map[fIndex];
                    Index fLabelIndex = (Index)this.labelIndices.get(jj);
                    for (int kk = 0; kk < fLabelIndex.size(); ++kk) {
                        double PtYYpPrime;
                        double condE;
                        double fCount;
                        int[] fLabel = ((CRFLabel)fLabelIndex.get(kk)).getLabel();
                        double d = fCount = containsFeature && (jj == 0 && fLabel[0] == yP || jj == 1 && k == kk) ? 1.0 : 0.0;
                        if (!this.dropoutApprox) {
                            double alpha = FAlpha[i][fIndexPos] == null || FAlpha[i][fIndexPos][y] == null ? 0.0 : FAlpha[i][fIndexPos][y][kk];
                            double beta = FBeta[i][fIndexPos] == null || FBeta[i][fIndexPos][yP] == null ? 0.0 : FBeta[i][fIndexPos][yP][kk];
                            condE = fCount + alpha + beta;
                            PtYYpPrime = PtYYp * (condE - EForADoc.get(fIndex)[kk]);
                        } else {
                            double E = 0.0;
                            if (EForADocPosAtI.containsKey(fIndex)) {
                                E = EForADocPosAtI.get(fIndex)[kk];
                            }
                            condE = fCount;
                            PtYYpPrime = PtYYp * (condE - E);
                        }
                        this.increScore(dropoutPriorGrad, fIndex, kk, VarUTimesOneMinus2PtYYp * PtYYpPrime);
                    }
                }
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : condensedFeaturesMap.entrySet()) {
            int key = entry.getKey();
            List<Integer> aList = entry.getValue();
            for (int toCopyInto : aList) {
                double[] arr = dropoutPriorGrad.get(key);
                double[] targetArr = new double[arr.length];
                for (int i4 = 0; i4 < arr.length; ++i4) {
                    targetArr[i4] = arr[i4];
                }
                dropoutPriorGrad.put(toCopyInto, targetArr);
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : dropoutPriorGrad.entrySet()) {
            Integer key = entry.getKey();
            double[] target = (double[])entry.getValue();
            if (!dropoutPriorGradFirstHalf.containsKey(key)) continue;
            double[] source = dropoutPriorGradFirstHalf.get(key);
            for (int i5 = 0; i5 < target.length; ++i5) {
                int n = i5;
                target[n] = target[n] + source[i5];
            }
        }
        return this.dropoutScale * priorValue;
    }

    @Override
    public void setWeights(double[][] weights) {
        int i;
        super.setWeights(weights);
        if (this.weightSquare == null) {
            this.weightSquare = new double[weights.length][];
            for (i = 0; i < weights.length; ++i) {
                this.weightSquare[i] = new double[weights[i].length];
            }
        }
        for (i = 0; i < weights.length; ++i) {
            for (int j = 0; j < weights[i].length; ++j) {
                double w = weights[i][j];
                this.weightSquare[i][j] = w * w;
            }
        }
    }

    @Override
    public void calculate(double[] x) {
        double prob = 0.0;
        this.to2D(x, this.weights);
        this.setWeights(this.weights);
        CRFLogConditionalObjectiveFunctionWithDropout.clear2D(this.E);
        CRFLogConditionalObjectiveFunctionWithDropout.clear2D(this.dropoutPriorGradTotal);
        MulticoreWrapper<Pair<Integer, Boolean>, Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>>> wrapper = new MulticoreWrapper<Pair<Integer, Boolean>, Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>>>(this.multiThreadGrad, this.dropoutPriorThreadProcessor);
        for (int m = 0; m < this.totalData.length; ++m) {
            boolean submitIsUnsup = m >= this.unsupDropoutStartIndex;
            wrapper.put(new Pair<Integer, Boolean>(m, submitIsUnsup));
            while (wrapper.peek()) {
                Map<Integer, double[]> partialE;
                boolean isUnsup;
                Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>> result = wrapper.poll();
                int docIndex = result.first();
                boolean bl = isUnsup = docIndex >= this.unsupDropoutStartIndex;
                prob = isUnsup ? (prob += this.unsupDropoutScale * result.second()) : (prob += result.second().doubleValue());
                Map<Integer, double[]> partialDropout = result.fourth();
                if (partialDropout != null) {
                    if (isUnsup) {
                        CRFLogConditionalObjectiveFunctionWithDropout.combine2DArr(this.dropoutPriorGradTotal, partialDropout, this.unsupDropoutScale);
                    } else {
                        CRFLogConditionalObjectiveFunctionWithDropout.combine2DArr(this.dropoutPriorGradTotal, partialDropout);
                    }
                }
                if (isUnsup || (partialE = result.third()) == null) continue;
                CRFLogConditionalObjectiveFunctionWithDropout.combine2DArr(this.E, partialE);
            }
        }
        wrapper.join();
        while (wrapper.peek()) {
            Map<Integer, double[]> partialE;
            boolean isUnsup;
            Quadruple<Integer, Double, Map<Integer, double[]>, Map<Integer, double[]>> result = wrapper.poll();
            int docIndex = result.first();
            boolean bl = isUnsup = docIndex >= this.unsupDropoutStartIndex;
            prob = isUnsup ? (prob += this.unsupDropoutScale * result.second()) : (prob += result.second().doubleValue());
            Map<Integer, double[]> partialDropout = result.fourth();
            if (partialDropout != null) {
                if (isUnsup) {
                    CRFLogConditionalObjectiveFunctionWithDropout.combine2DArr(this.dropoutPriorGradTotal, partialDropout, this.unsupDropoutScale);
                } else {
                    CRFLogConditionalObjectiveFunctionWithDropout.combine2DArr(this.dropoutPriorGradTotal, partialDropout);
                }
            }
            if (isUnsup || (partialE = result.third()) == null) continue;
            CRFLogConditionalObjectiveFunctionWithDropout.combine2DArr(this.E, partialE);
        }
        if (Double.isNaN(prob)) {
            throw new RuntimeException("Got NaN for prob in CRFLogConditionalObjectiveFunctionWithDropout.calculate() - this may well indicate numeric underflow due to overly long documents.");
        }
        this.value = -prob;
        if (VERBOSE) {
            System.err.println("value is " + Math.exp(-this.value));
        }
        int index = 0;
        for (int i = 0; i < this.E.length; ++i) {
            for (int j = 0; j < this.E[i].length; ++j) {
                this.derivative[index] = this.E[i][j] - this.Ehat[i][j];
                int n = index;
                this.derivative[n] = this.derivative[n] + this.dropoutScale * this.dropoutPriorGradTotal[i][j];
                if (VERBOSE) {
                    System.err.println("deriv(" + i + ',' + j + ") = " + this.E[i][j] + " - " + this.Ehat[i][j] + " = " + this.derivative[index]);
                }
                ++index;
            }
        }
    }
}

