/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref;

import edu.stanford.nlp.io.StringOutputStream;
import edu.stanford.nlp.util.SystemUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Scorer {
    public static String getEvalSummary(String evalScript, String goldFile, String predictFile) throws IOException {
        ProcessBuilder process = new ProcessBuilder(evalScript, "all", goldFile, predictFile, "none");
        StringOutputStream errSos = new StringOutputStream();
        StringOutputStream outSos = new StringOutputStream();
        PrintWriter out2 = new PrintWriter(outSos);
        PrintWriter err2 = new PrintWriter(errSos);
        SystemUtils.run(process, out2, err2);
        out2.close();
        err2.close();
        String summary = outSos.toString();
        String errStr = errSos.toString();
        if (!errStr.isEmpty()) {
            summary = summary + "\nERROR: " + errStr;
        }
        Pattern pattern = Pattern.compile("\\d+\\.\\d\\d\\d+");
        DecimalFormat df = new DecimalFormat("#.##");
        Matcher matcher = pattern.matcher(summary);
        while (matcher.find()) {
            String number = matcher.group();
            summary = summary.replaceFirst(number, df.format(Double.parseDouble(number)));
        }
        return summary;
    }
}

