/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils;

import com.minekube.connect.shadow.org.yaml.snakeyaml.Yaml;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.configutils.file.codec.FileCodec;
import org.geysermc.configutils.file.template.TemplateReader;
import org.geysermc.configutils.loader.ConfigLoader;
import org.geysermc.configutils.loader.validate.Validations;
import org.geysermc.configutils.parser.placeholder.Placeholders;
import org.geysermc.configutils.parser.template.TemplateParseResult;
import org.geysermc.configutils.parser.template.TemplateParser;
import org.geysermc.configutils.parser.template.action.Action;
import org.geysermc.configutils.parser.template.action.predefined.PredefinedGroup;
import org.geysermc.configutils.parser.template.action.register.RegisteredActions;
import org.geysermc.configutils.updater.ConfigUpdater;
import org.geysermc.configutils.updater.change.Changes;
import org.geysermc.configutils.updater.file.ConfigFileUpdaterResult;

public class ConfigUtilities {
    private final TemplateReader templateReader;
    private final FileCodec fileCodec;
    private final String configFile;
    private final String templateFile;
    private final String configVersionName;
    private final RegisteredActions actions;
    private final Changes changes;
    private final Set<String> copyDirectly;
    private final Placeholders placeholders;
    private final Validations validations;
    private final Object postInitializeCallbackArgument;
    private final boolean saveConfigAutomatically;

    private ConfigUtilities(@NonNull TemplateReader templateReader, @NonNull FileCodec fileCodec, @NonNull String configFile, @NonNull String templateFile, @NonNull String configVersionName, @NonNull RegisteredActions actions, @NonNull Changes changes, @NonNull Set<String> copyDirectly, @NonNull Placeholders placeholders, @NonNull Validations validations, @Nullable Object postInitializeCallbackArgument, boolean saveConfigAutomatically) {
        this.templateReader = Objects.requireNonNull(templateReader);
        this.fileCodec = Objects.requireNonNull(fileCodec);
        this.configFile = Objects.requireNonNull(configFile);
        this.templateFile = Objects.requireNonNull(templateFile);
        this.configVersionName = Objects.requireNonNull(configVersionName);
        this.actions = Objects.requireNonNull(actions);
        this.changes = Objects.requireNonNull(changes);
        this.copyDirectly = Objects.requireNonNull(copyDirectly);
        this.placeholders = Objects.requireNonNull(placeholders);
        this.validations = Objects.requireNonNull(validations);
        this.postInitializeCallbackArgument = postInitializeCallbackArgument;
        this.saveConfigAutomatically = saveConfigAutomatically;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T executeOn(Class<T> mapTo) throws Throwable {
        return this.createAndMapOrUpdateAndMap(mapTo);
    }

    public <T> T createAndMapOrUpdateAndMap(Class<T> mapTo) throws Throwable {
        ConfigFileUpdaterResult result = this.createOrUpdate();
        if (!result.succeeded()) {
            throw result.error();
        }
        String text = result.lines().stream().collect(Collectors.joining(System.lineSeparator()));
        Map mappedYaml = (Map)new Yaml().load(text);
        ConfigLoader loader = new ConfigLoader();
        return loader.load(mappedYaml, mapTo, this.validations, this.postInitializeCallbackArgument);
    }

    public ConfigFileUpdaterResult createOrUpdate() {
        List<String> currentConfig = this.readCurrentConfig();
        if (currentConfig != null) {
            return this.update0(currentConfig);
        }
        TemplateParseResult result = this.create();
        if (!result.succeeded()) {
            return ConfigFileUpdaterResult.failed(result.error());
        }
        return ConfigFileUpdaterResult.ok(result.templateLines(), null, Collections.emptySet(), Collections.emptyList());
    }

    public TemplateParseResult create() {
        TemplateParseResult result = this.parseTemplate();
        if (result.succeeded()) {
            this.saveConfig(result.templateLines());
        }
        return result;
    }

    public ConfigFileUpdaterResult update() {
        List<String> currentConfig = this.readCurrentConfig();
        Objects.requireNonNull(currentConfig, "Can't update a non-existing config");
        return this.update0(currentConfig);
    }

    private TemplateParseResult parseTemplate() {
        return new TemplateParser(this.templateReader, this.actions).parseTemplate(this.templateFile, this.placeholders);
    }

    private ConfigFileUpdaterResult update0(List<String> currentConfig) {
        TemplateParseResult parseResult = this.parseTemplate();
        if (!parseResult.succeeded()) {
            return ConfigFileUpdaterResult.failed(parseResult.error());
        }
        ConfigFileUpdaterResult result = new ConfigUpdater().update(currentConfig, this.configVersionName, parseResult, this.changes, this.copyDirectly, new String[0]);
        if (result.succeeded() && !result.changedLines().isEmpty()) {
            this.saveConfig(result.lines());
        }
        return result;
    }

    private void saveConfig(List<String> lines) {
        if (this.saveConfigAutomatically) {
            this.fileCodec.write(this.configFile, lines);
        }
    }

    private List<String> readCurrentConfig() {
        return this.fileCodec.read(this.configFile);
    }

    public static final class Builder {
        private final RegisteredActions actions = new RegisteredActions();
        private final Placeholders placeholders = new Placeholders();
        private final Set<String> copyDirectly = new HashSet<String>();
        private TemplateReader templateReader;
        private FileCodec fileCodec;
        private String configFile;
        private String templateFile;
        private String configVersionName = "config-version";
        private Changes changes;
        private Validations validations;
        private Object postInitializeCallbackArgument;
        private boolean saveConfigAutomatically = true;
        private boolean defaultActions = true;

        private Builder() {
        }

        public @NonNull Builder templateReader(@NonNull TemplateReader templateReader) {
            this.templateReader = Objects.requireNonNull(templateReader);
            return this;
        }

        public @NonNull Builder fileCodec(@NonNull FileCodec fileCodec) {
            this.fileCodec = Objects.requireNonNull(fileCodec);
            return this;
        }

        public @NonNull Builder configFile(@NonNull String configFile) {
            this.configFile = Objects.requireNonNull(configFile);
            return this;
        }

        public @NonNull Builder template(@NonNull String templateFile) {
            this.templateFile = Objects.requireNonNull(templateFile);
            return this;
        }

        public @NonNull Builder configVersionName(@NonNull String configVersionName) {
            this.configVersionName = Objects.requireNonNull(configVersionName);
            return this;
        }

        public @NonNull Builder registerAction(@NonNull Action action) {
            this.actions.registerAction(action);
            return this;
        }

        public @NonNull Builder changes(@NonNull Changes changes) {
            this.changes = Objects.requireNonNull(changes);
            return this;
        }

        public @NonNull Builder copyDirectly(@NonNull String subcategory) {
            Objects.requireNonNull(subcategory);
            this.copyDirectly.add(subcategory + '.');
            return this;
        }

        public @NonNull Builder definePlaceholder(@NonNull String name, @NonNull Supplier<Object> supplier) {
            Objects.requireNonNull(name, "Placeholder name shouldn't be null");
            Objects.requireNonNull(supplier, "Placeholder supplier shouldn't be null");
            this.placeholders.addPlaceholder(name, supplier);
            return this;
        }

        public @NonNull Builder definePlaceholder(@NonNull String name, @NonNull Object replacement) {
            Objects.requireNonNull(name, "Placeholder name shouldn't be null");
            Objects.requireNonNull(replacement, "Placeholder replacement shouldn't be null");
            this.placeholders.addPlaceholder(name, replacement);
            return this;
        }

        public @NonNull Builder validations(@NonNull Validations validations) {
            this.validations = Objects.requireNonNull(validations);
            return this;
        }

        public @NonNull Builder postInitializeCallbackArgument(@Nullable Object callbackArgument) {
            this.postInitializeCallbackArgument = callbackArgument;
            return this;
        }

        public @NonNull Builder saveConfigAutomatically(boolean saveConfigAutomatically) {
            this.saveConfigAutomatically = saveConfigAutomatically;
            return this;
        }

        public @NonNull Builder removeDefaultActions() {
            this.defaultActions = false;
            return this;
        }

        public @NonNull ConfigUtilities build() {
            if (this.defaultActions) {
                this.actions.registerAction(new PredefinedGroup());
            }
            Validations notNullValidations = this.validations != null ? this.validations : Validations.builder().build();
            return new ConfigUtilities(this.templateReader, this.fileCodec, this.configFile, this.templateFile, this.configVersionName, this.actions, this.changes, this.copyDirectly, this.placeholders, notNullValidations, this.postInitializeCallbackArgument, this.saveConfigAutomatically);
        }
    }
}

