/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server.log;

import com.sun.tools.sjavac.Log;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends FilterOutputStream {
    private static final byte[] LINE_SEP = System.lineSeparator().getBytes();
    private final Log.Level level;
    private final String linePrefix;
    private EolTrackingByteArrayOutputStream buf = new EolTrackingByteArrayOutputStream();

    public LoggingOutputStream(OutputStream outputStream2, Log.Level level, String string) {
        super(outputStream2);
        this.level = level;
        this.linePrefix = string;
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        this.buf.write(n);
        if (this.buf.isLineComplete()) {
            String string = new String(this.buf.toByteArray(), 0, this.buf.size() - LINE_SEP.length);
            Log.log(this.level, this.linePrefix + string);
            this.buf = new EolTrackingByteArrayOutputStream();
        }
    }

    private static class EolTrackingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private static final byte[] EOL = System.lineSeparator().getBytes();

        private EolTrackingByteArrayOutputStream() {
        }

        private boolean isLineComplete() {
            if (this.count < EOL.length) {
                return false;
            }
            for (int i = 0; i < EOL.length; ++i) {
                if (this.buf[this.count - EOL.length + i] == EOL[i]) continue;
                return false;
            }
            return true;
        }
    }
}

