/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;

public class Source
implements Comparable<Source> {
    private Package pkg;
    private String name;
    private String suffix;
    private long lastModified;
    private File file;
    private boolean isGenerated;
    private boolean linkedOnly;

    public boolean equals(Object object) {
        return object instanceof Source && this.name.equals(((Source)object).name);
    }

    @Override
    public int compareTo(Source source2) {
        return this.name.compareTo(source2.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Source(Module module, String string, File file) {
        this.name = string;
        int n = string.lastIndexOf(".");
        this.suffix = n != -1 ? string.substring(n) : "";
        this.file = file;
        this.lastModified = file.lastModified();
        this.linkedOnly = false;
    }

    public Source(Package package_, String string, long l) {
        this.pkg = package_;
        this.name = string;
        int n = string.lastIndexOf(".");
        this.suffix = n != -1 ? string.substring(n) : "";
        this.file = null;
        this.lastModified = l;
        this.linkedOnly = false;
        int n2 = string.lastIndexOf(47);
    }

    public String name() {
        return this.name;
    }

    public String suffix() {
        return this.suffix;
    }

    public Package pkg() {
        return this.pkg;
    }

    public File file() {
        return this.file;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setPackage(Package package_) {
        this.pkg = package_;
    }

    public void markAsGenerated() {
        this.isGenerated = true;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void markAsLinkedOnly() {
        this.linkedOnly = true;
    }

    public boolean isLinkedOnly() {
        return this.linkedOnly;
    }

    private void save(StringBuilder stringBuilder) {
        String string = this.linkedOnly ? "L" : "C";
        String string2 = this.isGenerated ? "G" : "S";
        stringBuilder.append(string2 + " " + string + " " + this.name + " " + this.file.lastModified() + "\n");
    }

    public static Source load(Package package_, String string, boolean bl) {
        int n = string.indexOf(32, 4);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(4, n);
        long l = Long.parseLong(string.substring(n + 1));
        boolean bl2 = false;
        if (string.charAt(2) == 'L') {
            bl2 = true;
        } else if (string.charAt(2) == 'C') {
            bl2 = false;
        } else {
            return null;
        }
        Source source2 = new Source(package_, string2, l);
        source2.file = new File(string2);
        if (bl) {
            source2.markAsGenerated();
        }
        if (bl2) {
            source2.markAsLinkedOnly();
        }
        return source2;
    }

    public static void saveSources(Map<String, Source> map, StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Source source2 = map.get(string);
            source2.save(stringBuilder);
        }
    }

    public static void scanRoot(final File file, final Set<String> set, List<String> list, List<String> list2, final Map<String, Source> map, Map<String, Module> map2, final Module module, boolean bl, final boolean bl2, final boolean bl3) throws IOException, ProblemException {
        if (file == null) {
            return;
        }
        FileSystem fileSystem = file.toPath().getFileSystem();
        if (list2.isEmpty()) {
            list2 = Collections.singletonList("**");
        }
        final List<PathMatcher> list3 = Source.createPathMatchers(fileSystem, list2);
        final List<PathMatcher> list4 = Source.createPathMatchers(fileSystem, list);
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Path path2 = file.toPath().relativize(path);
                if (!list3.stream().anyMatch(pathMatcher -> pathMatcher.matches(path2)) || !list4.stream().noneMatch(pathMatcher -> pathMatcher.matches(path2)) || !set.contains(Util.fileSuffix(path))) return FileVisitResult.CONTINUE;
                Source source2 = (Source)map.get(path);
                if (source2 != null) {
                    throw new IOException("You have already added the file " + path + " from " + source2.file().getPath());
                }
                source2 = module.lookupSource(path.toString());
                if (source2 != null) {
                    if (!bl3) throw new IOException("Internal error: Double add of file " + path + " from " + source2.file().getPath());
                    if (source2.isLinkedOnly()) {
                        throw new IOException("You have already added the link only file " + path + " from " + source2.file().getPath());
                    }
                    map.put(path.toString(), source2);
                    return FileVisitResult.CONTINUE;
                } else {
                    Source source3 = new Source(module, path.toString(), path.toFile());
                    if (bl2) {
                        source3.markAsGenerated();
                    }
                    if (bl3) {
                        source3.markAsLinkedOnly();
                    }
                    String string = Source.packageOfJavaFile(file.toPath(), path);
                    string = module.name() + ":" + string;
                    map.put(path.toString(), source3);
                    module.addSource(string, source3);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static List<PathMatcher> createPathMatchers(FileSystem fileSystem, List<String> list) {
        ArrayList<PathMatcher> arrayList = new ArrayList<PathMatcher>();
        for (String string : list) {
            try {
                arrayList.add(fileSystem.getPathMatcher("glob:" + string));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Log.error("Invalid pattern: " + string);
                throw patternSyntaxException;
            }
        }
        return arrayList;
    }

    private static String packageOfJavaFile(Path path, Path path2) {
        Path path3 = path2.getParent();
        Path path4 = path.relativize(path3);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Path path5 : path4) {
            arrayList.add(path5.getFileName().toString());
        }
        return String.join((CharSequence)".", arrayList);
    }

    public String toString() {
        return String.format("%s[pkg: %s, name: %s, suffix: %s, file: %s, isGenerated: %b, linkedOnly: %b]", this.getClass().getSimpleName(), this.pkg, this.name, this.suffix, this.file, this.isGenerated, this.linkedOnly);
    }
}

