/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Package
implements Comparable<Package> {
    private Module mod;
    private String name;
    private String dirname;
    private Set<String> dependents = new HashSet<String>();
    private Map<String, Set<String>> dependencies = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> cpDependencies = new TreeMap<String, Set<String>>();
    private PubApi pubApi = new PubApi();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();
    private static Pattern DEP_PATTERN = Pattern.compile("(.*) -> (.*)");

    public Package(Module module, String string) {
        int n = string.indexOf(":");
        Assert.check(n != -1);
        Assert.check(module.name().equals(module.name()));
        this.name = string;
        this.dirname = string.replace('.', File.separatorChar);
        if (module.name().length() > 0) {
            this.dirname = module.dirname() + File.separatorChar + this.dirname;
        }
    }

    public Module mod() {
        return this.mod;
    }

    public String name() {
        return this.name;
    }

    public String dirname() {
        return this.dirname;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public PubApi getPubApi() {
        return this.pubApi;
    }

    public Map<String, Set<String>> typeDependencies() {
        return this.dependencies;
    }

    public Map<String, Set<String>> typeClasspathDependencies() {
        return this.cpDependencies;
    }

    public Set<String> dependents() {
        return this.dependents;
    }

    public boolean equals(Object object) {
        return object instanceof Package && this.name.equals(((Package)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Package package_) {
        return this.name.compareTo(package_.name);
    }

    public void addSource(Source source2) {
        this.sources.put(source2.file().getPath(), source2);
    }

    public void parseAndAddDependency(String string, boolean bl) {
        Matcher matcher = DEP_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad dependency string: " + string);
        }
        this.addDependency(matcher.group(1), matcher.group(2), bl);
    }

    public void addDependency(String string, String string2, boolean bl) {
        Map<String, Set<String>> map;
        Map<String, Set<String>> map2 = map = bl ? this.cpDependencies : this.dependencies;
        if (!map.containsKey(string)) {
            map.put(string, new HashSet());
        }
        map.get(string).add(string2);
    }

    public void addDependent(String string) {
        this.dependents.add(string);
    }

    public boolean existsInJavacState() {
        return this.artifacts.size() > 0 || !this.pubApi.isEmpty();
    }

    public boolean hasPubApiChanged(PubApi pubApi) {
        return !pubApi.isBackwardCompatibleWith(this.pubApi);
    }

    public void setPubapi(PubApi pubApi) {
        this.pubApi = pubApi;
    }

    public void setDependencies(Map<String, Set<String>> map, boolean bl) {
        (bl ? this.cpDependencies : this.dependencies).clear();
        for (String string : map.keySet()) {
            for (String string2 : map.get(string)) {
                this.addDependency(string, string2, bl);
            }
        }
    }

    public void save(StringBuilder stringBuilder) {
        stringBuilder.append("P ").append(this.name).append("\n");
        Source.saveSources(this.sources, stringBuilder);
        this.saveDependencies(stringBuilder);
        this.savePubapi(stringBuilder);
        this.saveArtifacts(stringBuilder);
    }

    public static Package load(Module module, String string) {
        String string2 = string.substring(2);
        return new Package(module, string2);
    }

    public void saveDependencies(StringBuilder stringBuilder) {
        for (String string : this.dependencies.keySet()) {
            for (String string2 : this.dependencies.get(string)) {
                stringBuilder.append(String.format("D S %s -> %s%n", string, string2));
            }
        }
        for (String string : this.cpDependencies.keySet()) {
            for (String string2 : this.cpDependencies.get(string)) {
                stringBuilder.append(String.format("D C %s -> %s%n", string, string2));
            }
        }
    }

    public void savePubapi(StringBuilder stringBuilder) {
        this.pubApi.asListOfStrings().stream().flatMap(string -> Stream.of("I ", string, "\n")).forEach(stringBuilder::append);
    }

    public static void savePackages(Map<String, Package> map, StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Package package_ = map.get(string);
            package_.save(stringBuilder);
        }
    }

    public void addArtifact(String string) {
        this.artifacts.put(string, new File(string));
    }

    public void addArtifact(File file) {
        this.artifacts.put(file.getPath(), file);
    }

    public void addArtifacts(Set<URI> set) {
        for (URI uRI : set) {
            this.addArtifact(new File(uRI));
        }
    }

    public void setArtifacts(Set<URI> set) {
        Assert.check(!this.artifacts.isEmpty());
        this.artifacts = new HashMap<String, File>();
        this.addArtifacts(set);
    }

    public void loadArtifact(String string) {
        int n = string.indexOf(32, 2);
        String string2 = string.substring(2, n);
        long l = Long.parseLong(string.substring(n + 1));
        File file = new File(string2);
        if (file.exists() && file.lastModified() != l) {
            Log.debug("Removing " + file.getPath() + " since its timestamp does not match javac_state.");
            file.delete();
        }
        this.artifacts.put(file.getPath(), file);
    }

    public void saveArtifacts(StringBuilder stringBuilder) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : this.artifacts.values()) {
            arrayList.add(file);
        }
        Collections.sort(arrayList);
        for (File file : arrayList) {
            stringBuilder.append("A " + file.getPath() + " " + file.lastModified() + "\n");
        }
    }

    public void deleteArtifacts() {
        for (File file : this.artifacts.values()) {
            file.delete();
        }
    }
}

