/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.BuildState;
import com.sun.tools.sjavac.CompileJavaPackages;
import com.sun.tools.sjavac.CopyFile;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.PubApiExtractor;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JavacState {
    String theArgs;
    int numCores;
    private File javacState;
    private BuildState prev;
    private BuildState now;
    private boolean needsSaving;
    private boolean newJavacState;
    private Set<String> taintedPackages;
    private Set<String> packagesWithChangedPublicApis;
    private Set<String> taintedModules;
    private Set<String> recompiledPackages;
    private File binDir;
    private File gensrcDir;
    private File headerDir;
    private File stateDir;
    private Set<File> binArtifacts;
    private Set<File> gensrcArtifacts;
    private Set<File> headerArtifacts;
    Set<Source> removedSources = null;
    Set<Source> addedSources = null;
    Set<Source> modifiedSources = null;
    Set<URI> visibleSrcs;
    private CompileJavaPackages compileJavaPackages = new CompileJavaPackages();
    private Options options;

    JavacState(Options options, boolean bl) {
        this.options = options;
        this.numCores = this.options.getNumCores();
        this.theArgs = this.options.getStateArgsString();
        this.binDir = Util.pathToFile(this.options.getDestDir());
        this.gensrcDir = Util.pathToFile(this.options.getGenSrcDir());
        this.headerDir = Util.pathToFile(this.options.getHeaderDir());
        this.stateDir = Util.pathToFile(this.options.getStateDir());
        this.javacState = new File(this.stateDir, "javac_state");
        if (bl && this.javacState.exists()) {
            this.javacState.delete();
        }
        this.newJavacState = false;
        if (!this.javacState.exists()) {
            this.newJavacState = true;
            if (!this.options.areUnidentifiedArtifactsPermitted()) {
                this.deleteContents(this.binDir);
                this.deleteContents(this.gensrcDir);
                this.deleteContents(this.headerDir);
            }
            this.needsSaving = true;
        }
        this.prev = new BuildState();
        this.now = new BuildState();
        this.taintedPackages = new HashSet<String>();
        this.recompiledPackages = new HashSet<String>();
        this.packagesWithChangedPublicApis = new HashSet<String>();
    }

    public BuildState prev() {
        return this.prev;
    }

    public BuildState now() {
        return this.now;
    }

    static String[] removeArgsNotAffectingState(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-j")) {
                ++i;
                continue;
            }
            if (stringArray[i].startsWith("--server:") || stringArray[i].startsWith("--log=")) continue;
            if (stringArray[i].equals("--compare-found-sources")) {
                ++i;
                continue;
            }
            stringArray2[n] = stringArray[i];
            ++n;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    public void setVisibleSources(Map<String, Source> map) {
        this.visibleSrcs = new HashSet<URI>();
        for (String string : map.keySet()) {
            Source source2 = map.get(string);
            this.visibleSrcs.add(source2.file().toURI());
        }
    }

    public boolean isIncremental() {
        return !this.prev.sources().isEmpty();
    }

    public void findAllArtifacts() {
        this.binArtifacts = JavacState.findAllFiles(this.binDir);
        this.gensrcArtifacts = JavacState.findAllFiles(this.gensrcDir);
        this.headerArtifacts = JavacState.findAllFiles(this.headerDir);
    }

    private Map<String, File> fetchPrevArtifacts(String string) {
        Package package_ = this.prev.packages().get(string);
        if (package_ != null) {
            return package_.artifacts();
        }
        return new HashMap<String, File>();
    }

    public void deleteClassArtifactsInTaintedPackages() {
        for (String string : this.taintedPackages) {
            Map<String, File> map = this.fetchPrevArtifacts(string);
            for (File file : map.values()) {
                if (!file.exists() || !file.getName().endsWith(".class")) continue;
                file.delete();
            }
        }
    }

    private void needsSaving() {
        this.needsSaving = true;
    }

    public void save() throws IOException {
        if (!this.needsSaving) {
            return;
        }
        try (FileWriter fileWriter = new FileWriter(this.javacState);){
            StringBuilder stringBuilder = new StringBuilder();
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            stringBuilder.append("# javac_state ver 0.4 generated " + l + " " + simpleDateFormat.format(date) + "\n");
            stringBuilder.append("# This format might change at any time. Please do not depend on it.\n");
            stringBuilder.append("# R arguments\n");
            stringBuilder.append("# M module\n");
            stringBuilder.append("# P package\n");
            stringBuilder.append("# S C source_tobe_compiled timestamp\n");
            stringBuilder.append("# S L link_only_source timestamp\n");
            stringBuilder.append("# G C generated_source timestamp\n");
            stringBuilder.append("# A artifact timestamp\n");
            stringBuilder.append("# D S dependant -> source dependency\n");
            stringBuilder.append("# D C dependant -> classpath dependency\n");
            stringBuilder.append("# I pubapi\n");
            stringBuilder.append("R ").append(this.theArgs).append("\n");
            this.now.copyPackagesExcept(this.prev, this.recompiledPackages, new HashSet<String>());
            Module.saveModules(this.now.modules(), stringBuilder);
            String string = stringBuilder.toString();
            fileWriter.write(string, 0, string.length());
        }
    }

    public static JavacState load(Options options) {
        JavacState javacState = new JavacState(options, false);
        Module module = null;
        Package package_ = null;
        Source source2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Log.debug("Loading javac state file: " + javacState.javacState);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(javacState.javacState));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.length() < 3 || string.charAt(1) != ' ') continue;
                char c = string.charAt(0);
                if (c == 'M') {
                    module = javacState.prev.loadModule(string);
                    continue;
                }
                if (c == 'P') {
                    if (module == null) {
                        bl4 = true;
                        break;
                    }
                    package_ = javacState.prev.loadPackage(module, string);
                    continue;
                }
                if (c == 'D') {
                    if (module == null || package_ == null) {
                        bl4 = true;
                        break;
                    }
                    n = string.charAt(2);
                    if (n != 83 && n != 67) {
                        throw new RuntimeException("Bad dependency string: " + string);
                    }
                    package_.parseAndAddDependency(string.substring(4), n == 67);
                    continue;
                }
                if (c == 'I') {
                    if (module == null || package_ == null) {
                        bl4 = true;
                        break;
                    }
                    package_.getPubApi().appendItem(string.substring(2));
                    continue;
                }
                if (c == 'A') {
                    if (module == null || package_ == null) {
                        bl4 = true;
                        break;
                    }
                    package_.loadArtifact(string);
                    continue;
                }
                if (c == 'S') {
                    if (module == null || package_ == null) {
                        bl4 = true;
                        break;
                    }
                    source2 = javacState.prev.loadSource(package_, string, false);
                    continue;
                }
                if (c == 'G') {
                    if (module == null || package_ == null) {
                        bl4 = true;
                        break;
                    }
                    source2 = javacState.prev.loadSource(package_, string, true);
                    continue;
                }
                if (c == 'R') {
                    String string2 = "R " + javacState.theArgs;
                    if (string.equals(string2)) continue;
                    bl3 = true;
                    continue;
                }
                if (c != '#' || !string.startsWith("# javac_state ver ") || (n = string.indexOf(" ", 18)) == -1) continue;
                String string3 = string.substring(18, n);
                if (!string3.equals("0.4")) {
                    break;
                }
                bl2 = true;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            bl = true;
        }
        catch (IOException iOException) {
            Log.warn("Dropping old javac_state because of errors when reading it.");
            javacState = new JavacState(options, true);
            bl2 = true;
            bl3 = false;
            bl4 = false;
        }
        if (!bl2 && !bl) {
            Log.debug("Dropping old javac_state since it is of an old version.");
            javacState = new JavacState(options, true);
        } else if (bl3 && !bl) {
            Log.debug("Dropping old javac_state since a new command line is used!");
            javacState = new JavacState(options, true);
        } else if (bl4) {
            Log.warn("Dropping old javac_state since it contains syntax errors.");
            javacState = new JavacState(options, true);
        }
        javacState.prev.calculateDependents();
        return javacState;
    }

    public void taintPackage(String string, String string2) {
        if (!this.taintedPackages.contains(string)) {
            if (string2 != null) {
                Log.debug("Tainting " + Util.justPackageName(string) + " because " + string2);
            }
            this.taintedPackages.add(string);
            this.needsSaving();
            Package package_ = this.now.packages().get(string);
            if (package_ != null) {
                for (String string3 : package_.dependents()) {
                    this.taintPackage(string3, string2);
                }
            }
        }
    }

    public Set<String> taintedPackages() {
        return this.taintedPackages;
    }

    public void clearTaintedPackages() {
        this.taintedPackages = new HashSet<String>();
    }

    public void checkSourceStatus(boolean bl) {
        this.removedSources = this.calculateRemovedSources();
        for (Source source2 : this.removedSources) {
            if (source2.isGenerated() && !bl) continue;
            this.taintPackage(source2.pkg().name(), "source " + source2.name() + " was removed");
        }
        this.addedSources = this.calculateAddedSources();
        for (Source source2 : this.addedSources) {
            String string = null;
            if (this.isIncremental()) {
                string = "source " + source2.name() + " was added";
            }
            if (source2.isGenerated() && !bl) continue;
            this.taintPackage(source2.pkg().name(), string);
        }
        this.modifiedSources = this.calculateModifiedSources();
        for (Source source2 : this.modifiedSources) {
            if (source2.isGenerated() && !bl) continue;
            this.taintPackage(source2.pkg().name(), "source " + source2.name() + " was modified");
        }
    }

    public Map<String, Transformer> getJavaSuffixRule() {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        hashMap.put(".java", this.compileJavaPackages);
        return hashMap;
    }

    public void taintPackagesThatMissArtifacts() {
        for (Package package_ : this.prev.packages().values()) {
            for (File file : package_.artifacts().values()) {
                if (file.exists()) continue;
                this.taintPackage(package_.name(), "" + file + " is missing.");
            }
        }
    }

    public void taintPackagesDependingOnChangedPackages(Set<String> set, Set<String> set2) {
        for (Package package_ : new HashSet<Package>(this.prev.packages().values())) {
            Set set3 = package_.typeDependencies().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            for (String string : set3) {
                String string2 = ":" + string.substring(0, string.lastIndexOf(46));
                if (string2.equals(package_.name()) || !set.contains(string2) || set2.contains(package_.name())) continue;
                this.taintPackage(package_.name(), "its depending on " + string2);
            }
        }
    }

    public void taintPackagesDependingOnChangedClasspathPackages() throws IOException {
        HashSet hashSet = new HashSet();
        for (Package object2 : this.prev.packages().values()) {
            if (object2.sources().isEmpty()) continue;
            object2.typeClasspathDependencies().values().forEach(hashSet::addAll);
        }
        PubApiExtractor pubApiExtractor = new PubApiExtractor(this.options);
        HashMap<String, PubApi> hashMap = new HashMap<String, PubApi>();
        for (String string : hashSet) {
            hashMap.put(string, pubApiExtractor.getPubApi(string));
        }
        pubApiExtractor.close();
        block2: for (Package package_ : this.prev.packages().values()) {
            if (package_.sources().isEmpty()) continue;
            HashSet<String> hashSet2 = new HashSet<String>();
            for (Set<String> set : package_.typeClasspathDependencies().values()) {
                hashSet2.addAll(set);
            }
            for (String string : hashSet2) {
                String string2 = ":" + string.substring(0, string.lastIndexOf(46));
                PubApi pubApi = this.prev.packages().get(string2).getPubApi();
                PubApi pubApi2 = ((PubApi)hashMap.get((Object)string)).types.get((Object)string).pubApi;
                PubApi pubApi3 = pubApi.types.get((Object)string).pubApi;
                if (pubApi2.isBackwardCompatibleWith(pubApi3)) continue;
                List<String> list = pubApi2.diff(pubApi3);
                this.taintPackage(package_.name(), "depends on classpath package which has an updated package api: " + String.join((CharSequence)"\n", list));
                continue block2;
            }
        }
    }

    public void removeUnidentifiedArtifacts() {
        HashSet<File> hashSet = new HashSet<File>();
        for (Package comparable : this.prev.packages().values()) {
            for (File file : comparable.artifacts().values()) {
                hashSet.add(file);
            }
        }
        hashSet.add(this.javacState);
        for (File file : this.binArtifacts) {
            if (hashSet.contains(file) || this.options.isUnidentifiedArtifactPermitted(file.getAbsolutePath())) continue;
            Log.debug("Removing " + file.getPath() + " since it is unknown to the javac_state.");
            file.delete();
        }
        for (File file : this.headerArtifacts) {
            if (hashSet.contains(file)) continue;
            Log.debug("Removing " + file.getPath() + " since it is unknown to the javac_state.");
            file.delete();
        }
        for (File file : this.gensrcArtifacts) {
            if (hashSet.contains(file)) continue;
            Log.debug("Removing " + file.getPath() + " since it is unknown to the javac_state.");
            file.delete();
        }
    }

    public void removeSuperfluousArtifacts(Set<String> set) {
        if (set.size() == 0) {
            return;
        }
        for (String string : this.now.packages().keySet()) {
            if (!set.contains(string)) continue;
            Collection<File> collection = this.now.artifacts().values();
            for (File file : this.fetchPrevArtifacts(string).values()) {
                if (collection.contains(file)) continue;
                Log.debug("Removing " + file.getPath() + " since it is now superfluous!");
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    private Set<Source> calculateRemovedSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        for (String string : this.prev.sources().keySet()) {
            if (this.now.sources().get(string) != null) continue;
            hashSet.add(this.prev.sources().get(string));
        }
        return hashSet;
    }

    private Set<Source> calculateAddedSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        for (String string : this.now.sources().keySet()) {
            if (this.prev.sources().get(string) != null) continue;
            hashSet.add(this.now.sources().get(string));
        }
        return hashSet;
    }

    private Set<Source> calculateModifiedSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        for (String string : this.now.sources().keySet()) {
            Source source2 = this.now.sources().get(string);
            Source source3 = this.prev.sources().get(string);
            if (this.prev.sources().get(string) == null || source3 == null) continue;
            if (source2.lastModified() > source3.lastModified()) {
                hashSet.add(source2);
                continue;
            }
            if (source2.lastModified() >= source3.lastModified()) continue;
            hashSet.add(source2);
            Log.warn("The source file " + source2.name() + " timestamp has moved backwards in time.");
        }
        return hashSet;
    }

    private void deleteContents(File file) {
        if (file != null && file.exists()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    this.deleteContents(file2);
                }
                if (this.options.isUnidentifiedArtifactPermitted(file2.getAbsolutePath())) continue;
                Log.debug("Removing " + file2.getAbsolutePath());
                file2.delete();
            }
        }
    }

    public void performCopying(File file, Map<String, Transformer> map) {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        for (Map.Entry<String, Transformer> entry : map.entrySet()) {
            if (!entry.getValue().getClass().equals(CopyFile.class)) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.perform(null, file, hashMap);
    }

    public void performTranslation(File file, Map<String, Transformer> map) {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        for (Map.Entry<String, Transformer> entry : map.entrySet()) {
            Class<?> clazz = entry.getValue().getClass();
            if (clazz == CompileJavaPackages.class || clazz == CopyFile.class) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.perform(null, file, hashMap);
    }

    public boolean performJavaCompilations(CompilationService compilationService, Options options, Set<String> set, boolean[] blArray) {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        hashMap.put(".java", this.compileJavaPackages);
        this.compileJavaPackages.setExtra(options);
        blArray[0] = this.perform(compilationService, this.binDir, hashMap);
        set.addAll(this.taintedPackages());
        this.clearTaintedPackages();
        boolean bl = !this.packagesWithChangedPublicApis.isEmpty();
        this.taintPackagesDependingOnChangedPackages(this.packagesWithChangedPublicApis, set);
        this.packagesWithChangedPublicApis = new HashSet<String>();
        return bl && blArray[0];
    }

    private void addFileToTransform(Map<Transformer, Map<String, Set<URI>>> map, Transformer transformer, Source source2) {
        Set<URI> set;
        Map<String, Set<URI>> map2 = map.get(transformer);
        if (map2 == null) {
            map2 = new HashMap<String, Set<URI>>();
            map.put(transformer, map2);
        }
        if ((set = map2.get(source2.pkg().name())) == null) {
            set = new HashSet<URI>();
            map2.put(source2.pkg().name(), set);
        }
        set.add(source2.file().toURI());
    }

    private boolean perform(CompilationService compilationService, File file, Map<String, Transformer> map) {
        Transformer transformer;
        boolean bl = true;
        HashMap<Transformer, Map<String, Set<URI>>> hashMap = new HashMap<Transformer, Map<String, Set<URI>>>();
        for (Source object : this.now.sources().values()) {
            transformer = map.get(object.suffix());
            if (transformer == null || !this.taintedPackages.contains(object.pkg().name()) || object.isLinkedOnly()) continue;
            this.addFileToTransform(hashMap, transformer, object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object;
            Comparable<Package> comparable;
            Object object2;
            Object object3;
            transformer = (Transformer)entry.getKey();
            Map map2 = (Map)entry.getValue();
            Map<String, Set<URI>> map3 = Collections.synchronizedMap(new HashMap());
            Map<String, Map<String, Set<String>>> map4 = Collections.synchronizedMap(new HashMap());
            Map<String, Map<String, Set<String>>> map5 = Collections.synchronizedMap(new HashMap());
            Map<String, PubApi> map6 = Collections.synchronizedMap(new HashMap());
            Map<String, PubApi> map7 = Collections.synchronizedMap(new HashMap());
            boolean bl2 = transformer.transform(compilationService, map2, this.visibleSrcs, this.prev.dependents(), file.toURI(), map3, map4, map5, map6, map7, 0, this.isIncremental(), this.numCores);
            if (!bl2) {
                bl = false;
            }
            for (String string : map2.keySet()) {
                this.recompiledPackages.add(string);
            }
            for (Map.Entry entry2 : map3.entrySet()) {
                object3 = this.now.findModuleFromPackageName((String)entry2.getKey());
                ((Module)object3).addArtifacts((String)entry2.getKey(), (Set)entry2.getValue());
            }
            for (Map.Entry entry3 : map4.entrySet()) {
                object3 = (Map)entry3.getValue();
                object2 = this.now.findModuleFromPackageName((String)entry3.getKey());
                ((Module)object2).setDependencies((String)entry3.getKey(), (Map<String, Set<String>>)object3, false);
            }
            for (Map.Entry entry4 : map5.entrySet()) {
                object3 = (Map)entry4.getValue();
                object2 = this.now.findModuleFromPackageName((String)entry4.getKey());
                ((Module)object2).setDependencies((String)entry4.getKey(), (Map<String, Set<String>>)object3, true);
            }
            for (Map.Entry entry5 : map7.entrySet()) {
                object3 = (String)entry5.getKey();
                object2 = (PubApi)entry5.getValue();
                comparable = this.now.findModuleFromPackageName((String)object3).lookupPackage((String)object3);
                object = ((Package)comparable).getPubApi();
                PubApi pubApi = PubApi.mergeTypes((PubApi)object, (PubApi)object2);
                ((Package)comparable).setPubapi(pubApi);
                if (this.now.packages().containsKey(object3)) {
                    this.now.packages().get(object3).setPubapi(pubApi);
                    continue;
                }
                this.now.packages().put((String)object3, (Package)comparable);
            }
            for (Map.Entry entry6 : map6.entrySet()) {
                object3 = (String)entry6.getKey();
                object2 = (PubApi)entry6.getValue();
                comparable = this.prev.findModuleFromPackageName((String)object3);
                object = this.now.findModuleFromPackageName((String)object3);
                ((Module)object).setPubapi((String)object3, (PubApi)object2);
                if (!((Module)comparable).hasPubapiChanged((String)object3, (PubApi)object2) || !((Module)comparable).lookupPackage((String)object3).existsInJavacState()) continue;
                this.packagesWithChangedPublicApis.add((String)object3);
                Log.debug("The API of " + Util.justPackageName((String)object3) + " has changed!");
            }
        }
        return bl;
    }

    private static Set<File> findAllFiles(File file) {
        HashSet<File> hashSet = new HashSet<File>();
        if (file == null) {
            return hashSet;
        }
        JavacState.recurse(file, hashSet);
        return hashSet;
    }

    private static void recurse(File file, Set<File> set) {
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                set.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            JavacState.recurse(file2, set);
        }
    }

    public void compareWithMakefileList(File file) throws ProblemException {
        String string;
        boolean bl;
        boolean bl2 = bl = File.pathSeparatorChar == ';';
        if (file == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Source object : this.now.sources().values()) {
            if (object.isLinkedOnly()) continue;
            string = object.file().getPath();
            if (bl) {
                string = Util.normalizeDriveLetter(string);
            }
            hashSet.add(string);
        }
        try {
            Throwable throwable = null;
            try (Iterator iterator2 = new BufferedReader(new FileReader(file));){
                while ((string = ((BufferedReader)((Object)iterator2)).readLine()) != null) {
                    string = string.trim();
                    if (bl) {
                        if (string.indexOf(":") != 1 || string.indexOf("\\") != 2) {
                            if (string.indexOf(":") == 1 && string.indexOf("/") == 2) {
                                string = string.replaceAll("/", "\\\\");
                            } else if (string.charAt(0) == '/' && string.indexOf("/", 1) != -1) {
                                int n = string.indexOf("/", 1);
                                string = string.replaceAll("/", "\\\\");
                                string = "" + string.charAt(n + 1) + ":" + string.substring(n + 2);
                            }
                        }
                        if (Character.isLowerCase(string.charAt(0))) {
                            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                        }
                    }
                    hashSet2.add(string);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            throw new ProblemException("Could not open " + file.getPath() + " since it does not exist!");
        }
        catch (IOException iOException) {
            throw new ProblemException("Could not read " + file.getPath());
        }
        for (String string2 : hashSet2) {
            if (hashSet.contains(string2)) continue;
            throw new ProblemException("The makefile listed source " + string2 + " was not calculated by the smart javac wrapper!");
        }
        for (String string3 : hashSet) {
            if (hashSet2.contains(string3)) continue;
            throw new ProblemException("The smart javac wrapper calculated source " + string3 + " was not listed by the makefiles!");
        }
    }
}

