/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Gen;
import com.sun.tools.javah.TypeSignature;
import com.sun.tools.javah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class JNI
extends Gen {
    JNI(Util util) {
        super(util);
    }

    @Override
    public String getIncludes() {
        return "#include <jni.h>";
    }

    @Override
    public void write(OutputStream outputStream2, TypeElement typeElement) throws Util.Exit {
        try {
            Object object;
            String string = this.mangler.mangle(typeElement.getQualifiedName(), 1);
            PrintWriter printWriter = this.wrapWriter(outputStream2);
            printWriter.println(this.guardBegin(string));
            printWriter.println(this.cppGuardBegin());
            List<VariableElement> list = this.getAllFields(typeElement);
            for (VariableElement object22 : list) {
                if (!object22.getModifiers().contains((Object)Modifier.STATIC)) continue;
                object = null;
                object = this.defineForStatic(typeElement, object22);
                if (object == null) continue;
                printWriter.println((String)object);
            }
            List<ExecutableElement> list2 = ElementFilter.methodsIn(typeElement.getEnclosedElements());
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                AnnotatedConstruct annotatedConstruct;
                Object object2;
                object = (ExecutableElement)iterator2.next();
                if (!object.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                TypeMirror typeMirror = this.types.erasure(object.getReturnType());
                String string2 = this.signature((ExecutableElement)object);
                TypeSignature typeSignature = new TypeSignature(this.elems);
                Name name = object.getSimpleName();
                boolean bl = false;
                Object object3 = list2.iterator();
                while (object3.hasNext()) {
                    object2 = (ExecutableElement)object3.next();
                    if (object2 == object || !((Object)name).equals(object2.getSimpleName()) || !object2.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                    bl = true;
                }
                printWriter.println("/*");
                printWriter.println(" * Class:     " + string);
                printWriter.println(" * Method:    " + this.mangler.mangle(name, 2));
                printWriter.println(" * Signature: " + typeSignature.getTypeSignature(string2, typeMirror));
                printWriter.println(" */");
                printWriter.println("JNIEXPORT " + this.jniType(typeMirror) + " JNICALL " + this.mangler.mangleMethod((ExecutableElement)object, typeElement, bl ? 8 : 7));
                printWriter.print("  (JNIEnv *, ");
                object3 = object.getParameters();
                object2 = new ArrayList();
                Iterator iterator3 = object3.iterator();
                while (iterator3.hasNext()) {
                    annotatedConstruct = (VariableElement)iterator3.next();
                    object2.add(this.types.erasure(annotatedConstruct.asType()));
                }
                if (object.getModifiers().contains((Object)Modifier.STATIC)) {
                    printWriter.print("jclass");
                } else {
                    printWriter.print("jobject");
                }
                iterator3 = object2.iterator();
                while (iterator3.hasNext()) {
                    annotatedConstruct = (TypeMirror)iterator3.next();
                    printWriter.print(", ");
                    printWriter.print(this.jniType((TypeMirror)annotatedConstruct));
                }
                printWriter.println(");" + this.lineSep);
            }
            printWriter.println(this.cppGuardEnd());
            printWriter.println(this.guardEnd(string));
        }
        catch (TypeSignature.SignatureException signatureException) {
            this.util.error("jni.sigerror", signatureException.getMessage());
        }
    }

    protected final String jniType(TypeMirror typeMirror) throws Util.Exit {
        TypeElement typeElement = this.elems.getTypeElement("java.lang.Throwable");
        TypeElement typeElement2 = this.elems.getTypeElement("java.lang.Class");
        TypeElement typeElement3 = this.elems.getTypeElement("java.lang.String");
        Element element = this.types.asElement(typeMirror);
        switch (typeMirror.getKind()) {
            case ARRAY: {
                TypeMirror typeMirror2 = ((ArrayType)typeMirror).getComponentType();
                switch (typeMirror2.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(typeMirror2.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (element.equals(typeElement3)) {
                    return "jstring";
                }
                if (this.types.isAssignable(typeMirror, typeElement.asType())) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(typeMirror, typeElement2.asType())) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        this.util.bug("jni.unknown.type");
        return null;
    }
}

