/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Printer;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ForwardingDiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class RichDiagnosticFormatter
extends ForwardingDiagnosticFormatter<JCDiagnostic, AbstractDiagnosticFormatter> {
    final Symtab syms;
    final Types types;
    final JCDiagnostic.Factory diags;
    final JavacMessages messages;
    protected ClassNameSimplifier nameSimplifier;
    private RichPrinter printer;
    Map<WhereClauseKind, Map<Type, JCDiagnostic>> whereClauses;
    protected Types.UnaryVisitor<Void> typePreprocessor = new Types.UnaryVisitor<Void>(){

        public Void visit(List<Type> list) {
            for (Type type : list) {
                this.visit(type);
            }
            return null;
        }

        @Override
        public Void visitForAll(Type.ForAll forAll, Void void_) {
            this.visit(forAll.tvars);
            this.visit(forAll.qtype);
            return null;
        }

        @Override
        public Void visitMethodType(Type.MethodType methodType, Void void_) {
            this.visit(methodType.argtypes);
            this.visit(methodType.restype);
            return null;
        }

        @Override
        public Void visitErrorType(Type.ErrorType errorType, Void void_) {
            Type type = errorType.getOriginalType();
            if (type != null) {
                this.visit(type);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType arrayType, Void void_) {
            this.visit(arrayType.elemtype);
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            this.visit(wildcardType.type);
            return null;
        }

        @Override
        public Void visitType(Type type, Void void_) {
            return null;
        }

        @Override
        public Void visitCapturedType(Type.CapturedType capturedType, Void void_) {
            if (RichDiagnosticFormatter.this.indexOf(capturedType, WhereClauseKind.CAPTURED) == -1) {
                String string = capturedType.lower == RichDiagnosticFormatter.this.syms.botType ? ".1" : "";
                JCDiagnostic jCDiagnostic = RichDiagnosticFormatter.this.diags.fragment("where.captured" + string, capturedType, capturedType.bound, capturedType.lower, capturedType.wildcard);
                RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.CAPTURED).put(capturedType, jCDiagnostic);
                this.visit(capturedType.wildcard);
                this.visit(capturedType.lower);
                this.visit(capturedType.bound);
            }
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType classType, Void void_) {
            Type.ClassType classType2;
            if (classType.isCompound()) {
                if (RichDiagnosticFormatter.this.indexOf(classType, WhereClauseKind.INTERSECTION) == -1) {
                    Type type = RichDiagnosticFormatter.this.types.supertype(classType);
                    List<Type> list = RichDiagnosticFormatter.this.types.interfaces(classType);
                    JCDiagnostic jCDiagnostic = RichDiagnosticFormatter.this.diags.fragment("where.intersection", classType, list.prepend(type));
                    RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.INTERSECTION).put(classType, jCDiagnostic);
                    this.visit(type);
                    this.visit(list);
                }
            } else if (classType.tsym.name.isEmpty() && (classType2 = (Type.ClassType)classType.tsym.type) != null) {
                if (classType2.interfaces_field != null && classType2.interfaces_field.nonEmpty()) {
                    this.visit((Type)classType2.interfaces_field.head);
                } else {
                    this.visit(classType2.supertype_field);
                }
            }
            RichDiagnosticFormatter.this.nameSimplifier.addUsage(classType.tsym);
            this.visit((List<Type>)classType.getTypeArguments());
            if (classType.getEnclosingType() != Type.noType) {
                this.visit(classType.getEnclosingType());
            }
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar typeVar, Void void_) {
            if (RichDiagnosticFormatter.this.indexOf(typeVar = (Type.TypeVar)typeVar.stripMetadataIfNeeded(), WhereClauseKind.TYPEVAR) == -1) {
                boolean bl;
                Type type = typeVar.bound;
                while (type instanceof Type.ErrorType) {
                    type = ((Type.ErrorType)type).getOriginalType();
                }
                List<Type> list = type != null && (type.hasTag(TypeTag.CLASS) || type.hasTag(TypeTag.TYPEVAR)) ? RichDiagnosticFormatter.this.types.getBounds(typeVar) : List.nil();
                RichDiagnosticFormatter.this.nameSimplifier.addUsage(typeVar.tsym);
                boolean bl2 = bl = list.head == null || ((Type)list.head).hasTag(TypeTag.NONE) || ((Type)list.head).hasTag(TypeTag.ERROR);
                if ((typeVar.tsym.flags() & 0x1000L) == 0L) {
                    JCDiagnostic jCDiagnostic = RichDiagnosticFormatter.this.diags.fragment("where.typevar" + (bl ? ".1" : ""), typeVar, list, Kinds.kindName(typeVar.tsym.location()), typeVar.tsym.location());
                    RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.TYPEVAR).put(typeVar, jCDiagnostic);
                    RichDiagnosticFormatter.this.symbolPreprocessor.visit(typeVar.tsym.location(), null);
                    this.visit(list);
                } else {
                    Assert.check(!bl);
                    JCDiagnostic jCDiagnostic = RichDiagnosticFormatter.this.diags.fragment("where.fresh.typevar", typeVar, list);
                    RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.TYPEVAR).put(typeVar, jCDiagnostic);
                    this.visit(list);
                }
            }
            return null;
        }
    };
    protected Types.DefaultSymbolVisitor<Void, Void> symbolPreprocessor = new Types.DefaultSymbolVisitor<Void, Void>(){

        @Override
        public Void visitClassSymbol(Symbol.ClassSymbol classSymbol, Void void_) {
            if (classSymbol.type.isCompound()) {
                RichDiagnosticFormatter.this.typePreprocessor.visit(classSymbol.type);
            } else {
                RichDiagnosticFormatter.this.nameSimplifier.addUsage(classSymbol);
            }
            return null;
        }

        @Override
        public Void visitSymbol(Symbol symbol, Void void_) {
            return null;
        }

        @Override
        public Void visitMethodSymbol(Symbol.MethodSymbol methodSymbol, Void void_) {
            this.visit(methodSymbol.owner, null);
            if (methodSymbol.type != null) {
                RichDiagnosticFormatter.this.typePreprocessor.visit(methodSymbol.type);
            }
            return null;
        }
    };

    public static RichDiagnosticFormatter instance(Context context) {
        RichDiagnosticFormatter richDiagnosticFormatter = context.get(RichDiagnosticFormatter.class);
        if (richDiagnosticFormatter == null) {
            richDiagnosticFormatter = new RichDiagnosticFormatter(context);
        }
        return richDiagnosticFormatter;
    }

    protected RichDiagnosticFormatter(Context context) {
        super((AbstractDiagnosticFormatter)Log.instance(context).getDiagnosticFormatter());
        this.setRichPrinter(new RichPrinter());
        this.syms = Symtab.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.types = Types.instance(context);
        this.messages = JavacMessages.instance(context);
        this.whereClauses = new EnumMap<WhereClauseKind, Map<Type, JCDiagnostic>>(WhereClauseKind.class);
        this.configuration = new RichConfiguration(Options.instance(context), (AbstractDiagnosticFormatter)this.formatter);
        for (WhereClauseKind whereClauseKind : WhereClauseKind.values()) {
            this.whereClauses.put(whereClauseKind, new LinkedHashMap());
        }
    }

    @Override
    public String format(JCDiagnostic jCDiagnostic, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        this.nameSimplifier = new ClassNameSimplifier();
        for (Object object : WhereClauseKind.values()) {
            this.whereClauses.get(object).clear();
        }
        this.preprocessDiagnostic(jCDiagnostic);
        stringBuilder.append(((AbstractDiagnosticFormatter)this.formatter).format(jCDiagnostic, locale));
        if (this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.WHERE_CLAUSES)) {
            List<JCDiagnostic> list = this.getWhereClauses();
            String string = ((AbstractDiagnosticFormatter)this.formatter).isRaw() ? "" : ((AbstractDiagnosticFormatter)this.formatter).indentString(2);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object object;
                object = (JCDiagnostic)iterator2.next();
                String string2 = ((AbstractDiagnosticFormatter)this.formatter).format((JCDiagnostic)object, locale);
                if (string2.length() <= 0) continue;
                stringBuilder.append('\n' + string + string2);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String formatMessage(JCDiagnostic jCDiagnostic, Locale locale) {
        this.nameSimplifier = new ClassNameSimplifier();
        this.preprocessDiagnostic(jCDiagnostic);
        return super.formatMessage(jCDiagnostic, locale);
    }

    protected void setRichPrinter(RichPrinter richPrinter) {
        this.printer = richPrinter;
        ((AbstractDiagnosticFormatter)this.formatter).setPrinter(richPrinter);
    }

    protected RichPrinter getRichPrinter() {
        return this.printer;
    }

    protected void preprocessDiagnostic(JCDiagnostic jCDiagnostic) {
        for (Object object : jCDiagnostic.getArgs()) {
            if (object == null) continue;
            this.preprocessArgument(object);
        }
        if (jCDiagnostic.isMultiline()) {
            for (JCDiagnostic jCDiagnostic2 : jCDiagnostic.getSubdiagnostics()) {
                this.preprocessDiagnostic(jCDiagnostic2);
            }
        }
    }

    protected void preprocessArgument(Object object) {
        if (object instanceof Type) {
            this.preprocessType((Type)object);
        } else if (object instanceof Symbol) {
            this.preprocessSymbol((Symbol)object);
        } else if (object instanceof JCDiagnostic) {
            this.preprocessDiagnostic((JCDiagnostic)object);
        } else if (object instanceof Iterable && !(object instanceof Path)) {
            for (Object t : (Iterable)object) {
                this.preprocessArgument(t);
            }
        }
    }

    protected List<JCDiagnostic> getWhereClauses() {
        List<JCDiagnostic.MultilineDiagnostic> list = List.nil();
        for (WhereClauseKind whereClauseKind : WhereClauseKind.values()) {
            List<Object> list2 = List.nil();
            for (Map.Entry<Type, JCDiagnostic> entry : this.whereClauses.get((Object)whereClauseKind).entrySet()) {
                list2 = list2.prepend(entry.getValue());
            }
            if (list2.isEmpty()) continue;
            Object object3 = whereClauseKind.key();
            if (list2.size() > 1) {
                object3 = (String)object3 + ".1";
            }
            JCDiagnostic jCDiagnostic = this.diags.fragment((String)object3, this.whereClauses.get((Object)whereClauseKind).keySet());
            JCDiagnostic.MultilineDiagnostic multilineDiagnostic = new JCDiagnostic.MultilineDiagnostic(jCDiagnostic, list2.reverse());
            list = list.prepend(multilineDiagnostic);
        }
        return list.reverse();
    }

    private int indexOf(Type type, WhereClauseKind whereClauseKind) {
        int n = 1;
        for (Type type2 : this.whereClauses.get((Object)whereClauseKind).keySet()) {
            if (type2.tsym == type.tsym) {
                return n;
            }
            if (whereClauseKind == WhereClauseKind.TYPEVAR && !type2.toString().equals(type.toString())) continue;
            ++n;
        }
        return -1;
    }

    private boolean unique(Type.TypeVar typeVar) {
        typeVar = (Type.TypeVar)typeVar.stripMetadata();
        int n = 0;
        for (Type type : this.whereClauses.get((Object)WhereClauseKind.TYPEVAR).keySet()) {
            if (!type.stripMetadata().toString().equals(typeVar.toString())) continue;
            ++n;
        }
        if (n < 1) {
            throw new AssertionError((Object)("Missing type variable in where clause: " + typeVar));
        }
        return n == 1;
    }

    protected void preprocessType(Type type) {
        this.typePreprocessor.visit(type);
    }

    protected void preprocessSymbol(Symbol symbol) {
        this.symbolPreprocessor.visit(symbol, null);
    }

    @Override
    public RichConfiguration getConfiguration() {
        return (RichConfiguration)this.configuration;
    }

    public static class RichConfiguration
    extends ForwardingDiagnosticFormatter.ForwardingConfiguration {
        protected EnumSet<RichFormatterFeature> features;

        public RichConfiguration(Options options, AbstractDiagnosticFormatter abstractDiagnosticFormatter) {
            super(abstractDiagnosticFormatter.getConfiguration());
            this.features = abstractDiagnosticFormatter.isRaw() ? EnumSet.noneOf(RichFormatterFeature.class) : EnumSet.of(RichFormatterFeature.SIMPLE_NAMES, RichFormatterFeature.WHERE_CLAUSES, RichFormatterFeature.UNIQUE_TYPEVAR_NAMES);
            String string = options.get("diags.formatterOptions");
            if (string != null) {
                for (String string2 : string.split(",")) {
                    if (string2.equals("-where")) {
                        this.features.remove((Object)RichFormatterFeature.WHERE_CLAUSES);
                    } else if (string2.equals("where")) {
                        this.features.add(RichFormatterFeature.WHERE_CLAUSES);
                    }
                    if (string2.equals("-simpleNames")) {
                        this.features.remove((Object)RichFormatterFeature.SIMPLE_NAMES);
                    } else if (string2.equals("simpleNames")) {
                        this.features.add(RichFormatterFeature.SIMPLE_NAMES);
                    }
                    if (string2.equals("-disambiguateTvars")) {
                        this.features.remove((Object)RichFormatterFeature.UNIQUE_TYPEVAR_NAMES);
                        continue;
                    }
                    if (!string2.equals("disambiguateTvars")) continue;
                    this.features.add(RichFormatterFeature.UNIQUE_TYPEVAR_NAMES);
                }
            }
        }

        public RichFormatterFeature[] getAvailableFeatures() {
            return RichFormatterFeature.values();
        }

        public void enable(RichFormatterFeature richFormatterFeature) {
            this.features.add(richFormatterFeature);
        }

        public void disable(RichFormatterFeature richFormatterFeature) {
            this.features.remove((Object)richFormatterFeature);
        }

        public boolean isEnabled(RichFormatterFeature richFormatterFeature) {
            return this.features.contains((Object)richFormatterFeature);
        }

        public static enum RichFormatterFeature {
            WHERE_CLAUSES,
            SIMPLE_NAMES,
            UNIQUE_TYPEVAR_NAMES;

        }
    }

    protected class RichPrinter
    extends Printer {
        protected RichPrinter() {
        }

        @Override
        public String localize(Locale locale, String string, Object ... objectArray) {
            return ((AbstractDiagnosticFormatter)RichDiagnosticFormatter.this.formatter).localize(locale, string, objectArray);
        }

        @Override
        public String capturedVarId(Type.CapturedType capturedType, Locale locale) {
            return RichDiagnosticFormatter.this.indexOf(capturedType, WhereClauseKind.CAPTURED) + "";
        }

        @Override
        public String visitType(Type type, Locale locale) {
            String string = super.visitType(type, locale);
            if (type == RichDiagnosticFormatter.this.syms.botType) {
                string = this.localize(locale, "compiler.misc.type.null", new Object[0]);
            }
            return string;
        }

        @Override
        public String visitCapturedType(Type.CapturedType capturedType, Locale locale) {
            if (RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.WHERE_CLAUSES)) {
                return this.localize(locale, "compiler.misc.captured.type", RichDiagnosticFormatter.this.indexOf(capturedType, WhereClauseKind.CAPTURED));
            }
            return super.visitCapturedType(capturedType, locale);
        }

        @Override
        public String visitClassType(Type.ClassType classType, Locale locale) {
            if (classType.isCompound() && RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.WHERE_CLAUSES)) {
                return this.localize(locale, "compiler.misc.intersection.type", RichDiagnosticFormatter.this.indexOf(classType, WhereClauseKind.INTERSECTION));
            }
            return super.visitClassType(classType, locale);
        }

        @Override
        protected String className(Type.ClassType classType, boolean bl, Locale locale) {
            Symbol.TypeSymbol typeSymbol = classType.tsym;
            if (typeSymbol.name.length() == 0 || !RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.SIMPLE_NAMES)) {
                return super.className(classType, bl, locale);
            }
            if (bl) {
                return RichDiagnosticFormatter.this.nameSimplifier.simplify(typeSymbol).toString();
            }
            return typeSymbol.name.toString();
        }

        @Override
        public String visitTypeVar(Type.TypeVar typeVar, Locale locale) {
            if (RichDiagnosticFormatter.this.unique(typeVar) || !RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.UNIQUE_TYPEVAR_NAMES)) {
                return typeVar.toString();
            }
            return this.localize(locale, "compiler.misc.type.var", typeVar.toString(), RichDiagnosticFormatter.this.indexOf(typeVar, WhereClauseKind.TYPEVAR));
        }

        @Override
        public String visitClassSymbol(Symbol.ClassSymbol classSymbol, Locale locale) {
            if (classSymbol.type.isCompound()) {
                return this.visit(classSymbol.type, locale);
            }
            String string = RichDiagnosticFormatter.this.nameSimplifier.simplify(classSymbol);
            if (string.length() == 0 || !RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.SIMPLE_NAMES)) {
                return super.visitClassSymbol(classSymbol, locale);
            }
            return string;
        }

        @Override
        public String visitMethodSymbol(Symbol.MethodSymbol methodSymbol, Locale locale) {
            String string;
            String string2 = this.visit(methodSymbol.owner, locale);
            if (methodSymbol.isStaticOrInstanceInit()) {
                return string2;
            }
            String string3 = string = methodSymbol.name == methodSymbol.name.table.names.init ? string2 : methodSymbol.name.toString();
            if (methodSymbol.type != null) {
                if (methodSymbol.type.hasTag(TypeTag.FORALL)) {
                    string = "<" + this.visitTypes(methodSymbol.type.getTypeArguments(), locale) + ">" + string;
                }
                string = string + "(" + this.printMethodArgs(methodSymbol.type.getParameterTypes(), (methodSymbol.flags() & 0x400000000L) != 0L, locale) + ")";
            }
            return string;
        }
    }

    protected class ClassNameSimplifier {
        Map<Name, List<Symbol>> nameClashes = new HashMap<Name, List<Symbol>>();

        protected ClassNameSimplifier() {
        }

        protected void addUsage(Symbol symbol) {
            Name name = symbol.getSimpleName();
            List<Symbol> list = this.nameClashes.get(name);
            if (list == null) {
                list = List.nil();
            }
            if (!list.contains(symbol)) {
                this.nameClashes.put(name, list.append(symbol));
            }
        }

        public String simplify(Symbol symbol) {
            List<Symbol> list;
            String string = symbol.getQualifiedName().toString();
            if (!symbol.type.isCompound() && !symbol.type.isPrimitive() && ((list = this.nameClashes.get(symbol.getSimpleName())) == null || list.size() == 1 && list.contains(symbol))) {
                List<Object> list2 = List.nil();
                Symbol symbol2 = symbol;
                while (symbol2.type.hasTag(TypeTag.CLASS) && symbol2.type.getEnclosingType().hasTag(TypeTag.CLASS) && symbol2.owner.kind == Kinds.Kind.TYP) {
                    list2 = list2.prepend(symbol2.getSimpleName());
                    symbol2 = symbol2.owner;
                }
                list2 = list2.prepend(symbol2.getSimpleName());
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = "";
                for (Name name : list2) {
                    stringBuilder.append(string2);
                    stringBuilder.append(name);
                    string2 = ".";
                }
                string = stringBuilder.toString();
            }
            return string;
        }
    }

    static enum WhereClauseKind {
        TYPEVAR("where.description.typevar"),
        CAPTURED("where.description.captured"),
        INTERSECTION("where.description.intersection");

        private final String key;

        private WhereClauseKind(String string2) {
            this.key = string2;
        }

        String key() {
            return this.key;
        }
    }
}

