/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final DiagnosticInfo diagnosticInfo;
    private final Set<DiagnosticFlag> flags;
    private final Lint.LintCategory lintCategory;
    private SourcePosition sourcePosition;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String string, Object ... objectArray) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticInfo.of(DiagnosticType.FRAGMENT, "compiler", string, objectArray), null, EnumSet.noneOf(DiagnosticFlag.class), null, null);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter, DiagnosticInfo diagnosticInfo, Lint.LintCategory lintCategory, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition) {
        if (diagnosticSource == null && diagnosticPosition != null && diagnosticPosition.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = diagnosticFormatter;
        this.diagnosticInfo = diagnosticInfo;
        this.lintCategory = lintCategory;
        this.flags = set;
        this.source = diagnosticSource;
        this.position = diagnosticPosition;
    }

    public DiagnosticType getType() {
        return this.diagnosticInfo.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.flags.contains((Object)DiagnosticFlag.MANDATORY);
    }

    public boolean hasLintCategory() {
        return this.lintCategory != null;
    }

    public Lint.LintCategory getLintCategory() {
        return this.lintCategory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public DiagnosticPosition getDiagnosticPosition() {
        return this.position;
    }

    @Override
    public long getLineNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getColumnNumber();
    }

    public Object[] getArgs() {
        return this.diagnosticInfo.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.diagnosticInfo.type);
    }

    public String getPrefix(DiagnosticType diagnosticType) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.diagnosticInfo.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.flags.contains((Object)DiagnosticFlag.MANDATORY) ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.diagnosticInfo.key();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public void setFlag(DiagnosticFlag diagnosticFlag) {
        this.flags.add(diagnosticFlag);
        if (this.diagnosticInfo.type == DiagnosticType.ERROR) {
            switch (diagnosticFlag) {
                case SYNTAX: {
                    this.flags.remove((Object)DiagnosticFlag.RECOVERABLE);
                    break;
                }
                case RESOLVE_ERROR: {
                    this.flags.add(DiagnosticFlag.RECOVERABLE);
                }
            }
        }
    }

    public boolean isFlagSet(DiagnosticFlag diagnosticFlag) {
        return this.flags.contains((Object)diagnosticFlag);
    }

    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic jCDiagnostic, List<JCDiagnostic> list) {
            super(jCDiagnostic.defaultFormatter, jCDiagnostic.diagnosticInfo, jCDiagnostic.getLintCategory(), jCDiagnostic.flags, jCDiagnostic.getDiagnosticSource(), jCDiagnostic.position);
            this.subdiagnostics = list;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    public static final class Fragment
    extends DiagnosticInfo {
        public Fragment(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.FRAGMENT, string, string2, objectArray);
        }
    }

    public static final class Note
    extends DiagnosticInfo {
        public Note(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.NOTE, string, string2, objectArray);
        }
    }

    public static final class Warning
    extends DiagnosticInfo {
        public Warning(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.WARNING, string, string2, objectArray);
        }
    }

    public static final class Error
    extends DiagnosticInfo {
        public Error(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.ERROR, string, string2, objectArray);
        }
    }

    public static abstract class DiagnosticInfo {
        DiagnosticType type;
        String prefix;
        String code;
        Object[] args;

        private DiagnosticInfo(DiagnosticType diagnosticType, String string, String string2, Object ... objectArray) {
            this.type = diagnosticType;
            this.prefix = string;
            this.code = string2;
            this.args = objectArray;
        }

        public String key() {
            return this.prefix + "." + this.type.key + "." + this.code;
        }

        public static DiagnosticInfo of(DiagnosticType diagnosticType, String string, String string2, Object ... objectArray) {
            switch (diagnosticType) {
                case ERROR: {
                    return new Error(string, string2, objectArray);
                }
                case WARNING: {
                    return new Warning(string, string2, objectArray);
                }
                case NOTE: {
                    return new Note(string, string2, objectArray);
                }
                case FRAGMENT: {
                    return new Fragment(string, string2, objectArray);
                }
            }
            Assert.error("Wrong diagnostic type: " + (Object)((Object)diagnosticType));
            return null;
        }
    }

    class SourcePosition {
        private final int line;
        private final int column;

        SourcePosition() {
            int n;
            int n2 = n = JCDiagnostic.this.position == null ? -1 : JCDiagnostic.this.position.getPreferredPosition();
            if (n == -1 || JCDiagnostic.this.source == null) {
                this.column = -1;
                this.line = -1;
            } else {
                this.line = JCDiagnostic.this.source.getLineNumber(n);
                this.column = JCDiagnostic.this.source.getColumnNumber(n, true);
            }
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    public static enum DiagnosticFlag {
        MANDATORY,
        RESOLVE_ERROR,
        SYNTAX,
        RECOVERABLE,
        NON_DEFERRABLE,
        COMPRESSED,
        MULTIPLE,
        SOURCE_LEVEL;

    }

    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int n) {
            this.pos = n;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            return this.pos;
        }
    }

    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(EndPosTable var1);
    }

    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String string2) {
            this.key = string2;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;
        final Set<DiagnosticFlag> defaultErrorFlags;

        public static Factory instance(Context context) {
            Factory factory2 = context.get(diagnosticFactoryKey);
            if (factory2 == null) {
                factory2 = new Factory(context);
            }
            return factory2;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
            Options options = Options.instance(context);
            this.initOptions(options);
            options.addListener(() -> this.initOptions(options));
        }

        private void initOptions(Options options) {
            if (options.isSet("onlySyntaxErrorsUnrecoverable")) {
                this.defaultErrorFlags.add(DiagnosticFlag.RECOVERABLE);
            }
        }

        public Factory(JavacMessages javacMessages, String string) {
            this.prefix = string;
            this.formatter = new BasicDiagnosticFormatter(javacMessages);
            this.defaultErrorFlags = EnumSet.of(DiagnosticFlag.MANDATORY);
        }

        public JCDiagnostic error(DiagnosticFlag diagnosticFlag, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.error(diagnosticFlag, diagnosticSource, diagnosticPosition, this.errorKey(string, objectArray));
        }

        public JCDiagnostic error(DiagnosticFlag diagnosticFlag, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Error error) {
            JCDiagnostic jCDiagnostic = this.create(null, EnumSet.copyOf(this.defaultErrorFlags), diagnosticSource, diagnosticPosition, error);
            if (diagnosticFlag != null) {
                jCDiagnostic.setFlag(diagnosticFlag);
            }
            return jCDiagnostic;
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.mandatoryWarning(lintCategory, diagnosticSource, diagnosticPosition, this.warningKey(string, objectArray));
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Warning warning) {
            return this.create(lintCategory, EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, diagnosticPosition, warning);
        }

        public JCDiagnostic warning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.warning(lintCategory, diagnosticSource, diagnosticPosition, this.warningKey(string, objectArray));
        }

        public JCDiagnostic warning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Warning warning) {
            return this.create(lintCategory, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, warning);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource diagnosticSource, String string, Object ... objectArray) {
            return this.mandatoryNote(diagnosticSource, this.noteKey(string, objectArray));
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource diagnosticSource, Note note) {
            return this.create(null, EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, null, note);
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.note(diagnosticSource, diagnosticPosition, this.noteKey(string, objectArray));
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Note note) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, note);
        }

        public JCDiagnostic fragment(String string, Object ... objectArray) {
            return this.fragment(this.fragmentKey(string, objectArray));
        }

        public JCDiagnostic fragment(Fragment fragment) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), null, null, fragment);
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, DiagnosticInfo.of(diagnosticType, this.prefix, string, objectArray));
        }

        public JCDiagnostic create(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, DiagnosticInfo diagnosticInfo) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, diagnosticInfo);
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, Lint.LintCategory lintCategory, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(lintCategory, set, diagnosticSource, diagnosticPosition, DiagnosticInfo.of(diagnosticType, this.prefix, string, objectArray));
        }

        public JCDiagnostic create(Lint.LintCategory lintCategory, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, DiagnosticInfo diagnosticInfo) {
            return new JCDiagnostic(this.formatter, this.normalize(diagnosticInfo), lintCategory, set, diagnosticSource, diagnosticPosition);
        }

        DiagnosticInfo normalize(DiagnosticInfo diagnosticInfo) {
            return DiagnosticInfo.of(diagnosticInfo.type, diagnosticInfo.prefix, diagnosticInfo.code, Stream.of(diagnosticInfo.args).map(object -> object instanceof Fragment ? this.fragment((Fragment)object) : object).toArray());
        }

        Error errorKey(String string, Object ... objectArray) {
            return (Error)DiagnosticInfo.of(DiagnosticType.ERROR, this.prefix, string, objectArray);
        }

        Warning warningKey(String string, Object ... objectArray) {
            return (Warning)DiagnosticInfo.of(DiagnosticType.WARNING, this.prefix, string, objectArray);
        }

        Note noteKey(String string, Object ... objectArray) {
            return (Note)DiagnosticInfo.of(DiagnosticType.NOTE, this.prefix, string, objectArray);
        }

        Fragment fragmentKey(String string, Object ... objectArray) {
            return (Fragment)DiagnosticInfo.of(DiagnosticType.FRAGMENT, this.prefix, string, objectArray);
        }
    }
}

