/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class Context {
    protected final Map<Key<?>, Object> ht = new HashMap();
    private final Map<Key<?>, Factory<?>> ft = new HashMap();
    private final Map<Class<?>, Key<?>> kt = new HashMap();

    public <T> void put(Key<T> key, Factory<T> factory2) {
        Context.checkState(this.ht);
        Factory<T> factory3 = this.ht.put(key, factory2);
        if (factory3 != null) {
            throw new AssertionError((Object)"duplicate context value");
        }
        Context.checkState(this.ft);
        this.ft.put(key, factory2);
    }

    public <T> void put(Key<T> key, T t) {
        if (t instanceof Factory) {
            throw new AssertionError((Object)"T extends Context.Factory");
        }
        Context.checkState(this.ht);
        Object object = this.ht.put(key, t);
        if (object != null && !(object instanceof Factory) && object != t && t != null) {
            throw new AssertionError((Object)"duplicate context value");
        }
    }

    public <T> T get(Key<T> key) {
        Context.checkState(this.ht);
        Object object = this.ht.get(key);
        if (object instanceof Factory) {
            Factory factory2 = (Factory)object;
            if ((object = factory2.make(this)) instanceof Factory) {
                throw new AssertionError((Object)"T extends Context.Factory");
            }
            Assert.check(this.ht.get(key) == object);
        }
        return Context.uncheckedCast(object);
    }

    protected <T> Key<T> key(Class<T> clazz) {
        Context.checkState(this.kt);
        Key key = (Key)Context.uncheckedCast(this.kt.get(clazz));
        if (key == null) {
            key = new Key();
            this.kt.put(clazz, key);
        }
        return key;
    }

    public <T> T get(Class<T> clazz) {
        return this.get(this.key(clazz));
    }

    public <T> void put(Class<T> clazz, T t) {
        this.put(this.key(clazz), t);
    }

    public <T> void put(Class<T> clazz, Factory<T> factory2) {
        this.put(this.key(clazz), (T)factory2);
    }

    private static <T> T uncheckedCast(Object object) {
        return (T)object;
    }

    public void dump() {
        for (Object object : this.ht.values()) {
            System.err.println(object == null ? null : object.getClass());
        }
    }

    private static void checkState(Map<?, ?> map) {
        if (map == null) {
            throw new IllegalStateException();
        }
    }

    public static interface Factory<T> {
        public T make(Context var1);
    }

    public static class Key<T> {
    }
}

