/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.tools.JavaFileManager;

public class Main {
    String ownName;
    PrintWriter stdOut;
    PrintWriter stdErr;
    public Log log;
    boolean apiMode;
    private static final String ENV_OPT_NAME = "JDK_JAVAC_OPTIONS";
    private JavaFileManager fileManager;
    public static final String javacBundleName = "com.sun.tools.javac.resources.javac";

    public Main(String string) {
        this.ownName = string;
    }

    public Main(String string, PrintWriter printWriter) {
        this.ownName = string;
        this.stdOut = this.stdErr = printWriter;
    }

    public Main(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        this.ownName = string;
        this.stdOut = printWriter;
        this.stdErr = printWriter2;
    }

    void error(String string, Object ... objectArray) {
        if (this.apiMode) {
            String string2 = this.log.localize(Log.PrefixKind.JAVAC, string, objectArray);
            throw new PropagatedException(new IllegalStateException(string2));
        }
        this.warning(string, objectArray);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void warning(String string, Object ... objectArray) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, string, objectArray));
    }

    public Result compile(String[] stringArray) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(stringArray, context);
        if (this.fileManager instanceof JavacFileManager) {
            try {
                ((JavacFileManager)this.fileManager).close();
            }
            catch (IOException iOException) {
                this.bugMessage(iOException);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(String[] stringArray, Context context) {
        Object object;
        List<String> list;
        Object object2;
        Set<List<String>> set;
        String string;
        boolean bl;
        if (this.stdOut != null) {
            context.put(Log.outKey, this.stdOut);
        }
        if (this.stdErr != null) {
            context.put(Log.errKey, this.stdErr);
        }
        this.log = Log.instance(context);
        if (stringArray.length == 0) {
            OptionHelper.GrumpyHelper grumpyHelper = new OptionHelper.GrumpyHelper(this.log){

                @Override
                public String getOwnName() {
                    return Main.this.ownName;
                }

                @Override
                public void put(String string, String string2) {
                }
            };
            try {
                Option.HELP.process(grumpyHelper, "-help");
            }
            catch (Option.InvalidValueException invalidValueException) {
                // empty catch block
            }
            return Result.CMDERR;
        }
        try {
            stringArray = CommandLine.parse(ENV_OPT_NAME, stringArray);
        }
        catch (CommandLine.UnmatchedQuote unmatchedQuote) {
            this.error("err.unmatched.quote", unmatchedQuote.variableName);
            return Result.CMDERR;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            this.warning("err.file.not.found", iOException.getMessage());
            return Result.SYSERR;
        }
        catch (IOException iOException) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
            iOException.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
            return Result.SYSERR;
        }
        Arguments arguments = Arguments.instance(context);
        arguments.init(this.ownName, stringArray);
        if (this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        Options options = Options.instance(context);
        boolean bl2 = options.isSet("stdout");
        if (bl2) {
            this.log.flush();
            this.log.setWriters(new PrintWriter(System.out, true));
        }
        boolean bl3 = bl = options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
        if (bl) {
            CacheFSInfo.preRegister(context);
        }
        boolean bl4 = true;
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager instanceof BaseFileManager) {
            ((BaseFileManager)this.fileManager).setContext(context);
            bl4 &= ((BaseFileManager)this.fileManager).handleOptions(arguments.getDeferredFileManagerOptions());
        }
        if ((string = options.get("showClass")) != null) {
            if (string.equals("showClass")) {
                string = "com.sun.tools.javac.Main";
            }
            this.showClass(string);
        }
        if (!(bl4 &= arguments.validate()) || this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        if (arguments.isEmpty()) {
            return Result.OK;
        }
        if (options.isSet("debug.completionDeps")) {
            Dependencies.GraphDependencies.preRegister(context);
        }
        if (!(set = arguments.getPluginOpts()).isEmpty() || context.get(PlatformDescription.class) != null) {
            object2 = (BasicJavacTask)BasicJavacTask.instance(context);
            ((BasicJavacTask)object2).initPlugins(set);
        }
        if (this.fileManager.isSupportedOption(Option.MULTIRELEASE.primaryName) == 1) {
            object2 = Target.instance(context);
            list = List.of(((Target)((Object)object2)).multiReleaseValue());
            this.fileManager.handleOption(Option.MULTIRELEASE.primaryName, list.iterator());
        }
        object2 = JavaCompiler.instance(context);
        list = arguments.getDocLintOpts();
        if (!list.isEmpty()) {
            object = (BasicJavacTask)BasicJavacTask.instance(context);
            object.initDocLint(list);
        }
        if (options.get(Option.XSTDOUT) != null) {
            ((JavaCompiler)object2).closeables = ((JavaCompiler)object2).closeables.prepend(this.log.getWriter(Log.WriterKind.NOTICE));
        }
        try {
            ((JavaCompiler)object2).compile(arguments.getFileObjects(), arguments.getClassNames(), null, List.nil());
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    object = Result.OK;
                    return object;
                }
                this.log.printRawLines("expected diagnostic keys not found: " + this.log.expectDiagKeys);
                object = Result.ERROR;
                return object;
            }
            object = ((JavaCompiler)object2).errorCount() == 0 ? Result.OK : Result.ERROR;
            return object;
        }
        catch (OutOfMemoryError | StackOverflowError virtualMachineError) {
            this.resourceMessage(virtualMachineError);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError fatalError) {
            this.feMessage(fatalError, options);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError annotationProcessingError) {
            this.apMessage(annotationProcessingError);
            Result result = Result.SYSERR;
            return result;
        }
        catch (PropagatedException propagatedException) {
            throw propagatedException.getCause();
        }
        catch (Throwable throwable) {
            if (object2 == null || ((JavaCompiler)object2).errorCount() == 0 || options.isSet("dev")) {
                this.bugMessage(throwable);
            }
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (object2 != null) {
                try {
                    ((JavaCompiler)object2).close();
                }
                catch (ClientCodeException clientCodeException) {
                    throw new RuntimeException(clientCodeException.getCause());
                }
            }
        }
    }

    void bugMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable throwable, Options options) {
        this.log.printRawLines(throwable.getMessage());
        if (throwable.getCause() != null && options.isSet("dev")) {
            throwable.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError annotationProcessingError) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        annotationProcessingError.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void showClass(String string) {
        PrintWriter printWriter = this.log.getWriter(Log.WriterKind.NOTICE);
        printWriter.println("javac: show class: " + string);
        URL uRL = this.getClass().getResource('/' + string.replace('.', '/') + ".class");
        if (uRL != null) {
            printWriter.println("  " + uRL);
        }
        try (InputStream inputStream2 = this.getClass().getResourceAsStream('/' + string.replace('.', '/') + ".class");){
            byte[] byArray;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            Object object = new DigestInputStream(inputStream2, messageDigest);
            Object object2 = null;
            try {
                int n;
                byte[] byArray2 = new byte[8192];
                while ((n = ((FilterInputStream)object).read(byArray2)) > 0) {
                }
                byArray = messageDigest.digest();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((FilterInputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FilterInputStream)object).close();
                    }
                }
            }
            object = new StringBuilder();
            for (Object object3 : (Object)byArray) {
                ((StringBuilder)object).append(String.format("%02x", (byte)object3));
            }
            printWriter.println("  MD5 checksum: " + object);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            printWriter.println("  cannot compute digest: " + exception);
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int n2) {
            this.exitCode = n2;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

