/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.InferenceContext;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.lang.annotation.Documented;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;

public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Resolve rs;
    private final Symtab syms;
    private final Enter enter;
    private final DeferredAttr deferredAttr;
    private final Infer infer;
    private final Types types;
    private final TypeAnnotations typeAnnotations;
    private final JCDiagnostic.Factory diags;
    private final JavaFileManager fileManager;
    private final Source source;
    private final Profile profile;
    private final boolean warnOnAnyAccessToMembers;
    private Lint lint;
    private Symbol.MethodSymbol method;
    boolean allowSimplifiedVarargs;
    boolean allowDefaultMethods;
    boolean allowStrictMethodClashCheck;
    boolean allowPrivateSafeVarargs;
    boolean allowDiamondWithAnonymousClassCreation;
    char syntheticNameChar;
    private Map<Pair<Symbol.ModuleSymbol, Name>, Symbol.ClassSymbol> compiled = new HashMap<Pair<Symbol.ModuleSymbol, Name>, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler removalHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private MandatoryWarningHandler sunApiHandler;
    private DeferredLintHandler deferredLintHandler;
    private Map<Pair<Name, Name>, Integer> localClassNameIndexes = new HashMap<Pair<Name, Name>, Integer>();
    CheckContext basicHandler = new CheckContext(){

        @Override
        public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
            Check.this.log.error(diagnosticPosition, "prob.found.req", jCDiagnostic);
        }

        @Override
        public boolean compatible(Type type, Type type2, Warner warner) {
            return Check.this.types.isAssignable(type, type2, warner);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
            return Check.this.convertWarner(diagnosticPosition, type, type2);
        }

        @Override
        public InferenceContext inferenceContext() {
            return ((Check)Check.this).infer.emptyContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return ((Check)Check.this).deferredAttr.emptyDeferredAttrContext;
        }

        public String toString() {
            return "CheckContext: basicHandler";
        }
    };
    private static final boolean ignoreAnnotatedCasts = true;
    private static final Types.SimpleVisitor<Boolean, Void> diamondTypeChecker = new Types.SimpleVisitor<Boolean, Void>(){

        @Override
        public Boolean visitType(Type type, Void void_) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Void void_) {
            if (classType.isCompound()) {
                return false;
            }
            for (Type type : classType.allparams()) {
                if (((Boolean)this.visit(type, void_)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return typeVar.tsym.owner.type.getTypeArguments().contains(typeVar);
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType capturedType, Void void_) {
            return false;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Void void_) {
            return (Boolean)this.visit(arrayType.elemtype, void_);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            return (Boolean)this.visit(wildcardType.type, void_);
        }
    };
    Types.UnaryVisitor<Boolean> isTypeArgErroneous = new Types.UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type type, Void void_) {
            return type.isErroneous();
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return (Boolean)this.visit(typeVar.getUpperBound());
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType capturedType, Void void_) {
            return (Boolean)this.visit(capturedType.getUpperBound()) != false || (Boolean)this.visit(capturedType.getLowerBound()) != false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            return (Boolean)this.visit(wildcardType.type);
        }
    };
    Warner overrideWarner = new Warner();
    private Filter<Symbol> equalsHasCodeFilter = symbol -> Symbol.MethodSymbol.implementation_filter.accepts((Symbol)symbol) && (symbol.flags() & 0x200000000000L) == 0L;
    private Set<Name> defaultTargets;
    private final Name[] dfltTargetMeta;

    public static Check instance(Context context) {
        Check check2 = context.get(checkKey);
        if (check2 == null) {
            check2 = new Check(context);
        }
        return check2;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Names.instance(context);
        this.dfltTargetMeta = new Name[]{this.names.PACKAGE, this.names.TYPE, this.names.FIELD, this.names.METHOD, this.names.CONSTRUCTOR, this.names.ANNOTATION_TYPE, this.names.LOCAL_VARIABLE, this.names.PARAMETER};
        this.log = Log.instance(context);
        this.rs = Resolve.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.source = Source.instance(context);
        this.allowSimplifiedVarargs = this.source.allowSimplifiedVarargs();
        this.allowDefaultMethods = this.source.allowDefaultMethods();
        this.allowStrictMethodClashCheck = this.source.allowStrictMethodClashCheck();
        this.allowPrivateSafeVarargs = this.source.allowPrivateSafeVarargs();
        this.allowDiamondWithAnonymousClassCreation = this.source.allowDiamondWithAnonymousClassCreation();
        this.warnOnAnyAccessToMembers = options.isSet("warnOnAccessToMembers");
        Target target = Target.instance(context);
        this.syntheticNameChar = target.syntheticNameChar();
        this.profile = Profile.instance(context);
        boolean bl = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean bl2 = this.lint.isEnabled(Lint.LintCategory.REMOVAL);
        boolean bl3 = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        boolean bl4 = true;
        this.deprecationHandler = new MandatoryWarningHandler(this.log, bl, bl4, "deprecated", Lint.LintCategory.DEPRECATION);
        this.removalHandler = new MandatoryWarningHandler(this.log, bl2, bl4, "removal", Lint.LintCategory.REMOVAL);
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, bl3, bl4, "unchecked", Lint.LintCategory.UNCHECKED);
        this.sunApiHandler = new MandatoryWarningHandler(this.log, false, bl4, "sunapi", null);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
    }

    Lint setLint(Lint lint) {
        Lint lint2 = this.lint;
        this.lint = lint;
        return lint2;
    }

    Symbol.MethodSymbol setMethod(Symbol.MethodSymbol methodSymbol) {
        Symbol.MethodSymbol methodSymbol2 = this.method;
        this.method = methodSymbol;
        return methodSymbol2;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (symbol.isDeprecatedForRemoval()) {
            if (!this.lint.isSuppressed(Lint.LintCategory.REMOVAL)) {
                if (symbol.kind == Kinds.Kind.MDL) {
                    this.removalHandler.report(diagnosticPosition, "has.been.deprecated.for.removal.module", symbol);
                } else {
                    this.removalHandler.report(diagnosticPosition, "has.been.deprecated.for.removal", symbol, symbol.location());
                }
            }
        } else if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            if (symbol.kind == Kinds.Kind.MDL) {
                this.deprecationHandler.report(diagnosticPosition, "has.been.deprecated.module", symbol);
            } else {
                this.deprecationHandler.report(diagnosticPosition, "has.been.deprecated", symbol, symbol.location());
            }
        }
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(diagnosticPosition, string, objectArray);
        }
    }

    void warnUnsafeVararg(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        if (this.lint.isEnabled(Lint.LintCategory.VARARGS) && this.allowSimplifiedVarargs) {
            this.log.warning(Lint.LintCategory.VARARGS, diagnosticPosition, string, objectArray);
        }
    }

    public void warnStatic(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        if (this.lint.isEnabled(Lint.LintCategory.STATIC)) {
            this.log.warning(Lint.LintCategory.STATIC, diagnosticPosition, string, objectArray);
        }
    }

    void warnDivZero(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (this.lint.isEnabled(Lint.LintCategory.DIVZERO)) {
            this.log.warning(Lint.LintCategory.DIVZERO, diagnosticPosition, "div.zero", new Object[0]);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.removalHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
        this.sunApiHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.CompletionFailure completionFailure) {
        this.log.error(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE, diagnosticPosition, "cant.access", completionFailure.sym, completionFailure.getDetailValue());
        if (completionFailure instanceof ClassFinder.BadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Object object, Object object2) {
        if (object2 instanceof Type && ((Type)object2).hasTag(TypeTag.VOID)) {
            this.log.error(diagnosticPosition, "illegal.start.of.type", new Object[0]);
            return this.syms.errType;
        }
        this.log.error(diagnosticPosition, "type.found.req", object2, object);
        return this.types.createErrorType(object2 instanceof Type ? (Type)object2 : this.syms.errType);
    }

    void earlyRefError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        this.log.error(diagnosticPosition, "cant.ref.before.ctor.called", symbol);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (!symbol.type.isErroneous()) {
            Symbol symbol2 = symbol.location();
            if (symbol2.kind == Kinds.Kind.MTH && ((Symbol.MethodSymbol)symbol2).isStaticOrInstanceInit()) {
                this.log.error(diagnosticPosition, "already.defined.in.clinit", Kinds.kindName(symbol), symbol, Kinds.kindName(symbol.location()), Kinds.kindName(symbol.location().enclClass()), symbol.location().enclClass());
            } else {
                this.log.error(diagnosticPosition, "already.defined", Kinds.kindName(symbol), symbol, Kinds.kindName(symbol.location()), symbol.location());
            }
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        if (!symbol.type.isErroneous() && !symbol2.type.isErroneous()) {
            this.log.error(diagnosticPosition, "array.and.varargs", symbol, symbol2, symbol2.location());
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol, Scope scope) {
        for (Symbol symbol : scope.getSymbolsByName(varSymbol.name)) {
            if (symbol.owner != varSymbol.owner) break;
            if (symbol.kind != Kinds.Kind.VAR || !symbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || varSymbol.name == this.names.error) continue;
            this.duplicateError(diagnosticPosition, symbol);
            return;
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol, Scope scope) {
        for (Symbol symbol : scope.getSymbolsByName(classSymbol.name)) {
            if (symbol.owner != classSymbol.owner) break;
            if (symbol.kind != Kinds.Kind.TYP || symbol.type.hasTag(TypeTag.TYPEVAR) || !symbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || classSymbol.name == this.names.error) continue;
            this.duplicateError(diagnosticPosition, symbol);
            return;
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition diagnosticPosition, Name name, Scope scope) {
        for (Symbol symbol : scope.getSymbolsByName(name, Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol.kind != Kinds.Kind.TYP || symbol.name == this.names.error) continue;
            this.duplicateError(diagnosticPosition, symbol);
            return false;
        }
        Object object = scope.owner;
        while (object != null) {
            if (((Symbol)object).kind == Kinds.Kind.TYP && ((Symbol)object).name == name && ((Symbol)object).name != this.names.error) {
                this.duplicateError(diagnosticPosition, (Symbol)object);
                return true;
            }
            object = ((Symbol)object).owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol classSymbol) {
        int n;
        Name name = classSymbol.owner.enclClass().flatname;
        String string = name.toString();
        Pair<Name, Name> pair = new Pair<Name, Name>(name, classSymbol.name);
        Integer n2 = this.localClassNameIndexes.get(pair);
        int n3 = n = n2 == null ? 1 : n2;
        while (true) {
            Name name2;
            if (this.getCompiled(classSymbol.packge().modle, name2 = this.names.fromString(string + this.syntheticNameChar + n + classSymbol.name)) == null) {
                this.localClassNameIndexes.put(pair, n + 1);
                return name2;
            }
            ++n;
        }
    }

    void clearLocalClassNameIndexes(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner != null && classSymbol.owner.kind != Kinds.Kind.NIL) {
            this.localClassNameIndexes.remove(new Pair<Name, Name>(classSymbol.owner.enclClass().flatname, classSymbol.name));
        }
    }

    public void newRound() {
        this.compiled.clear();
        this.localClassNameIndexes.clear();
    }

    public void putCompiled(Symbol.ClassSymbol classSymbol) {
        this.compiled.put(Pair.of(classSymbol.packge().modle, classSymbol.flatname), classSymbol);
    }

    public Symbol.ClassSymbol getCompiled(Symbol.ClassSymbol classSymbol) {
        return this.compiled.get(Pair.of(classSymbol.packge().modle, classSymbol.flatname));
    }

    public Symbol.ClassSymbol getCompiled(Symbol.ModuleSymbol moduleSymbol, Name name) {
        return this.compiled.get(Pair.of(moduleSymbol, name));
    }

    public void removeCompiled(Symbol.ClassSymbol classSymbol) {
        this.compiled.remove(Pair.of(classSymbol.packge().modle, classSymbol.flatname));
    }

    public Type checkType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return this.checkType(diagnosticPosition, type, type2, this.basicHandler);
    }

    Type checkType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, CheckContext checkContext) {
        InferenceContext inferenceContext2 = checkContext.inferenceContext();
        if (inferenceContext2.free(type2) || inferenceContext2.free(type)) {
            inferenceContext2.addFreeTypeListener(List.of(type2, type), inferenceContext -> this.checkType(diagnosticPosition, inferenceContext.asInstType(type), inferenceContext.asInstType(type2), checkContext));
        }
        if (type2.hasTag(TypeTag.ERROR)) {
            return type2;
        }
        if (type2.hasTag(TypeTag.NONE)) {
            return type;
        }
        if (checkContext.compatible(type, type2, checkContext.checkWarner(diagnosticPosition, type, type2))) {
            return type;
        }
        if (type.isNumeric() && type2.isNumeric()) {
            checkContext.report(diagnosticPosition, this.diags.fragment("possible.loss.of.precision", type, type2));
            return this.types.createErrorType(type);
        }
        checkContext.report(diagnosticPosition, this.diags.fragment("inconvertible.types", type, type2));
        return this.types.createErrorType(type);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return this.checkCastable(diagnosticPosition, type, type2, this.basicHandler);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, CheckContext checkContext) {
        if (this.types.isCastable(type, type2, this.castWarner(diagnosticPosition, type, type2))) {
            return type2;
        }
        checkContext.report(diagnosticPosition, this.diags.fragment("inconvertible.types", type, type2));
        return this.types.createErrorType(type);
    }

    public void checkRedundantCast(Env<AttrContext> env, JCTree.JCTypeCast jCTypeCast) {
        if (!jCTypeCast.type.isErroneous() && this.types.isSameType(jCTypeCast.expr.type, jCTypeCast.clazz.type) && !TreeInfo.containsTypeAnnotation(jCTypeCast.clazz) && !this.is292targetTypeCast(jCTypeCast)) {
            this.deferredLintHandler.report(() -> {
                if (this.lint.isEnabled(Lint.LintCategory.CAST)) {
                    this.log.warning(Lint.LintCategory.CAST, jCTypeCast.pos(), "redundant.cast", jCTypeCast.clazz.type);
                }
            });
        }
    }

    private boolean is292targetTypeCast(JCTree.JCTypeCast jCTypeCast) {
        boolean bl = false;
        JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCTypeCast.expr);
        if (jCExpression.hasTag(JCTree.Tag.APPLY)) {
            JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)jCExpression;
            Symbol symbol = TreeInfo.symbol(jCMethodInvocation.meth);
            bl = symbol != null && symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x2000000000L) != 0L;
        }
        return bl;
    }

    private boolean checkExtends(Type type, Type type2) {
        if (type.isUnbound()) {
            return true;
        }
        if (!type.hasTag(TypeTag.WILDCARD)) {
            type = this.types.cvarUpperBound(type);
            return this.types.isSubtype(type, type2);
        }
        if (type.isExtendsBound()) {
            return this.types.isCastable(type2, this.types.wildUpperBound(type), this.types.noWarnings);
        }
        if (type.isSuperBound()) {
            return !this.types.notSoftSubtype(this.types.wildLowerBound(type), type2);
        }
        return true;
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.hasTag(TypeTag.VOID)) {
            this.log.error(diagnosticPosition, "void.not.allowed.here", new Object[0]);
            return this.types.createErrorType(type);
        }
        return type;
    }

    Type checkClassOrArrayType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (!(type.hasTag(TypeTag.CLASS) || type.hasTag(TypeTag.ARRAY) || type.hasTag(TypeTag.ERROR))) {
            return this.typeTagError(diagnosticPosition, this.diags.fragment("type.req.class.array", new Object[0]), this.asTypeParam(type));
        }
        return type;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (!type.hasTag(TypeTag.CLASS) && !type.hasTag(TypeTag.ERROR)) {
            return this.typeTagError(diagnosticPosition, this.diags.fragment("type.req.class", new Object[0]), this.asTypeParam(type));
        }
        return type;
    }

    private Object asTypeParam(Type type) {
        return type.hasTag(TypeTag.TYPEVAR) ? this.diags.fragment("type.parameter", type) : type;
    }

    Type checkConstructorRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if ((type = this.checkClassOrArrayType(diagnosticPosition, type)).hasTag(TypeTag.CLASS)) {
            if ((type.tsym.flags() & 0x600L) != 0L) {
                this.log.error(diagnosticPosition, "abstract.cant.be.instantiated", type.tsym);
                type = this.types.createErrorType(type);
            } else if ((type.tsym.flags() & 0x4000L) != 0L) {
                this.log.error(diagnosticPosition, "enum.cant.be.instantiated", new Object[0]);
                type = this.types.createErrorType(type);
            } else {
                type = this.checkClassType(diagnosticPosition, type, true);
            }
        } else if (type.hasTag(TypeTag.ARRAY) && !this.types.isReifiable(((Type.ArrayType)type).elemtype)) {
            this.log.error(diagnosticPosition, "generic.array.creation", new Object[0]);
            type = this.types.createErrorType(type);
        }
        return type;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, boolean bl) {
        type = this.checkClassType(diagnosticPosition, type);
        if (bl && type.isParameterized()) {
            List<Type> list = type.getTypeArguments();
            while (list.nonEmpty()) {
                if (((Type)list.head).hasTag(TypeTag.WILDCARD)) {
                    return this.typeTagError(diagnosticPosition, this.diags.fragment("type.req.exact", new Object[0]), list.head);
                }
                list = list.tail;
            }
        }
        return type;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isReference()) {
            return type;
        }
        return this.typeTagError(diagnosticPosition, this.diags.fragment("type.req.ref", new Object[0]), type);
    }

    List<Type> checkRefTypes(List<JCTree.JCExpression> list, List<Type> list2) {
        List<JCTree.JCExpression> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list4.head = this.checkRefType(((JCTree.JCExpression)list3.head).pos(), (Type)list4.head);
            list3 = list3.tail;
            list4 = list4.tail;
        }
        return list2;
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isReference() || type.hasTag(TypeTag.BOT)) {
            return type;
        }
        return this.typeTagError(diagnosticPosition, this.diags.fragment("type.req.ref", new Object[0]), type);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition diagnosticPosition, long l, long l2, long l3) {
        if ((l & l2) != 0L && (l & l3) != 0L) {
            this.log.error(diagnosticPosition, "illegal.combination.of.modifiers", Flags.asFlagSet(TreeInfo.firstFlag(l & l2)), Flags.asFlagSet(TreeInfo.firstFlag(l & l3)));
            return false;
        }
        return true;
    }

    Type checkDiamond(JCTree.JCNewClass jCNewClass, Type type) {
        if (!TreeInfo.isDiamond(jCNewClass) || type.isErroneous()) {
            return this.checkClassType(jCNewClass.clazz.pos(), type, true);
        }
        if (jCNewClass.def != null && !this.allowDiamondWithAnonymousClassCreation) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, jCNewClass.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(type, CompilerProperties.Fragments.DiamondAndAnonClassNotSupportedInSource(this.source.name)));
        }
        if (type.tsym.type.getTypeArguments().isEmpty()) {
            this.log.error(jCNewClass.clazz.pos(), "cant.apply.diamond.1", type, this.diags.fragment("diamond.non.generic", type));
            return this.types.createErrorType(type);
        }
        if (jCNewClass.typeargs != null && jCNewClass.typeargs.nonEmpty()) {
            this.log.error(jCNewClass.clazz.pos(), "cant.apply.diamond.1", type, this.diags.fragment("diamond.and.explicit.params", type));
            return this.types.createErrorType(type);
        }
        return type;
    }

    List<Type> checkDiamondDenotable(Type.ClassType classType) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : classType.allparams()) {
            if (((Boolean)diamondTypeChecker.visit(type, null)).booleanValue()) continue;
            listBuffer.append(type);
        }
        return listBuffer.toList();
    }

    void checkVarargsMethodDecl(Env<AttrContext> env, JCTree.JCMethodDecl jCMethodDecl) {
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        if (!this.allowSimplifiedVarargs) {
            return;
        }
        boolean bl = methodSymbol.attribute(this.syms.trustMeType.tsym) != null;
        Type type = null;
        if (methodSymbol.isVarArgs()) {
            type = this.types.elemtype(jCMethodDecl.params.last().type);
        }
        if (bl && !this.isTrustMeAllowedOnMethod(methodSymbol)) {
            if (type != null) {
                this.log.error(jCMethodDecl, "varargs.invalid.trustme.anno", this.syms.trustMeType.tsym, this.allowPrivateSafeVarargs ? this.diags.fragment("varargs.trustme.on.virtual.varargs", methodSymbol) : this.diags.fragment("varargs.trustme.on.virtual.varargs.final.only", methodSymbol));
            } else {
                this.log.error(jCMethodDecl, "varargs.invalid.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.non.varargs.meth", methodSymbol));
            }
        } else if (bl && type != null && this.types.isReifiable(type)) {
            this.warnUnsafeVararg(jCMethodDecl, "varargs.redundant.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.reifiable.varargs", type));
        } else if (!bl && type != null && !this.types.isReifiable(type)) {
            this.warnUnchecked(((JCTree.JCVariableDecl)jCMethodDecl.params.head).pos(), "unchecked.varargs.non.reifiable.type", type);
        }
    }

    private boolean isTrustMeAllowedOnMethod(Symbol symbol) {
        return (symbol.flags() & 0x400000000L) != 0L && (symbol.isConstructor() || (symbol.flags() & (long)(0x18 | (this.allowPrivateSafeVarargs ? 2 : 0))) != 0L);
    }

    Type checkMethod(Type type, Symbol symbol, Env<AttrContext> env, List<JCTree.JCExpression> list, List<Type> list2, boolean bl, InferenceContext inferenceContext2) {
        Object object;
        List<JCTree.JCExpression> list3;
        Type type2;
        if (inferenceContext2.free(type)) {
            inferenceContext2.addFreeTypeListener(List.of(type), inferenceContext -> this.checkMethod(inferenceContext.asInstType(type), symbol, env, list, list2, bl, inferenceContext));
            return type;
        }
        Type type3 = type;
        List<Type> list4 = type3.getParameterTypes();
        List<Type> list5 = symbol.type.getParameterTypes();
        if (list5.length() != list4.length()) {
            list5 = list4;
        }
        Type type4 = type2 = bl ? list4.last() : null;
        if (symbol.name == this.names.init && symbol.owner == this.syms.enumSym) {
            list4 = list4.tail.tail;
            list5 = list5.tail.tail;
        }
        if ((list3 = list) != null) {
            Object object2;
            while (list4.head != type2) {
                object = (JCTree)list3.head;
                object2 = this.convertWarner(((JCTree)object).pos(), ((JCTree)object).type, (Type)list5.head);
                this.assertConvertible((JCTree)object, ((JCTree)object).type, (Type)list4.head, (Warner)object2);
                list3 = list3.tail;
                list4 = list4.tail;
                list5 = list5.tail;
            }
            if (bl) {
                object = this.types.elemtype(type2);
                while (list3.tail != null) {
                    object2 = (JCTree)list3.head;
                    Warner warner = this.convertWarner(((JCTree)object2).pos(), ((JCTree)object2).type, (Type)object);
                    this.assertConvertible((JCTree)object2, ((JCTree)object2).type, (Type)object, warner);
                    list3 = list3.tail;
                }
            } else if ((symbol.flags() & 0x400400000000L) == 0x400000000L) {
                object = type3.getParameterTypes().last();
                object2 = list2.last();
                if (this.types.isSubtypeUnchecked((Type)object2, this.types.elemtype((Type)object)) && !this.types.isSameType(this.types.erasure((Type)object), this.types.erasure((Type)object2))) {
                    this.log.warning(list.last().pos(), "inexact.non-varargs.call", this.types.elemtype((Type)object), object);
                }
            }
        }
        if (bl) {
            object = type3.getParameterTypes().last();
            if (!(this.types.isReifiable((Type)object) || this.allowSimplifiedVarargs && symbol.baseSymbol().attribute(this.syms.trustMeType.tsym) != null && this.isTrustMeAllowedOnMethod(symbol))) {
                this.warnUnchecked(env.tree.pos(), "unchecked.generic.array.creation", object);
            }
            if ((symbol.baseSymbol().flags() & 0x400000000000L) == 0L) {
                TreeInfo.setVarargsElement(env.tree, this.types.elemtype((Type)object));
            }
        }
        return type3;
    }

    private void assertConvertible(JCTree jCTree, Type type, Type type2, Warner warner) {
        if (this.types.isConvertible(type, type2, warner)) {
            return;
        }
        if (type2.isCompound() && this.types.isSubtype(type, this.types.supertype(type2)) && this.types.isSubtypeUnchecked(type, this.types.interfaces(type2), warner)) {
            return;
        }
    }

    public boolean checkValidGenericType(Type type) {
        return this.firstIncompatibleTypeArg(type) == null;
    }

    private Type firstIncompatibleTypeArg(Type type) {
        List<Type> list = type.tsym.type.allparams();
        List<Type> list2 = type.allparams();
        List<Type> list3 = type.getTypeArguments();
        List<Type> list4 = type.tsym.type.getTypeArguments();
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        while (list3.nonEmpty() && list4.nonEmpty()) {
            listBuffer.append(this.types.subst(((Type)list4.head).getUpperBound(), list, list2));
            list3 = list3.tail;
            list4 = list4.tail;
        }
        list3 = type.getTypeArguments();
        List<Type> list5 = this.types.substBounds(list, list, this.types.capture(type).allparams());
        while (list3.nonEmpty() && list5.nonEmpty()) {
            ((Type)list3.head).withTypeVar((Type.TypeVar)list5.head);
            list3 = list3.tail;
            list5 = list5.tail;
        }
        list3 = type.getTypeArguments();
        List list6 = listBuffer.toList();
        while (list3.nonEmpty() && list6.nonEmpty()) {
            Type type2 = (Type)list3.head;
            if (!(this.isTypeArgErroneous(type2) || ((Type)list6.head).isErroneous() || this.checkExtends(type2, (Type)list6.head))) {
                return (Type)list3.head;
            }
            list3 = list3.tail;
            list6 = list6.tail;
        }
        list3 = type.getTypeArguments();
        list6 = listBuffer.toList();
        for (Type type3 : this.types.capture(type).getTypeArguments()) {
            if (type3.hasTag(TypeTag.TYPEVAR) && type3.getUpperBound().isErroneous() && !((Type)list6.head).isErroneous() && !this.isTypeArgErroneous((Type)list3.head)) {
                return (Type)list3.head;
            }
            list6 = list6.tail;
            list3 = list3.tail;
        }
        return null;
    }

    boolean isTypeArgErroneous(Type type) {
        return this.isTypeArgErroneous.visit(type);
    }

    long checkFlags(JCDiagnostic.DiagnosticPosition diagnosticPosition, long l, Symbol symbol, JCTree jCTree) {
        long l2;
        long l3 = 0L;
        switch (symbol.kind) {
            case VAR: {
                if (TreeInfo.isReceiverParam(jCTree)) {
                    l2 = 0x200000000L;
                    break;
                }
                if (symbol.owner.kind != Kinds.Kind.TYP) {
                    l2 = 0x200000010L;
                    break;
                }
                if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    l3 = 25L;
                    l2 = 25L;
                    break;
                }
                l2 = 16607L;
                break;
            }
            case MTH: {
                if (symbol.name == this.names.init) {
                    if ((symbol.owner.flags_field & 0x4000L) != 0L) {
                        l3 = 2L;
                        l2 = 2L;
                    } else {
                        l2 = 7L;
                    }
                } else if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    if ((symbol.owner.flags_field & 0x2000L) != 0L) {
                        l2 = 1025L;
                        l3 = 1025L;
                    } else if ((l & 0x8000000000AL) != 0L) {
                        l2 = 8796093025291L;
                        long l4 = l3 = (l & 2L) != 0L ? 0L : 1L;
                        if ((l & 0x80000000000L) != 0L) {
                            l3 |= 0x400L;
                        }
                    } else {
                        l3 = 1025L;
                        l2 = 1025L;
                    }
                } else {
                    l2 = 3391L;
                }
                if (((l | l3) & 0x400L) != 0L && (l & 0x80000000000L) == 0L) break;
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            case TYP: {
                if (symbol.isLocal()) {
                    l2 = 23568L;
                    if ((symbol.owner.flags_field & 8L) == 0L && (l & 0x4000L) != 0L) {
                        this.log.error(diagnosticPosition, "enums.must.be.static", new Object[0]);
                    }
                } else if (symbol.owner.kind == Kinds.Kind.TYP) {
                    l2 = 24087L;
                    if (symbol.owner.owner.kind == Kinds.Kind.PCK || (symbol.owner.flags_field & 8L) != 0L) {
                        l2 |= 8L;
                    } else if ((l & 0x4000L) != 0L) {
                        this.log.error(diagnosticPosition, "enums.must.be.static", new Object[0]);
                    }
                    if ((l & 0x4200L) != 0L) {
                        l3 = 8L;
                    }
                } else {
                    l2 = 32273L;
                }
                if ((l & 0x200L) != 0L) {
                    l3 |= 0x400L;
                }
                if ((l & 0x4000L) != 0L) {
                    l2 &= 0xFFFFFFFFFFFFFBEFL;
                    l3 |= this.implicitEnumFinalFlag(jCTree);
                }
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long l5 = l & 0x80000000FFFL & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (l5 != 0L) {
            if ((l5 & 0x200L) != 0L) {
                this.log.error(diagnosticPosition, "intf.not.allowed.here", new Object[0]);
                l2 |= 0x200L;
            } else {
                this.log.error(diagnosticPosition, "mod.not.allowed.here", Flags.asFlagSet(l5));
            }
        } else if (!((symbol.kind == Kinds.Kind.TYP || this.checkDisjoint(diagnosticPosition, l, 1024L, 0x8000000000AL)) && this.checkDisjoint(diagnosticPosition, l, 10L, 0x80000000000L) && this.checkDisjoint(diagnosticPosition, l, 1536L, 304L) && this.checkDisjoint(diagnosticPosition, l, 1L, 6L) && this.checkDisjoint(diagnosticPosition, l, 2L, 5L) && this.checkDisjoint(diagnosticPosition, l, 16L, 64L) && symbol.kind != Kinds.Kind.TYP && !this.checkDisjoint(diagnosticPosition, l, 1280L, 2048L))) {
            // empty if block
        }
        return l & (l2 | 0xFFFFF7FFFFFFF000L) | l3;
    }

    private long implicitEnumFinalFlag(JCTree jCTree) {
        if (!jCTree.hasTag(JCTree.Tag.CLASSDEF)) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends JCTree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            @Override
            public void visitTree(JCTree jCTree) {
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                if ((jCVariableDecl.mods.flags & 0x4000L) != 0L && jCVariableDecl.init instanceof JCTree.JCNewClass && ((JCTree.JCNewClass)jCVariableDecl.init).def != null) {
                    this.specialized = true;
                }
            }
        }
        SpecialTreeVisitor specialTreeVisitor = new SpecialTreeVisitor();
        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
        for (JCTree jCTree2 : jCClassDecl.defs) {
            jCTree2.accept(specialTreeVisitor);
            if (!specialTreeVisitor.specialized) continue;
            return 0L;
        }
        return 16L;
    }

    void validate(JCTree jCTree, Env<AttrContext> env) {
        this.validate(jCTree, env, true);
    }

    void validate(JCTree jCTree, Env<AttrContext> env, boolean bl) {
        new Validator(env).validateTree(jCTree, bl, true);
    }

    void validate(List<? extends JCTree> list, Env<AttrContext> env) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.validate((JCTree)list2.head, env);
            list2 = list2.tail;
        }
    }

    void checkRaw(JCTree jCTree, Env<AttrContext> env) {
        if (this.lint.isEnabled(Lint.LintCategory.RAW) && jCTree.type.hasTag(TypeTag.CLASS) && !TreeInfo.isDiamond(jCTree) && !this.withinAnonConstr(env) && jCTree.type.isRaw()) {
            this.log.warning(Lint.LintCategory.RAW, jCTree.pos(), "raw.class.use", jCTree.type, jCTree.type.tsym.type);
        }
    }

    private boolean withinAnonConstr(Env<AttrContext> env) {
        return env.enclClass.name.isEmpty() && env.enclMethod != null && env.enclMethod.name == this.names.init;
    }

    boolean subset(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubtype(type, (Type)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    boolean intersects(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubtype(type, (Type)list2.head) || this.types.isSubtype((Type)list2.head, type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    List<Type> incl(Type type, List<Type> list) {
        return this.subset(type, list) ? list : this.excl(type, list).prepend(type);
    }

    List<Type> excl(Type type, List<Type> list) {
        if (list.isEmpty()) {
            return list;
        }
        List<Type> list2 = this.excl(type, list.tail);
        if (this.types.isSubtype((Type)list.head, type)) {
            return list2;
        }
        if (list2 == list.tail) {
            return list;
        }
        return list2.prepend((Type)list.head);
    }

    List<Type> union(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.incl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    List<Type> diff(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.excl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    public List<Type> intersect(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list2)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        list4 = list2;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    boolean isUnchecked(Symbol.ClassSymbol classSymbol) {
        return classSymbol.kind == Kinds.Kind.ERR || classSymbol.isSubClass(this.syms.errorType.tsym, this.types) || classSymbol.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type type) {
        return type.hasTag(TypeTag.TYPEVAR) ? this.isUnchecked(this.types.supertype(type)) : (type.hasTag(TypeTag.CLASS) ? this.isUnchecked((Symbol.ClassSymbol)type.tsym) : type.hasTag(TypeTag.BOT));
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        try {
            return this.isUnchecked(type);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(diagnosticPosition, completionFailure);
            return true;
        }
    }

    boolean isHandled(Type type, List<Type> list) {
        return this.isUnchecked(type) || this.subset(type, list);
    }

    List<Type> unhandled(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (!this.isHandled((Type)list4.head, list2)) {
                list3 = list3.prepend((Type)list4.head);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    static int protection(long l) {
        switch ((short)(l & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    Object cannotOverride(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "cant.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return this.diags.fragment(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    Object uncheckedOverrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return this.diags.fragment(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    Object varargsOverrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "varargs.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "varargs.implement" : "varargs.clash.with");
        return this.diags.fragment(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkOverride(JCTree jCTree, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.ClassSymbol classSymbol) {
        if ((methodSymbol.flags() & 0x80001000L) != 0L || (methodSymbol2.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((methodSymbol.flags() & 8L) != 0L && (methodSymbol2.flags() & 8L) == 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.static", this.cannotOverride(methodSymbol, methodSymbol2));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if ((methodSymbol2.flags() & 0x10L) != 0L || (methodSymbol.flags() & 8L) == 0L && (methodSymbol2.flags() & 8L) != 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.meth", this.cannotOverride(methodSymbol, methodSymbol2), Flags.asFlagSet(methodSymbol2.flags() & 0x18L));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if ((methodSymbol.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        if (Check.protection(methodSymbol.flags()) > Check.protection(methodSymbol2.flags())) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.weaker.access", this.cannotOverride(methodSymbol, methodSymbol2), (methodSymbol2.flags() & 7L) == 0L ? "package" : Flags.asFlagSet(methodSymbol2.flags() & 7L));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        Type type = this.types.memberType(classSymbol.type, methodSymbol);
        Type type2 = this.types.memberType(classSymbol.type, methodSymbol2);
        List<Type> list = type.getTypeArguments();
        List<Type> list2 = type2.getTypeArguments();
        Type type3 = type.getReturnType();
        Type type4 = this.types.subst(type2.getReturnType(), list2, list);
        this.overrideWarner.clear();
        boolean bl = this.types.returnTypeSubstitutable(type, type2, type4, this.overrideWarner);
        if (!bl) {
            if ((methodSymbol.flags() & 8L) != 0L && (methodSymbol2.flags() & 8L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), CompilerProperties.Errors.OverrideIncompatibleRet(CompilerProperties.Fragments.CantHide(methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location()), type3, type4));
                methodSymbol.flags_field |= 0x200000000000L;
            } else {
                this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.incompatible.ret", this.cannotOverride(methodSymbol, methodSymbol2), type3, type4);
                methodSymbol.flags_field |= 0x200000000000L;
            }
            return;
        }
        if (this.overrideWarner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.unchecked.ret", this.uncheckedOverrides(methodSymbol, methodSymbol2), type3, type4);
        }
        List<Type> list3 = this.types.subst(type2.getThrownTypes(), list2, list);
        List<Type> list4 = this.unhandled(type.getThrownTypes(), this.types.erasure(list3));
        List<Type> list5 = this.unhandled(type.getThrownTypes(), list3);
        if (list4.nonEmpty()) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.meth.doesnt.throw", this.cannotOverride(methodSymbol, methodSymbol2), list5.head);
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if (list5.nonEmpty()) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.unchecked.thrown", this.cannotOverride(methodSymbol, methodSymbol2), list5.head);
            return;
        }
        if (((methodSymbol.flags() ^ methodSymbol2.flags()) & 0x400000000L) != 0L && this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            this.log.warning(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), (methodSymbol.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", this.varargsOverrides(methodSymbol, methodSymbol2));
        }
        if ((methodSymbol2.flags() & 0x80000000L) != 0L) {
            this.log.warning(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.bridge", this.uncheckedOverrides(methodSymbol, methodSymbol2));
        }
        if (!this.isDeprecatedOverrideIgnorable(methodSymbol2, classSymbol)) {
            Lint lint = this.setLint(this.lint.augment(methodSymbol));
            try {
                this.checkDeprecated(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), methodSymbol, methodSymbol2);
            }
            finally {
                this.setLint(lint);
            }
        }
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol methodSymbol, Symbol.ClassSymbol classSymbol) {
        Symbol.ClassSymbol classSymbol2 = methodSymbol.enclClass();
        Type type = this.types.supertype(classSymbol.type);
        if (!type.hasTag(TypeTag.CLASS)) {
            return true;
        }
        Symbol.MethodSymbol methodSymbol2 = methodSymbol.implementation((Symbol.ClassSymbol)type.tsym, this.types, false);
        if (classSymbol2 != null && (classSymbol2.flags() & 0x200L) != 0L) {
            List<Type> list = this.types.interfaces(classSymbol.type);
            return list.contains(classSymbol2.type) ? false : methodSymbol2 != null;
        }
        return methodSymbol2 != methodSymbol;
    }

    public void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        Type type2 = this.types.supertype(type);
        if (!type2.hasTag(TypeTag.CLASS)) {
            return;
        }
        Type type3 = type2;
        while (type3.hasTag(TypeTag.CLASS) && type3.tsym.type.isParameterized()) {
            for (Symbol symbol : type3.tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 0x80001008L) != 0L || !symbol.isInheritedIn(type.tsym, this.types) || ((Symbol.MethodSymbol)symbol).implementation(type.tsym, this.types, true) != symbol) continue;
                Type type4 = this.types.memberType(type3, symbol);
                int n = type4.getParameterTypes().length();
                if (type4 == symbol.type) continue;
                Type type5 = type2;
                while (type5.hasTag(TypeTag.CLASS)) {
                    for (Symbol symbol2 : type5.tsym.members().getSymbolsByName(symbol.name)) {
                        Type type6;
                        if (symbol2 == symbol || symbol2.kind != Kinds.Kind.MTH || (symbol2.flags() & 0x80001008L) != 0L || symbol2.type.getParameterTypes().length() != n || !symbol2.isInheritedIn(type.tsym, this.types) || ((Symbol.MethodSymbol)symbol2).implementation(type.tsym, this.types, true) != symbol2 || !this.types.overrideEquivalent(type4, type6 = this.types.memberType(type5, symbol2))) continue;
                        this.log.error(diagnosticPosition, "concrete.inheritance.conflict", symbol, type3, symbol2, type5, type2);
                    }
                    type5 = this.types.supertype(type5);
                }
            }
            type3 = this.types.supertype(type3);
        }
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        if ((type3.tsym.flags() & 0x1000000L) != 0L) {
            type = this.types.capture(type);
            type2 = this.types.capture(type2);
        }
        return this.firstIncompatibility(diagnosticPosition, type, type2, type3) == null;
    }

    private Symbol firstIncompatibility(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        HashMap<Symbol.TypeSymbol, Type> hashMap;
        HashMap<Symbol.TypeSymbol, Type> hashMap2 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(type, hashMap2);
        if (type == type2) {
            hashMap = hashMap2;
        } else {
            hashMap = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(type2, hashMap2, hashMap);
        }
        for (Type type4 : hashMap2.values()) {
            for (Type type5 : hashMap.values()) {
                Symbol symbol = this.firstDirectIncompatibility(diagnosticPosition, type4, type5, type3);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return null;
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map) {
        if (!type.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (map.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map);
            }
        }
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map, Map<Symbol.TypeSymbol, Type> map2) {
        if (!type.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (map.get(type.tsym) != null) {
            return;
        }
        if (map2.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map, map2);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map, map2);
            }
        }
    }

    private Symbol firstDirectIncompatibility(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        for (Symbol symbol : type.tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            Symbol.MethodSymbol methodSymbol;
            Type type4 = null;
            if (symbol.kind != Kinds.Kind.MTH || !symbol.isInheritedIn(type3.tsym, this.types) || (symbol.flags() & 0x1000L) != 0L || (methodSymbol = ((Symbol.MethodSymbol)symbol).implementation(type3.tsym, this.types, false)) != null && (methodSymbol.flags() & 0x400L) == 0L) continue;
            for (Symbol symbol2 : type2.tsym.members().getSymbolsByName(symbol.name)) {
                Type type5;
                if (symbol == symbol2 || symbol2.kind != Kinds.Kind.MTH || !symbol2.isInheritedIn(type3.tsym, this.types) || (symbol2.flags() & 0x1000L) != 0L) continue;
                if (type4 == null) {
                    type4 = this.types.memberType(type, symbol);
                }
                if (this.types.overrideEquivalent(type4, type5 = this.types.memberType(type2, symbol2))) {
                    Type type6;
                    List<Type> list = type4.getTypeArguments();
                    List<Type> list2 = type5.getTypeArguments();
                    Type type7 = type4.getReturnType();
                    boolean bl = this.types.isSameType(type7, type6 = this.types.subst(type5.getReturnType(), list2, list)) || !type7.isPrimitiveOrVoid() && !type6.isPrimitiveOrVoid() && (this.types.covariantReturnType(type7, type6, this.types.noWarnings) || this.types.covariantReturnType(type6, type7, this.types.noWarnings)) || this.checkCommonOverriderIn(symbol, symbol2, type3);
                    if (bl) continue;
                    this.log.error(diagnosticPosition, "types.incompatible.diff.ret", type, type2, symbol2.name + "(" + this.types.memberType(type2, symbol2).getParameterTypes() + ")");
                    return symbol2;
                }
                if (!this.checkNameClash((Symbol.ClassSymbol)type3.tsym, symbol, symbol2) || this.checkCommonOverriderIn(symbol, symbol2, type3)) continue;
                this.log.error(diagnosticPosition, "name.clash.same.erasure.no.override", symbol, symbol.location(), symbol2, symbol2.location());
                return symbol2;
            }
        }
        return null;
    }

    boolean checkCommonOverriderIn(Symbol symbol, Symbol symbol2, Type type) {
        HashMap<Symbol.TypeSymbol, Type> hashMap = new HashMap<Symbol.TypeSymbol, Type>();
        Type type2 = this.types.memberType(type, symbol);
        Type type3 = this.types.memberType(type, symbol2);
        this.closure(type, hashMap);
        for (Type type4 : hashMap.values()) {
            for (Symbol symbol3 : type4.tsym.members().getSymbolsByName(symbol.name)) {
                Type type5;
                if (symbol3 == symbol || symbol3 == symbol2 || symbol3.kind != Kinds.Kind.MTH || (symbol3.flags() & 0x80001000L) != 0L || !this.types.overrideEquivalent(type5 = this.types.memberType(type, symbol3), type2) || !this.types.overrideEquivalent(type5, type3) || !this.types.returnTypeSubstitutable(type5, type2) || !this.types.returnTypeSubstitutable(type5, type3)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void checkOverride(Env<AttrContext> env, JCTree.JCMethodDecl jCMethodDecl, Symbol.MethodSymbol methodSymbol) {
        boolean bl;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        if ((classSymbol.flags() & 0x4000L) != 0L && this.names.finalize.equals(methodSymbol.name) && methodSymbol.overrides(this.syms.enumFinalFinalize, classSymbol, this.types, false)) {
            this.log.error(jCMethodDecl.pos(), "enum.no.finalize", new Object[0]);
            return;
        }
        Type type = classSymbol.type;
        while (type.hasTag(TypeTag.CLASS)) {
            if (type != classSymbol.type) {
                this.checkOverride((JCTree)jCMethodDecl, type, classSymbol, methodSymbol);
            }
            for (Type object : this.types.interfaces(type)) {
                this.checkOverride((JCTree)jCMethodDecl, object, classSymbol, methodSymbol);
            }
            type = this.types.supertype(type);
        }
        boolean bl2 = methodSymbol.attribute(this.syms.overrideType.tsym) != null;
        boolean bl3 = bl = bl2 || ((AttrContext)env.info).isAnonymousDiamond && !methodSymbol.isConstructor() && !methodSymbol.isPrivate();
        if (bl && !this.isOverrider(methodSymbol)) {
            void var7_12;
            JCDiagnostic.DiagnosticPosition diagnosticPosition = jCMethodDecl.pos();
            for (JCTree.JCAnnotation jCAnnotation : jCMethodDecl.getModifiers().annotations) {
                if (jCAnnotation.annotationType.type.tsym != this.syms.overrideType.tsym) continue;
                JCDiagnostic.DiagnosticPosition diagnosticPosition2 = jCAnnotation.pos();
                break;
            }
            this.log.error((JCDiagnostic.DiagnosticPosition)var7_12, bl2 ? CompilerProperties.Errors.MethodDoesNotOverrideSuperclass : CompilerProperties.Errors.AnonymousDiamondMethodDoesNotOverrideSuperclass(CompilerProperties.Fragments.DiamondAnonymousMethodsImplicitlyOverride));
        }
    }

    void checkOverride(JCTree jCTree, Type type, Symbol.ClassSymbol classSymbol, Symbol.MethodSymbol methodSymbol) {
        Symbol.TypeSymbol typeSymbol = type.tsym;
        for (Symbol symbol : typeSymbol.members().getSymbolsByName(methodSymbol.name)) {
            if (!methodSymbol.overrides(symbol, classSymbol, this.types, false) || (symbol.flags() & 0x400L) != 0L) continue;
            this.checkOverride(jCTree, methodSymbol, (Symbol.MethodSymbol)symbol, classSymbol);
        }
    }

    public void checkClassOverrideEqualsAndHashIfNeeded(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        List<Type> list;
        if (classSymbol == (Symbol.ClassSymbol)this.syms.objectType.tsym || classSymbol.isInterface() || classSymbol.isEnum() || (classSymbol.flags() & 0x2000L) != 0L || (classSymbol.flags() & 0x400L) != 0L) {
            return;
        }
        if (classSymbol.isAnonymous() && (list = this.types.interfaces(classSymbol.type)) != null && !list.isEmpty() && ((Type)list.head).tsym == this.syms.comparatorType.tsym) {
            return;
        }
        this.checkClassOverrideEqualsAndHash(diagnosticPosition, classSymbol);
    }

    private void checkClassOverrideEqualsAndHash(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        if (this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            boolean bl;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().findFirst(this.names.equals);
            Symbol.MethodSymbol methodSymbol2 = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().findFirst(this.names.hashCode);
            boolean bl2 = this.types.implementation((Symbol.MethodSymbol)methodSymbol, (Symbol.TypeSymbol)classSymbol, (boolean)false, this.equalsHasCodeFilter).owner == classSymbol;
            boolean bl3 = bl = this.types.implementation(methodSymbol2, classSymbol, false, this.equalsHasCodeFilter) != methodSymbol2;
            if (bl2 && !bl) {
                this.log.warning(Lint.LintCategory.OVERRIDES, diagnosticPosition, "override.equals.but.not.hashcode", classSymbol);
            }
        }
    }

    public void checkModuleName(JCTree.JCModuleDecl jCModuleDecl) {
        Name name = jCModuleDecl.sym.name;
        Assert.checkNonNull(name);
        if (this.lint.isEnabled(Lint.LintCategory.MODULE)) {
            JCTree.JCExpression jCExpression = jCModuleDecl.qualId;
            while (jCExpression != null) {
                int n;
                JCDiagnostic.DiagnosticPosition diagnosticPosition;
                Name name2;
                Object object;
                switch (jCExpression.getTag()) {
                    case SELECT: {
                        object = (JCTree.JCFieldAccess)jCExpression;
                        name2 = ((JCTree.JCFieldAccess)object).name;
                        diagnosticPosition = ((JCTree)object).pos();
                        jCExpression = ((JCTree.JCFieldAccess)object).selected;
                        break;
                    }
                    case IDENT: {
                        name2 = ((JCTree.JCIdent)jCExpression).name;
                        diagnosticPosition = jCExpression.pos();
                        jCExpression = null;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected qualified identifier: " + jCExpression.toString()));
                    }
                }
                if (name2 == null || (n = ((String)(object = name2.toString())).length()) <= 0 || !Character.isDigit(((String)object).charAt(n - 1))) continue;
                this.log.warning(Lint.LintCategory.MODULE, diagnosticPosition, CompilerProperties.Warnings.PoorChoiceForModuleName(name2));
            }
        }
    }

    private boolean checkNameClash(Symbol.ClassSymbol classSymbol, Symbol symbol, Symbol symbol2) {
        ClashFilter clashFilter = new ClashFilter(classSymbol.type);
        return clashFilter.accepts(symbol) && clashFilter.accepts(symbol2) && this.types.hasSameArgs(symbol.erasure(this.types), symbol2.erasure(this.types));
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        Symbol.MethodSymbol methodSymbol = this.types.firstUnimplementedAbstract(classSymbol);
        if (methodSymbol != null) {
            Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(methodSymbol.flags(), methodSymbol.name, this.types.memberType(classSymbol.type, methodSymbol), methodSymbol.owner);
            this.log.error(diagnosticPosition, "does.not.override.abstract", classSymbol, methodSymbol2, methodSymbol2.location());
        }
    }

    void checkNonCyclicDecl(JCTree.JCClassDecl jCClassDecl) {
        CycleChecker cycleChecker = new CycleChecker();
        cycleChecker.scan(jCClassDecl);
        if (!cycleChecker.errorFound && !cycleChecker.partialCheck) {
            jCClassDecl.sym.flags_field |= 0x40000000L;
        }
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkNonCyclicInternal(diagnosticPosition, type);
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type.TypeVar typeVar) {
        this.checkNonCyclic1(diagnosticPosition, typeVar, List.nil());
    }

    private void checkNonCyclic1(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type.TypeVar> list) {
        if (type.hasTag(TypeTag.TYPEVAR) && (type.tsym.flags() & 0x10000000L) != 0L) {
            return;
        }
        if (list.contains(type)) {
            Type.TypeVar typeVar = (Type.TypeVar)type;
            typeVar.bound = this.types.createErrorType(type);
            this.log.error(diagnosticPosition, "cyclic.inheritance", type);
        } else if (type.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar typeVar = (Type.TypeVar)type;
            list = list.prepend(typeVar);
            for (Type type2 : this.types.getBounds(typeVar)) {
                this.checkNonCyclic1(diagnosticPosition, type2, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        boolean bl = true;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        if ((typeSymbol.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(diagnosticPosition, (Symbol.ClassSymbol)typeSymbol);
        } else if (!typeSymbol.type.isErroneous()) {
            try {
                typeSymbol.flags_field |= 0x8000000L;
                if (typeSymbol.type.hasTag(TypeTag.CLASS)) {
                    List list;
                    Type.ClassType classType = (Type.ClassType)typeSymbol.type;
                    if (classType.interfaces_field != null) {
                        list = classType.interfaces_field;
                        while (list.nonEmpty()) {
                            bl &= this.checkNonCyclicInternal(diagnosticPosition, (Type)list.head);
                            list = list.tail;
                        }
                    }
                    if (classType.supertype_field != null && (list = classType.supertype_field) != null && ((Type)((Object)list)).hasTag(TypeTag.CLASS)) {
                        bl &= this.checkNonCyclicInternal(diagnosticPosition, (Type)((Object)list));
                    }
                    if (typeSymbol.owner.kind == Kinds.Kind.TYP) {
                        bl &= this.checkNonCyclicInternal(diagnosticPosition, typeSymbol.owner.type);
                    }
                }
            }
            finally {
                typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
        }
        if (bl) {
            boolean bl2 = bl = (typeSymbol.flags_field & 0x10000000L) == 0L && typeSymbol.isCompleted();
        }
        if (bl) {
            typeSymbol.flags_field |= 0x40000000L;
        }
        return bl;
    }

    private void noteCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        this.log.error(diagnosticPosition, "cyclic.inheritance", classSymbol);
        Object object = this.types.interfaces(classSymbol.type);
        while (((List)object).nonEmpty()) {
            ((List)object).head = this.types.createErrorType((Symbol.ClassSymbol)((Type)((List)object).head).tsym, Type.noType);
            object = ((List)object).tail;
        }
        object = this.types.supertype(classSymbol.type);
        if (((Type)object).hasTag(TypeTag.CLASS)) {
            ((Type.ClassType)classSymbol.type).supertype_field = this.types.createErrorType((Symbol.ClassSymbol)((Type)object).tsym, Type.noType);
        }
        classSymbol.type = this.types.createErrorType(classSymbol, classSymbol.type);
        classSymbol.flags_field |= 0x40000000L;
    }

    void checkImplementations(JCTree.JCClassDecl jCClassDecl) {
        this.checkImplementations(jCClassDecl, jCClassDecl.sym, jCClassDecl.sym);
    }

    void checkImplementations(JCTree jCTree, Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        List<Type> list = this.types.closure(classSymbol2.type);
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol3 = (Symbol.ClassSymbol)((Type)list.head).tsym;
            if ((classSymbol3.flags() & 0x400L) != 0L) {
                for (Symbol symbol : classSymbol3.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                    Symbol.MethodSymbol methodSymbol;
                    Symbol.MethodSymbol methodSymbol2;
                    if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 0x408L) != 1024L || (methodSymbol2 = (methodSymbol = (Symbol.MethodSymbol)symbol).implementation(classSymbol, this.types, false)) == null || methodSymbol2 == methodSymbol || (methodSymbol2.owner.flags() & 0x200L) != (classSymbol.flags() & 0x200L)) continue;
                    this.checkOverride(jCTree, methodSymbol2, methodSymbol, classSymbol);
                }
            }
            list = list.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        List<Type> list = this.types.interfaces(type);
        Type type2 = this.types.supertype(type);
        if (type2.hasTag(TypeTag.CLASS) && (type2.tsym.flags() & 0x400L) != 0L) {
            list = list.prepend(type2);
        }
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (!((Type)list2.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(diagnosticPosition, (Type)list2.head, (Type)list2.head, type)) {
                return;
            }
            List<Type> list3 = list;
            while (list3 != list2) {
                if (!this.checkCompatibleAbstracts(diagnosticPosition, (Type)list2.head, (Type)list3.head, type)) {
                    return;
                }
                list3 = list3.tail;
            }
            list2 = list2.tail;
        }
        this.checkCompatibleConcretes(diagnosticPosition, type);
    }

    void checkConflicts(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol.TypeSymbol typeSymbol) {
        Type type = typeSymbol.type;
        while (type != Type.noType) {
            for (Symbol symbol2 : type.tsym.members().getSymbolsByName(symbol.name, Scope.LookupKind.NON_RECURSIVE)) {
                if (symbol.kind != symbol2.kind || !this.types.isSameType(this.types.erasure(symbol.type), this.types.erasure(symbol2.type)) || symbol == symbol2 || (symbol.flags() & 0x1000L) == (symbol2.flags() & 0x1000L) || (symbol.flags() & 0x80000000L) != 0L || (symbol2.flags() & 0x80000000L) != 0L) continue;
                this.syntheticError(diagnosticPosition, (symbol2.flags() & 0x1000L) == 0L ? symbol2 : symbol);
                return;
            }
            type = this.types.supertype(type);
        }
    }

    void checkOverrideClashes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Symbol.MethodSymbol methodSymbol) {
        ClashFilter clashFilter = new ClashFilter(type);
        List<Symbol.MethodSymbol> list = List.nil();
        boolean bl = false;
        for (Symbol symbol : this.types.membersClosure(type, false).getSymbolsByName(methodSymbol.name, clashFilter)) {
            if (!methodSymbol.overrides(symbol, type.tsym, this.types, false)) {
                if (symbol == methodSymbol || bl) continue;
                list = list.prepend((Symbol.MethodSymbol)symbol);
                continue;
            }
            if (symbol != methodSymbol) {
                bl = true;
                list = List.nil();
            }
            for (Symbol symbol2 : this.types.membersClosure(type, false).getSymbolsByName(methodSymbol.name, clashFilter)) {
                if (symbol2 == symbol || this.types.isSubSignature(methodSymbol.type, this.types.memberType(type, symbol2), this.allowStrictMethodClashCheck) || !this.types.hasSameArgs(symbol2.erasure(this.types), symbol.erasure(this.types))) continue;
                methodSymbol.flags_field |= 0x40000000000L;
                String string = symbol == methodSymbol ? "name.clash.same.erasure.no.override" : "name.clash.same.erasure.no.override.1";
                this.log.error(diagnosticPosition, string, methodSymbol, methodSymbol.location(), symbol2, symbol2.location(), symbol, symbol.location());
                return;
            }
        }
        if (!bl) {
            for (Symbol.MethodSymbol methodSymbol2 : list) {
                this.checkPotentiallyAmbiguousOverloads(diagnosticPosition, type, methodSymbol, methodSymbol2);
            }
        }
    }

    void checkHideClashes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Symbol.MethodSymbol methodSymbol) {
        ClashFilter clashFilter = new ClashFilter(type);
        for (Symbol symbol : this.types.membersClosure(type, true).getSymbolsByName(methodSymbol.name, clashFilter)) {
            if (this.types.isSubSignature(methodSymbol.type, this.types.memberType(type, symbol), this.allowStrictMethodClashCheck)) continue;
            if (this.types.hasSameArgs(symbol.erasure(this.types), methodSymbol.erasure(this.types))) {
                this.log.error(diagnosticPosition, "name.clash.same.erasure.no.hide", methodSymbol, methodSymbol.location(), symbol, symbol.location());
                return;
            }
            this.checkPotentiallyAmbiguousOverloads(diagnosticPosition, type, methodSymbol, (Symbol.MethodSymbol)symbol);
        }
    }

    void checkDefaultMethodClashes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        DefaultMethodClashFilter defaultMethodClashFilter = new DefaultMethodClashFilter(type);
        block0: for (Symbol symbol : this.types.membersClosure(type, false).getSymbols(defaultMethodClashFilter)) {
            Assert.check(symbol.kind == Kinds.Kind.MTH);
            List<Symbol.MethodSymbol> list = this.types.interfaceCandidates(type, (Symbol.MethodSymbol)symbol);
            if (list.size() <= 1) continue;
            ListBuffer<Object> listBuffer = new ListBuffer<Symbol.MethodSymbol>();
            ListBuffer<Object> listBuffer2 = new ListBuffer<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol methodSymbol : list) {
                Symbol symbol2;
                String string;
                if ((methodSymbol.flags() & 0x80000000000L) != 0L) {
                    listBuffer2 = listBuffer2.append(methodSymbol);
                } else if ((methodSymbol.flags() & 0x400L) != 0L) {
                    listBuffer = listBuffer.append(methodSymbol);
                }
                if (!listBuffer2.nonEmpty() || listBuffer2.size() + listBuffer.size() < 2) continue;
                Symbol symbol3 = (Symbol)listBuffer2.first();
                if (listBuffer2.size() > 1) {
                    string = "types.incompatible.unrelated.defaults";
                    symbol2 = (Symbol)listBuffer2.toList().tail.head;
                } else {
                    string = "types.incompatible.abstract.default";
                    symbol2 = (Symbol)listBuffer.first();
                }
                this.log.error(diagnosticPosition, string, Kinds.kindName(type.tsym), type, symbol.name, this.types.memberType(type, symbol).getParameterTypes(), symbol3.location(), symbol2.location());
                continue block0;
            }
        }
    }

    void checkPotentiallyAmbiguousOverloads(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        if (methodSymbol != methodSymbol2 && this.allowDefaultMethods && this.lint.isEnabled(Lint.LintCategory.OVERLOADS) && (methodSymbol.flags() & 0x1000000000000L) == 0L && (methodSymbol2.flags() & 0x1000000000000L) == 0L) {
            Type type2 = this.types.memberType(type, methodSymbol);
            Type type3 = this.types.memberType(type, methodSymbol2);
            if (type2.hasTag(TypeTag.FORALL) && type3.hasTag(TypeTag.FORALL) && this.types.hasSameBounds((Type.ForAll)type2, (Type.ForAll)type3)) {
                type3 = this.types.subst(type3, ((Type.ForAll)type3).tvars, ((Type.ForAll)type2).tvars);
            }
            int n = Math.max(type2.getParameterTypes().length(), type3.getParameterTypes().length());
            List<Type> list = this.rs.adjustArgs(type2.getParameterTypes(), methodSymbol, n, true);
            List<Type> list2 = this.rs.adjustArgs(type3.getParameterTypes(), methodSymbol2, n, true);
            if (list.length() != list2.length()) {
                return;
            }
            boolean bl = false;
            while (list.nonEmpty() && list2.nonEmpty()) {
                Type type4 = (Type)list2.head;
                Type type5 = (Type)list.head;
                if (!this.types.isSubtype(type4, type5) && !this.types.isSubtype(type5, type4)) {
                    if (!this.types.isFunctionalInterface(type5) || !this.types.isFunctionalInterface(type4) || this.types.findDescriptorType(type5).getParameterTypes().length() <= 0 || this.types.findDescriptorType(type5).getParameterTypes().length() != this.types.findDescriptorType(type4).getParameterTypes().length()) break;
                    bl = true;
                }
                list = list.tail;
                list2 = list2.tail;
            }
            if (bl) {
                methodSymbol.flags_field |= 0x1000000000000L;
                methodSymbol2.flags_field |= 0x1000000000000L;
                this.log.warning(Lint.LintCategory.OVERLOADS, diagnosticPosition, "potentially.ambiguous.overload", methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
                return;
            }
        }
    }

    void checkAccessFromSerializableElement(JCTree jCTree, boolean bl) {
        if (this.warnOnAnyAccessToMembers || this.lint.isEnabled(Lint.LintCategory.SERIAL) && !this.lint.isSuppressed(Lint.LintCategory.SERIAL) && bl) {
            Symbol symbol = TreeInfo.symbol(jCTree);
            if (!symbol.kind.matches(Kinds.KindSelector.VAL_MTH)) {
                return;
            }
            if (symbol.kind == Kinds.Kind.VAR && ((symbol.flags() & 0x200000000L) != 0L || symbol.isLocal() || symbol.name == this.names._this || symbol.name == this.names._super)) {
                return;
            }
            if (!this.types.isSubtype(symbol.owner.type, this.syms.serializableType) && this.isEffectivelyNonPublic(symbol)) {
                if (bl) {
                    if (this.belongsToRestrictedPackage(symbol)) {
                        this.log.warning(Lint.LintCategory.SERIAL, jCTree.pos(), "access.to.member.from.serializable.lambda", symbol);
                    }
                } else {
                    this.log.warning(jCTree.pos(), "access.to.member.from.serializable.element", symbol);
                }
            }
        }
    }

    private boolean isEffectivelyNonPublic(Symbol symbol) {
        if (symbol.packge() == this.syms.rootPackage) {
            return false;
        }
        while (symbol.kind != Kinds.Kind.PCK) {
            if ((symbol.flags() & 1L) == 0L) {
                return true;
            }
            symbol = symbol.owner;
        }
        return false;
    }

    private boolean belongsToRestrictedPackage(Symbol symbol) {
        String string = symbol.packge().fullname.toString();
        return string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun.") || string.contains(".internal.");
    }

    private void syntheticError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (!symbol.type.isErroneous()) {
            this.log.error(diagnosticPosition, "synthetic.name.conflict", symbol, symbol.location());
        }
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkClassBounds(diagnosticPosition, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition diagnosticPosition, Map<Symbol.TypeSymbol, Type> map, Type type) {
        if (type.isErroneous()) {
            return;
        }
        Object object = this.types.interfaces(type);
        while (((List)object).nonEmpty()) {
            List<Type> list;
            List<Type> list2;
            Type type2 = (Type)((List)object).head;
            Type type3 = map.put(type2.tsym, type2);
            if (type3 != null && !this.types.containsTypeEquivalent(list2 = type3.allparams(), list = type2.allparams())) {
                this.log.error(diagnosticPosition, "cant.inherit.diff.arg", type2.tsym, Type.toString(list2), Type.toString(list));
            }
            this.checkClassBounds(diagnosticPosition, map, type2);
            object = ((List)object).tail;
        }
        object = this.types.supertype(type);
        if (object != Type.noType) {
            this.checkClassBounds(diagnosticPosition, map, (Type)object);
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Set<Type> set) {
        if (set.contains(type)) {
            this.log.error(diagnosticPosition, "repeated.interface", new Object[0]);
        } else {
            set.add(type);
        }
    }

    void validateAnnotationTree(JCTree jCTree) {
        class AnnotationValidator
        extends TreeScanner {
            AnnotationValidator() {
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
                if (!jCAnnotation.type.isErroneous()) {
                    super.visitAnnotation(jCAnnotation);
                    Check.this.validateAnnotation(jCAnnotation);
                }
            }
        }
        jCTree.accept(new AnnotationValidator());
    }

    void validateAnnotationType(JCTree jCTree) {
        if (jCTree != null) {
            this.validateAnnotationType(jCTree.pos(), jCTree.type);
        }
    }

    void validateAnnotationType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.cvarLowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(diagnosticPosition, this.types.elemtype(type));
            return;
        }
        this.log.error(diagnosticPosition, "invalid.annotation.member.type", new Object[0]);
    }

    void validateAnnotationMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.MethodSymbol methodSymbol) {
        Type type = this.syms.annotationType;
        while (type.hasTag(TypeTag.CLASS)) {
            Scope.WriteableScope writeableScope = type.tsym.members();
            for (Symbol symbol : writeableScope.getSymbolsByName(methodSymbol.name)) {
                if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 5L) == 0L || !this.types.overrideEquivalent(methodSymbol.type, symbol.type)) continue;
                this.log.error(diagnosticPosition, "intf.annotation.member.clash", symbol, type);
            }
            type = this.types.supertype(type);
        }
    }

    public void validateAnnotations(List<JCTree.JCAnnotation> list, Symbol symbol) {
        for (JCTree.JCAnnotation jCAnnotation : list) {
            this.validateAnnotation(jCAnnotation, symbol);
        }
    }

    public void validateTypeAnnotations(List<JCTree.JCAnnotation> list, boolean bl) {
        for (JCTree.JCAnnotation jCAnnotation : list) {
            this.validateTypeAnnotation(jCAnnotation, bl);
        }
    }

    private void validateAnnotation(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        this.validateAnnotationTree(jCAnnotation);
        if (jCAnnotation.type.tsym.isAnnotationType() && !this.annotationApplicable(jCAnnotation, symbol)) {
            this.log.error(jCAnnotation.pos(), "annotation.type.not.applicable", new Object[0]);
        }
        if (jCAnnotation.annotationType.type.tsym == this.syms.functionalInterfaceType.tsym) {
            if (symbol.kind != Kinds.Kind.TYP) {
                this.log.error(jCAnnotation.pos(), "bad.functional.intf.anno", new Object[0]);
            } else if (!symbol.isInterface() || (symbol.flags() & 0x2000L) != 0L) {
                this.log.error(jCAnnotation.pos(), "bad.functional.intf.anno.1", this.diags.fragment("not.a.functional.intf", symbol));
            }
        }
    }

    public void validateTypeAnnotation(JCTree.JCAnnotation jCAnnotation, boolean bl) {
        Assert.checkNonNull(jCAnnotation.type);
        this.validateAnnotationTree(jCAnnotation);
        if (jCAnnotation.hasTag(JCTree.Tag.TYPE_ANNOTATION) && !jCAnnotation.annotationType.type.isErroneous() && !this.isTypeAnnotation(jCAnnotation, bl)) {
            this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicableToType(jCAnnotation.type));
        }
    }

    public void validateRepeatable(Symbol.TypeSymbol typeSymbol, Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Assert.check(this.types.isSameType(compound.type, this.syms.repeatableType));
        Type type = null;
        List<Pair<Symbol.MethodSymbol, Attribute>> list = compound.values;
        if (!list.isEmpty()) {
            Assert.check(((Symbol.MethodSymbol)((Pair)list.head).fst).name == this.names.value);
            type = ((Attribute.Class)((Pair)list.head).snd).getValue();
        }
        if (type == null) {
            return;
        }
        this.validateValue(type.tsym, typeSymbol, diagnosticPosition);
        this.validateRetention(type.tsym, typeSymbol, diagnosticPosition);
        this.validateDocumented(type.tsym, typeSymbol, diagnosticPosition);
        this.validateInherited(type.tsym, typeSymbol, diagnosticPosition);
        this.validateTarget(type.tsym, typeSymbol, diagnosticPosition);
        this.validateDefault(type.tsym, diagnosticPosition);
    }

    private void validateValue(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Symbol symbol = typeSymbol.members().findFirst(this.names.value);
        if (symbol != null && symbol.kind == Kinds.Kind.MTH) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            Type type = methodSymbol.getReturnType();
            if (!type.hasTag(TypeTag.ARRAY) || !this.types.isSameType(((Type.ArrayType)type).elemtype, typeSymbol2.type)) {
                this.log.error(diagnosticPosition, "invalid.repeatable.annotation.value.return", typeSymbol, type, this.types.makeArrayType(typeSymbol2.type));
            }
        } else {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.no.value", typeSymbol);
        }
    }

    private void validateRetention(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Attribute.RetentionPolicy retentionPolicy = this.types.getRetention(typeSymbol);
        Attribute.RetentionPolicy retentionPolicy2 = this.types.getRetention(typeSymbol2);
        boolean bl = false;
        switch (retentionPolicy2) {
            case RUNTIME: {
                if (retentionPolicy == Attribute.RetentionPolicy.RUNTIME) break;
                bl = true;
                break;
            }
            case CLASS: {
                if (retentionPolicy != Attribute.RetentionPolicy.SOURCE) break;
                bl = true;
            }
        }
        if (bl) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.retention", new Object[]{typeSymbol, retentionPolicy, typeSymbol2, retentionPolicy2});
        }
    }

    private void validateDocumented(Symbol symbol, Symbol symbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (symbol2.attribute(this.syms.documentedType.tsym) != null && symbol.attribute(this.syms.documentedType.tsym) == null) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.not.documented", symbol, symbol2);
        }
    }

    private void validateInherited(Symbol symbol, Symbol symbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (symbol2.attribute(this.syms.inheritedType.tsym) != null && symbol.attribute(this.syms.inheritedType.tsym) == null) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.not.inherited", symbol, symbol2);
        }
    }

    private void validateTarget(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Object object;
        Set<Name> set;
        Attribute.Array array = this.getAttributeTargetAttribute(typeSymbol);
        if (array == null) {
            set = this.getDefaultTargetSet();
        } else {
            set = new HashSet<Name>();
            for (Attribute attribute : array.values) {
                if (!(attribute instanceof Attribute.Enum)) continue;
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                set.add(enum_.value.name);
            }
        }
        Attribute.Array array2 = this.getAttributeTargetAttribute(typeSymbol2);
        if (array2 == null) {
            object = this.getDefaultTargetSet();
        } else {
            object = new HashSet();
            for (Attribute attribute : array2.values) {
                if (!(attribute instanceof Attribute.Enum)) continue;
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                object.add(enum_.value.name);
            }
        }
        if (!this.isTargetSubsetOf(set, (Set<Name>)object)) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.incompatible.target", typeSymbol, typeSymbol2);
        }
    }

    private Set<Name> getDefaultTargetSet() {
        if (this.defaultTargets == null) {
            HashSet<Name> hashSet = new HashSet<Name>();
            hashSet.add(this.names.ANNOTATION_TYPE);
            hashSet.add(this.names.CONSTRUCTOR);
            hashSet.add(this.names.FIELD);
            hashSet.add(this.names.LOCAL_VARIABLE);
            hashSet.add(this.names.METHOD);
            hashSet.add(this.names.PACKAGE);
            hashSet.add(this.names.PARAMETER);
            hashSet.add(this.names.TYPE);
            this.defaultTargets = Collections.unmodifiableSet(hashSet);
        }
        return this.defaultTargets;
    }

    private boolean isTargetSubsetOf(Set<Name> set, Set<Name> set2) {
        for (Name name : set) {
            boolean bl = false;
            for (Name name2 : set2) {
                if (name2 == name) {
                    bl = true;
                    break;
                }
                if (name2 == this.names.TYPE && name == this.names.ANNOTATION_TYPE) {
                    bl = true;
                    break;
                }
                if (name2 != this.names.TYPE_USE || name != this.names.TYPE && name != this.names.ANNOTATION_TYPE && name != this.names.TYPE_PARAMETER) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void validateDefault(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Scope.WriteableScope writeableScope = symbol.members();
        for (Symbol symbol2 : writeableScope.getSymbols()) {
            if (symbol2.name == this.names.value || symbol2.kind != Kinds.Kind.MTH || ((Symbol.MethodSymbol)symbol2).defaultValue != null) continue;
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.elem.nondefault", symbol, symbol2);
        }
    }

    boolean isOverrider(Symbol symbol) {
        if (symbol.kind != Kinds.Kind.MTH || symbol.isStatic()) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)methodSymbol.owner;
        for (Type type : this.types.closure(typeSymbol.type)) {
            if (type == typeSymbol.type) continue;
            Scope.WriteableScope writeableScope = type.tsym.members();
            for (Symbol symbol2 : writeableScope.getSymbolsByName(methodSymbol.name)) {
                if (symbol2.isStatic() || !methodSymbol.overrides(symbol2, typeSymbol, this.types, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTypeAnnotation(JCTree.JCAnnotation jCAnnotation, boolean bl) {
        List<Attribute> list = this.typeAnnotations.annotationTargets(jCAnnotation.annotationType.type.tsym);
        return list == null ? false : list.stream().anyMatch(attribute -> this.isTypeAnnotation((Attribute)attribute, bl));
    }

    boolean isTypeAnnotation(Attribute attribute, boolean bl) {
        Attribute.Enum enum_ = (Attribute.Enum)attribute;
        return enum_.value.name == this.names.TYPE_USE || bl && enum_.value.name == this.names.TYPE_PARAMETER;
    }

    boolean annotationApplicable(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        Name[] nameArray;
        Attribute.Array array = this.getAttributeTargetAttribute(jCAnnotation.annotationType.type.tsym);
        if (array == null) {
            nameArray = this.defaultTargetMetaInfo(jCAnnotation, symbol);
        } else {
            nameArray = new Name[array.values.length];
            for (int i = 0; i < array.values.length; ++i) {
                Attribute attribute = array.values[i];
                if (!(attribute instanceof Attribute.Enum)) {
                    return true;
                }
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                nameArray[i] = enum_.value.name;
            }
        }
        for (Name name : nameArray) {
            if (name == this.names.TYPE) {
                if (symbol.kind != Kinds.Kind.TYP) continue;
                return true;
            }
            if (name == this.names.FIELD) {
                if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind == Kinds.Kind.MTH) continue;
                return true;
            }
            if (name == this.names.METHOD) {
                if (symbol.kind != Kinds.Kind.MTH || symbol.isConstructor()) continue;
                return true;
            }
            if (name == this.names.PARAMETER) {
                if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind != Kinds.Kind.MTH || (symbol.flags() & 0x200000000L) == 0L) continue;
                return true;
            }
            if (name == this.names.CONSTRUCTOR) {
                if (symbol.kind != Kinds.Kind.MTH || !symbol.isConstructor()) continue;
                return true;
            }
            if (name == this.names.LOCAL_VARIABLE) {
                if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind != Kinds.Kind.MTH || (symbol.flags() & 0x200000000L) != 0L) continue;
                return true;
            }
            if (name == this.names.ANNOTATION_TYPE) {
                if (symbol.kind != Kinds.Kind.TYP || (symbol.flags() & 0x2000L) == 0L) continue;
                return true;
            }
            if (name == this.names.PACKAGE) {
                if (symbol.kind != Kinds.Kind.PCK) continue;
                return true;
            }
            if (name == this.names.TYPE_USE) {
                if (symbol.kind != Kinds.Kind.TYP && symbol.kind != Kinds.Kind.VAR && (symbol.kind != Kinds.Kind.MTH || symbol.isConstructor() || symbol.type.getReturnType().hasTag(TypeTag.VOID)) && (symbol.kind != Kinds.Kind.MTH || !symbol.isConstructor())) continue;
                return true;
            }
            if (name == this.names.TYPE_PARAMETER) {
                if (symbol.kind != Kinds.Kind.TYP || !symbol.type.hasTag(TypeTag.TYPEVAR)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    Attribute.Array getAttributeTargetAttribute(Symbol.TypeSymbol typeSymbol) {
        Attribute.Compound compound = typeSymbol.getAnnotationTypeMetadata().getTarget();
        if (compound == null) {
            return null;
        }
        Attribute attribute = compound.member(this.names.value);
        if (!(attribute instanceof Attribute.Array)) {
            return null;
        }
        return (Attribute.Array)attribute;
    }

    private Name[] defaultTargetMetaInfo(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        return this.dfltTargetMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAnnotationDeferErrors(JCTree.JCAnnotation jCAnnotation) {
        boolean bl = false;
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            bl = this.validateAnnotation(jCAnnotation);
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
        return bl;
    }

    private boolean validateAnnotation(JCTree.JCAnnotation jCAnnotation) {
        Object object;
        boolean bl = true;
        Annotate.AnnotationTypeMetadata annotationTypeMetadata = jCAnnotation.annotationType.type.tsym.getAnnotationTypeMetadata();
        Set<Symbol.MethodSymbol> set = annotationTypeMetadata.getAnnotationElements();
        for (JCTree object22 : jCAnnotation.args) {
            if (!object22.hasTag(JCTree.Tag.ASSIGN)) continue;
            object = (JCTree.JCAssign)object22;
            Symbol symbol = TreeInfo.symbol(((JCTree.JCAssign)object).lhs);
            if (symbol == null || symbol.type.isErroneous() || set.remove(symbol)) continue;
            bl = false;
            this.log.error(((JCTree.JCAssign)object).lhs.pos(), "duplicate.annotation.member.value", symbol.name, jCAnnotation.type);
        }
        List<Name> list = List.nil();
        Set<Symbol.MethodSymbol> set2 = annotationTypeMetadata.getAnnotationElementsWithDefault();
        for (Symbol.MethodSymbol methodSymbol : set) {
            if (methodSymbol.type.isErroneous() || set2.contains(methodSymbol)) continue;
            list = list.append(methodSymbol.name);
        }
        if ((list = list.reverse()).nonEmpty()) {
            bl = false;
            object = list.size() > 1 ? "annotation.missing.default.value.1" : "annotation.missing.default.value";
            this.log.error(jCAnnotation.pos(), (String)object, jCAnnotation.type, list);
        }
        return bl && this.validateTargetAnnotationValue(jCAnnotation);
    }

    boolean validateTargetAnnotationValue(JCTree.JCAnnotation jCAnnotation) {
        if (jCAnnotation.annotationType.type.tsym != this.syms.annotationTargetType.tsym || jCAnnotation.args.tail == null) {
            return true;
        }
        boolean bl = true;
        if (!((JCTree.JCExpression)jCAnnotation.args.head).hasTag(JCTree.Tag.ASSIGN)) {
            return false;
        }
        JCTree.JCAssign jCAssign = (JCTree.JCAssign)jCAnnotation.args.head;
        Symbol symbol = TreeInfo.symbol(jCAssign.lhs);
        if (symbol.name != this.names.value) {
            return false;
        }
        JCTree.JCExpression jCExpression = jCAssign.rhs;
        if (!jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
            return false;
        }
        JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        for (JCTree jCTree : jCNewArray.elems) {
            if (hashSet.add(TreeInfo.symbol(jCTree))) continue;
            bl = false;
            this.log.error(jCTree.pos(), "repeated.annotation.target", new Object[0]);
        }
        return bl;
    }

    void checkDeprecatedAnnotation(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && symbol.isDeprecatableViaAnnotation() && (symbol.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && symbol.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(Lint.LintCategory.DEP_ANN, diagnosticPosition, "missing.deprecated.annotation", new Object[0]);
        }
        if (this.lint.isEnabled(Lint.LintCategory.DEPRECATION) && !symbol.isDeprecatableViaAnnotation() && !this.syms.deprecatedType.isErroneous() && symbol.attribute(this.syms.deprecatedType.tsym) != null) {
            this.log.warning(Lint.LintCategory.DEPRECATION, diagnosticPosition, "deprecated.annotation.has.no.effect", Kinds.kindName(symbol));
        }
    }

    void checkDeprecated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        if ((symbol2.isDeprecatedForRemoval() || symbol2.isDeprecated() && !symbol.isDeprecated()) && (symbol2.outermostClass() != symbol.outermostClass() || symbol2.outermostClass() == null)) {
            this.deferredLintHandler.report(() -> this.warnDeprecated(diagnosticPosition, symbol2));
        }
    }

    void checkSunAPI(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if ((symbol.flags() & 0x4000000000L) != 0L) {
            this.deferredLintHandler.report(() -> this.log.mandatoryWarning(diagnosticPosition, "sun.proprietary", symbol));
        }
    }

    void checkProfile(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (this.profile != Profile.DEFAULT && (symbol.flags() & 0x200000000000L) != 0L) {
            this.log.error(diagnosticPosition, "not.in.profile", new Object[]{symbol, this.profile});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(JCTree.JCClassDecl jCClassDecl) {
        if ((jCClassDecl.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        Assert.check((jCClassDecl.sym.flags_field & 0x8000000L) == 0L);
        try {
            jCClassDecl.sym.flags_field |= 0x8000000L;
            for (JCTree jCTree : jCClassDecl.defs) {
                if (!jCTree.hasTag(JCTree.Tag.METHODDEF)) continue;
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                this.checkAnnotationResType(jCMethodDecl.pos(), jCMethodDecl.restype.type);
            }
        }
        finally {
            jCClassDecl.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            jCClassDecl.sym.flags_field |= 0x800000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if ((typeSymbol.flags_field & 0x800000000L) != 0L) {
            return;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.log.error(diagnosticPosition, "cyclic.annotation.element", new Object[0]);
            return;
        }
        try {
            typeSymbol.flags_field |= 0x8000000L;
            for (Symbol symbol : typeSymbol.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (symbol.kind != Kinds.Kind.MTH) continue;
                this.checkAnnotationResType(diagnosticPosition, ((Symbol.MethodSymbol)symbol).type.getReturnType());
            }
        }
        finally {
            typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            typeSymbol.flags_field |= 0x800000000L;
        }
    }

    void checkAnnotationResType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.getTag()) {
            case CLASS: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(diagnosticPosition, type.tsym);
                break;
            }
            case ARRAY: {
                this.checkAnnotationResType(diagnosticPosition, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(JCTree.JCClassDecl jCClassDecl) {
        HashMap<Symbol, Symbol> hashMap = new HashMap<Symbol, Symbol>();
        Object object = jCClassDecl.defs;
        while (object.nonEmpty()) {
            Symbol[] symbolArray = TreeInfo.firstConstructorCall((JCTree)object.head);
            if (symbolArray != null) {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)object.head;
                if (TreeInfo.name(symbolArray.meth) == this.names._this) {
                    hashMap.put(jCMethodDecl.sym, TreeInfo.symbol(symbolArray.meth));
                } else {
                    jCMethodDecl.sym.flags_field |= 0x40000000L;
                }
            }
            object = object.tail;
        }
        object = new Symbol[]{};
        for (Symbol symbol : object = hashMap.keySet().toArray((T[])object)) {
            this.checkCyclicConstructor(jCClassDecl, symbol, hashMap);
        }
    }

    private void checkCyclicConstructor(JCTree.JCClassDecl jCClassDecl, Symbol symbol, Map<Symbol, Symbol> map) {
        if (symbol != null && (symbol.flags_field & 0x40000000L) == 0L) {
            if ((symbol.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(symbol, jCClassDecl), "recursive.ctor.invocation", new Object[0]);
            } else {
                symbol.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(jCClassDecl, map.remove(symbol), map);
                symbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            symbol.flags_field |= 0x40000000L;
        }
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type) {
        int n;
        if (type.constValue() != null && type.getTag().isSubRangeOf(TypeTag.LONG) && ((Number)type.constValue()).longValue() == 0L && ((n = ((Symbol.OperatorSymbol)symbol).opcode) == 108 || n == 112 || n == 109 || n == 113)) {
            this.deferredLintHandler.report(() -> this.warnDivZero(diagnosticPosition));
        }
    }

    void checkEmptyIf(JCTree.JCIf jCIf) {
        if (jCIf.thenpart.hasTag(JCTree.Tag.SKIP) && jCIf.elsepart == null && this.lint.isEnabled(Lint.LintCategory.EMPTY)) {
            this.log.warning(Lint.LintCategory.EMPTY, jCIf.thenpart.pos(), "empty.if", new Object[0]);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Scope scope) {
        if (symbol.type.isErroneous()) {
            return true;
        }
        if (symbol.owner.name == this.names.any) {
            return false;
        }
        for (Symbol symbol2 : scope.getSymbolsByName(symbol.name, Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol == symbol2 || (symbol2.flags() & 0x40000000000L) != 0L || symbol.kind != symbol2.kind || symbol.name == this.names.error || symbol.kind == Kinds.Kind.MTH && !this.types.hasSameArgs(symbol.type, symbol2.type) && !this.types.hasSameArgs(this.types.erasure(symbol.type), this.types.erasure(symbol2.type))) continue;
            if ((symbol.flags() & 0x400000000L) != (symbol2.flags() & 0x400000000L)) {
                this.varargsDuplicateError(diagnosticPosition, symbol, symbol2);
                return true;
            }
            if (symbol.kind == Kinds.Kind.MTH && !this.types.hasSameArgs(symbol.type, symbol2.type, false)) {
                this.duplicateErasureError(diagnosticPosition, symbol, symbol2);
                symbol.flags_field |= 0x40000000000L;
                return true;
            }
            this.duplicateError(diagnosticPosition, symbol2);
            return false;
        }
        return true;
    }

    void duplicateErasureError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        if (!symbol.type.isErroneous() && !symbol2.type.isErroneous()) {
            this.log.error(diagnosticPosition, "name.clash.same.erasure", symbol, symbol2);
        }
    }

    void checkImportsUnique(JCTree.JCCompilationUnit jCCompilationUnit) {
        Scope.WriteableScope writeableScope = Scope.WriteableScope.create(jCCompilationUnit.packge);
        Scope.WriteableScope writeableScope2 = Scope.WriteableScope.create(jCCompilationUnit.packge);
        Scope.WriteableScope writeableScope3 = jCCompilationUnit.toplevelScope;
        for (JCTree jCTree : jCCompilationUnit.defs) {
            if (!jCTree.hasTag(JCTree.Tag.IMPORT)) continue;
            JCTree.JCImport jCImport = (JCTree.JCImport)jCTree;
            if (jCImport.importScope == null) continue;
            for (Symbol symbol2 : jCImport.importScope.getSymbols(symbol -> symbol.kind == Kinds.Kind.TYP)) {
                if (jCImport.isStatic()) {
                    this.checkUniqueImport(jCImport.pos(), writeableScope, writeableScope2, writeableScope3, symbol2, true);
                    writeableScope2.enter(symbol2);
                    continue;
                }
                this.checkUniqueImport(jCImport.pos(), writeableScope, writeableScope2, writeableScope3, symbol2, false);
                writeableScope.enter(symbol2);
            }
            jCImport.importScope = null;
        }
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition diagnosticPosition, Scope scope, Scope scope2, Scope scope3, Symbol symbol, boolean bl) {
        Filter<Symbol> filter = symbol2 -> symbol2 != symbol && !symbol2.type.isErroneous();
        Symbol symbol3 = scope.findFirst(symbol.name, filter);
        if (symbol3 == null && !bl) {
            symbol3 = scope2.findFirst(symbol.name, filter);
        }
        if (symbol3 != null) {
            if (bl) {
                this.log.error(diagnosticPosition, "already.defined.static.single.import", symbol3);
            } else {
                this.log.error(diagnosticPosition, "already.defined.single.import", symbol3);
            }
            return false;
        }
        symbol3 = scope3.findFirst(symbol.name, filter);
        if (symbol3 != null) {
            this.log.error(diagnosticPosition, "already.defined.this.unit", symbol3);
            return false;
        }
        return true;
    }

    public void checkCanonical(JCTree jCTree) {
        if (!this.isCanonical(jCTree)) {
            this.log.error(jCTree.pos(), "import.requires.canonical", TreeInfo.symbol(jCTree));
        }
    }

    private boolean isCanonical(JCTree jCTree) {
        while (jCTree.hasTag(JCTree.Tag.SELECT)) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
            if (jCFieldAccess.sym.owner.getQualifiedName() != TreeInfo.symbol(jCFieldAccess.selected).getQualifiedName()) {
                return false;
            }
            jCTree = jCFieldAccess.selected;
        }
        return true;
    }

    void checkForBadAuxiliaryClassAccess(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Symbol.ClassSymbol classSymbol) {
        if (this.lint.isEnabled(Lint.LintCategory.AUXILIARYCLASS) && (classSymbol.flags() & 0x100000000000L) != 0L && this.rs.isAccessible(env, classSymbol) && !this.fileManager.isSameFile(classSymbol.sourcefile, env.toplevel.sourcefile)) {
            this.log.warning(diagnosticPosition, "auxiliary.class.accessed.from.outside.of.its.source.file", classSymbol, classSymbol.sourcefile);
        }
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return new ConversionWarner(diagnosticPosition, "unchecked.cast.to.type", type, type2);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return new ConversionWarner(diagnosticPosition, "unchecked.assign", type, type2);
    }

    public void checkFunctionalInterface(JCTree.JCClassDecl jCClassDecl, Symbol.ClassSymbol classSymbol) {
        Attribute.Compound compound = classSymbol.attribute(this.syms.functionalInterfaceType.tsym);
        if (compound != null) {
            try {
                this.types.findDescriptorSymbol(classSymbol);
            }
            catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                JCDiagnostic.DiagnosticPosition diagnosticPosition = jCClassDecl.pos();
                for (JCTree.JCAnnotation jCAnnotation : jCClassDecl.getModifiers().annotations) {
                    if (jCAnnotation.annotationType.type.tsym != this.syms.functionalInterfaceType.tsym) continue;
                    diagnosticPosition = jCAnnotation.pos();
                    break;
                }
                this.log.error(diagnosticPosition, "bad.functional.intf.anno.1", functionDescriptorLookupError.getDiagnostic());
            }
        }
    }

    public void checkImportsResolvable(JCTree.JCCompilationUnit jCCompilationUnit) {
        for (JCTree.JCImport jCImport : jCCompilationUnit.getImports()) {
            Symbol.TypeSymbol typeSymbol;
            Symbol symbol;
            if (!jCImport.staticImport || !jCImport.qualid.hasTag(JCTree.Tag.SELECT)) continue;
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCImport.qualid;
            if (jCFieldAccess.name == this.names.asterisk || (symbol = TreeInfo.symbol(jCFieldAccess.selected)) == null || symbol.kind != Kinds.Kind.TYP || this.checkTypeContainsImportableElement(typeSymbol = (Symbol.TypeSymbol)TreeInfo.symbol(jCFieldAccess.selected), typeSymbol, jCCompilationUnit.packge, jCFieldAccess.name, new HashSet<Symbol>())) continue;
            this.log.error(jCImport.pos(), "cant.resolve.location", Kinds.KindName.STATIC, jCFieldAccess.name, List.nil(), List.nil(), Kinds.typeKindName(TreeInfo.symbol((JCTree)jCFieldAccess.selected).type), TreeInfo.symbol((JCTree)jCFieldAccess.selected).type);
        }
    }

    public void checkImportedPackagesObservable(JCTree.JCCompilationUnit jCCompilationUnit) {
        block0: for (JCTree.JCImport jCImport : jCCompilationUnit.getImports()) {
            if (jCImport.staticImport || TreeInfo.name(jCImport.qualid) != this.names.asterisk) continue;
            Symbol.TypeSymbol typeSymbol = ((JCTree.JCFieldAccess)jCImport.qualid).selected.type.tsym;
            if (jCCompilationUnit.modle.visiblePackages != null) {
                for (Symbol.PackageSymbol packageSymbol : jCCompilationUnit.modle.visiblePackages.values()) {
                    if (Convert.packagePart(packageSymbol.fullname) != typeSymbol.flatName()) continue;
                    continue block0;
                }
            }
            if (typeSymbol.kind != Kinds.Kind.PCK || !typeSymbol.members().isEmpty() || typeSymbol.exists()) continue;
            this.log.error(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR, jCImport.pos, "doesnt.exist", typeSymbol);
        }
    }

    private boolean checkTypeContainsImportableElement(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, Symbol.PackageSymbol packageSymbol, Name name, Set<Symbol> set) {
        if (typeSymbol == null || !set.add(typeSymbol)) {
            return false;
        }
        if (this.checkTypeContainsImportableElement(this.types.supertype((Type)typeSymbol.type).tsym, typeSymbol2, packageSymbol, name, set)) {
            return true;
        }
        for (Type annoConstruct : this.types.interfaces(typeSymbol.type)) {
            if (!this.checkTypeContainsImportableElement(annoConstruct.tsym, typeSymbol2, packageSymbol, name, set)) continue;
            return true;
        }
        for (Symbol symbol : typeSymbol.members().getSymbolsByName(name)) {
            if (!symbol.isStatic() || !this.importAccessible(symbol, packageSymbol) || !symbol.isMemberOf(typeSymbol2, this.types)) continue;
            return true;
        }
        return false;
    }

    public boolean importAccessible(Symbol symbol, Symbol.PackageSymbol packageSymbol) {
        try {
            int n = (int)(symbol.flags() & 7L);
            switch (n) {
                default: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 0: 
                case 4: 
            }
            return symbol.packge() == packageSymbol;
        }
        catch (ClassFinder.BadClassFile badClassFile) {
            throw badClassFile;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return false;
        }
    }

    public void checkLeaksNotAccessible(final Env<AttrContext> env, final JCTree.JCClassDecl jCClassDecl) {
        final JCTree.JCCompilationUnit jCCompilationUnit = env.toplevel;
        if (jCCompilationUnit.modle == this.syms.unnamedModule || jCCompilationUnit.modle == this.syms.noModule || (jCClassDecl.sym.flags() & 0x1000000L) != 0L) {
            return;
        }
        Directive.ExportsDirective exportsDirective = this.findExport(jCCompilationUnit.packge);
        if (exportsDirective == null || exportsDirective.modules != null) {
            return;
        }
        new TreeScanner(){
            Lint lint;
            boolean inSuperType;
            {
                this.lint = ((AttrContext)env.info).lint;
            }

            @Override
            public void visitBlock(JCTree.JCBlock jCBlock) {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                if (!Check.this.isAPISymbol(jCMethodDecl.sym)) {
                    return;
                }
                Lint lint = this.lint;
                try {
                    this.lint = this.lint.augment(jCMethodDecl.sym);
                    if (this.lint.isEnabled(Lint.LintCategory.EXPORTS)) {
                        super.visitMethodDef(jCMethodDecl);
                    }
                }
                finally {
                    this.lint = lint;
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                if (!Check.this.isAPISymbol(jCVariableDecl.sym) && jCVariableDecl.sym.owner.kind != Kinds.Kind.MTH) {
                    return;
                }
                Lint lint = this.lint;
                try {
                    this.lint = this.lint.augment(jCVariableDecl.sym);
                    if (this.lint.isEnabled(Lint.LintCategory.EXPORTS)) {
                        this.scan(jCVariableDecl.mods);
                        this.scan(jCVariableDecl.vartype);
                    }
                }
                finally {
                    this.lint = lint;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl2) {
                block8: {
                    if (jCClassDecl2 != jCClassDecl) {
                        return;
                    }
                    if (!Check.this.isAPISymbol(jCClassDecl2.sym)) {
                        return;
                    }
                    Lint lint = this.lint;
                    try {
                        this.lint = this.lint.augment(jCClassDecl2.sym);
                        if (!this.lint.isEnabled(Lint.LintCategory.EXPORTS)) break block8;
                        this.scan(jCClassDecl2.mods);
                        this.scan(jCClassDecl2.typarams);
                        try {
                            this.inSuperType = true;
                            this.scan(jCClassDecl2.extending);
                            this.scan(jCClassDecl2.implementing);
                        }
                        finally {
                            this.inSuperType = false;
                        }
                        this.scan(jCClassDecl2.defs);
                    }
                    finally {
                        this.lint = lint;
                    }
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
                this.scan(jCTypeApply.clazz);
                boolean bl = this.inSuperType;
                try {
                    this.inSuperType = false;
                    this.scan(jCTypeApply.arguments);
                }
                finally {
                    this.inSuperType = bl;
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                Symbol symbol = TreeInfo.symbol(jCIdent);
                if (symbol.kind == Kinds.Kind.TYP && !symbol.type.hasTag(TypeTag.TYPEVAR)) {
                    Check.this.checkVisible(jCIdent.pos(), symbol, jCCompilationUnit.packge, this.inSuperType);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                Symbol symbol = TreeInfo.symbol(jCFieldAccess);
                Symbol symbol2 = TreeInfo.symbol(jCFieldAccess.selected);
                if (symbol.kind == Kinds.Kind.TYP && symbol2.kind == Kinds.Kind.PCK) {
                    Check.this.checkVisible(jCFieldAccess.pos(), symbol, jCCompilationUnit.packge, this.inSuperType);
                } else {
                    super.visitSelect(jCFieldAccess);
                }
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
                if (jCAnnotation.attribute.type.tsym.getAnnotation(Documented.class) != null) {
                    super.visitAnnotation(jCAnnotation);
                }
            }
        }.scan(jCClassDecl);
    }

    private Directive.ExportsDirective findExport(Symbol.PackageSymbol packageSymbol) {
        for (Directive.ExportsDirective exportsDirective : packageSymbol.modle.exports) {
            if (exportsDirective.packge != packageSymbol) continue;
            return exportsDirective;
        }
        return null;
    }

    private boolean isAPISymbol(Symbol symbol) {
        while (symbol.kind != Kinds.Kind.PCK) {
            if ((symbol.flags() & 1L) == 0L && (symbol.flags() & 4L) == 0L) {
                return false;
            }
            symbol = symbol.owner;
        }
        return true;
    }

    private void checkVisible(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol.PackageSymbol packageSymbol, boolean bl) {
        if (!this.isAPISymbol(symbol) && !bl) {
            this.log.warning(Lint.LintCategory.EXPORTS, diagnosticPosition, CompilerProperties.Warnings.LeaksNotAccessible(Kinds.kindName(symbol), symbol, symbol.packge().modle));
            return;
        }
        Symbol.PackageSymbol packageSymbol2 = symbol.packge();
        Directive.ExportsDirective exportsDirective = this.findExport(packageSymbol2);
        Directive.ExportsDirective exportsDirective2 = this.findExport(packageSymbol);
        if (exportsDirective == null) {
            this.log.warning(Lint.LintCategory.EXPORTS, diagnosticPosition, CompilerProperties.Warnings.LeaksNotAccessibleUnexported(Kinds.kindName(symbol), symbol, symbol.packge().modle));
            return;
        }
        if (!(exportsDirective.modules == null || exportsDirective2.modules != null && exportsDirective.modules.containsAll(exportsDirective2.modules))) {
            this.log.warning(Lint.LintCategory.EXPORTS, diagnosticPosition, CompilerProperties.Warnings.LeaksNotAccessibleUnexportedQualified(Kinds.kindName(symbol), symbol, symbol.packge().modle));
        }
        if (packageSymbol2.modle != packageSymbol.modle && packageSymbol2.modle != this.syms.java_base) {
            List<Symbol.ModuleSymbol> list = List.of(packageSymbol.modle);
            while (list.nonEmpty()) {
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)list.head;
                list = list.tail;
                if (moduleSymbol == packageSymbol2.modle) {
                    return;
                }
                for (Directive.RequiresDirective requiresDirective : moduleSymbol.requires) {
                    if (!requiresDirective.isTransitive()) continue;
                    list = list.prepend(requiresDirective.module);
                }
            }
            this.log.warning(Lint.LintCategory.EXPORTS, diagnosticPosition, CompilerProperties.Warnings.LeaksNotAccessibleNotRequiredTransitive(Kinds.kindName(symbol), symbol, symbol.packge().modle));
        }
    }

    void checkModuleExists(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ModuleSymbol moduleSymbol) {
        if (moduleSymbol.kind != Kinds.Kind.MDL) {
            this.deferredLintHandler.report(() -> {
                if (this.lint.isEnabled(Lint.LintCategory.MODULE)) {
                    this.log.warning(Lint.LintCategory.MODULE, diagnosticPosition, CompilerProperties.Warnings.ModuleNotFound(moduleSymbol));
                }
            });
        }
    }

    void checkPackageExistsForOpens(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.PackageSymbol packageSymbol) {
        if (packageSymbol.members().isEmpty() && (packageSymbol.flags() & 0x100000000000000L) == 0L) {
            this.deferredLintHandler.report(() -> {
                if (this.lint.isEnabled(Lint.LintCategory.OPENS)) {
                    this.log.warning(diagnosticPosition, CompilerProperties.Warnings.PackageEmptyOrNotFound(packageSymbol));
                }
            });
        }
    }

    void checkModuleRequires(JCDiagnostic.DiagnosticPosition diagnosticPosition, Directive.RequiresDirective requiresDirective) {
        if ((requiresDirective.module.flags() & 0x10000000000000L) != 0L) {
            this.deferredLintHandler.report(() -> {
                if (requiresDirective.isTransitive() && this.lint.isEnabled(Lint.LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC)) {
                    this.log.warning(diagnosticPosition, CompilerProperties.Warnings.RequiresTransitiveAutomatic);
                } else if (this.lint.isEnabled(Lint.LintCategory.REQUIRES_AUTOMATIC)) {
                    this.log.warning(diagnosticPosition, CompilerProperties.Warnings.RequiresAutomatic);
                }
            });
        }
    }

    private class ConversionWarner
    extends Warner {
        final String uncheckedKey;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Type type, Type type2) {
            super(diagnosticPosition);
            this.uncheckedKey = string;
            this.found = type;
            this.expected = type2;
        }

        @Override
        public void warn(Lint.LintCategory lintCategory) {
            boolean bl = this.warned;
            super.warn(lintCategory);
            if (bl) {
                return;
            }
            switch (lintCategory) {
                case UNCHECKED: {
                    Check.this.warnUnchecked(this.pos(), "prob.found.req", Check.this.diags.fragment(this.uncheckedKey, new Object[0]), this.found, this.expected);
                    break;
                }
                case VARARGS: {
                    if (Check.this.method == null || Check.this.method.attribute(((Check)Check.this).syms.trustMeType.tsym) == null || !Check.this.isTrustMeAllowedOnMethod(Check.this.method) || Check.this.types.isReifiable(((Check)Check.this).method.type.getParameterTypes().last())) break;
                    Check.this.warnUnsafeVararg(this.pos(), "varargs.unsafe.use.varargs.param", ((Check)Check.this).method.params.last());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected lint: " + (Object)((Object)lintCategory)));
                }
            }
        }
    }

    private class DefaultMethodClashFilter
    implements Filter<Symbol> {
        Type site;

        DefaultMethodClashFilter(Type type) {
            this.site = type;
        }

        @Override
        public boolean accepts(Symbol symbol) {
            return symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x80000000000L) != 0L && symbol.isInheritedIn(this.site.tsym, Check.this.types) && !symbol.isConstructor();
        }
    }

    private class ClashFilter
    implements Filter<Symbol> {
        Type site;

        ClashFilter(Type type) {
            this.site = type;
        }

        boolean shouldSkip(Symbol symbol) {
            return (symbol.flags() & 0x40000000000L) != 0L && symbol.owner == this.site.tsym;
        }

        @Override
        public boolean accepts(Symbol symbol) {
            return symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x1000L) == 0L && !this.shouldSkip(symbol) && symbol.isInheritedIn(this.site.tsym, Check.this.types) && !symbol.isConstructor();
        }
    }

    class CycleChecker
    extends TreeScanner {
        List<Symbol> seenClasses = List.nil();
        boolean errorFound = false;
        boolean partialCheck = false;

        CycleChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSymbol(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            if (symbol != null && symbol.kind == Kinds.Kind.TYP) {
                Env<AttrContext> env = Check.this.enter.getEnv((Symbol.TypeSymbol)symbol);
                if (env != null) {
                    DiagnosticSource diagnosticSource = Check.this.log.currentSource();
                    try {
                        Check.this.log.useSource(env.toplevel.sourcefile);
                        this.scan(env.tree);
                    }
                    finally {
                        Check.this.log.useSource(diagnosticSource.getFile());
                    }
                } else if (symbol.kind == Kinds.Kind.TYP) {
                    this.checkClass(diagnosticPosition, symbol, List.nil());
                }
            } else {
                this.partialCheck = true;
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            super.visitSelect(jCFieldAccess);
            this.checkSymbol(jCFieldAccess.pos(), jCFieldAccess.sym);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            this.checkSymbol(jCIdent.pos(), jCIdent.sym);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
            this.scan(jCTypeApply.clazz);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            this.scan(jCArrayTypeTree.elemtype);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            List<JCTree> list = List.nil();
            if (jCClassDecl.getExtendsClause() != null) {
                list = list.prepend(jCClassDecl.getExtendsClause());
            }
            if (jCClassDecl.getImplementsClause() != null) {
                for (JCTree jCTree : jCClassDecl.getImplementsClause()) {
                    list = list.prepend(jCTree);
                }
            }
            this.checkClass(jCClassDecl.pos(), jCClassDecl.sym, list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkClass(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, List<JCTree> list) {
            if ((symbol.flags_field & 0x40000000L) != 0L) {
                return;
            }
            if (this.seenClasses.contains(symbol)) {
                this.errorFound = true;
                Check.this.noteCyclic(diagnosticPosition, (Symbol.ClassSymbol)symbol);
            } else if (!symbol.type.isErroneous()) {
                try {
                    this.seenClasses = this.seenClasses.prepend(symbol);
                    if (symbol.type.hasTag(TypeTag.CLASS)) {
                        if (list.nonEmpty()) {
                            this.scan(list);
                        } else {
                            Type.ClassType classType = (Type.ClassType)symbol.type;
                            if (classType.supertype_field == null || classType.interfaces_field == null) {
                                this.partialCheck = true;
                                return;
                            }
                            this.checkSymbol(diagnosticPosition, classType.supertype_field.tsym);
                            for (Type type : classType.interfaces_field) {
                                this.checkSymbol(diagnosticPosition, type.tsym);
                            }
                        }
                        if (symbol.owner.kind == Kinds.Kind.TYP) {
                            this.checkSymbol(diagnosticPosition, symbol.owner);
                        }
                    }
                }
                finally {
                    this.seenClasses = this.seenClasses.tail;
                }
            }
        }
    }

    class Validator
    extends JCTree.Visitor {
        boolean checkRaw;
        boolean isOuter;
        Env<AttrContext> env;

        Validator(Env<AttrContext> env) {
            this.env = env;
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            this.validateTree(jCArrayTypeTree.elemtype, this.checkRaw, this.isOuter);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
            if (jCTypeApply.type.hasTag(TypeTag.CLASS)) {
                boolean bl;
                List<JCTree.JCExpression> list = jCTypeApply.arguments;
                List<Type> list2 = jCTypeApply.type.tsym.type.getTypeArguments();
                Type type = Check.this.firstIncompatibleTypeArg(jCTypeApply.type);
                if (type != null) {
                    for (JCTree jCTree : jCTypeApply.arguments) {
                        if (jCTree.type == type) {
                            Check.this.log.error(jCTree, "not.within.bounds", type, list2.head);
                        }
                        list2 = list2.tail;
                    }
                }
                list2 = jCTypeApply.type.tsym.type.getTypeArguments();
                boolean bl2 = bl = jCTypeApply.type.tsym.flatName() == ((Check)Check.this).names.java_lang_Class;
                while (list.nonEmpty() && list2.nonEmpty()) {
                    this.validateTree((JCTree)list.head, !this.isOuter || !bl, false);
                    list = list.tail;
                    list2 = list2.tail;
                }
                if (jCTypeApply.type.getEnclosingType().isRaw()) {
                    Check.this.log.error(jCTypeApply.pos(), "improperly.formed.type.inner.raw.param", new Object[0]);
                }
                if (jCTypeApply.clazz.hasTag(JCTree.Tag.SELECT)) {
                    this.visitSelectInternal((JCTree.JCFieldAccess)jCTypeApply.clazz);
                }
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            this.validateTrees(jCTypeParameter.bounds, true, this.isOuter);
            Check.this.checkClassBounds(jCTypeParameter.pos(), jCTypeParameter.type);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard jCWildcard) {
            if (jCWildcard.inner != null) {
                this.validateTree(jCWildcard.inner, true, this.isOuter);
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.type.hasTag(TypeTag.CLASS)) {
                this.visitSelectInternal(jCFieldAccess);
                if (jCFieldAccess.selected.type.isParameterized() && jCFieldAccess.type.tsym.type.getTypeArguments().nonEmpty()) {
                    Check.this.log.error(jCFieldAccess.pos(), "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.type.tsym.isStatic() && jCFieldAccess.selected.type.isParameterized()) {
                Check.this.log.error(jCFieldAccess.pos(), "cant.select.static.class.from.param.type", new Object[0]);
            } else {
                jCFieldAccess.selected.accept(this);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            jCAnnotatedType.underlyingType.accept(this);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
            if (jCPrimitiveTypeTree.type.hasTag(TypeTag.VOID)) {
                Check.this.log.error(jCPrimitiveTypeTree.pos(), "void.not.allowed.here", new Object[0]);
            }
            super.visitTypeIdent(jCPrimitiveTypeTree);
        }

        @Override
        public void visitTree(JCTree jCTree) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateTree(JCTree jCTree, boolean bl, boolean bl2) {
            if (jCTree != null) {
                boolean bl3 = this.checkRaw;
                this.checkRaw = bl;
                this.isOuter = bl2;
                try {
                    jCTree.accept(this);
                    if (bl) {
                        Check.this.checkRaw(jCTree, this.env);
                    }
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    Check.this.completionError(jCTree.pos(), completionFailure);
                }
                finally {
                    this.checkRaw = bl3;
                }
            }
        }

        public void validateTrees(List<? extends JCTree> list, boolean bl, boolean bl2) {
            List<JCTree> list2 = list;
            while (list2.nonEmpty()) {
                this.validateTree((JCTree)list2.head, bl, bl2);
                list2 = list2.tail;
            }
        }
    }

    static class NestedCheckContext
    implements CheckContext {
        CheckContext enclosingContext;

        NestedCheckContext(CheckContext checkContext) {
            this.enclosingContext = checkContext;
        }

        @Override
        public boolean compatible(Type type, Type type2, Warner warner) {
            return this.enclosingContext.compatible(type, type2, warner);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
            this.enclosingContext.report(diagnosticPosition, jCDiagnostic);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
            return this.enclosingContext.checkWarner(diagnosticPosition, type, type2);
        }

        @Override
        public InferenceContext inferenceContext() {
            return this.enclosingContext.inferenceContext();
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.enclosingContext.deferredAttrContext();
        }
    }

    public static interface CheckContext {
        public boolean compatible(Type var1, Type var2, Warner var3);

        public void report(JCDiagnostic.DiagnosticPosition var1, JCDiagnostic var2);

        public Warner checkWarner(JCDiagnostic.DiagnosticPosition var1, Type var2, Type var3);

        public InferenceContext inferenceContext();

        public DeferredAttr.DeferredAttrContext deferredAttrContext();
    }
}

