/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import com.sun.tools.doclint.Entity;
import com.sun.tools.doclint.Env;
import com.sun.tools.doclint.HtmlTag;
import com.sun.tools.doclint.HtmlVersion;
import com.sun.tools.doclint.Messages;
import com.sun.tools.javac.tree.DocPretty;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Checker
extends DocTreePathScanner<Void, Void> {
    final Env env;
    Set<Element> foundParams = new HashSet<Element>();
    Set<TypeMirror> foundThrows = new HashSet<TypeMirror>();
    Map<Element, Set<String>> foundAnchors = new HashMap<Element, Set<String>>();
    boolean foundInheritDoc = false;
    boolean foundReturn = false;
    private final Deque<TagStackItem> tagStack;
    private HtmlTag currHeaderTag;
    private final int implicitHeaderLevel;
    private static final Pattern validName = Pattern.compile("[A-Za-z][A-Za-z0-9-_:.]*");
    private static final Pattern validNumber = Pattern.compile("-?[0-9]+");
    private static final Pattern docRoot = Pattern.compile("(?i)(\\{@docRoot *\\}/?)?(.*)");

    Checker(Env env) {
        this.env = Assert.checkNonNull(env);
        this.tagStack = new LinkedList<TagStackItem>();
        this.implicitHeaderLevel = env.implicitHeaderLevel;
    }

    public Void scan(DocCommentTree docCommentTree, TreePath treePath) {
        this.env.initTypes();
        this.env.setCurrent(treePath, docCommentTree);
        boolean bl = !this.env.currOverriddenMethods.isEmpty();
        JavaFileObject javaFileObject = treePath.getCompilationUnit().getSourceFile();
        if (treePath.getLeaf().getKind() == Tree.Kind.PACKAGE) {
            boolean bl2 = javaFileObject.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (docCommentTree == null) {
                if (bl2) {
                    this.reportMissing("dc.missing.comment", new Object[0]);
                }
                return null;
            }
            if (!bl2) {
                this.reportReference("dc.unexpected.comment", new Object[0]);
            }
        } else if (docCommentTree != null && javaFileObject.isNameCompatible("package", JavaFileObject.Kind.HTML)) {
            if (docCommentTree.getFullBody().isEmpty()) {
                this.reportMissing("dc.missing.comment", new Object[0]);
                return null;
            }
        } else if (docCommentTree == null) {
            if (!this.isSynthetic() && !bl) {
                this.reportMissing("dc.missing.comment", new Object[0]);
            }
            return null;
        }
        this.tagStack.clear();
        this.currHeaderTag = null;
        this.foundParams.clear();
        this.foundThrows.clear();
        this.foundInheritDoc = false;
        this.foundReturn = false;
        this.scan(new DocTreePath(treePath, docCommentTree), null);
        if (!bl) {
            switch (this.env.currElement.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: {
                    ExecutableElement executableElement = (ExecutableElement)this.env.currElement;
                    this.checkParamsDocumented(executableElement.getTypeParameters());
                    this.checkParamsDocumented(executableElement.getParameters());
                    switch (executableElement.getReturnType().getKind()) {
                        case VOID: 
                        case NONE: {
                            break;
                        }
                        default: {
                            if (this.foundReturn || this.foundInheritDoc || this.env.types.isSameType(executableElement.getReturnType(), this.env.java_lang_Void)) break;
                            this.reportMissing("dc.missing.return", new Object[0]);
                        }
                    }
                    this.checkThrowsDocumented(executableElement.getThrownTypes());
                }
            }
        }
        return null;
    }

    private void reportMissing(String string, Object ... objectArray) {
        this.env.messages.report(Messages.Group.MISSING, Diagnostic.Kind.WARNING, this.env.currPath.getLeaf(), string, objectArray);
    }

    private void reportReference(String string, Object ... objectArray) {
        this.env.messages.report(Messages.Group.REFERENCE, Diagnostic.Kind.WARNING, this.env.currPath.getLeaf(), string, objectArray);
    }

    @Override
    public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
        super.visitDocComment(docCommentTree, void_);
        for (TagStackItem tagStackItem : this.tagStack) {
            this.warnIfEmpty(tagStackItem, null);
            if (tagStackItem.tree.getKind() != DocTree.Kind.START_ELEMENT || tagStackItem.tag.endKind != HtmlTag.EndKind.REQUIRED) continue;
            StartElementTree startElementTree = (StartElementTree)tagStackItem.tree;
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.closed", startElementTree.getName());
        }
        return null;
    }

    @Override
    public Void visitText(TextTree textTree, Void void_) {
        if (this.hasNonWhitespace(textTree)) {
            this.checkAllowsText(textTree);
            this.markEnclosingTag(Flag.HAS_TEXT);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree entityTree, Void void_) {
        this.checkAllowsText(entityTree);
        this.markEnclosingTag(Flag.HAS_TEXT);
        String string = entityTree.getName().toString();
        if (string.startsWith("#")) {
            int n;
            int n2 = n = StringUtils.toLowerCase(string).startsWith("#x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1), 10);
            if (!Entity.isValid(n)) {
                this.env.messages.error(Messages.Group.HTML, entityTree, "dc.entity.invalid", string);
            }
        } else if (!Entity.isValid(string)) {
            this.env.messages.error(Messages.Group.HTML, entityTree, "dc.entity.invalid", string);
        }
        return null;
    }

    void checkAllowsText(DocTree docTree) {
        TagStackItem tagStackItem = this.tagStack.peek();
        if (tagStackItem != null && tagStackItem.tree.getKind() == DocTree.Kind.START_ELEMENT && !tagStackItem.tag.acceptsText() && tagStackItem.flags.add(Flag.REPORTED_BAD_INLINE)) {
            this.env.messages.error(Messages.Group.HTML, docTree, "dc.text.not.allowed", ((StartElementTree)tagStackItem.tree).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitStartElement(StartElementTree startElementTree, Void void_) {
        Name name = startElementTree.getName();
        HtmlTag htmlTag = HtmlTag.get(name);
        if (htmlTag == null) {
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.unknown", name);
        } else if (htmlTag.allowedVersion != HtmlVersion.ALL && htmlTag.allowedVersion != this.env.htmlVersion) {
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.supported", name);
        } else {
            boolean bl = false;
            for (TagStackItem tagStackItem : this.tagStack) {
                if (tagStackItem.tag.accepts(htmlTag)) {
                    while (this.tagStack.peek() != tagStackItem) {
                        this.warnIfEmpty(this.tagStack.peek(), null);
                        this.tagStack.pop();
                    }
                    bl = true;
                    break;
                }
                if (tagStackItem.tag.endKind == HtmlTag.EndKind.OPTIONAL) continue;
                bl = true;
                break;
            }
            if (!bl && HtmlTag.BODY.accepts(htmlTag)) {
                while (!this.tagStack.isEmpty()) {
                    this.warnIfEmpty(this.tagStack.peek(), null);
                    this.tagStack.pop();
                }
            }
            this.markEnclosingTag(Flag.HAS_ELEMENT);
            this.checkStructure(startElementTree, htmlTag);
            switch (htmlTag) {
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.checkHeader(startElementTree, htmlTag);
                }
            }
            if (htmlTag.flags.contains((Object)HtmlTag.Flag.NO_NEST)) {
                for (TagStackItem tagStackItem : this.tagStack) {
                    if (htmlTag != tagStackItem.tag) continue;
                    this.env.messages.warning(Messages.Group.HTML, startElementTree, "dc.tag.nested.not.allowed", name);
                    break;
                }
            }
        }
        if (startElementTree.isSelfClosing()) {
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.self.closing", name);
        }
        try {
            TagStackItem tagStackItem;
            TagStackItem tagStackItem2 = this.tagStack.peek();
            Iterator<TagStackItem> iterator2 = new TagStackItem(startElementTree, htmlTag);
            this.tagStack.push((TagStackItem)((Object)iterator2));
            super.visitStartElement(startElementTree, void_);
            if (htmlTag != null) {
                switch (htmlTag) {
                    case CAPTION: {
                        if (tagStackItem2 == null || tagStackItem2.tag != HtmlTag.TABLE) break;
                        tagStackItem2.flags.add(Flag.TABLE_HAS_CAPTION);
                        break;
                    }
                    case H1: 
                    case H2: 
                    case H3: 
                    case H4: 
                    case H5: 
                    case H6: {
                        if (tagStackItem2 == null || tagStackItem2.tag != HtmlTag.SECTION && tagStackItem2.tag != HtmlTag.ARTICLE) break;
                        tagStackItem2.flags.add(Flag.HAS_HEADING);
                        break;
                    }
                    case IMG: {
                        if (((TagStackItem)((Object)iterator2)).attrs.contains((Object)HtmlTag.Attr.ALT)) break;
                        this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.no.alt.attr.for.image", new Object[0]);
                    }
                }
            }
            tagStackItem = null;
            return tagStackItem;
        }
        finally {
            if (htmlTag == null || htmlTag.endKind == HtmlTag.EndKind.NONE) {
                this.tagStack.pop();
            }
        }
    }

    private void checkStructure(StartElementTree startElementTree, HtmlTag htmlTag) {
        Name name = startElementTree.getName();
        TagStackItem tagStackItem = this.tagStack.peek();
        switch (htmlTag.blockType) {
            case BLOCK: {
                if (tagStackItem == null || tagStackItem.tag.accepts(htmlTag)) {
                    return;
                }
                switch (tagStackItem.tree.getKind()) {
                    case START_ELEMENT: {
                        if (tagStackItem.tag.blockType != HtmlTag.BlockType.INLINE) break;
                        Name name2 = ((StartElementTree)tagStackItem.tree).getName();
                        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed.inline.element", name, name2);
                        return;
                    }
                    case LINK: 
                    case LINK_PLAIN: {
                        String string = tagStackItem.tree.getKind().tagName;
                        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed.inline.tag", name, string);
                        return;
                    }
                }
                break;
            }
            case INLINE: {
                if (tagStackItem != null && !tagStackItem.tag.accepts(htmlTag)) break;
                return;
            }
            case LIST_ITEM: 
            case TABLE_ITEM: {
                if (tagStackItem == null) break;
                tagStackItem.flags.remove((Object)Flag.REPORTED_BAD_INLINE);
                if (!tagStackItem.tag.accepts(htmlTag)) break;
                return;
            }
            case OTHER: {
                switch (htmlTag) {
                    case SCRIPT: {
                        break;
                    }
                    default: {
                        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed", name);
                    }
                }
                return;
            }
        }
        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed.here", name);
    }

    private void checkHeader(StartElementTree startElementTree, HtmlTag htmlTag) {
        if (this.getHeaderLevel(htmlTag) > this.getHeaderLevel(this.currHeaderTag) + 1) {
            if (this.currHeaderTag == null) {
                this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.tag.header.sequence.1", new Object[]{htmlTag});
            } else {
                this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.tag.header.sequence.2", new Object[]{htmlTag, this.currHeaderTag});
            }
        }
        this.currHeaderTag = htmlTag;
    }

    private int getHeaderLevel(HtmlTag htmlTag) {
        if (htmlTag == null) {
            return this.implicitHeaderLevel;
        }
        switch (htmlTag) {
            case H1: {
                return 1;
            }
            case H2: {
                return 2;
            }
            case H3: {
                return 3;
            }
            case H4: {
                return 4;
            }
            case H5: {
                return 5;
            }
            case H6: {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Void visitEndElement(EndElementTree endElementTree, Void void_) {
        Name name = endElementTree.getName();
        HtmlTag htmlTag = HtmlTag.get(name);
        if (htmlTag == null) {
            this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.unknown", name);
        } else if (htmlTag.endKind == HtmlTag.EndKind.NONE) {
            this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.end.not.permitted", name);
        } else {
            boolean bl = false;
            while (!this.tagStack.isEmpty()) {
                TagStackItem tagStackItem = this.tagStack.peek();
                if (htmlTag == tagStackItem.tag) {
                    switch (htmlTag) {
                        case TABLE: {
                            if (tagStackItem.attrs.contains((Object)HtmlTag.Attr.SUMMARY) || tagStackItem.flags.contains((Object)Flag.TABLE_HAS_CAPTION)) break;
                            this.env.messages.error(Messages.Group.ACCESSIBILITY, endElementTree, "dc.no.summary.or.caption.for.table", new Object[0]);
                            break;
                        }
                        case SECTION: 
                        case ARTICLE: {
                            if (this.env.htmlVersion != HtmlVersion.HTML5 || tagStackItem.flags.contains((Object)Flag.HAS_HEADING)) break;
                            this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.requires.heading", name);
                        }
                    }
                    this.warnIfEmpty(tagStackItem, endElementTree);
                    this.tagStack.pop();
                    bl = true;
                    break;
                }
                if (tagStackItem.tag == null || tagStackItem.tag.endKind != HtmlTag.EndKind.REQUIRED) {
                    this.tagStack.pop();
                    continue;
                }
                boolean bl2 = false;
                for (TagStackItem tagStackItem2 : this.tagStack) {
                    if (tagStackItem2.tag != htmlTag) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && tagStackItem.tree.getKind() == DocTree.Kind.START_ELEMENT) {
                    this.env.messages.error(Messages.Group.HTML, tagStackItem.tree, "dc.tag.start.unmatched", ((StartElementTree)tagStackItem.tree).getName());
                    this.tagStack.pop();
                    continue;
                }
                this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.end.unexpected", name);
                bl = true;
                break;
            }
            if (!bl && this.tagStack.isEmpty()) {
                this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.end.unexpected", name);
            }
        }
        return (Void)super.visitEndElement(endElementTree, void_);
    }

    void warnIfEmpty(TagStackItem tagStackItem, DocTree docTree) {
        if (tagStackItem.tag != null && tagStackItem.tree instanceof StartElementTree && tagStackItem.tag.flags.contains((Object)HtmlTag.Flag.EXPECT_CONTENT) && !tagStackItem.flags.contains((Object)Flag.HAS_TEXT) && !tagStackItem.flags.contains((Object)Flag.HAS_ELEMENT) && !tagStackItem.flags.contains((Object)Flag.HAS_INLINE_TAG)) {
            DocTree docTree2 = docTree != null ? docTree : tagStackItem.tree;
            Name name = ((StartElementTree)tagStackItem.tree).getName();
            this.env.messages.warning(Messages.Group.HTML, docTree2, "dc.tag.empty", name);
        }
    }

    @Override
    public Void visitAttribute(AttributeTree attributeTree, Void void_) {
        HtmlTag htmlTag = this.tagStack.peek().tag;
        if (htmlTag != null) {
            Name name = attributeTree.getName();
            HtmlTag.Attr attr = htmlTag.getAttr(name);
            if (attr != null) {
                boolean bl;
                if (this.env.htmlVersion == HtmlVersion.HTML4 && attr.name().contains("-")) {
                    this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.not.supported.html4", name);
                }
                if (!(bl = this.tagStack.peek().attrs.add(attr))) {
                    this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.repeated", name);
                }
            }
            if (!name.toString().startsWith("on")) {
                HtmlTag.AttrKind attrKind = htmlTag.getAttrKind(name);
                switch (this.env.htmlVersion) {
                    case HTML4: {
                        this.validateHtml4Attrs(attributeTree, name, attrKind);
                        break;
                    }
                    case HTML5: {
                        this.validateHtml5Attrs(attributeTree, name, attrKind);
                    }
                }
            }
            if (attr != null) {
                switch (attr) {
                    case NAME: {
                        if (htmlTag != HtmlTag.A) break;
                    }
                    case ID: {
                        String string = this.getAttrValue(attributeTree);
                        if (string == null) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.anchor.value.missing", new Object[0]);
                            break;
                        }
                        if (!validName.matcher(string).matches()) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.invalid.anchor", string);
                        }
                        if (this.checkAnchor(string)) break;
                        this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.anchor.already.defined", string);
                        break;
                    }
                    case HREF: {
                        if (htmlTag != HtmlTag.A) break;
                        String string = this.getAttrValue(attributeTree);
                        if (string == null || string.isEmpty()) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.lacks.value", new Object[0]);
                            break;
                        }
                        Matcher matcher = docRoot.matcher(string);
                        if (matcher.matches()) {
                            String string2 = matcher.group(2);
                            if (string2.isEmpty()) break;
                            this.checkURI(attributeTree, string2);
                            break;
                        }
                        this.checkURI(attributeTree, string);
                        break;
                    }
                    case VALUE: {
                        if (htmlTag != HtmlTag.LI) break;
                        String string = this.getAttrValue(attributeTree);
                        if (string == null || string.isEmpty()) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.lacks.value", new Object[0]);
                            break;
                        }
                        if (validNumber.matcher(string).matches()) break;
                        this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.not.number", new Object[0]);
                        break;
                    }
                    case BORDER: {
                        if (htmlTag != HtmlTag.TABLE) break;
                        String string = this.getAttrValue(attributeTree);
                        try {
                            if (this.env.htmlVersion != HtmlVersion.HTML5 || string != null && (string.isEmpty() || Integer.parseInt(string) == 1)) break;
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.table.border.html5", new Object[]{attr});
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.table.border.html5", new Object[]{attr});
                        }
                    }
                }
            }
        }
        return (Void)super.visitAttribute(attributeTree, void_);
    }

    private void validateHtml4Attrs(AttributeTree attributeTree, Name name, HtmlTag.AttrKind attrKind) {
        switch (attrKind) {
            case ALL: 
            case HTML4: {
                break;
            }
            case INVALID: {
                this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.unknown", name);
                break;
            }
            case OBSOLETE: {
                this.env.messages.warning(Messages.Group.ACCESSIBILITY, attributeTree, "dc.attr.obsolete", name);
                break;
            }
            case USE_CSS: {
                this.env.messages.warning(Messages.Group.ACCESSIBILITY, attributeTree, "dc.attr.obsolete.use.css", name);
                break;
            }
            case HTML5: {
                this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.not.supported.html4", name);
            }
        }
    }

    private void validateHtml5Attrs(AttributeTree attributeTree, Name name, HtmlTag.AttrKind attrKind) {
        switch (attrKind) {
            case ALL: 
            case HTML5: {
                break;
            }
            case HTML4: 
            case INVALID: 
            case OBSOLETE: 
            case USE_CSS: {
                this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.not.supported.html5", name);
            }
        }
    }

    private boolean checkAnchor(String string) {
        Element element = this.getEnclosingPackageOrClass(this.env.currElement);
        if (element == null) {
            return true;
        }
        Set<String> set = this.foundAnchors.get(element);
        if (set == null) {
            set = new HashSet<String>();
            this.foundAnchors.put(element, set);
        }
        return set.add(string);
    }

    private Element getEnclosingPackageOrClass(Element element) {
        while (element != null) {
            switch (element.getKind()) {
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case PACKAGE: {
                    return element;
                }
            }
            element = element.getEnclosingElement();
        }
        return element;
    }

    private String getAttrValue(AttributeTree attributeTree) {
        if (attributeTree.getValue() == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            new DocPretty(stringWriter).print(attributeTree.getValue());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private void checkURI(AttributeTree attributeTree, String string) {
        if (string.startsWith("javascript:")) {
            return;
        }
        try {
            URI uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.invalid.uri", string);
        }
    }

    @Override
    public Void visitAuthor(AuthorTree authorTree, Void void_) {
        this.warnIfEmpty(authorTree, authorTree.getName());
        return (Void)super.visitAuthor(authorTree, void_);
    }

    @Override
    public Void visitDocRoot(DocRootTree docRootTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        return (Void)super.visitDocRoot(docRootTree, void_);
    }

    @Override
    public Void visitInheritDoc(InheritDocTree inheritDocTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        this.foundInheritDoc = true;
        return (Void)super.visitInheritDoc(inheritDocTree, void_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitLink(LinkTree linkTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        HtmlTag htmlTag = linkTree.getKind() == DocTree.Kind.LINK ? HtmlTag.CODE : HtmlTag.SPAN;
        this.tagStack.push(new TagStackItem(linkTree, htmlTag));
        try {
            Void void_2 = (Void)super.visitLink(linkTree, void_);
            return void_2;
        }
        finally {
            this.tagStack.pop();
        }
    }

    @Override
    public Void visitLiteral(LiteralTree literalTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        if (literalTree.getKind() == DocTree.Kind.CODE) {
            for (TagStackItem tagStackItem : this.tagStack) {
                if (tagStackItem.tag != HtmlTag.CODE) continue;
                this.env.messages.warning(Messages.Group.HTML, literalTree, "dc.tag.code.within.code", new Object[0]);
                break;
            }
        }
        return (Void)super.visitLiteral(literalTree, void_);
    }

    @Override
    public Void visitParam(ParamTree paramTree, Void void_) {
        Element element;
        boolean bl = paramTree.isTypeParameter();
        IdentifierTree identifierTree = paramTree.getName();
        Element element2 = element = identifierTree != null ? this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), identifierTree)) : null;
        if (element == null) {
            switch (this.env.currElement.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    if (!bl) {
                        this.env.messages.error(Messages.Group.REFERENCE, paramTree, "dc.invalid.param", new Object[0]);
                        break;
                    }
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    this.env.messages.error(Messages.Group.REFERENCE, identifierTree, "dc.param.name.not.found", new Object[0]);
                    break;
                }
                default: {
                    this.env.messages.error(Messages.Group.REFERENCE, paramTree, "dc.invalid.param", new Object[0]);
                    break;
                }
            }
        } else {
            boolean bl2 = this.foundParams.add(element);
            if (!bl2) {
                this.env.messages.warning(Messages.Group.REFERENCE, paramTree, "dc.exists.param", identifierTree);
            }
        }
        this.warnIfEmpty(paramTree, paramTree.getDescription());
        return (Void)super.visitParam(paramTree, void_);
    }

    private void checkParamsDocumented(List<? extends Element> list) {
        if (this.foundInheritDoc) {
            return;
        }
        for (Element element : list) {
            if (this.foundParams.contains(element)) continue;
            Name name = element.getKind() == ElementKind.TYPE_PARAMETER ? "<" + element.getSimpleName() + ">" : element.getSimpleName();
            this.reportMissing("dc.missing.param", name);
        }
    }

    @Override
    public Void visitProvides(ProvidesTree providesTree, Void void_) {
        Element element = this.env.trees.getElement(this.env.currPath);
        if (element.getKind() != ElementKind.MODULE) {
            this.env.messages.error(Messages.Group.REFERENCE, providesTree, "dc.invalid.provides", new Object[0]);
        }
        ReferenceTree referenceTree = providesTree.getServiceType();
        Element element2 = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
        if (element2 == null) {
            this.env.messages.error(Messages.Group.REFERENCE, providesTree, "dc.service.not.found", new Object[0]);
        }
        return (Void)super.visitProvides(providesTree, void_);
    }

    @Override
    public Void visitReference(ReferenceTree referenceTree, Void void_) {
        Element element;
        String string = referenceTree.getSignature();
        if (string.contains("<") || string.contains(">")) {
            this.env.messages.error(Messages.Group.REFERENCE, referenceTree, "dc.type.arg.not.allowed", new Object[0]);
        }
        if ((element = this.env.trees.getElement(this.getCurrentPath())) == null) {
            this.env.messages.error(Messages.Group.REFERENCE, referenceTree, "dc.ref.not.found", new Object[0]);
        }
        return (Void)super.visitReference(referenceTree, void_);
    }

    @Override
    public Void visitReturn(ReturnTree returnTree, Void void_) {
        Element element;
        if (this.foundReturn) {
            this.env.messages.warning(Messages.Group.REFERENCE, returnTree, "dc.exists.return", new Object[0]);
        }
        if ((element = this.env.trees.getElement(this.env.currPath)).getKind() != ElementKind.METHOD || ((ExecutableElement)element).getReturnType().getKind() == TypeKind.VOID) {
            this.env.messages.error(Messages.Group.REFERENCE, returnTree, "dc.invalid.return", new Object[0]);
        }
        this.foundReturn = true;
        this.warnIfEmpty(returnTree, returnTree.getDescription());
        return (Void)super.visitReturn(returnTree, void_);
    }

    @Override
    public Void visitSerialData(SerialDataTree serialDataTree, Void void_) {
        this.warnIfEmpty(serialDataTree, serialDataTree.getDescription());
        return (Void)super.visitSerialData(serialDataTree, void_);
    }

    @Override
    public Void visitSerialField(SerialFieldTree serialFieldTree, Void void_) {
        this.warnIfEmpty(serialFieldTree, serialFieldTree.getDescription());
        return (Void)super.visitSerialField(serialFieldTree, void_);
    }

    @Override
    public Void visitSince(SinceTree sinceTree, Void void_) {
        this.warnIfEmpty(sinceTree, sinceTree.getBody());
        return (Void)super.visitSince(sinceTree, void_);
    }

    @Override
    public Void visitThrows(ThrowsTree throwsTree, Void void_) {
        block5: {
            block6: {
                Element element;
                ReferenceTree referenceTree;
                block4: {
                    referenceTree = throwsTree.getExceptionName();
                    element = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
                    if (element != null) break block4;
                    this.env.messages.error(Messages.Group.REFERENCE, throwsTree, "dc.ref.not.found", new Object[0]);
                    break block5;
                }
                if (!this.isThrowable(element.asType())) break block6;
                switch (this.env.currElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: {
                        if (this.isCheckedException(element.asType())) {
                            ExecutableElement executableElement = (ExecutableElement)this.env.currElement;
                            this.checkThrowsDeclared(referenceTree, element.asType(), executableElement.getThrownTypes());
                            break;
                        }
                        break block5;
                    }
                    default: {
                        this.env.messages.error(Messages.Group.REFERENCE, throwsTree, "dc.invalid.throws", new Object[0]);
                        break;
                    }
                }
                break block5;
            }
            this.env.messages.error(Messages.Group.REFERENCE, throwsTree, "dc.invalid.throws", new Object[0]);
        }
        this.warnIfEmpty(throwsTree, throwsTree.getDescription());
        return (Void)this.scan(throwsTree.getDescription(), void_);
    }

    private boolean isThrowable(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: 
            case TYPEVAR: {
                return this.env.types.isAssignable(typeMirror, this.env.java_lang_Throwable);
            }
        }
        return false;
    }

    private void checkThrowsDeclared(ReferenceTree referenceTree, TypeMirror typeMirror, List<? extends TypeMirror> list) {
        boolean bl = false;
        for (TypeMirror typeMirror2 : list) {
            if (!this.env.types.isAssignable(typeMirror, typeMirror2)) continue;
            this.foundThrows.add(typeMirror2);
            bl = true;
        }
        if (!bl) {
            this.env.messages.error(Messages.Group.REFERENCE, referenceTree, "dc.exception.not.thrown", typeMirror);
        }
    }

    private void checkThrowsDocumented(List<? extends TypeMirror> list) {
        if (this.foundInheritDoc) {
            return;
        }
        for (TypeMirror typeMirror : list) {
            if (!this.isCheckedException(typeMirror) || this.foundThrows.contains(typeMirror)) continue;
            this.reportMissing("dc.missing.throws", typeMirror);
        }
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void void_) {
        this.checkUnknownTag(unknownBlockTagTree, unknownBlockTagTree.getTagName());
        return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, void_);
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void void_) {
        this.checkUnknownTag(unknownInlineTagTree, unknownInlineTagTree.getTagName());
        return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, void_);
    }

    private void checkUnknownTag(DocTree docTree, String string) {
        if (this.env.customTags != null && !this.env.customTags.contains(string)) {
            this.env.messages.error(Messages.Group.SYNTAX, docTree, "dc.tag.unknown", string);
        }
    }

    @Override
    public Void visitUses(UsesTree usesTree, Void void_) {
        Element element = this.env.trees.getElement(this.env.currPath);
        if (element.getKind() != ElementKind.MODULE) {
            this.env.messages.error(Messages.Group.REFERENCE, usesTree, "dc.invalid.uses", new Object[0]);
        }
        ReferenceTree referenceTree = usesTree.getServiceType();
        Element element2 = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
        if (element2 == null) {
            this.env.messages.error(Messages.Group.REFERENCE, usesTree, "dc.service.not.found", new Object[0]);
        }
        return (Void)super.visitUses(usesTree, void_);
    }

    @Override
    public Void visitValue(ValueTree valueTree, Void void_) {
        ReferenceTree referenceTree = valueTree.getReference();
        if (referenceTree == null || referenceTree.getSignature().isEmpty()) {
            if (!this.isConstant(this.env.currElement)) {
                this.env.messages.error(Messages.Group.REFERENCE, valueTree, "dc.value.not.allowed.here", new Object[0]);
            }
        } else {
            Element element = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
            if (!this.isConstant(element)) {
                this.env.messages.error(Messages.Group.REFERENCE, valueTree, "dc.value.not.a.constant", new Object[0]);
            }
        }
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        return (Void)super.visitValue(valueTree, void_);
    }

    private boolean isConstant(Element element) {
        if (element == null) {
            return false;
        }
        switch (element.getKind()) {
            case FIELD: {
                Object object = ((VariableElement)element).getConstantValue();
                return object != null;
            }
        }
        return false;
    }

    @Override
    public Void visitVersion(VersionTree versionTree, Void void_) {
        this.warnIfEmpty(versionTree, versionTree.getBody());
        return (Void)super.visitVersion(versionTree, void_);
    }

    @Override
    public Void visitErroneous(ErroneousTree erroneousTree, Void void_) {
        this.env.messages.error(Messages.Group.SYNTAX, erroneousTree, null, erroneousTree.getDiagnostic().getMessage(null));
        return null;
    }

    private boolean isCheckedException(TypeMirror typeMirror) {
        return !this.env.types.isAssignable(typeMirror, this.env.java_lang_Error) && !this.env.types.isAssignable(typeMirror, this.env.java_lang_RuntimeException);
    }

    private boolean isSynthetic() {
        switch (this.env.currElement.getKind()) {
            case CONSTRUCTOR: {
                TreePath treePath = this.env.currPath;
                return this.env.getPos(treePath) == this.env.getPos(treePath.getParentPath());
            }
        }
        return false;
    }

    void markEnclosingTag(Flag flag) {
        TagStackItem tagStackItem = this.tagStack.peek();
        if (tagStackItem != null) {
            tagStackItem.flags.add(flag);
        }
    }

    String toString(TreePath treePath) {
        StringBuilder stringBuilder = new StringBuilder("TreePath[");
        this.toString(treePath, stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    void toString(TreePath treePath, StringBuilder stringBuilder) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            this.toString(treePath2, stringBuilder);
            stringBuilder.append(",");
        }
        stringBuilder.append((Object)treePath.getLeaf().getKind()).append(":").append(this.env.getPos(treePath)).append(":S").append(this.env.getStartPos(treePath));
    }

    void warnIfEmpty(DocTree docTree, List<? extends DocTree> list) {
        block3: for (DocTree docTree2 : list) {
            switch (docTree2.getKind()) {
                case TEXT: {
                    if (!this.hasNonWhitespace((TextTree)docTree2)) continue block3;
                    return;
                }
            }
            return;
        }
        this.env.messages.warning(Messages.Group.SYNTAX, docTree, "dc.empty", docTree.getKind().tagName);
    }

    boolean hasNonWhitespace(TextTree textTree) {
        String string = textTree.getBody();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static class TagStackItem {
        final DocTree tree;
        final HtmlTag tag;
        final Set<HtmlTag.Attr> attrs;
        final Set<Flag> flags;

        TagStackItem(DocTree docTree, HtmlTag htmlTag) {
            this.tree = docTree;
            this.tag = htmlTag;
            this.attrs = EnumSet.noneOf(HtmlTag.Attr.class);
            this.flags = EnumSet.noneOf(Flag.class);
        }

        public String toString() {
            return String.valueOf((Object)this.tag);
        }
    }

    public static enum Flag {
        TABLE_HAS_CAPTION,
        HAS_ELEMENT,
        HAS_HEADING,
        HAS_INLINE_TAG,
        HAS_TEXT,
        REPORTED_BAD_INLINE;

    }
}

