/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.watch;

import com.google.rpc.Status;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.shadow.com.google.protobuf.InvalidProtocolBufferException;
import com.minekube.connect.watch.SessionProposal;
import com.minekube.connect.watch.Watcher;
import java.io.IOException;
import minekube.connect.v1alpha1.WatchServiceOuterClass;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchClient {
    private static final String ENDPOINT_HEADER = "Connect-Endpoint";
    private static final String ENDPOINT_OFFLINE_MODE_HEADER = "Connect-Endpoint-Offline-Mode";
    private static final String ENDPOINT_PARENTS_HEADER = "Connect-Endpoint-Parents";
    private static final String WATCH_URL = System.getenv().getOrDefault("CONNECT_WATCH_URL", "wss://watch-connect.minekube.net");
    private final OkHttpClient httpClient;
    private final ConnectConfig config;

    @Inject
    public WatchClient(@Named(value="connectHttpClient") OkHttpClient httpClient, ConnectConfig config) {
        this.httpClient = httpClient;
        this.config = config;
    }

    public WebSocket watch(final Watcher watcher) {
        Request.Builder request = new Request.Builder().url(WATCH_URL).header(ENDPOINT_HEADER, this.config.getEndpoint());
        if (this.config.getAllowOfflineModePlayers() != null) {
            request = request.header(ENDPOINT_OFFLINE_MODE_HEADER, this.config.getAllowOfflineModePlayers().toString());
        }
        if (this.config.getSuperEndpoints() != null) {
            for (String superEndpoint : this.config.getSuperEndpoints()) {
                request = request.addHeader(ENDPOINT_PARENTS_HEADER, superEndpoint);
            }
        }
        Request req = request.build();
        return this.httpClient.newWebSocket(req, new WebSocketListener(){

            @Override
            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                if (code != 1000) {
                    watcher.onError(new RuntimeException("Watch closed with code " + code + ": " + reason));
                    return;
                }
                watcher.onCompleted();
            }

            @Override
            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                webSocket.close(1000, null);
            }

            @Override
            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                String message = null;
                if (response != null && response.body() != null) {
                    try {
                        message = response.body().string();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (message == null || message.isEmpty()) {
                    watcher.onError(t);
                } else {
                    watcher.onError(new RuntimeException(message, t));
                }
            }

            @Override
            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                WatchServiceOuterClass.WatchResponse res;
                try {
                    res = WatchServiceOuterClass.WatchResponse.parseFrom(bytes.asByteBuffer());
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    webSocket.close(1002, e.toString());
                    return;
                }
                SessionProposal prop = new SessionProposal(res.getSession(), reason -> {
                    WatchServiceOuterClass.SessionRejection.Builder rejection = WatchServiceOuterClass.SessionRejection.newBuilder().setId(res.getSession().getId());
                    if (reason != null) {
                        rejection.setReason((Status)reason);
                    }
                    webSocket.send(ByteString.of(WatchServiceOuterClass.WatchRequest.newBuilder().setSessionRejection(rejection).build().toByteArray()));
                });
                watcher.onProposal(prop);
            }

            @Override
            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                watcher.onOpen();
            }
        });
    }
}

