/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.util;

import com.minekube.connect.api.packet.PacketHandler;
import com.minekube.connect.api.packet.PacketHandlers;
import com.minekube.connect.network.netty.LocalSession;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.util.ClassNames;
import com.minekube.connect.util.ReflectionUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.UUID;

public class SpigotProtocolSupportHandler
implements PacketHandler {
    private static final Method getFromChannel;
    private static final Method getLoginProfile;
    private static final Method setName;
    private static final Method setOriginalName;
    private static final Method setUuid;
    private static final Method setOriginalUuid;
    private static final Method getNetworkManagerWrapper;
    private static final Method getPacketListener;
    private static final Method handleLoginStart;

    @Inject
    public void register(PacketHandlers packetHandlers) {
        packetHandlers.register(this, ClassNames.LOGIN_START_PACKET);
    }

    @Override
    public Object handle(ChannelHandlerContext ctx, Object packet, boolean serverbound) {
        LocalSession.context(ctx.channel()).map(LocalSession.Context::getPlayer).ifPresent(player -> {
            Object connection = ReflectionUtils.invoke(null, getFromChannel, ctx.channel());
            Object profile = ReflectionUtils.invoke(connection, getLoginProfile, new Object[0]);
            ReflectionUtils.invoke(profile, setName, player.getUsername());
            ReflectionUtils.invoke(profile, setOriginalName, player.getUsername());
            ReflectionUtils.invoke(profile, setUuid, player.getUniqueId());
            ReflectionUtils.invoke(profile, setOriginalUuid, player.getUniqueId());
            Object temp = ReflectionUtils.invoke(connection, getNetworkManagerWrapper, new Object[0]);
            temp = ReflectionUtils.invoke(temp, getPacketListener, new Object[0]);
            ReflectionUtils.invoke(temp, handleLoginStart, player.getUsername());
        });
        return packet;
    }

    static {
        Class<?> connectionImpl = ReflectionUtils.getClass("protocolsupport.protocol.ConnectionImpl");
        getFromChannel = ReflectionUtils.getMethod(connectionImpl, "getFromChannel", Channel.class);
        getLoginProfile = ReflectionUtils.getMethod(connectionImpl, "getLoginProfile", new Class[0]);
        Class<?> profile = ReflectionUtils.getClass("protocolsupport.protocol.utils.authlib.LoginProfile");
        setName = ReflectionUtils.getMethod(profile, "setName", String.class);
        setOriginalName = ReflectionUtils.getMethod(profile, "setOriginalName", String.class);
        setUuid = ReflectionUtils.getMethod(profile, "setUUID", UUID.class);
        setOriginalUuid = ReflectionUtils.getMethod(profile, "setOriginalUUID", UUID.class);
        getNetworkManagerWrapper = ReflectionUtils.getMethod(connectionImpl, "getNetworkManagerWrapper", new Class[0]);
        Class<?> networkManagerWrapper = ReflectionUtils.getClass("protocolsupport.zplatform.network.NetworkManagerWrapper");
        getPacketListener = ReflectionUtils.getMethod(networkManagerWrapper, "getPacketListener", new Class[0]);
        Class<?> loginListener = ReflectionUtils.getClass("protocolsupport.protocol.packet.handler.AbstractLoginListener");
        handleLoginStart = ReflectionUtils.getMethod(loginListener, "handleLoginStart", String.class);
    }
}

