/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.util;

import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.platform.command.CommandUtil;
import com.minekube.connect.player.UserAudience;
import com.minekube.connect.util.LanguageManager;
import com.minekube.connect.util.SpigotVersionSpecificMethods;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SpigotCommandUtil
extends CommandUtil {
    private final Server server;
    private final SpigotVersionSpecificMethods versionSpecificMethods;
    private final JavaPlugin plugin;
    private UserAudience console;

    public SpigotCommandUtil(LanguageManager manager, Server server, ConnectApi api, SpigotVersionSpecificMethods versionSpecificMethods, JavaPlugin plugin) {
        super(manager, api);
        this.server = server;
        this.versionSpecificMethods = versionSpecificMethods;
        this.plugin = plugin;
    }

    @Override
    public @NonNull UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSender)) {
            throw new IllegalArgumentException("Source has to be a CommandSender!");
        }
        CommandSender source2 = (CommandSender)sourceObj;
        if (!(source2 instanceof Player)) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new UserAudience.ConsoleAudience(source2, this);
            return this.console;
        }
        Player player = (Player)source2;
        UUID uuid = player.getUniqueId();
        String username = player.getName();
        String locale = this.versionSpecificMethods.getLocale(player);
        return new UserAudience.PlayerAudience(uuid, username, locale, source2, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source2) {
        return ((Player)source2).getName();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source2) {
        return ((Player)source2).getUniqueId();
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return this.server.getOnlinePlayers();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        Player player = this.server.getPlayer(uuid);
        return player != null ? player : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        Player player = this.server.getPlayer(username);
        return player != null ? player : username;
    }

    @Override
    public boolean hasPermission(Object player, String permission) {
        return ((CommandSender)player).hasPermission(permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        ((CommandSender)target).sendMessage(message);
    }

    @Override
    public void kickPlayer(Object player, String message) {
        if (player instanceof Player) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)player).kickPlayer(message));
        }
    }
}

