/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.util;

import com.minekube.connect.api.ConnectApi;
import com.minekube.connect.api.logger.ConnectLogger;
import com.minekube.connect.config.ConnectConfig;
import com.minekube.connect.platform.util.PlatformUtils;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.org.bstats.MetricsBase;
import com.minekube.connect.shadow.org.bstats.charts.AdvancedPie;
import com.minekube.connect.shadow.org.bstats.charts.DrilldownPie;
import com.minekube.connect.shadow.org.bstats.charts.SimplePie;
import com.minekube.connect.shadow.org.bstats.charts.SingleLineChart;
import com.minekube.connect.shadow.org.bstats.json.JsonObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;

public final class Metrics {
    private final MetricsBase metricsBase;
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final int CORE_COUNT = Runtime.getRuntime().availableProcessors();

    @Inject
    Metrics(ConnectConfig config, PlatformUtils platformUtils, ConnectApi api, @Named(value="platformName") String implementationName, ConnectLogger logger) {
        ConnectConfig.MetricsConfig metricsConfig = config.getMetrics();
        this.metricsBase = new MetricsBase("server-implementation", metricsConfig.getUuid(), 14794, !metricsConfig.isDisabled(), this::appendPlatformData, jsonObjectBuilder -> {}, null, () -> true, (x$0, x$1) -> logger.error((String)x$0, (Throwable)x$1, new Object[0]), x$0 -> logger.info((String)x$0, new Object[0]), false, false, false);
        this.metricsBase.addCustomChart(new SingleLineChart("players", api::getPlayerCount));
        this.metricsBase.addCustomChart(new DrilldownPie("player_count", () -> {
            int playerCount = api.getPlayerCount();
            int category = playerCount / 5 * 5;
            String categoryName = category + " - " + (category + 4);
            return Collections.singletonMap(categoryName, Collections.singletonMap(implementationName, 1));
        }));
        this.metricsBase.addCustomChart(new SimplePie("authentication", () -> platformUtils.authType().name().toLowerCase(Locale.ROOT)));
        this.metricsBase.addCustomChart(new DrilldownPie("platform", () -> Collections.singletonMap(implementationName, Collections.singletonMap(platformUtils.serverImplementationName(), 1))));
        this.metricsBase.addCustomChart(new SimplePie("platform", () -> implementationName));
        this.metricsBase.addCustomChart(new AdvancedPie("passthrough_auth_player_count", () -> {
            HashMap valueMap = new HashMap();
            api.getPlayers().forEach(connectPlayer -> {
                String key = Boolean.toString(connectPlayer.getAuth().isPassthrough());
                valueMap.put(key, valueMap.getOrDefault(key, 0) + 1);
            });
            return valueMap;
        }));
        this.metricsBase.addCustomChart(new DrilldownPie("minecraft_version", () -> Collections.singletonMap(platformUtils.minecraftVersion(), Collections.singletonMap(implementationName, 1))));
        this.metricsBase.addCustomChart(new DrilldownPie("java_version", () -> {
            String release;
            HashMap map = new HashMap();
            String javaVersion = JAVA_VERSION;
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            String majorVersion = javaVersion.split("\\.")[0];
            int indexOf = javaVersion.lastIndexOf(46);
            if (majorVersion.equals("1")) {
                release = "Java " + javaVersion.substring(0, indexOf);
            } else {
                Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                if (versionMatcher.find()) {
                    majorVersion = versionMatcher.group(0);
                }
                release = "Java " + majorVersion;
            }
            map.put(release, entry);
            return map;
        }));
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("osName", OS_NAME);
        builder.appendField("osArch", OS_ARCH);
        builder.appendField("osVersion", OS_VERSION);
        builder.appendField("coreCount", CORE_COUNT);
    }
}

