/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.util;

import com.minekube.connect.shadow.com.google.common.base.Preconditions;
import com.minekube.connect.util.ReflectionUtils;
import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class ClassNames {
    public static final Class<?> MINECRAFT_SERVER;
    public static final Class<?> SERVER_CONNECTION;
    public static final Class<?> HANDSHAKE_PACKET;
    public static final Class<?> LOGIN_START_PACKET;
    public static final Class<?> LOGIN_LISTENER;
    @Nullable
    public static final Class<?> CLIENT_INTENT;
    public static final Constructor<OfflinePlayer> CRAFT_OFFLINE_PLAYER_CONSTRUCTOR;
    @Nullable
    public static final Constructor<?> LOGIN_HANDLER_CONSTRUCTOR;
    @Nullable
    public static final Constructor<?> HANDSHAKE_PACKET_CONSTRUCTOR;
    public static final Field SOCKET_ADDRESS;
    public static final Field HANDSHAKE_HOST;
    public static final Field VELOCITY_LOGIN_MESSAGE_ID;
    public static final Field LOGIN_PROFILE;
    public static final Field PACKET_LISTENER;
    @Nullable
    public static final Field HANDSHAKE_PORT;
    @Nullable
    public static final Field HANDSHAKE_PROTOCOL;
    @Nullable
    public static final Field HANDSHAKE_INTENTION;
    @Nullable
    public static final Field PAPER_DISABLE_USERNAME_VALIDATION;
    @Nullable
    public static final BooleanSupplier PAPER_VELOCITY_SUPPORT;
    public static final Method GET_PROFILE_METHOD;
    public static final Method LOGIN_DISCONNECT;
    public static final Method NETWORK_EXCEPTION_CAUGHT;
    @Nullable
    public static final Method INIT_UUID;
    @Nullable
    public static final Method FIRE_LOGIN_EVENTS;
    @Nullable
    public static final Method FIRE_LOGIN_EVENTS_GAME_PROFILE;
    @Nullable
    public static final Method CALL_PLAYER_PRE_LOGIN_EVENTS;
    @Nullable
    public static final Method START_CLIENT_VERIFICATION;
    public static final Field BUNGEE;
    public static final boolean IS_FOLIA;
    public static final boolean IS_PRE_1_20_2;
    public static final boolean IS_POST_LOGIN_HANDLER;

    private static Class<?> getClassOrFallback(String className, String fallbackName) {
        Class<?> clazz = ReflectionUtils.getClassSilently(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = ReflectionUtils.getClassOrThrow(fallbackName);
        return clazz;
    }

    private static <T> T checkNotNull(@CheckForNull T toCheck, @CheckForNull String objectName) {
        return Preconditions.checkNotNull(toCheck, objectName + " cannot be null");
    }

    private static <T> T checkNotNull(@CheckForNull T toCheck, @CheckForNull T toCheck2, @CheckForNull String objectName, @CheckForNull String objectName2) {
        return Preconditions.checkNotNull(toCheck != null ? toCheck : toCheck2, objectName2 + " cannot be null if " + objectName + " is null");
    }

    static {
        String[] versionSplit = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        if (versionSplit.length <= 3 && ReflectionUtils.getClassSilently("net.minecraft.server.MinecraftServer") == null) {
            throw new IllegalStateException("Was unable to find net.minecraft.server.MinecraftServer. We don't support Mojmap yet");
        }
        String version = versionSplit.length > 3 ? versionSplit[3] + '.' : "";
        String nmsPackage = "net.minecraft.server." + version;
        Class<?> craftPlayerClass = ReflectionUtils.getClass("org.bukkit.craftbukkit." + version + "entity.CraftPlayer");
        GET_PROFILE_METHOD = ReflectionUtils.getMethod(craftPlayerClass, "getProfile", new Class[0]);
        ClassNames.checkNotNull(GET_PROFILE_METHOD, "Get profile method");
        MINECRAFT_SERVER = ClassNames.getClassOrFallback("net.minecraft.server.MinecraftServer", nmsPackage + "MinecraftServer");
        SERVER_CONNECTION = ClassNames.getClassOrFallback("net.minecraft.server.network.ServerConnection", nmsPackage + "ServerConnection");
        Class<?> craftServerClass = ReflectionUtils.getClass("org.bukkit.craftbukkit." + version + "CraftServer");
        Class craftOfflinePlayerClass = ReflectionUtils.getCastedClass("org.bukkit.craftbukkit." + version + "CraftOfflinePlayer");
        CRAFT_OFFLINE_PLAYER_CONSTRUCTOR = ReflectionUtils.getConstructor(craftOfflinePlayerClass, true, craftServerClass, GameProfile.class);
        Class<?> networkManager = ClassNames.getClassOrFallback("net.minecraft.network.NetworkManager", nmsPackage + "NetworkManager");
        SOCKET_ADDRESS = ReflectionUtils.getFieldOfType(networkManager, SocketAddress.class, false);
        HANDSHAKE_PACKET = ClassNames.getClassOrFallback("net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol", nmsPackage + "PacketHandshakingInSetProtocol");
        HANDSHAKE_HOST = ReflectionUtils.getFieldOfType(HANDSHAKE_PACKET, String.class);
        ClassNames.checkNotNull(HANDSHAKE_HOST, "Handshake host");
        LOGIN_START_PACKET = ClassNames.getClassOrFallback("net.minecraft.network.protocol.login.PacketLoginInStart", nmsPackage + "PacketLoginInStart");
        LOGIN_LISTENER = ClassNames.getClassOrFallback("net.minecraft.server.network.LoginListener", nmsPackage + "LoginListener");
        LOGIN_PROFILE = ReflectionUtils.getFieldOfType(LOGIN_LISTENER, GameProfile.class);
        ClassNames.checkNotNull(LOGIN_PROFILE, "Profile from LoginListener");
        LOGIN_DISCONNECT = ReflectionUtils.getMethod(LOGIN_LISTENER, "disconnect", String.class);
        ClassNames.checkNotNull(LOGIN_DISCONNECT, "LoginListener's disconnect method");
        NETWORK_EXCEPTION_CAUGHT = ReflectionUtils.getMethod(networkManager, "exceptionCaught", ChannelHandlerContext.class, Throwable.class);
        VELOCITY_LOGIN_MESSAGE_ID = ReflectionUtils.getField(LOGIN_LISTENER, "velocityLoginMessageId");
        INIT_UUID = ReflectionUtils.getMethod(LOGIN_LISTENER, "initUUID", new Class[0]);
        IS_PRE_1_20_2 = INIT_UUID != null;
        CALL_PLAYER_PRE_LOGIN_EVENTS = ReflectionUtils.getMethod(LOGIN_LISTENER, "callPlayerPreLoginEvents", GameProfile.class);
        boolean bl = IS_POST_LOGIN_HANDLER = CALL_PLAYER_PRE_LOGIN_EVENTS != null;
        if (IS_PRE_1_20_2) {
            Class<?> packetListenerClass = ClassNames.getClassOrFallback("net.minecraft.network.PacketListener", nmsPackage + "PacketListener");
            PACKET_LISTENER = ReflectionUtils.getFieldOfType(networkManager, packetListenerClass);
        } else {
            PACKET_LISTENER = ReflectionUtils.getField(networkManager, "q");
            ReflectionUtils.makeAccessible(PACKET_LISTENER);
        }
        ClassNames.checkNotNull(PACKET_LISTENER, "Packet listener");
        if (IS_POST_LOGIN_HANDLER) {
            ReflectionUtils.makeAccessible(CALL_PLAYER_PRE_LOGIN_EVENTS);
            START_CLIENT_VERIFICATION = ReflectionUtils.getMethod(LOGIN_LISTENER, "b", GameProfile.class);
            ClassNames.checkNotNull(START_CLIENT_VERIFICATION, "startClientVerification");
            ReflectionUtils.makeAccessible(START_CLIENT_VERIFICATION);
            LOGIN_HANDLER_CONSTRUCTOR = null;
            FIRE_LOGIN_EVENTS = null;
            FIRE_LOGIN_EVENTS_GAME_PROFILE = null;
        } else {
            Class<?> loginHandler = ClassNames.getClassOrFallback("net.minecraft.server.network.LoginListener$LoginHandler", nmsPackage + "LoginListener$LoginHandler");
            LOGIN_HANDLER_CONSTRUCTOR = ReflectionUtils.getConstructor(loginHandler, true, LOGIN_LISTENER);
            ClassNames.checkNotNull(LOGIN_HANDLER_CONSTRUCTOR, "LoginHandler constructor");
            FIRE_LOGIN_EVENTS = ReflectionUtils.getMethod(loginHandler, "fireEvents", new Class[0]);
            FIRE_LOGIN_EVENTS_GAME_PROFILE = ReflectionUtils.getMethod(loginHandler, "fireEvents", GameProfile.class);
            ClassNames.checkNotNull(FIRE_LOGIN_EVENTS, FIRE_LOGIN_EVENTS_GAME_PROFILE, "fireEvents from LoginHandler", "fireEvents(GameProfile) from LoginHandler");
            START_CLIENT_VERIFICATION = null;
        }
        PAPER_DISABLE_USERNAME_VALIDATION = ReflectionUtils.getField(LOGIN_LISTENER, "iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation");
        Class<?> spigotConfig = ReflectionUtils.getClass("org.spigotmc.SpigotConfig");
        ClassNames.checkNotNull(spigotConfig, "Spigot config");
        BUNGEE = ReflectionUtils.getField(spigotConfig, "bungee");
        ClassNames.checkNotNull(BUNGEE, "Bungee field");
        Class<?> paperConfigNew = ReflectionUtils.getClassSilently("io.papermc.paper.configuration.GlobalConfiguration");
        if (paperConfigNew != null) {
            Method paperConfigGet = ClassNames.checkNotNull(ReflectionUtils.getMethod(paperConfigNew, "get", new Class[0]), "GlobalConfiguration get");
            Field paperConfigProxies = ClassNames.checkNotNull(ReflectionUtils.getField(paperConfigNew, "proxies"), "Proxies field");
            Field paperConfigVelocity = ClassNames.checkNotNull(ReflectionUtils.getField(paperConfigProxies.getType(), "velocity"), "velocity field");
            Field paperVelocityEnabled = ClassNames.checkNotNull(ReflectionUtils.getField(paperConfigVelocity.getType(), "enabled"), "Velocity enabled field");
            PAPER_VELOCITY_SUPPORT = () -> {
                Object paperConfigInstance = ReflectionUtils.invoke(null, paperConfigGet, new Object[0]);
                Object proxiesInstance = ReflectionUtils.getValue(paperConfigInstance, paperConfigProxies);
                Object velocityInstance = ReflectionUtils.getValue(proxiesInstance, paperConfigVelocity);
                return ReflectionUtils.getBooleanValue(velocityInstance, paperVelocityEnabled);
            };
        } else {
            Field velocitySupport;
            Class<?> paperConfig = ReflectionUtils.getClassSilently("com.destroystokyo.paper.PaperConfig");
            PAPER_VELOCITY_SUPPORT = paperConfig != null ? ((velocitySupport = ReflectionUtils.getField(paperConfig, "velocitySupport")) != null ? () -> ReflectionUtils.castedStaticBooleanValue(velocitySupport) : null) : null;
        }
        boolean bl2 = IS_FOLIA = ReflectionUtils.getClassSilently("io.papermc.paper.threadedregions.RegionizedServer") != null;
        if (!IS_PRE_1_20_2) {
            CLIENT_INTENT = ClassNames.getClassOrFallback("net.minecraft.network.protocol.handshake.ClientIntent", nmsPackage + "ClientIntent");
            ClassNames.checkNotNull(CLIENT_INTENT, "Client intent enum");
            HANDSHAKE_PACKET_CONSTRUCTOR = ReflectionUtils.getConstructor(HANDSHAKE_PACKET, false, Integer.TYPE, String.class, Integer.TYPE, CLIENT_INTENT);
            ClassNames.checkNotNull(HANDSHAKE_PACKET_CONSTRUCTOR, "Handshake packet constructor");
            Field a = ReflectionUtils.getField(HANDSHAKE_PACKET, "a");
            ClassNames.checkNotNull(a, "Handshake \"a\" field (protocol version, or stream codec)");
            if (a.getType().isPrimitive()) {
                HANDSHAKE_PROTOCOL = a;
                HANDSHAKE_PORT = ReflectionUtils.getField(HANDSHAKE_PACKET, "c");
            } else {
                HANDSHAKE_PROTOCOL = ReflectionUtils.getField(HANDSHAKE_PACKET, "b");
                HANDSHAKE_PORT = ReflectionUtils.getField(HANDSHAKE_PACKET, "d");
            }
            ClassNames.checkNotNull(HANDSHAKE_PROTOCOL, "Handshake protocol");
            ReflectionUtils.makeAccessible(HANDSHAKE_PROTOCOL);
            ClassNames.checkNotNull(HANDSHAKE_PORT, "Handshake port");
            ReflectionUtils.makeAccessible(HANDSHAKE_PORT);
            HANDSHAKE_INTENTION = ReflectionUtils.getFieldOfType(HANDSHAKE_PACKET, CLIENT_INTENT);
            ClassNames.checkNotNull(HANDSHAKE_INTENTION, "Handshake intention");
            ReflectionUtils.makeAccessible(HANDSHAKE_INTENTION);
        } else {
            CLIENT_INTENT = null;
            HANDSHAKE_PACKET_CONSTRUCTOR = null;
            HANDSHAKE_PORT = null;
            HANDSHAKE_PROTOCOL = null;
            HANDSHAKE_INTENTION = null;
        }
    }
}

