/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.tunnel;

import com.minekube.connect.shadow.com.google.common.base.Preconditions;
import com.minekube.connect.shadow.com.google.inject.Inject;
import com.minekube.connect.shadow.com.google.inject.name.Named;
import com.minekube.connect.tunnel.TunnelConn;
import com.minekube.connect.util.ReflectionUtils;
import java.io.Closeable;
import java.io.EOFException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tunneler
implements Closeable {
    private static final String SESSION_HEADER = "Connect-Session";
    private static final Field DATA = ReflectionUtils.getField(ByteString.class, "data");
    private final OkHttpClient httpClient;

    @Inject
    public Tunneler(@Named(value="connectHttpClient") OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public TunnelConn tunnel(String tunnelServiceAddr, String sessionId, final TunnelConn.Handler handler) {
        Preconditions.checkNotNull(tunnelServiceAddr, "tunnelServiceAddr must not be null");
        Preconditions.checkNotNull(sessionId, "sessionId must not be null");
        Preconditions.checkNotNull(handler, "handler must not be null");
        Preconditions.checkArgument(!tunnelServiceAddr.isEmpty(), "tunnelServiceAddr must not be empty");
        Preconditions.checkArgument(!sessionId.isEmpty(), "sessionId must not be empty");
        Request request = new Request.Builder().url(tunnelServiceAddr).addHeader(SESSION_HEADER, sessionId).build();
        AtomicBoolean closeHandlerOnce = new AtomicBoolean();
        final Runnable handlerOnClose = () -> {
            if (closeHandlerOnce.compareAndSet(false, true)) {
                handler.onClose();
            }
        };
        final AtomicBoolean opened = new AtomicBoolean();
        final WebSocket ws = this.httpClient.newWebSocket(request, new WebSocketListener(){

            @Override
            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                handlerOnClose.run();
            }

            @Override
            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                webSocket.close(1000, null);
            }

            @Override
            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                if (!(t instanceof EOFException)) {
                    handler.onError(t);
                }
                handlerOnClose.run();
            }

            @Override
            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                handler.onReceive((byte[])ReflectionUtils.getCastedValue((Object)bytes, DATA));
            }

            @Override
            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                opened.set(true);
            }
        });
        return new TunnelConn(){

            @Override
            public void write(byte[] data) {
                ws.send(ByteString.of(data));
            }

            @Override
            public void close(Throwable t) {
                if (t == null) {
                    ws.close(1000, "tunnel closed clientside");
                } else {
                    ws.close(1002, t.toString());
                }
                handlerOnClose.run();
            }

            @Override
            public boolean opened() {
                return opened.get();
            }
        };
    }

    @Override
    public void close() {
        Stream.of(this.httpClient.dispatcher().queuedCalls()).flatMap(Collection::stream).filter(call -> call.request().header(SESSION_HEADER) != null).forEach(Call::cancel);
    }
}

