/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.com.google.inject.internal;

import com.minekube.connect.shadow.com.google.common.cache.CacheBuilder;
import com.minekube.connect.shadow.com.google.common.cache.CacheLoader;
import com.minekube.connect.shadow.com.google.common.cache.LoadingCache;
import com.minekube.connect.shadow.com.google.common.collect.ImmutableMap;
import com.minekube.connect.shadow.com.google.common.collect.Maps;
import com.minekube.connect.shadow.com.google.inject.internal.Errors;
import com.minekube.connect.shadow.com.google.inject.internal.ErrorsException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FailableCache<K, V> {
    private final Set<K> loadingSet = ConcurrentHashMap.newKeySet();
    private final LoadingCache<K, Object> delegate = CacheBuilder.newBuilder().build(new CacheLoader<K, Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object load(K key) {
            FailableCache.this.loadingSet.add(key);
            Errors errors = new Errors();
            Object result = null;
            try {
                result = FailableCache.this.create(key, errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
            finally {
                FailableCache.this.loadingSet.remove(key);
            }
            return errors.hasErrors() ? errors : result;
        }
    });

    protected abstract V create(K var1, Errors var2) throws ErrorsException;

    public V get(K key, Errors errors) throws ErrorsException {
        Object resultOrError = this.delegate.getUnchecked(key);
        if (resultOrError instanceof Errors) {
            errors.merge((Errors)resultOrError);
            throw errors.toException();
        }
        Object result = resultOrError;
        return (V)result;
    }

    boolean remove(K key) {
        return this.delegate.asMap().remove(key) != null;
    }

    boolean isLoading(K key) {
        return this.loadingSet.contains(key);
    }

    Map<K, V> asMap() {
        return Maps.transformValues(Maps.filterValues(ImmutableMap.copyOf(this.delegate.asMap()), resultOrError -> !(resultOrError instanceof Errors)), resultOrError -> {
            Object result = resultOrError;
            return result;
        });
    }
}

