/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.com.google.inject.internal;

import com.minekube.connect.shadow.com.google.common.collect.ImmutableCollection;
import com.minekube.connect.shadow.com.google.common.collect.ImmutableList;
import com.minekube.connect.shadow.com.google.common.collect.Lists;
import com.minekube.connect.shadow.com.google.inject.internal.ConstructionProxyFactory;
import com.minekube.connect.shadow.com.google.inject.internal.ConstructorInjector;
import com.minekube.connect.shadow.com.google.inject.internal.DefaultConstructionProxyFactory;
import com.minekube.connect.shadow.com.google.inject.internal.Errors;
import com.minekube.connect.shadow.com.google.inject.internal.ErrorsException;
import com.minekube.connect.shadow.com.google.inject.internal.FailableCache;
import com.minekube.connect.shadow.com.google.inject.internal.InjectorImpl;
import com.minekube.connect.shadow.com.google.inject.internal.InternalFlags;
import com.minekube.connect.shadow.com.google.inject.internal.MembersInjectorImpl;
import com.minekube.connect.shadow.com.google.inject.internal.MethodAspect;
import com.minekube.connect.shadow.com.google.inject.internal.ProxyFactory;
import com.minekube.connect.shadow.com.google.inject.internal.SingleParameterInjector;
import com.minekube.connect.shadow.com.google.inject.spi.InjectionPoint;
import com.minekube.connect.shadow.com.google.inject.spi.InterceptorBinding;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    boolean isLoading(InjectionPoint ip) {
        return this.cache.isLoading(ip);
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory2 = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<InterceptorBinding> injectorBindings = this.injector.getBindingData().getInterceptorBindings();
            ImmutableCollection methodAspects = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)Lists.transform(injectorBindings, MethodAspect::fromBinding))).addAll(membersInjector.getAddedAspects())).build();
            factory2 = new ProxyFactory(injectionPoint, methodAspects);
        } else {
            factory2 = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory2.create(), constructorParameterInjectors, membersInjector);
    }
}

