/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.exceptions;

import com.minekube.connect.shadow.cloud.commandframework.arguments.CommandArgument;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.CommandParseException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NoSuchCommandException
extends CommandParseException {
    private static final long serialVersionUID = -7775865652882764771L;
    private final String suppliedCommand;

    public NoSuchCommandException(@NonNull Object commandSender, @NonNull List<CommandArgument<?, ?>> currentChain, @NonNull String command) {
        super(commandSender, currentChain);
        this.suppliedCommand = command;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        for (CommandArgument<?, ?> commandArgument : this.getCurrentChain()) {
            if (commandArgument == null) continue;
            builder.append(" ").append(commandArgument.getName());
        }
        return String.format("Unrecognized command input '%s' following chain%s", this.suppliedCommand, builder.toString());
    }

    public @NonNull String getSuppliedCommand() {
        return this.suppliedCommand;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        return this;
    }
}

