/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers.location;

import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import com.minekube.connect.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import com.minekube.connect.shadow.cloud.commandframework.arguments.standard.DoubleArgument;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers.PlayerArgument;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers.location.LocationCoordinate;
import com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers.location.LocationCoordinateType;
import com.minekube.connect.shadow.cloud.commandframework.context.CommandContext;
import com.minekube.connect.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import java.util.Queue;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LocationCoordinateParser<C>
implements ArgumentParser<C, LocationCoordinate> {
    @Override
    public @NonNull ArgumentParseResult<@NonNull LocationCoordinate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        double coordinate;
        LocationCoordinateType locationCoordinateType;
        String input = inputQueue.peek();
        if (input == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(PlayerArgument.PlayerParser.class, commandContext));
        }
        if (input.startsWith("^")) {
            locationCoordinateType = LocationCoordinateType.LOCAL;
            input = input.substring(1);
        } else if (input.startsWith("~")) {
            locationCoordinateType = LocationCoordinateType.RELATIVE;
            input = input.substring(1);
        } else {
            locationCoordinateType = LocationCoordinateType.ABSOLUTE;
        }
        try {
            coordinate = input.isEmpty() ? 0.0 : Double.parseDouble(input);
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new DoubleArgument.DoubleParseException(input, new DoubleArgument.DoubleParser(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), commandContext));
        }
        inputQueue.remove();
        return ArgumentParseResult.success(LocationCoordinate.of(locationCoordinateType, coordinate));
    }
}

