/*
 * Decompiled with CFR 0.152.
 */
package com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers.location;

import com.minekube.connect.shadow.cloud.commandframework.bukkit.parsers.location.LocationCoordinateType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LocationCoordinate {
    private final LocationCoordinateType type;
    private final double coordinate;

    private LocationCoordinate(@NonNull LocationCoordinateType type, double coordinate) {
        this.type = type;
        this.coordinate = coordinate;
    }

    public static @NonNull LocationCoordinate of(@NonNull LocationCoordinateType type, double coordinate) {
        return new LocationCoordinate(type, coordinate);
    }

    public @NonNull LocationCoordinateType getType() {
        return this.type;
    }

    public double getCoordinate() {
        return this.coordinate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationCoordinate that = (LocationCoordinate)o;
        return Double.compare(that.coordinate, this.coordinate) == 0 && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.coordinate});
    }

    public String toString() {
        return String.format("LocationCoordinate{type=%s, coordinate=%f}", this.type.name().toLowerCase(), this.coordinate);
    }
}

